/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.SizeAdjustment;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.SizeAdjustmentLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

final class SizeAdjustmentLoader
extends LstLineFileLoader {
    public void loadLstFile(URI uRI, String string) throws PersistenceLayerException {
        SystemCollections.getGameModeNamed(string).clearSizeAdjustmentList();
        super.loadLstFile(uRI, string);
    }

    public void parseLine(String string, URI uRI) throws PersistenceLayerException {
        SizeAdjustment sizeAdjustment = new SizeAdjustment();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(SizeAdjustmentLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            String string4 = "";
            try {
                string4 = string3.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            SizeAdjustmentLstToken sizeAdjustmentLstToken = (SizeAdjustmentLstToken)map.get(string4);
            if (string3.startsWith("SIZENAME:")) {
                string2 = string3.substring(n + 1);
                sizeAdjustment = SystemCollections.getGameModeNamed(this.getGameMode()).getSizeAdjustmentNamed(string2);
                if (sizeAdjustment != null) continue;
                sizeAdjustment = new SizeAdjustment();
                sizeAdjustment.setName(string2);
                SystemCollections.getGameModeNamed(this.getGameMode()).addToSizeAdjustmentList(sizeAdjustment);
                continue;
            }
            if (sizeAdjustmentLstToken != null) {
                string2 = string3.substring(n + 1);
                LstUtils.deprecationCheck(sizeAdjustmentLstToken, sizeAdjustment, string2);
                if (sizeAdjustmentLstToken.parse(sizeAdjustment, string2)) continue;
                Logging.errorPrint("Error parsing size adjustment " + sizeAdjustment.getDisplayName() + ':' + uRI.toString() + ':' + string3 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(sizeAdjustment, string3)) continue;
            Logging.errorPrint("Illegal size info '" + string + "' in " + uRI.toString());
        }
    }
}

