/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PCTemplateLstToken;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCTemplateLoader
extends LstObjectFileLoader<PCTemplate> {
    @Override
    protected void addGlobalObject(PObject pObject) {
        PCTemplate pCTemplate = Globals.getTemplateKeyed(pObject.getKeyName());
        if (pCTemplate == null) {
            Globals.getTemplateList().add((PCTemplate)pObject);
        }
    }

    @Override
    protected PCTemplate getObjectKeyed(String string) {
        return Globals.getTemplateKeyed(string);
    }

    @Override
    public PCTemplate parseLine(PCTemplate pCTemplate, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        if (pCTemplate == null) {
            pCTemplate = new PCTemplate();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = stringTokenizer.nextToken();
        pCTemplate.setName(string2);
        pCTemplate.setSourceCampaign(campaignSourceEntry.getCampaign());
        pCTemplate.setSourceURI(campaignSourceEntry.getURI());
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PCTemplateLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            String string4 = "";
            try {
                string4 = string3.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            PCTemplateLstToken pCTemplateLstToken = (PCTemplateLstToken)map.get(string4);
            if (string3.startsWith("CHOOSE:LANGAUTO:")) {
                pCTemplate.setChooseLanguageAutos(string3.substring(16));
                continue;
            }
            if (pCTemplateLstToken != null) {
                String string5 = string3.substring(n + 1);
                LstUtils.deprecationCheck(pCTemplateLstToken, pCTemplate, string5);
                if (pCTemplateLstToken.parse(pCTemplate, string5)) continue;
                Logging.errorPrint("Error parsing template " + pCTemplate.getDisplayName() + ':' + campaignSourceEntry.toString() + ':' + string3 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(pCTemplate, string3)) continue;
            Logging.errorPrint("Unknown tag '" + string3 + "' in " + campaignSourceEntry.toString());
        }
        this.completeObject(campaignSourceEntry, pCTemplate);
        return null;
    }

    @Override
    protected void performForget(PCTemplate pCTemplate) {
        Globals.getTemplateList().remove(pCTemplate);
    }
}

