/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Campaign;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.FeatMultipleChoice;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.pclevelinfo.PCLevelInfoStat;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.io.Cache;
import pcgen.io.EntityEncoder;
import pcgen.io.IOConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PCGVer2Creator
implements IOConstants {
    private PlayerCharacter thePC;

    PCGVer2Creator(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    public String createPCGString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        PCGVer2Creator.appendPCGVersionLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("System Information", stringBuffer);
        PCGVer2Creator.appendCampaignLine(stringBuffer);
        PCGVer2Creator.appendVersionLine(stringBuffer);
        PCGVer2Creator.appendRollMethodLine(stringBuffer);
        PCGVer2Creator.appendPurchasePointsLine(stringBuffer);
        this.appendPoolPointsLine(stringBuffer);
        PCGVer2Creator.appendGameModeLine(stringBuffer);
        PCGVer2Creator.appendTabLabelLine(stringBuffer);
        this.appendAutoSpellsLine(stringBuffer);
        this.appendUseHigherSpellSlotsLines(stringBuffer);
        this.appendLoadCompanionLine(stringBuffer);
        this.appendUseTempModsLine(stringBuffer);
        this.appendOutputSheetsLines(stringBuffer);
        this.appendAutoSortLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Bio", stringBuffer);
        this.appendCharacterNameLine(stringBuffer);
        this.appendTabNameLine(stringBuffer);
        this.appendPlayerNameLine(stringBuffer);
        this.appendHeightLine(stringBuffer);
        this.appendWeightLine(stringBuffer);
        this.appendAgeLine(stringBuffer);
        this.appendGenderLine(stringBuffer);
        this.appendHandedLine(stringBuffer);
        this.appendSkinColorLine(stringBuffer);
        this.appendEyeColorLine(stringBuffer);
        this.appendHairColorLine(stringBuffer);
        this.appendHairStyleLine(stringBuffer);
        this.appendLocationLine(stringBuffer);
        this.appendResidenceLine(stringBuffer);
        this.appendBirthdayLine(stringBuffer);
        this.appendBirthplaceLine(stringBuffer);
        this.appendPersonalityTrait1Line(stringBuffer);
        this.appendPersonalityTrait2Line(stringBuffer);
        this.appendSpeechPatternLine(stringBuffer);
        this.appendPhobiasLine(stringBuffer);
        this.appendInterestsLine(stringBuffer);
        this.appendCatchPhraseLine(stringBuffer);
        this.appendPortraitLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Attributes", stringBuffer);
        this.appendStatLines(stringBuffer);
        this.appendAlignmentLine(stringBuffer);
        this.appendRaceLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Class(es)", stringBuffer);
        this.appendClassLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Experience", stringBuffer);
        this.appendExperienceLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Templates", stringBuffer);
        this.appendTemplateLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Region", stringBuffer);
        this.appendRegionLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Skills", stringBuffer);
        this.appendSkillLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Languages", stringBuffer);
        this.appendLanguageLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Feats", stringBuffer);
        this.appendFeatLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Abilities", stringBuffer);
        this.appendAbilityLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Weapon proficiencies", stringBuffer);
        this.appendWeaponProficiencyLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Equipment", stringBuffer);
        this.appendMoneyLine(stringBuffer);
        this.appendEquipmentLines(stringBuffer);
        this.appendEquipmentSetLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Temporary Bonuses", stringBuffer);
        this.appendTempBonuses(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("EquipSet Temp Bonuses", stringBuffer);
        this.appendEqSetBonuses(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Deity/Domain", stringBuffer);
        this.appendDeityLine(stringBuffer);
        this.appendDomainLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Spells Information", stringBuffer);
        this.appendSpellBookLines(stringBuffer);
        this.appendSpellLines(stringBuffer);
        this.appendSpellListLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Description/Bio/History", stringBuffer);
        this.appendCharacterBioLine(stringBuffer);
        this.appendCharacterDescLine(stringBuffer);
        this.appendCharacterCompLine(stringBuffer);
        this.appendCharacterAssetLine(stringBuffer);
        this.appendCharacterMagicLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Kits", stringBuffer);
        this.appendKitLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Master/Follower", stringBuffer);
        this.appendFollowerLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Character Notes Tab", stringBuffer);
        this.appendNotesLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Chosen Armor Profs", stringBuffer);
        this.appendArmorProfLines(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        PCGVer2Creator.appendComment("Age Set Selections", stringBuffer);
        this.appendAgeSetLine(stringBuffer);
        PCGVer2Creator.appendNewline(stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendCampaignLine(StringBuffer stringBuffer) {
        String string = "";
        for (Campaign campaign : Globals.getCampaignList()) {
            if (!campaign.isLoaded()) continue;
            stringBuffer.append(string);
            stringBuffer.append("CAMPAIGN").append(':');
            stringBuffer.append(campaign.getKeyName());
            string = "|";
        }
        stringBuffer.append("\n");
    }

    private static void appendGameModeLine(StringBuffer stringBuffer) {
        stringBuffer.append("GAMEMODE").append(':');
        stringBuffer.append(SettingsHandler.getGame().getName());
        stringBuffer.append("\n");
    }

    private static void appendPCGVersionLine(StringBuffer stringBuffer) {
        stringBuffer.append("PCGVERSION").append(':');
        stringBuffer.append("2.0");
        stringBuffer.append("\n");
    }

    private static void appendPurchasePointsLine(StringBuffer stringBuffer) {
        stringBuffer.append("PURCHASEPOINTS").append(':');
        if (SettingsHandler.getGame().isPurchaseStatMode()) {
            stringBuffer.append('Y');
            stringBuffer.append('|');
            stringBuffer.append("TYPE").append(':');
            stringBuffer.append(SettingsHandler.getGame().getPurchaseModeMethodName());
        } else {
            stringBuffer.append('N');
        }
        stringBuffer.append("\n");
    }

    private static void appendRollMethodLine(StringBuffer stringBuffer) {
        GameMode gameMode = SettingsHandler.getGame();
        stringBuffer.append("ROLLMETHOD").append(':');
        stringBuffer.append(gameMode.getRollMethod());
        stringBuffer.append('|');
        stringBuffer.append("EXPRESSION").append(':');
        switch (gameMode.getRollMethod()) {
            case 1: {
                stringBuffer.append(gameMode.getAllStatsValue());
                break;
            }
            case 2: {
                stringBuffer.append(gameMode.getPurchaseModeMethodName());
                break;
            }
            case 3: {
                stringBuffer.append(gameMode.getRollMethodExpression());
                break;
            }
            default: {
                stringBuffer.append(0);
            }
        }
        stringBuffer.append("\n");
    }

    private static void appendVersionLine(StringBuffer stringBuffer) {
        stringBuffer.append("VERSION").append(':');
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            stringBuffer.append(resourceBundle.getString("VersionNumber"));
        }
        catch (MissingResourceException missingResourceException) {
            Object var1_2 = null;
        }
        stringBuffer.append("\n");
    }

    private void appendAgeLine(StringBuffer stringBuffer) {
        stringBuffer.append("AGE").append(':');
        stringBuffer.append(this.thePC.getAge());
        stringBuffer.append("\n");
    }

    private void appendAgeSetLine(StringBuffer stringBuffer) {
        stringBuffer.append("AGESET");
        for (int i = 0; i < 10; ++i) {
            stringBuffer.append(':');
            if (this.thePC.hasMadeKitSelectionForAgeSet(i)) {
                stringBuffer.append('1');
                continue;
            }
            stringBuffer.append('0');
        }
    }

    private void appendAlignmentLine(StringBuffer stringBuffer) {
        if (Globals.getGameModeAlignmentText().length() != 0) {
            stringBuffer.append("ALIGN").append(':');
            stringBuffer.append(SettingsHandler.getGame().getShortAlignmentAtIndex(this.thePC.getAlignment()));
            stringBuffer.append("\n");
        }
    }

    private void appendArmorProfLines(StringBuffer stringBuffer) {
        ListKey<String> listKey = ListKey.SELECTED_ARMOR_PROF;
        if (this.thePC.getDeity() != null && this.thePC.getDeity().containsListFor((ListKey)listKey)) {
            stringBuffer.append("ARMORPROF").append(':').append("DEITY").append('=').append(this.thePC.getDeity().getKeyName()).append(':');
            for (String object2 : this.thePC.getDeity().getListFor(listKey)) {
                stringBuffer.append(object2).append(':');
            }
            stringBuffer.append("\n");
        }
        for (PCClass pCClass : this.thePC.getClassList()) {
            if (!pCClass.containsListFor((ListKey)listKey)) continue;
            stringBuffer.append("ARMORPROF").append(':').append("CLASS").append('=').append(pCClass.getKeyName()).append(':');
            for (String string : pCClass.getListFor(listKey)) {
                stringBuffer.append(string).append(':');
            }
            stringBuffer.append("\n");
        }
        for (Ability ability : this.thePC.aggregateFeatList()) {
            if (!ability.containsListFor((ListKey)listKey)) continue;
            stringBuffer.append("ARMORPROF").append(':').append("FEAT").append('=').append(ability.getKeyName()).append(':');
            for (String string : ability.getListFor(listKey)) {
                stringBuffer.append(string).append(':');
            }
            stringBuffer.append("\n");
        }
        Iterator<String> iterator = new ArrayList<Skill>(this.thePC.getSkillList());
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Skill skill = (Skill)iterator2.next();
            if (!skill.containsListFor((ListKey)listKey)) continue;
            stringBuffer.append("ARMORPROF").append(':').append("SKILL").append('=').append(skill.getKeyName()).append(':');
            for (String string : skill.getListFor(listKey)) {
                stringBuffer.append(string).append(':');
            }
            stringBuffer.append("\n");
        }
        for (CharacterDomain characterDomain : this.thePC.getCharacterDomainList()) {
            if (characterDomain.getDomain() == null || !characterDomain.getDomain().containsListFor((ListKey)listKey)) continue;
            stringBuffer.append("ARMORPROF").append(':').append("DOMAIN").append('=').append(characterDomain.getDomain().getKeyName()).append(':');
            for (String string : characterDomain.getDomain().getListFor(listKey)) {
                stringBuffer.append(string).append(':');
            }
            stringBuffer.append("\n");
        }
        for (Equipment equipment : this.thePC.getEquipmentMasterList()) {
            if (!equipment.isEquipped() || !equipment.containsListFor((ListKey)listKey)) continue;
            stringBuffer.append("ARMORPROF").append(':').append("EQUIPMENT").append('=').append(equipment.getName()).append(':');
            for (String string : equipment.getListFor(listKey)) {
                stringBuffer.append(string).append(':');
            }
            stringBuffer.append("\n");
        }
        for (PCTemplate pCTemplate : this.thePC.getTemplateList()) {
            if (!pCTemplate.containsListFor((ListKey)listKey)) continue;
            stringBuffer.append("ARMORPROF").append(':').append("TEMPLATE").append('=').append(pCTemplate.getKeyName()).append(':');
            for (String string : pCTemplate.getListFor(listKey)) {
                stringBuffer.append(string).append(':');
            }
            stringBuffer.append("\n");
        }
    }

    private void appendBirthdayLine(StringBuffer stringBuffer) {
        stringBuffer.append("BIRTHDAY").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getBirthday()));
        stringBuffer.append("\n");
    }

    private void appendBirthplaceLine(StringBuffer stringBuffer) {
        stringBuffer.append("BIRTHPLACE").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getBirthplace()));
        stringBuffer.append("\n");
    }

    private void appendCatchPhraseLine(StringBuffer stringBuffer) {
        stringBuffer.append("CATCHPHRASE").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getCatchPhrase()));
        stringBuffer.append("\n");
    }

    private void appendCharacterAssetLine(StringBuffer stringBuffer) {
        stringBuffer.append("CHARACTERASSET").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getMiscList().get(0)));
        stringBuffer.append("\n");
    }

    private void appendCharacterBioLine(StringBuffer stringBuffer) {
        stringBuffer.append("CHARACTERBIO").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getBio()));
        stringBuffer.append("\n");
    }

    private void appendCharacterCompLine(StringBuffer stringBuffer) {
        stringBuffer.append("CHARACTERCOMP").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getMiscList().get(1)));
        stringBuffer.append("\n");
    }

    private void appendCharacterDescLine(StringBuffer stringBuffer) {
        stringBuffer.append("CHARACTERDESC").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getDescription()));
        stringBuffer.append("\n");
    }

    private void appendCharacterMagicLine(StringBuffer stringBuffer) {
        stringBuffer.append("CHARACTERMAGIC").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getMiscList().get(2)));
        stringBuffer.append("\n");
    }

    private void appendClassLines(StringBuffer stringBuffer) {
        Object object;
        Cache cache = new Cache();
        for (PCClass cloneable : this.thePC.getClassList()) {
            List<String> iterator;
            boolean bl;
            int n = cloneable.getLevel();
            stringBuffer.append("CLASS").append(':');
            stringBuffer.append(EntityEncoder.encode(cloneable.getKeyName()));
            String string = cloneable.getSubClassKey();
            if (!"".equals(string)) {
                stringBuffer.append('|');
                stringBuffer.append("SUBCLASS").append(':');
                stringBuffer.append(EntityEncoder.encode(string));
            }
            stringBuffer.append('|');
            stringBuffer.append("LEVEL").append(':');
            stringBuffer.append(n);
            stringBuffer.append('|');
            stringBuffer.append("SKILLPOOL").append(':');
            stringBuffer.append(cloneable.skillPool());
            boolean pCClass = false;
            if (!cloneable.zeroCastSpells()) {
                pCClass = true;
            }
            boolean bl2 = bl = cloneable.hasKnownList() && !pCClass;
            if (pCClass || bl) {
                stringBuffer.append('|');
                stringBuffer.append("SPELLBASE").append(':');
                stringBuffer.append(EntityEncoder.encode(cloneable.getSpellBaseStat()));
                stringBuffer.append('|');
                stringBuffer.append("CANCASTPERDAY").append(':');
                stringBuffer.append(CoreUtility.join(cloneable.getCastListForLevel(n), ","));
            }
            if ((iterator = cloneable.getProhibitedSchools()) != null) {
                stringBuffer.append('|');
                stringBuffer.append("PROHIBITED").append(':');
                stringBuffer.append(EntityEncoder.encode(CoreUtility.join(iterator, ",")));
            }
            stringBuffer.append("\n");
            object = cloneable.getKeyName() + "SPECIALTY" + '0';
            for (String string2 : cloneable.getSpecialtyList()) {
                cache.put((String)object, string2);
            }
            object = cloneable.getKeyName() + "SAVE" + '0';
            for (String string2 : cloneable.getSafeListFor(ListKey.SAVE)) {
                SpecialAbility specialAbility = cloneable.getSpecialAbilityKeyed(string2);
                if (specialAbility != null) {
                    int n2 = 1;
                    String string3 = specialAbility.getSASource();
                    try {
                        n2 = Integer.parseInt(string3.substring(string3.lastIndexOf(124) + 1));
                        if (n2 < 0) {
                            n2 = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    cache.put(cloneable.getKeyName() + "SA" + (n2 - 1), specialAbility.getKeyName());
                    continue;
                }
                cache.put((String)object, string2);
            }
        }
        for (PCLevelInfo pCLevelInfo : this.thePC.getLevelInfo()) {
            int n;
            Object object2;
            String string = pCLevelInfo.getClassKeyName();
            int n3 = pCLevelInfo.getLevel() - 1;
            PCClass pCClass = this.thePC.getClassKeyed(string);
            stringBuffer.append("CLASSABILITIESLEVEL").append(':');
            if (pCClass == null && (pCClass = Globals.getClassKeyed(string)) != null) {
                pCClass = this.thePC.getClassKeyed(pCClass.getExClass());
            }
            if (pCClass != null) {
                stringBuffer.append(EntityEncoder.encode(pCClass.getKeyName()));
            } else {
                stringBuffer.append(EntityEncoder.encode("???"));
            }
            stringBuffer.append('=').append(n3 + 1);
            if (pCClass != null) {
                object2 = pCClass.getSubstitutionClassKey(n3 + 1);
                if (object2 != null) {
                    stringBuffer.append('|');
                    stringBuffer.append("SUBSTITUTIONLEVEL").append(':');
                    stringBuffer.append((String)object2);
                }
                stringBuffer.append('|');
                stringBuffer.append("HITPOINTS").append(':');
                stringBuffer.append(String.valueOf(pCClass.getHitPoint(n3)));
                PCGVer2Creator.appendSpecials(stringBuffer, cache.get(pCClass.getKeyName() + "SAVE" + n3), "SAVES", "SAVE", n3);
                PCGVer2Creator.appendSpecials(stringBuffer, cache.get(pCClass.getKeyName() + "SPECIALTY" + n3), "SPECIALTIES", "SPECIALTY", n3);
                PCGVer2Creator.appendSpecials(stringBuffer, cache.get(pCClass.getKeyName() + "SA" + n3), "SPECIALABILITIES", "SA", n3);
                if (n3 == 0) {
                    PCGVer2Creator.appendSpecials(stringBuffer, cache.get(pCClass.getKeyName() + "SA" + (n3 - 1)), "SPECIALABILITIES", "SA", -1);
                }
                this.appendLevelAbilityInfo(stringBuffer, pCClass, n3);
            }
            if ((object2 = pCLevelInfo.getModifiedStats(true)) != null) {
                Iterator n4 = object2.iterator();
                while (n4.hasNext()) {
                    object = (PCLevelInfoStat)n4.next();
                    stringBuffer.append('|').append("PRESTAT").append(':').append(((PCLevelInfoStat)object).toString());
                }
            }
            if ((object2 = pCLevelInfo.getModifiedStats(false)) != null) {
                Iterator<PCLevelInfoStat> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuffer.append('|').append("PRESTAT").append(':').append(((PCLevelInfoStat)object).toString());
                }
            }
            if ((n = pCLevelInfo.getSkillPointsGained()) != 0) {
                stringBuffer.append('|').append("SKILLSGAINED").append(':').append(n);
            }
            if ((n = pCLevelInfo.getSkillPointsRemaining()) != 0) {
                stringBuffer.append('|').append("SKILLSREMAINING").append(':').append(n);
            }
            stringBuffer.append("\n");
        }
    }

    private static void appendComment(String string, StringBuffer stringBuffer) {
        stringBuffer.append(PCGVer2Creator.createComment(string));
    }

    private void appendDeityLine(StringBuffer stringBuffer) {
        if (this.thePC.getDeity() != null) {
            Deity deity = this.thePC.getDeity();
            stringBuffer.append("DEITY").append(':');
            stringBuffer.append(EntityEncoder.encode(deity.getKeyName()));
            stringBuffer.append('|');
            stringBuffer.append("DEITYDOMAINS").append(':');
            stringBuffer.append('[');
            String string = "";
            for (QualifiedObject<Domain> object : deity.getDomainList()) {
                stringBuffer.append(string);
                stringBuffer.append("DOMAIN").append(':');
                if (object == null || object.getObject(null) == null) {
                    stringBuffer.append(EntityEncoder.encode("None"));
                } else {
                    stringBuffer.append(EntityEncoder.encode(object.getObject(null).getKeyName()));
                }
                string = "|";
            }
            stringBuffer.append(']');
            stringBuffer.append('|');
            stringBuffer.append("ALIGNALLOW").append(':');
            stringBuffer.append(deity.getFollowerAlignments());
            for (Description description : deity.getDescriptionList()) {
                stringBuffer.append('|');
                stringBuffer.append("DESC").append(':');
                stringBuffer.append(description.getPCCText());
            }
            stringBuffer.append('|');
            stringBuffer.append("HOLYITEM").append(':');
            stringBuffer.append(EntityEncoder.encode(deity.getHolyItem()));
            stringBuffer.append('|');
            stringBuffer.append("DEITYFAVWEAP").append(':');
            stringBuffer.append('[');
            StringTokenizer stringTokenizer = new StringTokenizer(deity.getFavoredWeapon(), "|");
            string = "";
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string);
                stringBuffer.append("WEAPON").append(':');
                stringBuffer.append(EntityEncoder.encode(stringTokenizer.nextToken()));
                string = "|";
            }
            stringBuffer.append(']');
            stringBuffer.append('|');
            stringBuffer.append("DEITYALIGN").append(':');
            stringBuffer.append(deity.getAlignment());
            stringBuffer.append("\n");
        }
    }

    private void appendDomainLines(StringBuffer stringBuffer) {
        for (CharacterDomain characterDomain : this.thePC.getCharacterDomainList()) {
            Domain domain;
            if (characterDomain == null || (domain = characterDomain.getDomain()) == null) continue;
            stringBuffer.append("DOMAIN").append(':');
            stringBuffer.append(EntityEncoder.encode(domain.getKeyName()));
            for (int i = 0; i < domain.getAssociatedCount(); ++i) {
                stringBuffer.append('|');
                stringBuffer.append("ASSOCIATEDDATA").append(':');
                stringBuffer.append(EntityEncoder.encode(domain.getAssociated(i)));
            }
            for (Description description : domain.getDescriptionList()) {
                stringBuffer.append('|');
                stringBuffer.append("DOMAINGRANTS").append(':');
                stringBuffer.append(description.getPCCText());
            }
            stringBuffer.append('|');
            PCGVer2Creator.appendSourceInTaggedFormat(stringBuffer, characterDomain.getDomainSourcePcgString());
            stringBuffer.append("\n");
        }
    }

    private void appendEqSetBonuses(StringBuffer stringBuffer) {
        for (EquipSet equipSet : this.thePC.getEquipSet()) {
            if (!equipSet.useTempBonusList()) continue;
            stringBuffer.append("EQSETBONUS").append(':');
            stringBuffer.append(equipSet.getIdPath());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BonusObj bonusObj : equipSet.getTempBonusList()) {
                Object object;
                Object object2 = bonusObj.getCreatorObject();
                String string = this.tempBonusName(object2, object = bonusObj.getTargetObject());
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
                stringBuffer.append('|');
                stringBuffer.append("TBBONUS").append(':');
                stringBuffer.append(EntityEncoder.encode(string));
            }
            stringBuffer.append("\n");
        }
    }

    private void appendEquipmentLines(StringBuffer stringBuffer) {
        for (Equipment equipment : this.thePC.getEquipmentMasterList()) {
            stringBuffer.append("EQUIPNAME").append(':');
            stringBuffer.append(EntityEncoder.encode(equipment.getName()));
            stringBuffer.append('|');
            stringBuffer.append("OUTPUTORDER").append(':');
            stringBuffer.append(equipment.getOutputIndex());
            stringBuffer.append('|');
            stringBuffer.append("COST").append(':');
            stringBuffer.append(equipment.getCost(this.thePC).toString());
            stringBuffer.append('|');
            stringBuffer.append("WT").append(':');
            stringBuffer.append(equipment.getWeight(this.thePC).toString());
            stringBuffer.append('|');
            stringBuffer.append("QUANTITY").append(':');
            stringBuffer.append(equipment.qty());
            String string = equipment.formatSaveLine('$', '=').trim();
            int n = string.indexOf(36);
            if (string.length() > 0 && n >= 0) {
                stringBuffer.append('|');
                stringBuffer.append("CUSTOMIZATION").append(':');
                stringBuffer.append('[');
                stringBuffer.append("BASEITEM").append(':');
                stringBuffer.append(EntityEncoder.encode(string.substring(0, n)));
                stringBuffer.append('|');
                stringBuffer.append("DATA").append(':');
                stringBuffer.append(EntityEncoder.encode(string.substring(n + 1)));
                stringBuffer.append(']');
            }
            stringBuffer.append("\n");
        }
    }

    private void appendEquipmentSetLines(StringBuffer stringBuffer) {
        List<EquipSet> list = this.thePC.getEquipSet();
        Collections.sort(list);
        for (EquipSet equipSet : list) {
            stringBuffer.append("EQUIPSET").append(':');
            stringBuffer.append(EntityEncoder.encode(equipSet.getName()));
            stringBuffer.append('|');
            stringBuffer.append("ID").append(':');
            stringBuffer.append(equipSet.getIdPath());
            if (equipSet.getValue().length() > 0) {
                stringBuffer.append('|');
                stringBuffer.append("VALUE").append(':');
                stringBuffer.append(EntityEncoder.encode(equipSet.getValue()));
                stringBuffer.append('|');
                stringBuffer.append("QUANTITY").append(':');
                stringBuffer.append(equipSet.getQty());
            }
            if (equipSet.getNote().length() > 0) {
                stringBuffer.append('|');
                stringBuffer.append("NOTE").append(':');
                stringBuffer.append(equipSet.getNote());
            }
            if (equipSet.getUseTempMods()) {
                stringBuffer.append('|');
                stringBuffer.append("USETEMPMODS").append(':');
                stringBuffer.append(equipSet.getUseTempMods() ? (char)'Y' : 'N');
            }
            stringBuffer.append("\n");
        }
        String string = this.thePC.getCalcEquipSetId();
        stringBuffer.append("CALCEQUIPSET").append(':');
        stringBuffer.append(string);
        stringBuffer.append("\n");
    }

    private void appendEyeColorLine(StringBuffer stringBuffer) {
        stringBuffer.append("EYECOLOR").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getEyeColor()));
        stringBuffer.append("\n");
    }

    private void appendFeatLines(StringBuffer stringBuffer) {
        stringBuffer.append("FEATPOOL").append(':');
        stringBuffer.append(this.thePC.getRawFeats(false));
        stringBuffer.append("\n");
    }

    private void appendAbilityLines(StringBuffer stringBuffer) {
        for (AbilityCategory abilityCategory : SettingsHandler.getGame().getAllAbilityCategories()) {
            if (!abilityCategory.isEditable()) continue;
            List<Ability> list = this.thePC.getRealAbilitiesList(abilityCategory);
            for (Ability ability : this.thePC.getVirtualAbilityList(abilityCategory)) {
                if (!ability.needsSaving()) continue;
                list.add(ability);
            }
            for (Ability ability : list) {
                stringBuffer.append("ABILITY").append(":");
                stringBuffer.append(EntityEncoder.encode(abilityCategory.getKeyName())).append("|");
                stringBuffer.append("TYPE").append(":");
                stringBuffer.append(EntityEncoder.encode(ability.getFeatType().toString())).append("|");
                stringBuffer.append("CATEGORY").append(":");
                stringBuffer.append(EntityEncoder.encode(ability.getCategory())).append("|");
                stringBuffer.append("KEY").append(":");
                stringBuffer.append(EntityEncoder.encode(ability.getKeyName())).append("|");
                int n = 0;
                if (ability.isMultiples()) {
                    stringBuffer.append("APPLIEDTO").append(":");
                    if (ability.getAssociatedObject(0) instanceof FeatMultipleChoice) {
                        stringBuffer.append("MULTISELECT").append(':');
                    }
                    while (n < ability.getAssociatedCount()) {
                        if (n > 0 && n < ability.getAssociatedCount()) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(EntityEncoder.encode(ability.getAssociated(n)));
                        ++n;
                    }
                    stringBuffer.append("|");
                }
                stringBuffer.append("TYPE").append(":");
                stringBuffer.append(EntityEncoder.encode(ability.getType()));
                for (String string : ability.getSafeListFor(ListKey.SAVE)) {
                    stringBuffer.append('|');
                    stringBuffer.append("SAVE").append(':');
                    stringBuffer.append(EntityEncoder.encode(string));
                }
                for (Description description : ability.getDescriptionList()) {
                    stringBuffer.append("|");
                    stringBuffer.append("DESC").append(':');
                    stringBuffer.append(EntityEncoder.encode(description.getPCCText()));
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("USERPOOL").append(":");
            stringBuffer.append(EntityEncoder.encode(abilityCategory.getKeyName())).append("|");
            stringBuffer.append("POOLPOINTS").append(":");
            stringBuffer.append(this.thePC.getUserPoolBonus(abilityCategory));
            stringBuffer.append("\n");
        }
    }

    private List<String> buildLevelAbilityFeatList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PCLevelInfo pCLevelInfo : this.thePC.getLevelInfo()) {
            String string = pCLevelInfo.getClassKeyName();
            int n = pCLevelInfo.getLevel() - 1;
            PCClass pCClass = this.thePC.getClassKeyed(string);
            List<LevelAbility> list = pCClass.getLevelAbilityList();
            if (pCClass == null || list == null) continue;
            for (LevelAbility levelAbility : list) {
                if (levelAbility.level() - 1 != n || levelAbility.getAssociatedCount() == 0) continue;
                for (int i = 0; i < levelAbility.getAssociatedCount(true); ++i) {
                    arrayList.add(levelAbility.getAssociated(i, true));
                }
            }
        }
        return arrayList;
    }

    private boolean isInLevelAbilityList(List<String> list, Ability ability, String string) {
        String string2 = ability.getKeyName();
        if (string != null && string.length() > 0) {
            string2 = string2 + '(' + string + ')';
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (!string2.equals(string3) || ability.getAssociatedCount() != 0 && (string == null || string.length() <= 0)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private void appendFollowerLines(StringBuffer stringBuffer) {
        List<Follower> list;
        Follower follower = this.thePC.getMaster();
        if (follower != null) {
            stringBuffer.append("MASTER").append(':');
            stringBuffer.append(EntityEncoder.encode(follower.getName()));
            stringBuffer.append('|');
            stringBuffer.append("TYPE").append(':');
            stringBuffer.append(EntityEncoder.encode(follower.getType()));
            stringBuffer.append('|');
            stringBuffer.append("HITDICE").append(':');
            stringBuffer.append(follower.getUsedHD());
            stringBuffer.append('|');
            stringBuffer.append("FILE").append(':');
            stringBuffer.append(EntityEncoder.encode(follower.getRelativeFileName()));
            stringBuffer.append('|');
            stringBuffer.append("ADJUSTMENT").append(':');
            stringBuffer.append(follower.getAdjustment());
            stringBuffer.append("\n");
        }
        if (!(list = this.thePC.getFollowerList()).isEmpty()) {
            for (Follower follower2 : list) {
                stringBuffer.append("FOLLOWER").append(':');
                stringBuffer.append(EntityEncoder.encode(follower2.getName()));
                stringBuffer.append('|');
                stringBuffer.append("TYPE").append(':');
                stringBuffer.append(EntityEncoder.encode(follower2.getType()));
                stringBuffer.append('|');
                stringBuffer.append("RACE").append(':');
                stringBuffer.append(EntityEncoder.encode(follower2.getRace().toUpperCase()));
                stringBuffer.append('|');
                stringBuffer.append("HITDICE").append(':');
                stringBuffer.append(follower2.getUsedHD());
                stringBuffer.append('|');
                stringBuffer.append("FILE").append(':');
                stringBuffer.append(EntityEncoder.encode(follower2.getRelativeFileName()));
                stringBuffer.append("\n");
            }
        }
    }

    private void appendGenderLine(StringBuffer stringBuffer) {
        stringBuffer.append("GENDER").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getGender()));
        stringBuffer.append("\n");
    }

    private void appendHairColorLine(StringBuffer stringBuffer) {
        stringBuffer.append("HAIRCOLOR").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getHairColor()));
        stringBuffer.append("\n");
    }

    private void appendHairStyleLine(StringBuffer stringBuffer) {
        stringBuffer.append("HAIRSTYLE").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getHairStyle()));
        stringBuffer.append("\n");
    }

    private void appendHandedLine(StringBuffer stringBuffer) {
        stringBuffer.append("HANDED").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getHanded()));
        stringBuffer.append("\n");
    }

    private void appendInterestsLine(StringBuffer stringBuffer) {
        stringBuffer.append("INTERESTS").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getInterests()));
        stringBuffer.append("\n");
    }

    private void appendKitLines(StringBuffer stringBuffer) {
        if (this.thePC.getKitInfo() != null) {
            for (Kit kit : this.thePC.getKitInfo()) {
                stringBuffer.append("KIT").append(':').append(kit.getKeyName()).append("\n");
            }
        }
    }

    private void appendLanguageLine(StringBuffer stringBuffer) {
        String string = "";
        for (Language language : this.thePC.getLanguagesList()) {
            stringBuffer.append(string);
            stringBuffer.append("LANGUAGE").append(':');
            stringBuffer.append(EntityEncoder.encode(language.getKeyName()));
            string = "|";
        }
        stringBuffer.append("\n");
    }

    private void appendLocationLine(StringBuffer stringBuffer) {
        stringBuffer.append("LOCATION").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getLocation()));
        stringBuffer.append("\n");
    }

    private static void appendNewline(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
    }

    private void appendNotesLines(StringBuffer stringBuffer) {
        for (NoteItem noteItem : this.thePC.getNotesList()) {
            stringBuffer.append("NOTE").append(':');
            stringBuffer.append(EntityEncoder.encode(noteItem.getName()));
            stringBuffer.append('|');
            stringBuffer.append("ID").append(':');
            stringBuffer.append(noteItem.getId());
            stringBuffer.append('|');
            stringBuffer.append("PARENTID").append(':');
            stringBuffer.append(noteItem.getParentId());
            stringBuffer.append('|');
            stringBuffer.append("VALUE").append(':');
            stringBuffer.append(EntityEncoder.encode(noteItem.getValue()));
            stringBuffer.append("\n");
        }
    }

    private void appendPersonalityTrait1Line(StringBuffer stringBuffer) {
        stringBuffer.append("PERSONALITYTRAIT1").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getTrait1()));
        stringBuffer.append("\n");
    }

    private void appendPersonalityTrait2Line(StringBuffer stringBuffer) {
        stringBuffer.append("PERSONALITYTRAIT2").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getTrait2()));
        stringBuffer.append("\n");
    }

    private void appendPhobiasLine(StringBuffer stringBuffer) {
        stringBuffer.append("PHOBIAS").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getPhobias()));
        stringBuffer.append("\n");
    }

    private void appendPoolPointsLine(StringBuffer stringBuffer) {
        stringBuffer.append("POOLPOINTS").append(':');
        stringBuffer.append(this.thePC.getPoolAmount());
        stringBuffer.append("\n");
        stringBuffer.append("POOLPOINTSAVAIL").append(':');
        stringBuffer.append(this.thePC.getPointBuyPoints());
        stringBuffer.append("\n");
    }

    private static void appendTabLabelLine(StringBuffer stringBuffer) {
        stringBuffer.append("TABLABEL").append(':');
        stringBuffer.append(SettingsHandler.getNameDisplayStyle());
        stringBuffer.append("\n");
    }

    private void appendAutoSortLines(StringBuffer stringBuffer) {
        stringBuffer.append("AUTOSORTGEAR").append(':');
        stringBuffer.append(this.thePC.isAutoSortGear() ? (char)'Y' : 'N');
        stringBuffer.append("\n");
        stringBuffer.append("SKILLSOUTPUTORDER").append(':');
        stringBuffer.append(this.thePC.getSkillsOutputOrder());
        stringBuffer.append("\n");
    }

    private void appendAutoSpellsLine(StringBuffer stringBuffer) {
        stringBuffer.append("AUTOSPELLS").append(':');
        stringBuffer.append(this.thePC.getAutoSpells() ? (char)'Y' : 'N');
        stringBuffer.append("\n");
    }

    private void appendUseHigherSpellSlotsLines(StringBuffer stringBuffer) {
        stringBuffer.append("USEHIGHERKNOWN").append(':');
        stringBuffer.append(this.thePC.getUseHigherKnownSlots() ? (char)'Y' : 'N');
        stringBuffer.append("\n");
        stringBuffer.append("USEHIGHERPREPPED").append(':');
        stringBuffer.append(this.thePC.getUseHigherPreppedSlots() ? (char)'Y' : 'N');
        stringBuffer.append("\n");
    }

    private void appendCharacterNameLine(StringBuffer stringBuffer) {
        stringBuffer.append("CHARACTERNAME").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getName()));
        stringBuffer.append("\n");
    }

    private void appendHeightLine(StringBuffer stringBuffer) {
        stringBuffer.append("HEIGHT").append(':');
        stringBuffer.append(this.thePC.getHeight());
        stringBuffer.append("\n");
    }

    private void appendLoadCompanionLine(StringBuffer stringBuffer) {
        stringBuffer.append("LOADCOMPANIONS").append(':');
        stringBuffer.append(this.thePC.getLoadCompanion() ? (char)'Y' : 'N');
        stringBuffer.append("\n");
    }

    private void appendOutputSheetsLines(StringBuffer stringBuffer) {
        if (SettingsHandler.getSaveOutputSheetWithPC()) {
            stringBuffer.append("OUTPUTSHEETHTML").append(':');
            stringBuffer.append(EntityEncoder.encode(SettingsHandler.getSelectedCharacterHTMLOutputSheet(null)));
            stringBuffer.append("\n");
            stringBuffer.append("OUTPUTSHEETPDF").append(':');
            stringBuffer.append(EntityEncoder.encode(SettingsHandler.getSelectedCharacterPDFOutputSheet(null)));
            stringBuffer.append("\n");
        }
    }

    private void appendPlayerNameLine(StringBuffer stringBuffer) {
        stringBuffer.append("PLAYERNAME").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getPlayersName()));
        stringBuffer.append("\n");
    }

    private void appendPortraitLine(StringBuffer stringBuffer) {
        stringBuffer.append("PORTRAIT").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getPortraitPath()));
        stringBuffer.append("\n");
    }

    private void appendRaceLine(StringBuffer stringBuffer) {
        stringBuffer.append("RACE").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getRace().getKeyName()));
        int n = this.thePC.getRace().hitDice(this.thePC);
        if (n != 0) {
            stringBuffer.append('|').append("HITPOINTS");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(':').append(this.thePC.getRace().getHitPoint(i).toString());
            }
        }
        stringBuffer.append("\n");
    }

    private void appendResidenceLine(StringBuffer stringBuffer) {
        stringBuffer.append("CITY").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getResidence()));
        stringBuffer.append("\n");
    }

    private void appendSkinColorLine(StringBuffer stringBuffer) {
        stringBuffer.append("SKINCOLOR").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getSkinColor()));
        stringBuffer.append("\n");
    }

    private static void appendSourceInTaggedFormat(StringBuffer stringBuffer, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|=");
        stringBuffer.append("SOURCE").append(':');
        stringBuffer.append('[');
        stringBuffer.append("TYPE").append(':');
        stringBuffer.append(stringTokenizer.nextToken());
        stringBuffer.append('|');
        stringBuffer.append("NAME").append(':');
        stringBuffer.append(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append('|');
            stringBuffer.append("LEVEL").append(':');
            stringBuffer.append(stringTokenizer.nextToken());
        }
        if (string.indexOf(61) >= 0) {
            stringBuffer.append('|');
            stringBuffer.append("DEFINED").append(':');
            stringBuffer.append('Y');
        }
        stringBuffer.append(']');
    }

    private static void appendSourceInTaggedFormat(StringBuffer stringBuffer, PObject pObject) {
        stringBuffer.append("SOURCE").append(':');
        stringBuffer.append('[');
        stringBuffer.append("TYPE").append(':');
        Class<?> clazz = pObject.getClass();
        String string = clazz.getPackage().getName();
        String string2 = clazz.getName().substring(string.length() + 1);
        stringBuffer.append(string2.toUpperCase());
        stringBuffer.append('|');
        stringBuffer.append("NAME").append(':');
        stringBuffer.append(pObject.getKeyName());
        stringBuffer.append(']');
    }

    private static void appendSpecials(StringBuffer stringBuffer, List<String> list, String string, String string2, int n) {
        if (list != null && !list.isEmpty()) {
            stringBuffer.append('|');
            stringBuffer.append(string).append(':');
            stringBuffer.append('[');
            String string3 = "";
            for (String string4 : list) {
                stringBuffer.append(string3);
                stringBuffer.append(string2).append(':');
                stringBuffer.append(EntityEncoder.encode(string4));
                if (n == -1) {
                    stringBuffer.append(":-1");
                }
                string3 = "|";
            }
            stringBuffer.append(']');
        }
    }

    private void appendExperienceLine(StringBuffer stringBuffer) {
        stringBuffer.append("EXPERIENCE").append(':');
        stringBuffer.append(this.thePC.getXP());
        stringBuffer.append("\n");
    }

    private void appendRegionLine(StringBuffer stringBuffer) {
        String string = this.thePC.getRegion(false);
        if (string != null) {
            stringBuffer.append("REGION").append(':').append(string).append("\n");
        }
    }

    private void appendSkillLines(StringBuffer stringBuffer) {
        int n = SettingsHandler.getIncludeSkills();
        if (n == 3) {
            n = SettingsHandler.getSkillsTab_IncludeSkills();
        }
        this.thePC.populateSkills(n);
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.thePC.getSkillList());
        for (Skill skill : arrayList) {
            if (!(skill.getRank().doubleValue() > 0.0) && skill.getOutputIndex() == 0) continue;
            stringBuffer.append("SKILL").append(':');
            stringBuffer.append(EntityEncoder.encode(skill.getKeyName()));
            stringBuffer.append('|');
            stringBuffer.append("OUTPUTORDER").append(':');
            stringBuffer.append(skill.getOutputIndex());
            stringBuffer.append('|');
            for (String string : skill.getRankList()) {
                int n2 = string.indexOf(58);
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                PCClass pCClass = this.thePC.getClassKeyed(string2);
                stringBuffer.append("CLASSBOUGHT").append(':');
                stringBuffer.append('[');
                stringBuffer.append("CLASS").append(':');
                stringBuffer.append(EntityEncoder.encode(string2));
                stringBuffer.append('|');
                stringBuffer.append("RANKS").append(':');
                stringBuffer.append(string3);
                stringBuffer.append('|');
                stringBuffer.append("COST").append(':');
                stringBuffer.append(Integer.toString(skill.costForPCClass(pCClass, this.thePC)));
                stringBuffer.append('|');
                stringBuffer.append("CLASSSKILL").append(':');
                stringBuffer.append(skill.isClassSkill(pCClass, this.thePC) ? (char)'Y' : 'N');
                stringBuffer.append(']');
            }
            for (int i = 0; i < skill.getAssociatedCount(); ++i) {
                stringBuffer.append('|');
                stringBuffer.append("ASSOCIATEDDATA").append(':');
                stringBuffer.append(EntityEncoder.encode(skill.getAssociated(i)));
            }
            this.appendLevelAbilityInfo(stringBuffer, skill);
            stringBuffer.append("\n");
        }
    }

    private void appendSpeechPatternLine(StringBuffer stringBuffer) {
        stringBuffer.append("SPEECHPATTERN").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getSpeechTendency()));
        stringBuffer.append("\n");
    }

    private void appendSpellBookLines(StringBuffer stringBuffer) {
        for (String string : this.thePC.getSpellBooks()) {
            if (string.equals(Globals.getDefaultSpellBook()) || string.equals("Innate")) continue;
            SpellBook spellBook = this.thePC.getSpellBookByName(string);
            stringBuffer.append("SPELLBOOK").append(':');
            stringBuffer.append(spellBook.getName());
            stringBuffer.append('|');
            stringBuffer.append("TYPE").append(':');
            stringBuffer.append(spellBook.getType());
            if (spellBook.getName().equals(this.thePC.getSpellBookNameToAutoAddKnown())) {
                stringBuffer.append('|');
                stringBuffer.append("AUTOADDKNOWN").append(':');
                stringBuffer.append('Y');
            }
            stringBuffer.append("\n");
        }
    }

    private void appendSpellLines(StringBuffer stringBuffer) {
        for (PCClass pCClass : this.thePC.getClassList()) {
            for (CharacterSpell characterSpell : pCClass.getSpellSupport().getCharacterSpell(null, "", -1)) {
                for (SpellInfo spellInfo : characterSpell.getInfoList()) {
                    List<Ability> list;
                    String string = characterSpell.getOwner().getSpellKey();
                    if (spellInfo.getBook().equals(Globals.getDefaultSpellBook()) && pCClass.isAutoKnownSpell(characterSpell.getSpell().getKeyName(), characterSpell.getSpell().getFirstLevelForKey(string, this.thePC), this.thePC) && this.thePC.getAutoSpells()) continue;
                    stringBuffer.append("SPELLNAME").append(':');
                    stringBuffer.append(EntityEncoder.encode(characterSpell.getSpell().getKeyName()));
                    stringBuffer.append('|');
                    stringBuffer.append("TIMES").append(':');
                    stringBuffer.append(spellInfo.getTimes());
                    stringBuffer.append('|');
                    stringBuffer.append("CLASS").append(':');
                    stringBuffer.append(EntityEncoder.encode(pCClass.getKeyName()));
                    stringBuffer.append('|');
                    stringBuffer.append("BOOK").append(':');
                    stringBuffer.append(EntityEncoder.encode(spellInfo.getBook()));
                    stringBuffer.append('|');
                    stringBuffer.append("SPELLLEVEL").append(':');
                    stringBuffer.append(spellInfo.getActualLevel());
                    if (Spell.hasPPCost()) {
                        stringBuffer.append('|');
                        stringBuffer.append("SPELLPPCOST").append(':');
                        stringBuffer.append(spellInfo.getActualPPCost());
                    }
                    if (spellInfo.getNumPages() > 0) {
                        stringBuffer.append('|');
                        stringBuffer.append("SPELLNUMPAGES").append(':');
                        stringBuffer.append(spellInfo.getNumPages());
                    }
                    if ((list = spellInfo.getFeatList()) != null && !list.isEmpty()) {
                        stringBuffer.append('|');
                        stringBuffer.append("FEATLIST").append(':');
                        stringBuffer.append('[');
                        String string2 = "";
                        for (Ability ability : list) {
                            stringBuffer.append(string2);
                            stringBuffer.append("FEAT").append(':');
                            stringBuffer.append(EntityEncoder.encode(ability.getKeyName()));
                            string2 = "|";
                        }
                        stringBuffer.append(']');
                    }
                    stringBuffer.append('|');
                    PCGVer2Creator.appendSourceInTaggedFormat(stringBuffer, string);
                    stringBuffer.append("\n");
                }
            }
        }
    }

    private void appendSpellListLines(StringBuffer stringBuffer) {
        for (PCClass pCClass : this.thePC.getClassList()) {
            if (pCClass.getClassSpellList() == null || pCClass.getClassSpellList().size() <= 0) continue;
            stringBuffer.append("SPELLLIST").append(':');
            stringBuffer.append(pCClass.getKeyName());
            for (String string : pCClass.getClassSpellList()) {
                stringBuffer.append('|').append(string);
            }
            stringBuffer.append("\n");
        }
    }

    private void appendStatLines(StringBuffer stringBuffer) {
        for (PCStat pCStat : this.thePC.getStatList()) {
            stringBuffer.append("STAT").append(':');
            stringBuffer.append(pCStat.getAbb());
            stringBuffer.append('|');
            stringBuffer.append("SCORE").append(':');
            stringBuffer.append(pCStat.getBaseScore());
            stringBuffer.append("\n");
        }
    }

    private void appendTabNameLine(StringBuffer stringBuffer) {
        stringBuffer.append("TABNAME").append(':');
        stringBuffer.append(EntityEncoder.encode(this.thePC.getTabName()));
        stringBuffer.append("\n");
    }

    private void appendTempBonuses(StringBuffer stringBuffer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BonusObj bonusObj : this.thePC.getTempBonusList()) {
            Object object;
            Object object2 = bonusObj.getCreatorObject();
            String string = this.tempBonusName(object2, object = bonusObj.getTargetObject());
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
            String string2 = this.tempBonusName(object2, object);
            stringBuffer.append(string2);
            for (BonusObj bonusObj2 : this.thePC.getTempBonusList()) {
                Object object3;
                Object object4 = bonusObj2.getCreatorObject();
                String string3 = this.tempBonusName(object4, object3 = bonusObj2.getTargetObject());
                if (!string3.equals(string)) continue;
                stringBuffer.append('|');
                stringBuffer.append("TBBONUS").append(':');
                stringBuffer.append(EntityEncoder.encode(bonusObj2.getPCCText()));
            }
            stringBuffer.append("\n");
        }
    }

    private void appendTemplateLines(StringBuffer stringBuffer) {
        for (PCTemplate pCTemplate : this.thePC.getTemplateList()) {
            stringBuffer.append("TEMPLATESAPPLIED").append(':').append('[');
            stringBuffer.append("NAME").append(':').append(EntityEncoder.encode(pCTemplate.getKeyName()));
            String string = this.chosenFeats(pCTemplate);
            if (string.length() != 0) {
                stringBuffer.append('|').append(string);
            }
            for (String string2 : pCTemplate.templatesAdded()) {
                stringBuffer.append('|').append("CHOSENTEMPLATE").append(':').append('[');
                stringBuffer.append("NAME").append(':').append(EntityEncoder.encode(string2));
                stringBuffer.append(']');
            }
            stringBuffer.append(']').append("\n");
        }
    }

    private void appendUseTempModsLine(StringBuffer stringBuffer) {
        stringBuffer.append("USETEMPMODS").append(':');
        stringBuffer.append(this.thePC.getUseTempMods() ? (char)'Y' : 'N');
        stringBuffer.append("\n");
    }

    private void appendWeaponProficiencyLines(StringBuffer stringBuffer) {
        int n = this.thePC.getWeaponProfs().size();
        if (n > 0) {
            String[] stringArray = new String[n];
            int n2 = 0;
            for (WeaponProf weaponProf : this.thePC.getWeaponProfs()) {
                stringArray[n2++] = weaponProf.getKeyName();
            }
            int n3 = n / 10 + (n % 10 > 0 ? 1 : 0);
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append("WEAPONPROF").append(':');
                stringBuffer.append('[');
                String string = "";
                int n4 = Math.min(n, i * 10 + 10);
                for (int j = i * 10; j < n4; ++j) {
                    stringBuffer.append(string);
                    stringBuffer.append("WEAPON").append(':');
                    stringBuffer.append(EntityEncoder.encode((String)stringArray[j]));
                    string = "|";
                }
                stringBuffer.append(']');
                stringBuffer.append("\n");
            }
        }
        PCGVer2Creator.appendWeaponProficiencyLines(stringBuffer, this.thePC.getRace());
        for (PCClass pCClass : this.thePC.getClassList()) {
            PCGVer2Creator.appendWeaponProficiencyLines(stringBuffer, pCClass);
        }
        for (CharacterDomain characterDomain : this.thePC.getCharacterDomainList()) {
            PCGVer2Creator.appendWeaponProficiencyLines(stringBuffer, characterDomain.getDomain());
        }
        for (Ability ability : this.thePC.getRealAbilityList(AbilityCategory.FEAT)) {
            PCGVer2Creator.appendWeaponProficiencyLines(stringBuffer, ability);
        }
    }

    private static void appendWeaponProficiencyLines(StringBuffer stringBuffer, PObject pObject) {
        if (pObject == null) {
            return;
        }
        List<String> list = pObject.getListFor(ListKey.SELECTED_WEAPON_PROF_BONUS);
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size() / 10 + 1;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("WEAPONPROF").append(':');
            stringBuffer.append('[');
            String string = "";
            int n2 = Math.min(list.size(), i * 10 + 10);
            for (int j = i * 10; j < n2; ++j) {
                stringBuffer.append(string);
                stringBuffer.append("WEAPON").append(':');
                stringBuffer.append(EntityEncoder.encode(list.get(j)));
                string = "|";
            }
            stringBuffer.append(']');
            stringBuffer.append('|');
            PCGVer2Creator.appendSourceInTaggedFormat(stringBuffer, pObject);
            stringBuffer.append("\n");
        }
    }

    private void appendMoneyLine(StringBuffer stringBuffer) {
        stringBuffer.append("MONEY").append(':');
        stringBuffer.append(this.thePC.getGold().toString());
        stringBuffer.append("\n");
    }

    private void appendWeightLine(StringBuffer stringBuffer) {
        stringBuffer.append("WEIGHT").append(':');
        stringBuffer.append(this.thePC.getWeight());
        stringBuffer.append("\n");
    }

    private String chosenFeats(PCTemplate pCTemplate) {
        StringBuffer stringBuffer = new StringBuffer(50);
        HashMap<String, String> hashMap = pCTemplate.getChosenFeatStrings();
        if (hashMap != null) {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append('|');
                }
                stringBuffer.append("CHOSENFEAT").append(':');
                stringBuffer.append('[');
                stringBuffer.append("KEY").append(':').append(EntityEncoder.encode(entry.getKey())).append('|');
                stringBuffer.append("VALUE").append(':').append(EntityEncoder.encode(entry.getValue()));
                stringBuffer.append(']');
            }
        }
        return stringBuffer.toString();
    }

    private static String createComment(String string) {
        String string2 = string + "\n";
        string2 = string2.replace('\t', ' ');
        string2 = string2.replace('\f', ' ');
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "#");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        string2 = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        stringTokenizer = new StringTokenizer(string2, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("# ").append(stringTokenizer.nextToken()).append("\n");
        }
        return stringBuffer.toString();
    }

    private String tempBonusName(Object object, Object object2) {
        PObject pObject;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TEMPBONUS").append(':');
        if (object instanceof PObject) {
            pObject = (PObject)object;
            if (pObject instanceof Ability) {
                stringBuffer.append("FEAT").append('=');
            } else if (pObject instanceof Spell) {
                stringBuffer.append("SPELL").append('=');
            } else if (pObject instanceof Equipment) {
                stringBuffer.append("EQUIPMENT").append('=');
            } else if (pObject instanceof PCClass) {
                stringBuffer.append("CLASS").append('=');
            } else if (pObject instanceof PCTemplate) {
                stringBuffer.append("TEMPLATE").append('=');
            } else if (pObject instanceof Skill) {
                stringBuffer.append("SKILL").append('=');
            } else {
                stringBuffer.append("ERROR").append('=');
            }
        } else {
            return "";
        }
        stringBuffer.append(EntityEncoder.encode(pObject.getKeyName()));
        stringBuffer.append('|');
        stringBuffer.append("TBTARGET").append(':');
        if (object2 instanceof PlayerCharacter) {
            stringBuffer.append("PC");
        } else if (object2 instanceof Equipment) {
            stringBuffer.append(EntityEncoder.encode(((Equipment)object2).getName()));
        }
        return stringBuffer.toString();
    }

    private void appendLevelAbilityInfo(StringBuffer stringBuffer, PObject pObject) {
        this.appendLevelAbilityInfo(stringBuffer, pObject, -10);
    }

    private void appendLevelAbilityInfo(StringBuffer stringBuffer, PObject pObject, int n) {
        List<LevelAbility> list = pObject.getLevelAbilityList();
        if (list != null) {
            for (LevelAbility levelAbility : list) {
                if (levelAbility.level() - 1 != n || levelAbility.getAssociatedCount() == 0) continue;
                stringBuffer.append('|').append("ABILITY").append(':').append('[').append("PROMPT").append(':').append(EntityEncoder.encode(levelAbility.getTagData()));
                for (int i = 0; i < levelAbility.getAssociatedCount(true); ++i) {
                    stringBuffer.append('|').append("CHOICE").append(':').append(EntityEncoder.encode(levelAbility.getAssociated(i, true)));
                }
                stringBuffer.append(']');
            }
        }
    }
}

