/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import pcgen.util.Logging;

public final class WholeNumberField
extends JTextField
implements Serializable {
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    public WholeNumberField() {
        this(0, 0);
    }

    public WholeNumberField(int n, int n2) {
        super(n2);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(n);
    }

    public void setValue(int n) {
        this.setText(Integer.toString(n));
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            Logging.errorPrint("", parseException);
        }
        return n;
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    private static class WholeNumberDocument
    extends PlainDocument {
        private WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (i == 0 && cArray[i] == '-') {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                if (Character.isDigit(cArray[i])) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                Logging.errorPrint("insertString: " + cArray[i] + " in " + string);
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

