/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.chooser.ChooserTableModel;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwingChooser
extends JDialog
implements ChooserInterface {
    static final long serialVersionUID = -2148735105737308335L;
    private static final String in_available = PropertyFactory.getString("in_available");
    private static final String in_selected = PropertyFactory.getString("in_selected");
    private static final String in_completeMess = PropertyFactory.getString("in_completeMess");
    private static final String in_chooser = PropertyFactory.getString("in_chooser");
    private static final String in_selRemain = PropertyFactory.getString("in_selRemain");
    private static final String in_validItem = PropertyFactory.getString("in_validItem");
    private static final String in_deselectOne = PropertyFactory.getString("in_deselectOne");
    private static final String in_noRemain = PropertyFactory.getString("in_noRemain");
    private static final String in_addOne = PropertyFactory.getString("in_addOne");
    private static final String in_selectPartA = PropertyFactory.getString("in_selectPartA");
    private static final String in_selectPartB = PropertyFactory.getString("in_selectPartB");
    private static final String in_alreadySelected = PropertyFactory.getString("in_alreadySelected");
    private static final String in_closeChooserTip = PropertyFactory.getString("in_closeChooserTip");
    private static final String in_pressToAdd = PropertyFactory.getString("in_pressToAdd");
    private static final String in_pressToRemove = PropertyFactory.getString("in_pressToRemove");
    private static final String in_removeOne = PropertyFactory.getString("in_removeOne");
    private static final List<String> AVAILABLE_COLUMN_NAMES = Arrays.asList(in_available);
    private static final List<String> SELECTED_COLUMN_NAMES = Arrays.asList(in_selected);
    private ChooserTableModel mAvailableModel = new ChooserTableModel();
    private ChooserTableModel mSelectedModel = new ChooserTableModel();
    private JButton mAddButton;
    private JButton mCloseButton;
    private JButton mRemoveButton;
    private JLabel mPoolText;
    private JLabelPane mMessageText;
    private JTableEx mAvailableTable;
    private JTableEx mSelectedTable;
    private List<String> mAvailableColumnNames;
    private List mAvailableList = new ArrayList();
    private List<String> mSelectedColumnNames;
    private List mSelectedList = new ArrayList();
    private List mUniqueList = new ArrayList();
    private String mSelectedTerminator = "";
    private boolean canGoNegative = false;
    private boolean mAllowDuplicates = false;
    private boolean mPoolFlag = true;
    private int mCostColumnNumber = -1;
    private int mPool;

    public SwingChooser() {
        super(Globals.getCurrentFrame());
        this.initComponents();
    }

    @Override
    public void setAllowsDups(boolean bl) {
        this.mAllowDuplicates = bl;
    }

    @Override
    public void setCostColumnNumber(int n) {
        this.mCostColumnNumber = n;
    }

    @Override
    public void setMessageText(String string) {
        String string2 = string == null || string.trim().length() == 0 ? "<html>&nbsp;</html>" : string;
        this.mMessageText.setText(string2);
    }

    @Override
    public void setNegativeAllowed(boolean bl) {
        this.canGoNegative = bl;
    }

    @Override
    public void setPool(int n) {
        this.mPool = n;
        this.mPoolText.setText(Integer.toString(this.mPool));
    }

    @Override
    public int getPool() {
        return this.mPool;
    }

    @Override
    public void setPoolFlag(boolean bl) {
        this.mPoolFlag = bl;
    }

    @Override
    public List getSelectedList() {
        return new ArrayList(this.mSelectedList);
    }

    @Override
    public void setSelectedListTerminator(String string) {
        this.mSelectedTerminator = string;
    }

    @Override
    public void setUniqueList(List list) {
        this.mUniqueList = list;
    }

    @Override
    public void setVisible(boolean bl) {
        int n;
        this.updateAvailableTable();
        this.updateSelectedTable();
        this.updateButtonStates();
        if (this.mAvailableList != null && this.mAvailableList.size() == 1 && bl && (n = SettingsHandler.getSingleChoicePreference()) != 0) {
            this.mAvailableTable.changeSelection(0, 0, false, false);
            this.updateButtonStates();
            if (this.mAddButton.isEnabled()) {
                this.selectAvailable();
                if (n == 2 && this.close()) {
                    return;
                }
            }
        }
        Window window = this.getOwner();
        Rectangle rectangle = window.getBounds();
        Rectangle rectangle2 = this.getBounds();
        int n2 = (int)rectangle2.getWidth();
        int n3 = (int)rectangle2.getHeight();
        this.setBounds((int)((double)window.getX() + (rectangle.getWidth() - (double)n2) / 2.0), (int)((double)window.getY() + (rectangle.getHeight() - (double)n3) / 2.0), n2, n3);
        super.setVisible(bl);
    }

    private int getAdjustment(JTableEx jTableEx) {
        TableModel tableModel = jTableEx.getModel();
        int n = jTableEx.getSelectedRow();
        int n2 = 1;
        if (this.mCostColumnNumber >= 0 && this.mCostColumnNumber < jTableEx.getColumnCount()) {
            try {
                n2 = Integer.parseInt(tableModel.getValueAt(n, this.mCostColumnNumber).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public void setAvailableColumnNames(List<String> list) {
        this.mAvailableColumnNames = list;
        this.mAvailableModel.setColumnsNames(list == null ? Globals.EMPTY_STRING_ARRAY : list.toArray(new String[list.size()]));
    }

    @Override
    public void setAvailableList(List list) {
        this.mAvailableList = list;
    }

    public void setSelectedColumnNames(List<String> list) {
        this.mSelectedColumnNames = list;
        this.mSelectedModel.setColumnsNames(list == null ? Globals.EMPTY_STRING_ARRAY : list.toArray(new String[list.size()]));
    }

    @Override
    public void setSelectedList(List list) {
        this.mSelectedList = list;
    }

    private void windowCloseEvent() {
        if (!this.mCloseButton.isEnabled() && JOptionPane.showConfirmDialog(this, "You still have choices remaining. Are you sure you want to close the dialog?", "PCGen", 0, 3) == 1) {
            return;
        }
        this.setVisible(false);
    }

    private boolean close() {
        if (this.mPool <= 0 || !this.mPoolFlag) {
            this.setVisible(false);
            return true;
        }
        this.setMessageText(in_completeMess);
        return false;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SwingChooser.this.windowCloseEvent();
            }
        });
        this.setModal(true);
        this.setSize(new Dimension(640, 400));
        this.setTitle(in_chooser);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.mAvailableModel = new ChooserTableModel();
        TableSorter tableSorter = new TableSorter(this.mAvailableModel);
        this.mAvailableTable = new JTableEx(tableSorter);
        JScrollPane jScrollPane = new JScrollPane(this.mAvailableTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        tableSorter.addMouseListenerToHeaderInTable(this.mAvailableTable);
        this.mSelectedModel = new ChooserTableModel();
        tableSorter = new TableSorter(this.mSelectedModel);
        this.mSelectedTable = new JTableEx(tableSorter);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSelectedTable);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        tableSorter.addMouseListenerToHeaderInTable(this.mSelectedTable);
        ListSelectionModel listSelectionModel = this.mAvailableTable.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.mSelectedTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel2.setSelectionMode(0);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SwingChooser.this.updateButtonStates();
                }
            }
        };
        listSelectionModel.addListSelectionListener(listSelectionListener);
        listSelectionModel2.addListSelectionListener(listSelectionListener);
        this.mAvailableTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SwingChooser.this.selectAvailable();
                }
            }
        });
        this.mSelectedTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SwingChooser.this.removeSelected();
                }
            }
        });
        JLabel jLabel = new JLabel(in_selRemain + ": ");
        this.mMessageText = new JLabelPane();
        this.mMessageText.setBackground(container.getBackground());
        this.setMessageText(null);
        this.mPoolText = new JLabel(" ");
        this.mAddButton = new JButton(PropertyFactory.getString("in_add"));
        this.mAddButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_add"));
        this.mCloseButton = new JButton(PropertyFactory.getString("in_close"));
        this.mCloseButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
        this.mRemoveButton = new JButton(PropertyFactory.getString("in_remove"));
        this.mRemoveButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_remove"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == SwingChooser.this.mAddButton) {
                    SwingChooser.this.selectAvailable();
                } else if (actionEvent.getSource() == SwingChooser.this.mRemoveButton) {
                    SwingChooser.this.removeSelected();
                } else if (actionEvent.getSource() == SwingChooser.this.mCloseButton) {
                    SwingChooser.this.close();
                }
            }
        };
        this.mAddButton.addActionListener(actionListener);
        this.mRemoveButton.addActionListener(actionListener);
        this.mCloseButton.addActionListener(actionListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mAddButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mRemoveButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mMessageText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        container.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        container.add((Component)this.mPoolText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        container.add((Component)this.mCloseButton, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.mCloseButton);
    }

    private void removeSelected() {
        this.setMessageText(null);
        if (this.mSelectedTable.getSelectedRowCount() == 0) {
            this.setMessageText(in_validItem);
            return;
        }
        if (this.mSelectedTable.getSelectedRowCount() > 1) {
            this.setMessageText(in_deselectOne);
            return;
        }
        int n = this.mSelectedTable.getSelectedRow();
        this.setPool(this.getPool() + this.getAdjustment(this.mSelectedTable));
        this.mSelectedList.remove(n);
        this.updateSelectedTable();
        this.updateButtonStates();
    }

    private void selectAvailable() {
        Object object4;
        int n;
        this.setMessageText(null);
        if (this.getPool() <= 0) {
            this.setMessageText(in_noRemain);
            return;
        }
        int n2 = this.mAvailableTable.getSelectedRow();
        if (n2 < 0) {
            this.setMessageText(in_validItem);
            return;
        }
        if (this.mAvailableTable.getSelectedRowCount() > 1) {
            this.setMessageText(in_addOne);
            return;
        }
        TableModel tableModel = this.mAvailableTable.getModel();
        Object object2 = tableModel.getValueAt(n2, 0);
        if (this.mUniqueList.contains(object2)) {
            this.setMessageText(in_selectPartA + " " + object2.toString() + " " + in_selectPartB);
            return;
        }
        TableModel tableModel2 = this.mSelectedTable.getModel();
        int n3 = tableModel2.getRowCount();
        for (n = 0; n < n3; ++n) {
            object4 = tableModel2.getValueAt(n, 0);
            if (!object2.equals(object4) || this.mAllowDuplicates) continue;
            this.setMessageText(object2 + " " + in_alreadySelected);
            return;
        }
        n = this.getAdjustment(this.mAvailableTable);
        if (this.getPool() - n < 0 && !this.canGoNegative) {
            this.setMessageText(in_noRemain);
            return;
        }
        n3 = tableModel2.getColumnCount();
        if (n3 > 1 && n2 >= 0) {
            object4 = (List)this.mAvailableList.get(n2);
            Object object3 = tableModel.getValueAt(n2, 0);
            if (object4.get(0).equals(object3)) {
                this.mSelectedList.add(object4);
            } else {
                for (Object object4 : this.mAvailableList) {
                    if (!object4.get(0).equals(object3)) continue;
                    this.mSelectedList.add(object4);
                    break;
                }
            }
        } else {
            this.mSelectedList.add(object2);
        }
        this.updateSelectedTable();
        this.setPool(this.getPool() - n);
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        String string;
        String string2;
        int n;
        int n2;
        String string3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.mPool > 0) {
            if (!this.mPoolFlag) {
                bl3 = true;
                string3 = in_closeChooserTip;
            } else {
                string3 = in_completeMess;
            }
            n2 = this.mAvailableTable.getSelectedRowCount();
            if (n2 == 1) {
                n = this.mAvailableTable.getSelectedRow();
                if (n >= 0 && n < this.mAvailableTable.getRowCount()) {
                    TableModel tableModel = this.mAvailableTable.getModel();
                    Object object = tableModel.getValueAt(n, 0);
                    if (!this.mUniqueList.contains(object)) {
                        bl = true;
                        string2 = in_pressToAdd + " " + object.toString();
                        int n3 = this.mSelectedTable.getRowCount();
                        for (int i = 0; i < n3; ++i) {
                            Object object2 = this.mSelectedModel.getValueAt(i, 0);
                            if (!object.equals(object2) || this.mAllowDuplicates) continue;
                            bl = false;
                            string2 = object + " " + in_alreadySelected;
                        }
                    } else {
                        string2 = in_selectPartA + " " + object + " " + in_selectPartB;
                    }
                } else {
                    string2 = in_validItem;
                }
            } else {
                string2 = n2 == 0 ? in_validItem : in_addOne;
            }
        } else {
            string2 = in_noRemain;
            string3 = in_closeChooserTip;
            bl3 = true;
        }
        n2 = this.mSelectedTable.getSelectedRowCount();
        if (n2 == 1) {
            n = this.mSelectedTable.getSelectedRow();
            if (n >= 0 && n < this.mSelectedTable.getRowCount()) {
                bl2 = true;
                string = in_pressToRemove + " " + this.mSelectedTable.getModel().getValueAt(n, 0) + ".";
            } else {
                string = in_validItem;
            }
        } else {
            string = n2 == 0 ? in_validItem : in_removeOne;
        }
        this.mAddButton.setEnabled(bl);
        this.mCloseButton.setEnabled(bl3);
        this.mRemoveButton.setEnabled(bl2);
        Utility.setDescription(this.mAddButton, string2);
        Utility.setDescription(this.mCloseButton, string3);
        Utility.setDescription(this.mRemoveButton, string);
    }

    private void updateAvailableTable() {
        if (this.mAvailableColumnNames == null) {
            this.setAvailableColumnNames(AVAILABLE_COLUMN_NAMES);
        }
        SwingChooser.updateTable(this.mAvailableTable, this.mAvailableModel, this.mAvailableList, "");
    }

    private void updateSelectedTable() {
        if (this.mSelectedColumnNames == null) {
            this.setSelectedColumnNames(this.mAvailableColumnNames == AVAILABLE_COLUMN_NAMES ? SELECTED_COLUMN_NAMES : this.mAvailableColumnNames);
        }
        SwingChooser.updateTable(this.mSelectedTable, this.mSelectedModel, this.mSelectedList, this.mSelectedTerminator);
    }

    private static List createInputList(List list, List list2, List list3, List list4, ColumnSetter columnSetter) {
        List list5 = list3;
        if (list4 != null) {
            if (list != null && list4.size() == list.size()) {
                int n = list4.size();
                for (int i = 0; i < n; ++i) {
                    if (list4.get(i).equals(list.get(i))) continue;
                    columnSetter.setColumnNames(list4);
                    break;
                }
            } else {
                columnSetter.setColumnNames(list4);
            }
        } else if (list != list2) {
            columnSetter.setColumnNames(list4);
        }
        return list5;
    }

    private static void updateTable(JTableEx jTableEx, ChooserTableModel chooserTableModel, List list, String string) {
        Object object;
        if (list.size() <= 0) {
            chooserTableModel.setData(null, string);
            return;
        }
        Object object2 = null;
        int n = jTableEx.getSelectedRow();
        if (n >= 0 && n < list.size()) {
            object2 = list.get(n);
        }
        ListSelectionModel listSelectionModel = jTableEx.getSelectionModel();
        listSelectionModel.clearSelection();
        Object[][] objectArray = new Object[list.size()][];
        int n2 = 0;
        for (Object e : list) {
            if (e instanceof String) {
                objectArray[n2++] = SwingChooser.parseString(e.toString());
                continue;
            }
            if (e instanceof Collection) {
                object = (Collection)e;
                int n3 = object.size();
                objectArray[n2] = new Object[n3];
                int n4 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    objectArray[n2][n4++] = iterator.next();
                }
                ++n2;
                continue;
            }
            objectArray[n2] = new Object[1];
            objectArray[n2++][0] = e;
        }
        chooserTableModel.setData(objectArray, string);
        if (object2 != null) {
            int n5 = chooserTableModel.getRowCount();
            for (int i = 0; i < n5; ++i) {
                object = chooserTableModel.getValueAt(i, 0);
                if (!object2.equals(object)) continue;
                listSelectionModel.setSelectionInterval(i, i);
                break;
            }
        }
    }

    private static String[] parseString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private static interface ColumnSetter {
        public void setColumnNames(List var1);
    }
}

