/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pcgen.core.Constants;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;

public class JTableEx
extends JTable {
    static final long serialVersionUID = 514835142307946415L;

    public JTableEx() {
        this(null, null, null);
    }

    public JTableEx(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public JTableEx(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    private JTableEx(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.setDefaultRenderer(BigDecimal.class, new AlignCellRenderer(4));
        this.setDefaultRenderer(Float.class, new AlignCellRenderer(4));
        this.setDefaultRenderer(Integer.class, new AlignCellRenderer(4));
    }

    public final void setOptimalColumnWidths(int[] nArray) {
        JTableHeader jTableHeader = this.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader != null ? jTableHeader.getDefaultRenderer() : null;
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel == null) {
            return;
        }
        int n = tableColumnModel.getColumnCount();
        if (nArray.length <= 0 || n < nArray.length || n < nArray[nArray.length - 1]) {
            Logging.errorPrint("Bad parameters passed to setOptimalColumnWidth.");
            return;
        }
        TableModel tableModel = this.getModel();
        int n2 = tableModel.getRowCount();
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            try {
                Component component;
                Object object;
                TableColumn tableColumn = tableColumnModel.getColumn(nArray[i]);
                if (tableColumn == null) continue;
                int n4 = tableColumn.getModelIndex();
                int n5 = -1;
                TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
                if (tableCellRenderer2 == null) {
                    tableCellRenderer2 = tableCellRenderer;
                }
                if (tableCellRenderer2 != null && (object = tableColumn.getHeaderValue()) != null && (component = tableCellRenderer2.getTableCellRendererComponent(this, object, false, false, -1, i)) != null) {
                    n5 = component.getPreferredSize().width;
                }
                if ((object = tableColumn.getCellRenderer()) == null) {
                    object = this.getDefaultRenderer(tableModel.getColumnClass(n4));
                }
                if (object != null) {
                    for (int j = n2 - 1; j >= 0; --j) {
                        Component component2;
                        Object object2 = tableModel.getValueAt(j, n4);
                        if (object2 == null || (component2 = object.getTableCellRendererComponent(this, object2, false, false, j, n4)) == null) continue;
                        n5 = Math.max(n5, component2.getPreferredSize().width);
                    }
                }
                if (n5 >= 0) {
                    tableColumn.setPreferredWidth(n5 + 5);
                }
                n3 += tableColumn.getPreferredWidth();
                continue;
            }
            catch (Exception exception) {
                Logging.errorPrint("Exception JTableEx.setOptimalColumnWidths:" + i + ":" + nArray.length + ":" + n + Constants.s_LINE_SEP + "Exception type:" + exception.getClass().getName() + Constants.s_LINE_SEP + "Message:" + exception.getMessage());
            }
        }
        Dimension dimension = this.getPreferredScrollableViewportSize();
        dimension.width = n3 += n * tableColumnModel.getColumnMargin();
        this.setPreferredScrollableViewportSize(dimension);
        this.sizeColumnsToFit(-1);
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        if (SettingsHandler.isToolTipTextShown()) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n < 0 || n2 < 0) {
                return null;
            }
            Object object = this.getValueAt(n, n2);
            if (object == null || "".equals(object.toString())) {
                return null;
            }
            return JTableEx.wrap(object.toString());
        }
        return null;
    }

    public void setColAlign(int n, int n2) {
        this.getColumnModel().getColumn(n).setCellRenderer(new AlignCellRenderer(n2));
    }

    public void updateUI() {
        super.updateUI();
        this.getTableHeader().updateUI();
    }

    private static String wrap(String string) {
        String string2 = string.substring(string.lastIndexOf("|") + 1);
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        while (n > 70 && string2.indexOf(92) < 0) {
            int n2 = -1;
            boolean bl = false;
            int n3 = 0;
            block6: for (int i = 0; i < n && n3 < 70; ++i) {
                switch (string2.charAt(i)) {
                    case ' ': {
                        if (bl) continue block6;
                        n2 = i;
                        ++n3;
                        continue block6;
                    }
                    case '<': {
                        bl = true;
                        continue block6;
                    }
                    case '>': {
                        bl = false;
                        continue block6;
                    }
                    default: {
                        if (bl) continue block6;
                        ++n3;
                    }
                }
            }
            if (n3 < 70) {
                n2 = n;
            }
            if (n2 == -1) {
                n2 = 70;
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append("<br>");
            }
            stringBuffer.append(string2.substring(0, n2));
            string2 = string2.substring(n2).trim();
            n = string2.length();
        }
        if (string2.length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("<br>");
            }
            stringBuffer.append(string2);
        }
        if (!stringBuffer.toString().startsWith("<html>")) {
            stringBuffer.insert(0, "<html>");
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString();
    }

    public static final class AlignCellRenderer
    extends DefaultTableCellRenderer {
        private int align = 2;

        public AlignCellRenderer(int n) {
            this.align = n;
            this.setHorizontalAlignment(this.align);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setEnabled(jTable == null || jTable.isEnabled());
            this.setHorizontalAlignment(this.align);
            return this;
        }
    }
}

