/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.tabs.ability.AbilitySelectionPanel;
import pcgen.gui.tabs.ability.IAbilityListFilter;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityModel
extends AbstractTreeTableModel
implements TableColumnManagerModel {
    private AbilitySelectionPanel.ViewMode theViewMode = AbilitySelectionPanel.ViewMode.TYPENAME;
    private PlayerCharacter thePC = null;
    private List<Ability> theAbilityList;
    private AbilityCategory theCategory;
    private IAbilityListFilter theFilter = null;
    private String theOptionsRoot = "InfoAbility.";
    private PObjectNode typeRoot = null;
    private PObjectNode sourceRoot = null;

    public AbilityModel(PlayerCharacter playerCharacter, List<Ability> list, AbilityCategory abilityCategory, AbilitySelectionPanel.ViewMode viewMode, String string) {
        super(null);
        this.thePC = playerCharacter;
        this.theAbilityList = list;
        this.theOptionsRoot = string;
        this.theViewMode = viewMode;
        this.theCategory = abilityCategory;
        this.setPanelSpecificDefaults();
        for (Column column : Column.values()) {
            column.setVisible(SettingsHandler.getPCGenOption(this.theOptionsRoot + ".viewcol." + column.toString(), column.isVisible()));
        }
        this.resetModel(this.thePC, viewMode, false);
    }

    private void setPanelSpecificDefaults() {
        Logging.debugPrint("setPanelSpecificDefaults for " + this.theOptionsRoot);
        if (this.theOptionsRoot.indexOf("selected") >= 0) {
            Column.CHOICES.setVisible(true);
        }
    }

    private void buildDefaultRoots() {
        Object object;
        if (this.typeRoot != null) {
            return;
        }
        this.typeRoot = new PObjectNode();
        this.sourceRoot = new PObjectNode();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<PObjectNode[]> treeSet2 = new TreeSet<PObjectNode[]>();
        for (Ability ability : Globals.getAbilityList(this.theCategory)) {
            if (ability.getVisibility() != Visibility.DEFAULT && ability.getVisibility() != Visibility.DISPLAY_ONLY) continue;
            treeSet.addAll(ability.getTypeList(true));
            object = ability.getSourceEntry().getSourceBook().getLongName();
            if (object == null) continue;
            treeSet2.add((PObjectNode[])object);
        }
        PObjectNode[] pObjectNodeArray = new PObjectNode[treeSet.size()];
        int n = 0;
        for (String object2 : treeSet) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n].setItem(object2);
            pObjectNodeArray[n].setParent(this.typeRoot);
            ++n;
        }
        this.typeRoot.setChildren(pObjectNodeArray);
        object = new PObjectNode[treeSet2.size()];
        n = 0;
        for (String string : treeSet2) {
            object[n] = new PObjectNode();
            object[n].setItem(string);
            object[n].setParent(this.sourceRoot);
            ++n;
        }
        this.sourceRoot.setChildren((PObjectNode[])object);
    }

    public void setViewMode(AbilitySelectionPanel.ViewMode viewMode) {
        this.theViewMode = viewMode;
    }

    public void setAbilityFilter(IAbilityListFilter iAbilityListFilter) {
        this.theFilter = iAbilityListFilter;
        this.resetModel(this.thePC, this.theViewMode, false);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == Column.NAME.ordinal()) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int n) {
        return Column.values()[n].getName();
    }

    @Override
    public Object getRoot() {
        return super.getRoot();
    }

    @Override
    public Object getValueAt(Object object, int n) {
        PObjectNode pObjectNode = (PObjectNode)object;
        String string = null;
        Ability ability = null;
        Object object2 = pObjectNode.getItem();
        if (object2 instanceof Ability) {
            ability = (Ability)object2;
        }
        Column column = Column.values()[n];
        switch (column) {
            case NAME: {
                string = pObjectNode.toString();
                break;
            }
            case TYPE: {
                if (ability == null) break;
                string = CoreUtility.join(ability.getTypeList(true), '.');
                break;
            }
            case COST: {
                if (ability == null) break;
                string = ability.getCostString();
                break;
            }
            case MULTIPLES: {
                if (ability == null) break;
                if (ability.isMultiples()) {
                    string = PropertyFactory.getString("in_yes");
                    break;
                }
                string = PropertyFactory.getString("in_no");
                break;
            }
            case STACKS: {
                if (ability == null) break;
                if (ability.isStacks()) {
                    string = PropertyFactory.getString("in_yes");
                    break;
                }
                string = PropertyFactory.getString("in_no");
                break;
            }
            case REQUIREMENTS: {
                if (ability == null) break;
                string = ability.preReqStrings();
                break;
            }
            case DESCRIPTION: {
                if (ability == null) break;
                string = ability.piDescSubString(this.thePC);
                break;
            }
            case CHOICES: {
                string = pObjectNode.getChoices();
                break;
            }
            case SOURCE: {
                string = pObjectNode.getSource();
            }
        }
        return string;
    }

    private void setRoot(PObjectNode pObjectNode) {
        super.setRoot(pObjectNode.clone());
    }

    private void buildTreeNameOnly(boolean bl) {
        super.setRoot(new PObjectNode());
        String string = this.getQFilter();
        for (Ability ability : this.theAbilityList) {
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            PObjectNode pObjectNode = new PObjectNode();
            pObjectNode.setParent((PObjectNode)super.getRoot());
            switch (ability.getFeatType()) {
                case AUTOMATIC: {
                    pObjectNode.setColor(SettingsHandler.getFeatAutoColor());
                    break;
                }
                case VIRTUAL: {
                    pObjectNode.setColor(SettingsHandler.getFeatVirtualColor());
                }
            }
            pObjectNode.setItem(ability);
            if (string != null && ability.getDisplayName().toLowerCase().indexOf(string) < 0 && ability.getType().toLowerCase().indexOf(string) < 0) continue;
            ((PObjectNode)super.getRoot()).addChild(pObjectNode);
        }
    }

    private void buildTreePrereqTree(boolean bl) {
        Cloneable cloneable;
        int n;
        PObjectNode[] pObjectNodeArray;
        int n2;
        PObjectNode[] pObjectNodeArray2;
        this.setRoot(new PObjectNode());
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (Ability ability : this.theAbilityList) {
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            arrayList.add(ability);
        }
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            pObjectNodeArray2 = (PObjectNode[])arrayList.get(i);
            if (pObjectNodeArray2.hasPreReqTypeOf("FEAT")) continue;
            arrayList.remove(pObjectNodeArray2);
            arrayList2.add(pObjectNodeArray2);
            --i;
        }
        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
        if (pObjectNode == null) {
            return;
        }
        pObjectNodeArray2 = new PObjectNode[arrayList2.size()];
        block10: for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            Ability ability = (Ability)arrayList2.get(n2);
            pObjectNodeArray2[n2] = new PObjectNode();
            pObjectNodeArray2[n2].setItem(ability);
            pObjectNodeArray2[n2].setParent(pObjectNode);
            switch (ability.getFeatType()) {
                case AUTOMATIC: {
                    pObjectNodeArray2[n2].setColor(SettingsHandler.getFeatAutoColor());
                    continue block10;
                }
                case VIRTUAL: {
                    pObjectNodeArray2[n2].setColor(SettingsHandler.getFeatVirtualColor());
                }
            }
        }
        pObjectNode.setChildren(pObjectNodeArray2);
        n2 = 6;
        while (arrayList.size() > 0 && n2-- > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Cloneable cloneable22;
                pObjectNodeArray = (Ability)arrayList.get(i);
                n = 0;
                cloneable = new ArrayList();
                for (Cloneable cloneable22 : pObjectNodeArray.getPreReqList()) {
                    if (cloneable22.getKind() == null || !cloneable22.getKind().equalsIgnoreCase("FEAT")) continue;
                    cloneable.add(cloneable22);
                }
                for (int j = 0; j < pObjectNode.getChildCount() && (n = this.placedThisFeatInThisTree((Ability)pObjectNodeArray, (PObjectNode)(cloneable22 = pObjectNode.getChild(j)), (List<Prerequisite>)((Object)cloneable))) <= 0; ++j) {
                }
                if (n != 2) continue;
                arrayList.remove(pObjectNodeArray);
                --i;
            }
        }
        if (arrayList.size() > 0) {
            PObjectNode pObjectNode2 = new PObjectNode();
            pObjectNode2.setItem(PropertyFactory.getString("in_other"));
            pObjectNodeArray = new PObjectNode[arrayList.size()];
            block15: for (n = 0; n < arrayList.size(); ++n) {
                cloneable = (Ability)arrayList.get(n);
                pObjectNodeArray[n] = new PObjectNode();
                pObjectNodeArray[n].setItem(cloneable);
                pObjectNodeArray[n].setParent(pObjectNode2);
                switch (((Ability)cloneable).getFeatType()) {
                    case AUTOMATIC: {
                        pObjectNodeArray[n].setColor(SettingsHandler.getFeatAutoColor());
                        continue block15;
                    }
                    case VIRTUAL: {
                        pObjectNodeArray[n].setColor(SettingsHandler.getFeatVirtualColor());
                    }
                }
            }
            pObjectNode2.setChildren(pObjectNodeArray);
            pObjectNode.addChild(pObjectNode2);
        }
    }

    private void buildTreeTypeName(boolean bl) {
        if (this.typeRoot == null) {
            return;
        }
        this.setRoot(this.typeRoot);
        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
        if (pObjectNode == null) {
            return;
        }
        for (Ability ability : this.theAbilityList) {
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                if (!ability.isType(pObjectNode.getChild(i).toString())) continue;
                PObjectNode pObjectNode2 = new PObjectNode();
                switch (ability.getFeatType()) {
                    case AUTOMATIC: {
                        pObjectNode2.setColor(SettingsHandler.getFeatAutoColor());
                        break;
                    }
                    case VIRTUAL: {
                        pObjectNode2.setColor(SettingsHandler.getFeatVirtualColor());
                    }
                }
                pObjectNode2.setParent(pObjectNode.getChild(i));
                pObjectNode2.setItem(ability);
                pObjectNode.getChild(i).addChild(pObjectNode2);
            }
        }
    }

    private void buildTreeSourceName(boolean bl) {
        if (this.sourceRoot == null) {
            return;
        }
        this.setRoot(this.sourceRoot);
        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
        if (pObjectNode == null) {
            return;
        }
        for (Ability ability : this.theAbilityList) {
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            String string = ability.getSourceEntry().getSourceBook().getLongName();
            if (string == null) {
                Logging.errorPrint("In InfoFeats.buildTreeSourceName the feat " + ability + " has no source long entry.");
            }
            for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                if (!string.equals(pObjectNode.getChild(i).toString())) continue;
                PObjectNode pObjectNode2 = new PObjectNode();
                switch (ability.getFeatType()) {
                    case AUTOMATIC: {
                        pObjectNode2.setColor(SettingsHandler.getFeatAutoColor());
                        break;
                    }
                    case VIRTUAL: {
                        pObjectNode2.setColor(SettingsHandler.getFeatVirtualColor());
                    }
                }
                pObjectNode2.setParent(pObjectNode.getChild(i));
                pObjectNode2.setItem(ability);
                pObjectNode.getChild(i).addChild(pObjectNode2);
            }
        }
    }

    private int placedThisFeatInThisTree(Ability ability, PObjectNode pObjectNode, List<Prerequisite> list) {
        Ability ability2 = (Ability)pObjectNode.getItem();
        boolean bl = false;
        boolean bl2 = false;
        for (Prerequisite prerequisite : list) {
            String string = prerequisite.getKey();
            if (string.equalsIgnoreCase(ability2.getKeyName())) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (bl2) {
                PObjectNode pObjectNode2 = new PObjectNode();
                pObjectNode2.setItem(ability);
                pObjectNode2.setParent(pObjectNode);
                pObjectNode.addChild(pObjectNode2);
                switch (ability.getFeatType()) {
                    case AUTOMATIC: {
                        pObjectNode2.setColor(SettingsHandler.getFeatAutoColor());
                        break;
                    }
                    case VIRTUAL: {
                        pObjectNode2.setColor(SettingsHandler.getFeatVirtualColor());
                    }
                }
                return 2;
            }
            if (!bl) continue;
            for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                int n = this.placedThisFeatInThisTree(ability, pObjectNode.getChild(i), list);
                if (n != 2) continue;
                return 2;
            }
        }
        return 0;
    }

    public void setAbilityList(List<Ability> list) {
        this.theAbilityList = list;
        this.resetModel(this.thePC, this.theViewMode, false);
    }

    public void resetModel(PlayerCharacter playerCharacter, AbilitySelectionPanel.ViewMode viewMode, boolean bl) {
        this.thePC = playerCharacter;
        this.buildDefaultRoots();
        switch (viewMode) {
            case TYPENAME: {
                this.buildTreeTypeName(bl);
                break;
            }
            case NAMEONLY: {
                this.buildTreeNameOnly(bl);
                break;
            }
            case PREREQTREE: {
                this.buildTreePrereqTree(bl);
                break;
            }
            case SOURCENAME: {
                this.buildTreeSourceName(bl);
            }
        }
        if (super.getRoot() != null) {
            this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
        }
    }

    @Override
    public List<String> getMColumnList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Column[] columnArray = Column.values();
        for (int i = 1; i < columnArray.length; ++i) {
            arrayList.add(columnArray[i].getName());
        }
        return arrayList;
    }

    @Override
    public boolean isMColumnDisplayed(int n) {
        return Column.values()[n].isVisible();
    }

    private void setColumnOption(Column column, String string, String string2) {
        SettingsHandler.setPCGenOption(this.theOptionsRoot + "." + string + "." + column.toString(), string2);
    }

    private int getColumnOption(Column column, String string, int n) {
        return SettingsHandler.getPCGenOption(this.theOptionsRoot + "." + string + "." + column.toString(), n);
    }

    @Override
    public void setMColumnDisplayed(int n, boolean bl) {
        Column.values()[n].setVisible(bl);
        this.setColumnOption(Column.values()[n], "viewcol", String.valueOf(bl));
    }

    @Override
    public int getMColumnOffset() {
        return 1;
    }

    @Override
    public int getMColumnDefaultWidth(int n) {
        return this.getColumnOption(Column.values()[n], "sizecol", Column.values()[n].getWidth());
    }

    @Override
    public void setMColumnDefaultWidth(int n, int n2) {
        Column.values()[n].setWidth(n2);
        this.setColumnOption(Column.values()[n], "sizecol", String.valueOf(n2));
    }

    @Override
    public void resetMColumn(int n, TableColumn tableColumn) {
        Column column = Column.values()[n];
        switch (column) {
            case COST: 
            case MULTIPLES: 
            case STACKS: {
                tableColumn.setCellRenderer(new JTableEx.AlignCellRenderer(0));
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        NAME("AbilityModel.Columns.Name", 100, true),
        TYPE("AbilityModel.Columns.Type", 100, false),
        COST("AbilityModel.Columns.Cost", 100, false),
        MULTIPLES("AbilityModel.Columns.Multiples", 100, false),
        STACKS("AbilityModel.Columns.Stacks", 100, false),
        REQUIREMENTS("AbilityModel.Columns.Requirements", 100, false),
        DESCRIPTION("AbilityModel.Columns.Description", 100, false),
        CHOICES("AbilityModel.Columns.Choices", 100, false),
        SOURCE("AbilityModel.Columns.Source", 100, false);

        private String theName;
        private int theWidth;
        private boolean theVisibleFlag;

        private Column(String string2, int n2, boolean bl) {
            this.theName = PropertyFactory.getString(string2);
            this.theWidth = n2;
            this.theVisibleFlag = bl;
        }

        public void setWidth(int n) {
            this.theWidth = n;
        }

        public int getWidth() {
            return this.theWidth;
        }

        public String getName() {
            return this.theName;
        }

        public void setVisible(boolean bl) {
            this.theVisibleFlag = bl;
        }

        public boolean isVisible() {
            return this.theVisibleFlag;
        }

        public static Column get(int n) {
            return Column.values()[n];
        }
    }
}

