/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import pcgen.core.Ability;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class AbilityInfoPanel
extends JPanel {
    private PlayerCharacter thePC;
    private Ability theAbility = null;
    private JLabelPane theInfoLabel = new JLabelPane();

    public AbilityInfoPanel(PlayerCharacter playerCharacter, String string) {
        this.thePC = playerCharacter;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JScrollPane jScrollPane = new JScrollPane();
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.theInfoLabel.setBackground(this.getBackground());
        jScrollPane.setViewportView(this.theInfoLabel);
        Utility.setDescription(jScrollPane, PropertyFactory.getString("in_infoScrollTip"));
        this.add(jScrollPane);
    }

    public void setPC(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    public void setAbility(Ability ability) {
        this.theAbility = ability;
        this.theInfoLabel.setText(this.getDisplayString());
    }

    private String getDisplayString() {
        String string;
        if (this.theAbility == null) {
            return "<html></html>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>").append("<b>");
        stringBuffer.append(this.theAbility.piSubString());
        stringBuffer.append("</b>").append(" &nbsp;");
        stringBuffer.append("<b>");
        stringBuffer.append(PropertyFactory.getString("in_type")).append(':');
        stringBuffer.append("</b>");
        stringBuffer.append(CoreUtility.join(this.theAbility.getTypeList(true), '.'));
        String string2 = this.theAbility.getCostString();
        if (!string2.equals("1")) {
            stringBuffer.append(' ').append("<b>");
            stringBuffer.append(PropertyFactory.getString("Ability.Info.Cost")).append(':');
            stringBuffer.append("</b>");
            stringBuffer.append(string2);
        }
        if (this.theAbility.isMultiples()) {
            stringBuffer.append(" &nbsp;").append(PropertyFactory.getString("Ability.Info.Multiple"));
        }
        if (this.theAbility.isStacks()) {
            stringBuffer.append(" &nbsp;").append(PropertyFactory.getString("Ability.Info.Stacks"));
        }
        if ((string = this.theAbility.preReqHTMLStrings(this.thePC, false)).length() > 0) {
            stringBuffer.append(" &nbsp;");
            stringBuffer.append("<b>");
            stringBuffer.append(PropertyFactory.getString("in_requirements")).append(':');
            stringBuffer.append("</b>");
            stringBuffer.append(string);
        }
        stringBuffer.append(" &nbsp;");
        stringBuffer.append("<b>");
        stringBuffer.append(PropertyFactory.getString("in_descrip")).append(':');
        stringBuffer.append("</b>");
        stringBuffer.append(this.theAbility.piDescSubString(this.thePC));
        stringBuffer.append(" &nbsp;");
        stringBuffer.append("<b>");
        stringBuffer.append(PropertyFactory.getString("in_sourceLabel")).append(':');
        stringBuffer.append("</b>");
        stringBuffer.append(this.theAbility.getDefaultSourceString());
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }
}

