/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import pcgen.core.GameMode;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.tabs.spells.InfoKnownSpells;
import pcgen.gui.tabs.spells.InfoPreparedSpells;
import pcgen.gui.tabs.spells.InfoSpellBooks;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoSpells
extends JTabbedPane
implements CharacterInfoTab,
Filterable {
    static final long serialVersionUID = 755097384157285101L;
    private static final Tab tab = Tab.SPELLS;
    private static final int KNOWN_INDEX = 0;
    private static final int PREPARED_INDEX = 1;
    private static final int SPELLBOOKS_INDEX = 2;
    private InfoKnownSpells known;
    private InfoPreparedSpells prepared;
    private InfoSpellBooks spellbooks;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoSpells(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.known = new InfoKnownSpells(playerCharacter);
        this.prepared = new InfoPreparedSpells(playerCharacter);
        this.spellbooks = new InfoSpellBooks(playerCharacter);
        this.setName(tab.toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoSpells.this.initComponents();
            }
        });
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Spells.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Spells.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.known.getToDos());
        arrayList.addAll(this.prepared.getToDos());
        arrayList.addAll(this.spellbooks.getToDos());
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            this.setNeedsUpdate(true);
            this.known.setPc(this.pc);
            this.prepared.setPc(this.pc);
            this.spellbooks.setPc(this.pc);
        } else {
            this.serial = 0;
        }
    }

    public void setNeedsUpdate(boolean bl) {
        if (this.known == null) {
            return;
        }
        this.known.setNeedsUpdate(bl);
        this.prepared.setNeedsUpdate(bl);
        this.spellbooks.setNeedsUpdate(bl);
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        if (this.getSelectedIndex() == 0) {
            return this.known.isMatchAnyEnabled();
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.isMatchAnyEnabled();
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.isMatchAnyEnabled();
        }
        return true;
    }

    @Override
    public final boolean isNegateEnabled() {
        if (this.getSelectedIndex() == 0) {
            return this.known.isNegateEnabled();
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.isNegateEnabled();
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.isNegateEnabled();
        }
        return true;
    }

    @Override
    public final int getSelectionMode() {
        if (this.getSelectedIndex() == 0) {
            return this.known.getSelectionMode();
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.getSelectionMode();
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.getSelectionMode();
        }
        return -2;
    }

    @Override
    public final void initializeFilters() {
        if (this.getSelectedIndex() == 0) {
            this.known.initializeFilters();
        } else if (this.getSelectedIndex() == 1) {
            this.prepared.initializeFilters();
        } else if (this.getSelectedIndex() == 2) {
            this.spellbooks.initializeFilters();
        }
    }

    @Override
    public final void refreshFiltering() {
        if (this.getSelectedIndex() == 0) {
            this.known.refreshFiltering();
        } else if (this.getSelectedIndex() == 1) {
            this.prepared.refreshFiltering();
        } else if (this.getSelectedIndex() == 2) {
            this.spellbooks.refreshFiltering();
        }
    }

    @Override
    public List<PObjectFilter> getRemovedFilters() {
        if (this.getSelectedIndex() == 0) {
            return this.known.getRemovedFilters();
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.getRemovedFilters();
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.getRemovedFilters();
        }
        return null;
    }

    @Override
    public List<PObjectFilter> getSelectedFilters() {
        if (this.getSelectedIndex() == 0) {
            return this.known.getSelectedFilters();
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.getSelectedFilters();
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.getSelectedFilters();
        }
        return null;
    }

    @Override
    public int getFilterMode() {
        if (this.getSelectedIndex() == 0) {
            return this.known.getFilterMode();
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.getFilterMode();
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.getFilterMode();
        }
        return 0;
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.add((Component)this.known, 0);
        this.setTitleAt(0, PropertyFactory.getString("in_Info" + this.known.getName()));
        this.add((Component)this.prepared, 1);
        this.setTitleAt(1, PropertyFactory.getString("in_Info" + this.prepared.getName()));
        this.add((Component)this.spellbooks, 2);
        this.setTitleAt(2, PropertyFactory.getString("in_Info" + this.spellbooks.getName()));
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoSpells.this.refresh();
            }
        });
    }

    @Override
    public List<PObjectFilter> getAvailableFilters() {
        if (this.getSelectedIndex() == 0) {
            return this.known.getAvailableFilters();
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.getAvailableFilters();
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.getAvailableFilters();
        }
        return null;
    }

    @Override
    public void setFilterMode(int n) {
        if (this.getSelectedIndex() == 0) {
            this.known.setFilterMode(n);
        } else if (this.getSelectedIndex() == 1) {
            this.prepared.setFilterMode(n);
        } else if (this.getSelectedIndex() == 2) {
            this.spellbooks.setFilterMode(n);
        }
    }

    @Override
    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (this.getSelectedIndex() == 0) {
            return this.known.accept(playerCharacter, pObject);
        }
        if (this.getSelectedIndex() == 1) {
            return this.prepared.accept(playerCharacter, pObject);
        }
        if (this.getSelectedIndex() == 2) {
            return this.spellbooks.accept(playerCharacter, pObject);
        }
        return false;
    }
}

