/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SkillComparator;
import pcgen.core.SkillUtilities;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.InfoSkillsSorter;
import pcgen.gui.InfoSkillsSorters;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.ResetableListIterator;
import pcgen.util.StringIgnoreCaseComparator;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoSkills
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -5369872214039221832L;
    private static final Tab tab = Tab.SKILLS;
    private static boolean resetSelectedModel = true;
    private static PCClass previouslySelectedClass = null;
    private static boolean needsUpdate = true;
    private static int splitOrientation = 1;
    private static int viewMode = 4;
    private static Integer saveAvailableViewMode = null;
    private static int viewSelectMode = 5;
    private static Integer saveSelectedViewMode = null;
    private static int selectedOutputOrder = 4;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECT = 1;
    private static final int COL_INC = 7;
    private static final int COL_DEC = 8;
    public static final int nCosts = 3;
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("in_iskDisplay_By"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("in_iskDisplay_By"));
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addButton;
    private JButton removeButton;
    private JButton clearAvailableQFilterButton = new JButton("Clear");
    private JButton clearSelectedQFilterButton = new JButton("Clear");
    private JComboBoxEx currCharacterClass = null;
    private JComboBoxEx outputOrderComboBox = new JComboBoxEx();
    private JComboBoxEx skillChoice = new JComboBoxEx();
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabel exclusiveLabel = new JLabel();
    private JLabel includeLabel = new JLabel();
    private final JLabel lblAvailableQFilter = new JLabel("Filter:");
    private final JLabel lblSelectedQFilter = new JLabel("Filter:");
    private JLabel jLbClassSkillPoints = null;
    private JLabel jLbMaxCrossSkill = new JLabel();
    private JLabel jLbMaxSkill = new JLabel();
    private JLabel jLbTotalSkillPointsLeft = new JLabel();
    private JLabel maxCrossSkillRank = new JLabel();
    private JLabel maxSkillRank = new JLabel();
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel center = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private JScrollPane cScroll = new JScrollPane();
    private JTextField textAvailableQFilter = new JTextField();
    private JTextField textSelectedQFilter = new JTextField();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort;
    private JTreeTableSorter selectedSort;
    private RendererEditor plusMinusRenderer = new RendererEditor();
    private Skill lastSkill;
    private SkillModel availableModel;
    private SkillModel selectedModel;
    private TreePath selPath;
    private WholeNumberField currCharClassSkillPnts = null;
    private WholeNumberField totalSkillPointsLeft = new WholeNumberField(0, 4);
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoSkills(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoSkills.this.initComponents();
                InfoSkills.this.initActionListeners();
            }
        });
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Skills.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Skills.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.pc.getSkillPoints() < 0) {
            arrayList.add(PropertyFactory.getString("in_iskTodoTooMany"));
        } else if (this.pc.getSkillPoints() > 0) {
            arrayList.add(PropertyFactory.getString("in_iskTodoRemain"));
        }
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public final int getSelectionMode() {
        return 2;
    }

    public static SkillWrapper createSkillWrapper(boolean bl, Skill skill, PlayerCharacter playerCharacter) {
        return bl ? new SkillWrapper(skill, 0, new Float(0.0f), 0) : new SkillWrapper(skill, skill.modifier(playerCharacter), skill.getTotalRank(playerCharacter), skill.getOutputIndex());
    }

    @Override
    public final void initializeFilters() {
        this.registerFilter(this.createClassSkillFilter());
        this.registerFilter(this.createCrossClassSkillFilter());
        this.registerFilter(this.createExclusiveSkillFilter());
        this.registerFilter(this.createQualifyFilter());
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSkillFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.updateAvailableModel();
    }

    private PCLevelInfo getSelectedLevelInfo(PlayerCharacter playerCharacter) {
        if (playerCharacter.getLevelInfo() == null) {
            return null;
        }
        int n = -1;
        if (this.currCharacterClass != null) {
            n = Math.max(0, this.currCharacterClass.getSelectedIndex());
        } else {
            n = 0;
            for (PCLevelInfo pCLevelInfo : playerCharacter.getLevelInfo()) {
                if (pCLevelInfo.getSkillPointsRemaining() != 0) break;
                ++n;
            }
            if (n == playerCharacter.getLevelInfo().size()) {
                --n;
            }
        }
        if (n < 0 || n >= playerCharacter.getLevelInfo().size()) {
            return null;
        }
        return playerCharacter.getLevelInfo().get(n);
    }

    public PCClass getSelectedPCClass() {
        if (Globals.getGameModeHasPointPool()) {
            return (PCClass)this.pc.getSpellClassAtIndex(0);
        }
        PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(this.pc);
        if (pCLevelInfo != null) {
            return this.pc.getClassKeyed(pCLevelInfo.getClassKeyName());
        }
        return null;
    }

    private void setCurrentClassCombo() {
        int n;
        boolean bl = resetSelectedModel;
        PCClass pCClass = null;
        for (n = 0; n < this.pc.getLevelInfoSize() - 1; ++n) {
            PCLevelInfo pCLevelInfo = this.pc.getLevelInfo().get(n);
            if (pCLevelInfo.getSkillPointsRemaining() <= 0) continue;
            pCClass = this.pc.getClassKeyed(pCLevelInfo.getClassKeyName());
            break;
        }
        if (n < this.pc.getLevelInfoSize()) {
            boolean bl2 = resetSelectedModel = previouslySelectedClass != pCClass;
            if (this.currCharacterClass.getSelectedIndex() != n) {
                this.currCharacterClass.setSelectedIndex(n);
                this.updateAvailableModel();
            }
            previouslySelectedClass = pCClass;
            resetSelectedModel = bl;
        }
    }

    private int getHighestOutputIndex() {
        int n = 0;
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.pc.getSkillList());
        for (Skill skill : arrayList) {
            if (skill.getOutputIndex() <= n) continue;
            n = skill.getOutputIndex();
        }
        return n;
    }

    private static int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private final void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new SkillModel(viewMode, true);
        } else {
            this.availableModel.resetModel(viewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private JPanel buildModPanel(JButton jButton, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        Utility.setDescription(jButton, string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel buildDelPanel(JButton jButton, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        Utility.setDescription(jButton, string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add(jButton);
        return jPanel;
    }

    private final PObjectFilter createClassSkillFilter() {
        return new ClassSkillFilter();
    }

    private final PObjectFilter createCrossClassSkillFilter() {
        return new CrossClassSkillFilter();
    }

    private final PObjectFilter createExclusiveSkillFilter() {
        return new ExclusiveSkillFilter();
    }

    private final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private final PObjectFilter createQualifyFilter() {
        return new QualifyFilter();
    }

    private final void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new SkillModel(viewSelectMode, false);
        } else if (resetSelectedModel) {
            this.selectedModel.resetModel(viewSelectMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private void availTableMouseClicked(MouseEvent mouseEvent) {
        int n = this.availableTable.getSelectedRow();
        Object object = this.availableTable.getTree().getPathForRow(n).getLastPathComponent();
        if (object == null) {
            this.lastSkill = null;
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_02"), "PCGen", MessageType.ERROR);
            return;
        }
        Skill skill = null;
        if (object instanceof PObjectNode && (object = ((PObjectNode)object).getItem()) instanceof SkillWrapper) {
            skill = ((SkillWrapper)object).getSkWrapSkill();
        }
        this.addButton.setEnabled(skill != null);
        this.setInfoLabelText(skill);
        int n2 = this.availableTable.columnAtPoint(mouseEvent.getPoint());
        n2 = this.availableTable.convertColumnIndexToModel(n2);
        this.skillTableMouseClicked(mouseEvent, n2);
    }

    private void selectedTableMouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n = this.selectedTable.getSelectedRow();
        TreePath treePath = this.selectedTable.getTree().getPathForRow(n);
        Object object2 = object = treePath == null ? null : treePath.getLastPathComponent();
        if (object == null) {
            this.lastSkill = null;
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_02"), "PCGen", MessageType.ERROR);
            return;
        }
        Skill skill = null;
        if (object instanceof PObjectNode && (object = ((PObjectNode)object).getItem()) instanceof SkillWrapper) {
            skill = ((SkillWrapper)object).getSkWrapSkill();
        }
        this.removeButton.setEnabled(skill != null);
        this.setInfoLabelText(skill);
        int n2 = this.selectedTable.columnAtPoint(mouseEvent.getPoint());
        n2 = this.selectedTable.convertColumnIndexToModel(n2);
        this.skillTableMouseClicked(mouseEvent, n2);
    }

    private void skillTableMouseClicked(MouseEvent mouseEvent, int n) {
        switch (n) {
            case 7: {
                this.addSkill(1);
                break;
            }
            case 8: {
                this.addSkill(-1);
                break;
            }
        }
    }

    private final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        JTree jTree = this.availableTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoSkills.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = InfoSkills.this.availableTable.getTree().getPathForRow(n).getLastPathComponent();
                    if (object == null) {
                        InfoSkills.this.lastSkill = null;
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_02"), "PCGen", MessageType.ERROR);
                        return;
                    }
                    Skill skill = null;
                    if (object instanceof PObjectNode && (object = ((PObjectNode)object).getItem()) instanceof SkillWrapper) {
                        skill = ((SkillWrapper)object).getSkWrapSkill();
                    }
                    InfoSkills.this.addButton.setEnabled(skill != null);
                    InfoSkills.this.setInfoLabelText(skill);
                }
            }
        });
        this.availableTable.addMouseListener(new JTreeTableMouseAdapter(this.availableTable, new AvailableClickHandler(), false));
        this.availableTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                InfoSkills.this.availTableMouseClicked(mouseEvent);
            }
        });
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        JTree jTree2 = this.selectedTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = InfoSkills.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = InfoSkills.this.selectedTable.getTree().getPathForRow(n).getLastPathComponent();
                    if (object == null) {
                        InfoSkills.this.lastSkill = null;
                        InfoSkills.this.infoLabel.setText();
                        return;
                    }
                    Skill skill = null;
                    if (object instanceof PObjectNode && (object = ((PObjectNode)object).getItem()) instanceof SkillWrapper) {
                        skill = ((SkillWrapper)object).getSkWrapSkill();
                    }
                    InfoSkills.this.removeButton.setEnabled(skill != null);
                    InfoSkills.this.setInfoLabelText(skill);
                }
            }
        });
        this.selectedTable.addMouseListener(new JTreeTableMouseAdapter(this.selectedTable, new SelectedClickHandler(), false));
        this.selectedTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                InfoSkills.this.selectedTableMouseClicked(mouseEvent);
            }
        });
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private Skill getSelectedSkill() {
        return this.lastSkill;
    }

    private void addSkill(int n) {
        Skill skill = this.getSelectedSkill();
        if (skill == null) {
            return;
        }
        if (skill.isReadOnly()) {
            ShowMessageDelegate.showMessageDialog("You cannot " + (n < 0 ? "remove" : "add") + " ranks for this skill: " + skill.getDisplayName(), "PCGen", MessageType.ERROR);
            return;
        }
        int n2 = Globals.getGameModeSkillCost_Class();
        if (n2 > 1) {
            n *= n2;
        }
        ArrayList<Skill> arrayList = this.getSatisfiedPrereqSkills(skill);
        boolean bl = false;
        int n3 = n;
        if (n3 > 0 && skill.hasPreReqs()) {
            while (n3 > n2 && this.modRank(skill, n2, false)) {
                n3 -= n2;
                bl = true;
            }
        }
        if (!bl && !this.modRank(skill, n3, true)) {
            this.updateSelectedModel();
            return;
        }
        if (this.prereqSkillsInvalid(arrayList)) {
            this.modRank(skill, -n, false);
            this.updateSelectedModel();
            ShowMessageDelegate.showMessageDialog("Modifying this skill invalidates the prerequisites for the following skill(s):\n" + arrayList.toString(), "PCGen", MessageType.ERROR);
            return;
        }
        PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(this.pc);
        this.pc.setDirty(true);
        if (pCLevelInfo != null) {
            if (this.currCharClassSkillPnts != null) {
                this.currCharClassSkillPnts.setValue(pCLevelInfo.getSkillPointsRemaining());
            }
            this.totalSkillPointsLeft.setValue(this.pc.getSkillPoints());
        }
        this.updateSelectedModel();
        if (this.pc.isDisplayUpdate()) {
            this.pc.setDisplayUpdate(false);
            this.pc.calcActiveBonuses();
        }
        if (n > 0) {
            this.selectedTable.expandByPObjectName(skill.getKeyName());
        }
        if (Globals.getGameModeHasPointPool()) {
            this.totalSkillPointsLeft.setValue(this.pc.getSkillPoints());
        }
    }

    private void currCharClassSkillPntsChanged() {
        PlayerCharacter playerCharacter = this.pc;
        playerCharacter.setDirty(true);
        PCClass pCClass = this.getSelectedPCClass();
        PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(playerCharacter);
        if (pCLevelInfo == null) {
            return;
        }
        int n = pCLevelInfo.getSkillPointsRemaining();
        if (this.currCharClassSkillPnts.getText().length() > 0) {
            int n2 = Delta.decode(this.currCharClassSkillPnts.getText());
            if (pCClass == null || n2 == n) {
                return;
            }
            int n3 = n - n2;
            pCLevelInfo.setSkillPointsRemaining(n2);
            pCClass.setSkillPool(Math.max(0, pCClass.getSkillPool(this.pc) - n3));
            playerCharacter.setSkillPoints(Math.max(0, playerCharacter.getSkillPoints() - n3));
        }
        this.currCharClassSkillPnts.setValue(pCLevelInfo.getSkillPointsRemaining());
        this.totalSkillPointsLeft.setValue(playerCharacter.getSkillPoints());
    }

    private void currCharacterClassActionPerformed() {
        PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(this.pc);
        boolean bl = resetSelectedModel;
        PCClass pCClass = null;
        if (pCLevelInfo != null) {
            this.currCharClassSkillPnts.setValue(pCLevelInfo.getSkillPointsRemaining());
            this.totalSkillPointsLeft.setValue(this.pc.getSkillPoints());
            pCClass = this.pc.getClassKeyed(pCLevelInfo.getClassKeyName());
            resetSelectedModel = pCClass != previouslySelectedClass;
        } else {
            this.currCharClassSkillPnts.setValue(0);
            this.totalSkillPointsLeft.setValue(0);
        }
        this.updateSelectedModel();
        this.updateAvailableModel();
        previouslySelectedClass = pCClass;
        resetSelectedModel = bl;
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("");
        this.refresh();
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bsplit.getDividerLocation();
        int n3 = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            Object object;
            int n5;
            this.hasBeenSized = true;
            n = SettingsHandler.getPCGenOption("InfoSkills.splitPane", (int)(this.getSize().getWidth() * 4.0 / 10.0));
            n2 = SettingsHandler.getPCGenOption("InfoSkills.bsplit", (int)(this.getSize().getHeight() - 120.0));
            n3 = SettingsHandler.getPCGenOption("InfoSkills.asplit", (int)(this.getSize().getWidth() - 500.0));
            TableColumnModel tableColumnModel = this.selectedTable.getColumnModel();
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                object = tableColumnModel.getColumn(n5);
                int n6 = ((TableColumn)object).getModelIndex();
                n4 = Globals.getCustColumnWidth("InfoSel", n6);
                if (n4 != 0) {
                    ((TableColumn)object).setPreferredWidth(n4);
                }
                ((TableColumn)object).addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "InfoSel", n5));
                if (n6 == 6) {
                    ((TableColumn)object).setCellEditor(new OutputOrderEditor(new String[]{PropertyFactory.getString("in_iskFirst"), PropertyFactory.getString("in_iskLast"), PropertyFactory.getString("in_iskHidden")}));
                    continue;
                }
                if (n6 != 7 && n6 != 8) continue;
                ((TableColumn)object).setCellRenderer(this.plusMinusRenderer);
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                object = this.availableTable.getColumnModel();
                TableColumn tableColumn = object.getColumn(n5);
                int n7 = tableColumn.getModelIndex();
                n4 = Globals.getCustColumnWidth("InfoAva", n7);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "InfoAva", tableColumn.getModelIndex()));
                if (n7 == 6) {
                    tableColumn.setCellEditor(new OutputOrderEditor(new String[]{PropertyFactory.getString("in_iskFirst"), PropertyFactory.getString("in_iskLast"), PropertyFactory.getString("in_iskHidden")}));
                    continue;
                }
                if (n7 != 7 && n7 != 8) continue;
                tableColumn.setCellRenderer(this.plusMinusRenderer);
            }
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoSkills.splitPane", n);
        }
        if (n2 > 0) {
            this.bsplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoSkills.bsplit", n2);
        }
        if (n3 > 0) {
            this.asplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoSkills.asplit", n3);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new SkillPopupListener(jTreeTable, new SkillPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                try {
                    InfoSkills.this.formComponentShown();
                }
                catch (Throwable throwable) {
                    Logging.errorPrint("Failure while showing skills tab. Skills tab may not be properly displayed.", throwable);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.asplit.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.bsplit.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.splitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.addSkill(-1);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.addSkill(1);
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.viewSelectComboBoxActionPerformed();
            }
        });
        this.outputOrderComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.outputOrderComboBoxActionPerformed();
            }
        });
        this.textAvailableQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoSkills.this.setAvailableQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoSkills.this.setAvailableQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoSkills.this.setAvailableQFilter();
            }
        });
        this.clearAvailableQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.clearAvailableQFilter();
            }
        });
        this.textSelectedQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoSkills.this.setSelectedQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoSkills.this.setSelectedQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoSkills.this.setSelectedQFilter();
            }
        });
        this.clearSelectedQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.clearSelectedQFilter();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        int n;
        this.readyForRefresh = true;
        int n2 = SettingsHandler.getSkillsTab_AvailableListMode();
        if (n2 >= 0 && n2 <= 5) {
            viewMode = n2;
        }
        SettingsHandler.setSkillsTab_AvailableListMode(viewMode);
        n2 = SettingsHandler.getSkillsTab_SelectedListMode();
        if (n2 >= 0 && n2 <= 5) {
            viewSelectMode = n2;
        }
        SettingsHandler.setSkillsTab_SelectedListMode(viewSelectMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_SubType_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskSubType_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskCost_SubType_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskCost_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskName"));
        Utility.setDescription(this.viewComboBox, PropertyFactory.getString("in_iskSkill_display_order_tooltip"));
        this.viewComboBox.setSelectedIndex(viewMode);
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_SubType_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskSubType_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskCost_SubType_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskCost_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskName"));
        Utility.setDescription(this.viewSelectComboBox, PropertyFactory.getString("in_iskSkill_display_order_tooltip"));
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_name_ascending"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_name_descending"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_trained_then_untrained"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_untrained_then_trained"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskManual"));
        Utility.setDescription(this.outputOrderComboBox, PropertyFactory.getString("in_iskSkill_output_order_tooltip"));
        this.outputOrderComboBox.setSelectedIndex(selectedOutputOrder);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.splitPane = new FlippingSplitPane(splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.avaLabel, this.viewComboBox, this.lblAvailableQFilter, this.textAvailableQFilter, this.clearAvailableQFilterButton), "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable, 22, 30);
        jPanel.add((Component)jScrollPane, "Center");
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        jPanel.add((Component)this.buildModPanel(this.addButton, PropertyFactory.getString("in_iskAdd_skill_tooltip")), "South");
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)InfoTabUtils.createFilterPane(this.selLabel, this.viewSelectComboBox, this.lblSelectedQFilter, this.textSelectedQFilter, this.clearSelectedQFilterButton), "North");
        jScrollPane = new JScrollPane(this.selectedTable, 22, 30);
        jPanel2.add((Component)jScrollPane, "Center");
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        jPanel2.add((Component)this.buildDelPanel(this.removeButton, PropertyFactory.getString("in_iskRemove_skill_tooltip")), "South");
        JButton jButton2 = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText("^");
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_iskSkill_Info"));
        titledBorder.setTitleJustification(2);
        this.cScroll.setBorder(titledBorder);
        this.infoLabel.setBackground(jPanel2.getBackground());
        this.cScroll.setViewportView(this.infoLabel);
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.jLbMaxSkill.setText(PropertyFactory.getString("in_iskMax_Class_Skill_Rank"));
        Utility.setDescription(this.jLbMaxSkill, PropertyFactory.getString("in_iskMax_Class_Skill_Rank_tooltip"));
        this.jLbMaxSkill.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jLbMaxSkill, gridBagConstraints);
        this.maxSkillRank.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.maxSkillRank, gridBagConstraints);
        this.jLbMaxCrossSkill.setText(PropertyFactory.getString("in_iskMax_Cross-Class_Skill_Rank"));
        Utility.setDescription(this.jLbMaxCrossSkill, PropertyFactory.getString("in_iskMax_Cross-Class_Skill_Rank_tooltip"));
        this.jLbMaxCrossSkill.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jLbMaxCrossSkill, gridBagConstraints);
        this.maxCrossSkillRank.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.maxCrossSkillRank, gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)new JLabel(PropertyFactory.getString("in_iskSkill_output_order")), gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.outputOrderComboBox, gridBagConstraints);
        if (!Globals.getGameModeHasPointPool()) {
            this.jLbClassSkillPoints = new JLabel();
            this.currCharacterClass = new JComboBoxEx();
            this.currCharClassSkillPnts = new WholeNumberField(0, 4);
            this.jLbClassSkillPoints.setText(PropertyFactory.getString("in_iskSkill_Points_Left_for_Class"));
            this.jLbClassSkillPoints.setForeground(Color.black);
            Utility.buildConstraints(gridBagConstraints, 0, 3, 2, 1, 5.0, 5.0);
            gridBagConstraints.anchor = 13;
            this.jPanel1.add((Component)this.jLbClassSkillPoints, gridBagConstraints);
            this.currCharacterClass.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InfoSkills.this.currCharacterClassActionPerformed();
                }
            });
            Utility.buildConstraints(gridBagConstraints, 2, 3, 1, 1, 5.0, 5.0);
            gridBagConstraints.anchor = 10;
            n = gridBagConstraints.fill;
            gridBagConstraints.fill = 2;
            this.jPanel1.add((Component)this.currCharacterClass, gridBagConstraints);
            gridBagConstraints.fill = n;
        }
        if (Globals.getGameModeHasPointPool()) {
            this.jLbTotalSkillPointsLeft.setText(Globals.getGameModePointPoolName() + ": ");
        } else {
            this.jLbTotalSkillPointsLeft.setText(PropertyFactory.getString("in_iskTotal_Skill_Points_Left"));
        }
        this.jLbTotalSkillPointsLeft.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints, 2, 2, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jLbTotalSkillPointsLeft, gridBagConstraints);
        if (Globals.getGameModeHasPointPool()) {
            this.totalSkillPointsLeft.setEditable(false);
            this.totalSkillPointsLeft.setHorizontalAlignment(4);
        } else {
            this.totalSkillPointsLeft.setInputVerifier(new InputVerifier(){

                public boolean shouldYieldFocus(JComponent jComponent) {
                    boolean bl = this.verify(jComponent);
                    InfoSkills.this.totalSkillPointsLeftChanged();
                    return bl;
                }

                public boolean verify(JComponent jComponent) {
                    return true;
                }
            });
        }
        Utility.buildConstraints(gridBagConstraints, 3, 2, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 17;
        this.totalSkillPointsLeft.setMinimumSize(new Dimension(40, 17));
        this.totalSkillPointsLeft.setPreferredSize(new Dimension(40, 17));
        this.jPanel1.add((Component)this.totalSkillPointsLeft, gridBagConstraints);
        if (this.currCharClassSkillPnts != null) {
            this.currCharClassSkillPnts.setInputVerifier(new InputVerifier(){

                public boolean shouldYieldFocus(JComponent jComponent) {
                    boolean bl = this.verify(jComponent);
                    InfoSkills.this.currCharClassSkillPntsChanged();
                    return bl;
                }

                public boolean verify(JComponent jComponent) {
                    return true;
                }
            });
            Utility.buildConstraints(gridBagConstraints, 3, 3, 1, 1, 5.0, 5.0);
            gridBagConstraints.anchor = 17;
            this.currCharClassSkillPnts.setPreferredSize(new Dimension(40, 20));
            this.currCharClassSkillPnts.setMinimumSize(new Dimension(40, 20));
            this.jPanel1.add((Component)this.currCharClassSkillPnts, gridBagConstraints);
        }
        this.includeLabel = new JLabel(PropertyFactory.getString("in_iskInclude_Skills"));
        Utility.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.includeLabel, gridBagConstraints);
        this.skillChoice.setModel(new DefaultComboBoxModel<String>(new String[]{PropertyFactory.getString("in_iskNone"), PropertyFactory.getString("in_iskUntrained"), PropertyFactory.getString("in_iskAll")}));
        this.skillChoice.setMaximumRowCount(3);
        Utility.setDescription(this.skillChoice, PropertyFactory.getString("in_iskDisplayed_skills_tooltip"));
        this.skillChoice.setMinimumSize(new Dimension(98, 22));
        this.skillChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSkills.this.skillChoiceActionPerformed();
            }
        });
        n = resetSelectedModel ? 1 : 0;
        resetSelectedModel = true;
        this.skillChoice.setSelectedIndex(SettingsHandler.getSkillsTab_IncludeSkills());
        resetSelectedModel = n;
        Utility.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.skillChoice, gridBagConstraints);
        this.exclusiveLabel = new JLabel("Class:" + Integer.toString(Globals.getGameModeSkillCost_Class()) + " Cross:" + Integer.toString(Globals.getGameModeSkillCost_CrossClass()) + " Exclusive:" + Integer.toString(Globals.getGameModeSkillCost_Exclusive()));
        PropertyFactory.getString("in_iskExclusive_skill_cost");
        Utility.setDescription(this.exclusiveLabel, PropertyFactory.getString("in_iskExclusive_skill_cost_tooltip"));
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 5.0, 5.0);
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.exclusiveLabel, gridBagConstraints);
        this.asplit = new FlippingSplitPane(1, this.cScroll, this.jPanel1);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, jPanel3);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoSkills.this.refresh();
            }
        });
    }

    private boolean modRank(Skill skill, double d, boolean bl) {
        int n;
        if (CoreUtility.doublesEqual(d, 0.0)) {
            return false;
        }
        PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(this.pc);
        if (pCLevelInfo == null) {
            return false;
        }
        if (Globals.getGameModeHasPointPool()) {
            n = this.pc.getSkillPoints();
        } else {
            int n2 = -1;
            if (this.currCharacterClass != null) {
                n2 = this.currCharacterClass.getSelectedIndex();
            }
            if (d > 0.0) {
                this.updateClassSelection();
            }
            if (this.currCharacterClass != null && n2 != this.currCharacterClass.getSelectedIndex()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_iskErr_message_03a", pCLevelInfo.getClassKeyName(), String.valueOf(pCLevelInfo.getLevel())), "PCGen", MessageType.INFORMATION);
                return false;
            }
            n = pCLevelInfo.getSkillPointsRemaining();
            if (d < 0.0 && (double)n - d > (double)pCLevelInfo.getSkillPointsGained()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_iskErr_message_05a", pCLevelInfo.getClassKeyName(), String.valueOf(pCLevelInfo.getLevel()), String.valueOf(pCLevelInfo.getSkillPointsGained())), "PCGen", MessageType.INFORMATION);
                return false;
            }
        }
        if (d > 0.0 && d > (double)n) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_iskErr_message_04a", String.valueOf(n)), "PCGen", MessageType.INFORMATION);
            return false;
        }
        Skill skill2 = skill;
        PCClass pCClass = this.getSelectedPCClass();
        double d2 = skill.costForPCClass(pCClass, this.pc);
        if (CoreUtility.doublesEqual(d2, 0.0)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_06"), "PCGen", MessageType.INFORMATION);
            return false;
        }
        double d3 = d / d2;
        if (skill != null) {
            skill2 = this.pc.addSkill(skill);
            Collections.sort(this.pc.getSkillList(), new StringIgnoreCaseComparator());
            if (selectedOutputOrder != 4) {
                this.resortSelected(selectedOutputOrder);
            } else if (skill2.getOutputIndex() == 0) {
                skill2.setOutputIndex(this.getHighestOutputIndex() + 1);
            }
        }
        String string = "";
        if (skill2 != null) {
            string = skill2.modRanks(d3, pCClass, this.pc);
            if ("".equals(string) && pCLevelInfo != null) {
                if (this.currCharacterClass == null) {
                    this.updatePcl((int)d);
                } else {
                    pCLevelInfo.setSkillPointsRemaining(n - (int)d);
                }
            }
            this.updateClassSelection();
            if (CoreUtility.doublesEqual(skill2.getRank().doubleValue(), 0.0) && !skill2.isUntrained()) {
                this.pc.getSkillList().remove(skill2);
            }
        }
        if (string.length() > 0) {
            if (bl) {
                ShowMessageDelegate.showMessageDialog(string, "PCGen", MessageType.INFORMATION);
            }
            return false;
        }
        return true;
    }

    private void outputOrderComboBoxActionPerformed() {
        int n = this.outputOrderComboBox.getSelectedIndex();
        if (n != selectedOutputOrder) {
            selectedOutputOrder = n;
            this.resortSelected(selectedOutputOrder);
            if (this.pc != null) {
                this.pc.setDirty(true);
                this.pc.setSkillsOutputOrder(selectedOutputOrder);
            }
        }
    }

    private void resortSelected(int n) {
        int n2 = -1;
        boolean bl = false;
        switch (n) {
            case 0: {
                n2 = 0;
                bl = true;
                break;
            }
            case 1: {
                n2 = 0;
                bl = false;
                break;
            }
            case 2: {
                n2 = 1;
                bl = true;
                break;
            }
            case 3: {
                n2 = 1;
                bl = false;
                break;
            }
            default: {
                this.updateSelectedModel();
                return;
            }
        }
        this.resortSelected(n2, bl);
    }

    private void resortSelected(int n, boolean bl) {
        if (this.pc == null) {
            return;
        }
        SkillComparator skillComparator = new SkillComparator(n, bl);
        int n2 = 1;
        ArrayList<Skill> arrayList = this.pc.getSkillList();
        Collections.sort(arrayList, skillComparator);
        for (Skill skill : arrayList) {
            if (skill.getOutputIndex() < 0) continue;
            skill.setOutputIndex(n2++);
        }
        if (this.selectedTable != null) {
            this.updateSelectedModel();
        }
    }

    private void saveDividerLocations() {
        int n = this.splitPane.getDividerLocation();
        if (n > 0) {
            SettingsHandler.setPCGenOption("InfoSkills.splitPane", n);
        }
        if ((n = this.asplit.getDividerLocation()) > 0) {
            SettingsHandler.setPCGenOption("InfoSkills.asplit", n);
        }
        if ((n = this.bsplit.getDividerLocation()) > 0) {
            SettingsHandler.setPCGenOption("InfoSkills.bsplit", n);
        }
    }

    private void skillChoiceActionPerformed() {
        int n = this.skillChoice.getSelectedIndex();
        int n2 = SettingsHandler.getSkillsTab_IncludeSkills();
        if (n >= 0 && n <= 2 && (n != n2 || resetSelectedModel)) {
            SettingsHandler.setSkillsTab_IncludeSkills(n);
            this.pc.populateSkills(n);
            this.updateSelectedModel();
        }
    }

    private void totalSkillPointsLeftChanged() {
        PlayerCharacter playerCharacter = this.pc;
        playerCharacter.setDirty(true);
        if (this.totalSkillPointsLeft.getText().length() > 0) {
            int n = Delta.decode(this.totalSkillPointsLeft.getText());
            if (n == playerCharacter.getSkillPoints()) {
                return;
            }
            playerCharacter.setSkillPoints(n);
            int n2 = playerCharacter.getClassList().size();
            if (n2 == 0) {
                return;
            }
            int n3 = n / n2;
            for (PCClass pCClass : playerCharacter.getClassList()) {
                pCClass.setSkillPool(Math.max(0, n3));
            }
            PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(playerCharacter);
            int n4 = pCLevelInfo.getSkillPointsRemaining();
            PCClass pCClass = this.getSelectedPCClass();
            if (pCClass != null && this.currCharClassSkillPnts != null) {
                this.currCharClassSkillPnts.setValue(n4);
            }
        }
        this.totalSkillPointsLeft.setValue(playerCharacter.getSkillPoints());
    }

    private final void updateCharacterInfo() {
        PlayerCharacter playerCharacter = this.pc;
        if (playerCharacter != null && needsUpdate) {
            selectedOutputOrder = playerCharacter.getSkillsOutputOrder();
            this.outputOrderComboBox.setSelectedIndex(selectedOutputOrder);
            playerCharacter.getAllSkillList(true);
            SettingsHandler.getSkillsTab_IncludeSkills();
            resetSelectedModel = true;
            previouslySelectedClass = null;
            this.skillChoiceActionPerformed();
            this.resortSelected(selectedOutputOrder);
        }
        this.pc = playerCharacter;
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.pc.setAggregateAbilitiesStable(null, false);
        this.updateClassSelection();
        if (!Globals.getGameModeHasPointPool()) {
            PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(this.pc);
            if (pCLevelInfo != null) {
                if (this.currCharClassSkillPnts != null) {
                    this.currCharClassSkillPnts.setValue(pCLevelInfo.getSkillPointsRemaining());
                }
            } else if (this.currCharClassSkillPnts != null) {
                this.currCharClassSkillPnts.setValue(0);
            }
        }
        this.totalSkillPointsLeft.setValue(this.pc.getSkillPoints());
        if (SettingsHandler.isMonsterDefault()) {
            this.maxSkillRank.setText(String.valueOf(SkillUtilities.maxClassSkillForLevel(this.pc.getTotalLevels() + this.pc.totalHitDice(), this.pc)));
            this.maxCrossSkillRank.setText(String.valueOf(SkillUtilities.maxCrossClassSkillForLevel(this.pc.getTotalLevels() + this.pc.totalHitDice(), this.pc)));
        } else {
            this.maxSkillRank.setText(String.valueOf(SkillUtilities.maxClassSkillForLevel(this.pc.getTotalLevels(), this.pc)));
            this.maxCrossSkillRank.setText(String.valueOf(SkillUtilities.maxCrossClassSkillForLevel(this.pc.getTotalLevels(), this.pc)));
        }
        resetSelectedModel = true;
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.pc.setAggregateAbilitiesStable(null, false);
        needsUpdate = false;
    }

    private final void updateClassSelection() {
        if (!Globals.getGameModeHasPointPool()) {
            resetSelectedModel = false;
            Object[] objectArray = new String[this.pc.getLevelInfoSize()];
            int n = 0;
            for (PCLevelInfo pCLevelInfo : this.pc.getLevelInfo()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(pCLevelInfo.getClassKeyName()).append('/').append(pCLevelInfo.getLevel()).append(' ').append('[').append(pCLevelInfo.getSkillPointsRemaining()).append('/').append(pCLevelInfo.getSkillPointsGained()).append(']');
                objectArray[n] = stringBuffer.toString();
                ++n;
            }
            if (this.currCharacterClass != null) {
                int n2;
                ActionListener[] actionListenerArray = this.currCharacterClass.getActionListeners();
                for (n2 = 0; n2 < actionListenerArray.length; ++n2) {
                    this.currCharacterClass.removeActionListener(actionListenerArray[n2]);
                }
                this.currCharacterClass.removeAllItems();
                this.currCharacterClass.setAllItems(objectArray);
                resetSelectedModel = true;
                if (this.currCharacterClass.getItemCount() > 0) {
                    this.setCurrentClassCombo();
                }
                for (n2 = 0; n2 < actionListenerArray.length; ++n2) {
                    this.currCharacterClass.addActionListener(actionListenerArray[n2]);
                }
            }
        }
    }

    private void setInfoLabelText(Skill skill) {
        this.lastSkill = skill;
        if (skill != null) {
            Skill skill2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><b>").append(skill.piSubString()).append("</b>");
            if (!Globals.checkRule("SKILLMAX")) {
                stringBuffer.append(PropertyFactory.getString("in_iskHtml_MAXRANK")).append(this.pc.getMaxRank(skill.getKeyName(), this.getSelectedPCClass()).doubleValue());
            }
            stringBuffer.append(PropertyFactory.getString("in_iskHtml_TYPE")).append(CoreUtility.join(skill.getTypeList(true), '.'));
            String string = skill.getKeyStatFromStats();
            if (string.length() != 0) {
                stringBuffer.append(PropertyFactory.getString("in_iskHtml_KEY_STAT")).append(string);
            }
            stringBuffer.append(PropertyFactory.getString("in_iskHtml_UNTRAINED")).append(skill.isUntrained() ? PropertyFactory.getString("in_yes") : PropertyFactory.getString("in_no"));
            stringBuffer.append(PropertyFactory.getString("in_iskHtml_EXCLUSIVE")).append(skill.getExclusive());
            String string2 = skill.getDefaultSourceString();
            if (string2.length() > 0) {
                stringBuffer.append(PropertyFactory.getString("in_iskHtml_SOURCE")).append(string2);
            }
            if (SettingsHandler.getShowSkillModifier() && (skill2 = this.pc.getSkillKeyed(skill.getKeyName())) != null && (string2 = skill2.getModifierExplanation(this.pc, false)).length() != 0) {
                stringBuffer.append("<br><b>PC Modifier</b>: ").append(string2);
            }
            if (SettingsHandler.getShowSkillRanks() && (skill2 = this.pc.getSkillKeyed(skill.getKeyName())) != null && (string2 = skill2.getRanksExplanation()).length() != 0) {
                stringBuffer.append("<br><b>PC Ranks</b>: ").append(string2);
            }
            stringBuffer.append("</html>");
            this.infoLabel.setText(stringBuffer.toString());
        }
    }

    private void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        try {
            this.selectedTable.updateUI();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        this.selectedTable.expandPathList(list);
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != viewMode) {
            viewMode = n;
            SettingsHandler.setSkillsTab_AvailableListMode(viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int n = this.viewSelectComboBox.getSelectedIndex();
        if (n != viewSelectMode) {
            viewSelectMode = n;
            SettingsHandler.setSkillsTab_SelectedListMode(viewSelectMode);
            this.updateSelectedModel();
        }
    }

    private void clearAvailableQFilter() {
        this.availableModel.clearQFilter();
        if (saveAvailableViewMode != null) {
            viewMode = saveAvailableViewMode;
            saveAvailableViewMode = null;
        }
        this.textAvailableQFilter.setText("");
        this.availableModel.resetModel(viewMode, true);
        this.clearAvailableQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void clearSelectedQFilter() {
        this.selectedModel.clearQFilter();
        if (saveSelectedViewMode != null) {
            viewSelectMode = saveSelectedViewMode;
            saveSelectedViewMode = null;
        }
        this.textSelectedQFilter.setText("");
        this.selectedModel.resetModel(viewSelectMode, false);
        this.clearSelectedQFilterButton.setEnabled(false);
        this.viewSelectComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void setAvailableQFilter() {
        String string = this.textAvailableQFilter.getText();
        if (string.length() == 0) {
            this.clearAvailableQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveAvailableViewMode == null) {
            saveAvailableViewMode = viewMode;
        }
        viewMode = 5;
        this.availableModel.resetModel(viewMode, true);
        this.clearAvailableQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private void setSelectedQFilter() {
        String string = this.textSelectedQFilter.getText();
        if (string.length() == 0) {
            this.clearSelectedQFilter();
            return;
        }
        this.selectedModel.setQFilter(string);
        if (saveSelectedViewMode == null) {
            saveSelectedViewMode = viewSelectMode;
        }
        viewSelectMode = 5;
        this.selectedModel.resetModel(viewMode, false);
        this.clearSelectedQFilterButton.setEnabled(true);
        this.viewSelectComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private void updatePcl(int n) {
        if (n > 0) {
            PCLevelInfo pCLevelInfo = this.getSelectedLevelInfo(this.pc);
            while (pCLevelInfo != null && n > 0) {
                int n2 = pCLevelInfo.getSkillPointsRemaining();
                if (n2 >= n) {
                    pCLevelInfo.setSkillPointsRemaining(n2 -= n);
                    n = 0;
                    continue;
                }
                n -= n2;
                pCLevelInfo.setSkillPointsRemaining(0);
                pCLevelInfo = this.getSelectedLevelInfo(this.pc);
            }
        } else {
            n = -n;
            for (int i = this.pc.getLevelInfo().size() - 1; i >= 0; --i) {
                PCLevelInfo pCLevelInfo = this.pc.getLevelInfo().get(i);
                int n3 = pCLevelInfo.getSkillPointsGained();
                int n4 = n3 - pCLevelInfo.getSkillPointsRemaining();
                if (n4 >= n) {
                    pCLevelInfo.setSkillPointsRemaining(n3 - (n4 -= n));
                    break;
                }
                pCLevelInfo.setSkillPointsRemaining(n3);
                n -= n4;
            }
        }
    }

    private ArrayList<Skill> getSatisfiedPrereqSkills(Skill skill) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        ArrayList<Skill> arrayList2 = this.pc.getSkillList();
        for (Skill skill2 : arrayList2) {
            if (skill.compareTo(skill2) == 0 || !skill2.hasPreReqs() || !PrereqHandler.passesAll(skill2.getPreReqList(), this.pc, skill2)) continue;
            arrayList.add(skill2);
        }
        return arrayList;
    }

    private boolean prereqSkillsInvalid(ArrayList<Skill> arrayList) {
        Iterator<Skill> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = iterator.next();
            if (!PrereqHandler.passesAll(skill.getPreReqList(), this.pc, skill)) continue;
            iterator.remove();
        }
        return arrayList.size() != 0;
    }

    private final class RendererEditor
    implements TableCellRenderer {
        private DefaultTableCellRenderer def = new DefaultTableCellRenderer();
        private JButton plusButton = new JButton("+");

        private RendererEditor() {
            this.def.setBackground(InfoSkills.this.getBackground());
            this.def.setAlignmentX(0.5f);
            this.def.setHorizontalAlignment(0);
            this.plusButton.setPreferredSize(new Dimension(30, 24));
            this.plusButton.setMinimumSize(new Dimension(30, 24));
            this.plusButton.setMaximumSize(new Dimension(30, 24));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 7) {
                this.def.setText("+");
                this.def.setBorder(BorderFactory.createEtchedBorder());
                return this.def;
            }
            if (n3 == 8) {
                this.def.setText("-");
                this.def.setBorder(BorderFactory.createEtchedBorder());
                return this.def;
            }
            return null;
        }
    }

    private class SkillPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -5369872214039221832L;
        private JMenu resortMenu = null;
        private String lastSearch = "";

        SkillPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == InfoSkills.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_1"), 1, "shortcut EQUALS"));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_2"), 2, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_5"), 5, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_10"), 10, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_n"), -1, "alt A"));
                this.add(this.createMaxMenuItem(PropertyFactory.getString("in_iskMax_Ranks"), "alt M"));
                this.addSeparator();
                this.add(Utility.createMenuItem("Find item", new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SkillPopupMenu.this.lastSearch = InfoSkills.this.availableTable.searchTree(SkillPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", "Find item", null, true));
            } else {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_1"), 1, "shortcut EQUALS"));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_2"), 2, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_5"), 5, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_10"), 10, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_n"), -1, "alt A"));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_1"), 1, "shortcut MINUS"));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_2"), 2, null));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_5"), 5, null));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_10"), 10, null));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_n"), -1, "alt R"));
                this.add(this.createMaxMenuItem(PropertyFactory.getString("in_iskMax_Ranks"), "alt M"));
                this.add(this.createResetMenuItem(PropertyFactory.getString("in_iskZero_Ranks"), "alt Z"));
                this.addSeparator();
                this.add(Utility.createMenuItem("Find item", new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SkillPopupMenu.this.lastSearch = InfoSkills.this.selectedTable.searchTree(SkillPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", "Find item", null, true));
                this.addSeparator();
                this.resortMenu = Utility.createMenu("Output Order", '\u0000', PropertyFactory.getString("in_iskOutput_Order"), null, true);
                this.add(this.resortMenu);
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_name_ascending"), new ResortActionListener(0, true), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_name_ascending_tooltip"), null, true));
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_name_descending"), new ResortActionListener(0, false), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_name_descending_tooltip"), null, true));
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_trained_then_untrained"), new ResortActionListener(1, true), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_trained_then_untrained_tooltip"), null, true));
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_untrained_then_trained"), new ResortActionListener(1, false), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_untrained_then_trained_tooltip"), null, true));
            }
        }

        private JMenuItem createAddMenuItem(String string, int n, String string2) {
            return Utility.createMenuItem(string, new AddSkillActionListener(n), "add " + n, '\u0000', string2, PropertyFactory.getString("in_iskAdd") + (n < 0 ? PropertyFactory.getString("in_iskn") : Integer.toString(n)) + PropertyFactory.getString("in_isk_skill_point") + (n == 1 ? "" : PropertyFactory.getString("in_isks")), "Add16.gif", true);
        }

        private JMenuItem createMaxMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new MaxSkillActionListener(0), "max ranks", '\u0000', string2, PropertyFactory.getString("in_iskSet_to_max_ranks"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String string, int n, String string2) {
            return Utility.createMenuItem(string, new RemoveSkillActionListener(n), "remove " + n, '\u0000', string2, PropertyFactory.getString("in_iskRemove") + (n < 0 ? PropertyFactory.getString("in_iskn") : Integer.toString(n)) + PropertyFactory.getString("in_isk_skill_point") + (n == 1 ? "" : PropertyFactory.getString("in_isks")), "Remove16.gif", true);
        }

        private JMenuItem createResetMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new ResetSkillActionListener(0), "reset ranks", '\u0000', string2, PropertyFactory.getString("in_iskReset_to_zero_ranks"), "Add16.gif", true);
        }

        public JMenu getResortMenu() {
            return this.resortMenu;
        }

        private class SkillActionListener
        implements ActionListener {
            int qty = 0;

            private SkillActionListener(int n) {
                this.qty = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class ResetSkillActionListener
        extends SkillActionListener {
            private ResetSkillActionListener(int n) {
                super(n);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Skill skill = InfoSkills.this.pc.getSkillKeyed(InfoSkills.this.getSelectedSkill().getKeyName());
                if (skill != null) {
                    Iterator<PCClass> iterator = InfoSkills.this.pc.getClassList().iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        int n = skill.costForPCClass(InfoSkills.this.getSelectedPCClass(), InfoSkills.this.pc);
                        double d = -skill.getTotalRank(InfoSkills.this.pc).doubleValue() * (double)n;
                        if (Globals.getGameModeSkillCost_Class() > 1) {
                            d /= (double)Globals.getGameModeSkillCost_Class();
                        }
                        InfoSkills.this.addSkill((int)d);
                    }
                    if (CoreUtility.doublesEqual(skill.getRank().doubleValue(), 0.0) && !skill.isUntrained()) {
                        InfoSkills.this.pc.getSkillList().remove(skill);
                    }
                    InfoSkills.this.updateSelectedModel();
                    if (!Globals.getGameModeHasPointPool()) {
                        InfoSkills.this.currCharacterClassActionPerformed();
                    }
                }
            }
        }

        private class RemoveSkillActionListener
        extends SkillActionListener {
            private RemoveSkillActionListener(int n) {
                super(n);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = this.qty;
                if (this.qty < 0) {
                    String string = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_iskRemove_quantity_tooltip"), "PCGen", 3);
                    if (string != null) {
                        try {
                            n = Math.abs(Integer.parseInt(string.trim()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskInvalid_number"), "PCGen", MessageType.ERROR);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                InfoSkills.this.addSkill(-n);
            }
        }

        private class MaxSkillActionListener
        extends SkillActionListener {
            private MaxSkillActionListener(int n) {
                super(n);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Skill skill = InfoSkills.this.getSelectedSkill();
                if (skill == null) {
                    return;
                }
                PlayerCharacter playerCharacter = InfoSkills.this.pc;
                playerCharacter.setDirty(true);
                Skill skill2 = playerCharacter.getSkillKeyed(skill.getKeyName());
                if (skill2 != null) {
                    skill = skill2;
                }
                PCClass pCClass = InfoSkills.this.getSelectedPCClass();
                PCLevelInfo pCLevelInfo = InfoSkills.this.getSelectedLevelInfo(playerCharacter);
                double d = 0.0;
                double d2 = 0.0;
                if (pCClass != null) {
                    d = playerCharacter.getMaxRank(skill.getKeyName(), pCClass).doubleValue();
                    if (Globals.getGameModeHasPointPool()) {
                        d2 = InfoSkills.this.pc.getSkillPoints();
                    } else if (pCLevelInfo != null) {
                        d2 = pCLevelInfo.getSkillPointsRemaining();
                    }
                }
                if (d > skill.getRank().doubleValue() || Globals.checkRule("SKILLMAX")) {
                    int n = skill.costForPCClass(InfoSkills.this.getSelectedPCClass(), InfoSkills.this.pc);
                    double d3 = Math.floor((d - skill.getTotalRank(InfoSkills.this.pc).doubleValue()) * (double)n);
                    double d4 = Math.min(d3, d2);
                    int n2 = Globals.getGameModeSkillCost_Class();
                    if (n2 > 1) {
                        d4 = Math.floor(d4 / (double)n2);
                    }
                    InfoSkills.this.addSkill((int)d4);
                } else {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_01"), "PCGen", MessageType.INFORMATION);
                }
            }
        }

        private class AddSkillActionListener
        extends SkillActionListener {
            private AddSkillActionListener(int n) {
                super(n);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = this.qty;
                if (this.qty < 0) {
                    String string = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_iskAdd_quantity_tooltip"), "PCGen", 3);
                    if (string != null) {
                        try {
                            n = Math.abs(Integer.parseInt(string.trim()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskInvalid_number"), "PCGen", MessageType.ERROR);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                InfoSkills.this.addSkill(n);
            }
        }
    }

    private class SkillPopupListener
    extends MouseAdapter {
        private JTree tree;
        private SkillPopupMenu menu;

        private SkillPopupListener(JTreeTable jTreeTable, SkillPopupMenu skillPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = skillPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoSkills.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < SkillPopupListener.this.menu.getComponentCount(); ++i) {
                            JMenuItem jMenuItem;
                            KeyStroke keyStroke2;
                            Component component = SkillPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = (jMenuItem = (JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoSkills.this.selPath = SkillPopupListener.this.tree.getSelectionPath();
                            jMenuItem.doClick(2);
                            return;
                        }
                    }
                    InfoSkills.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoSkills.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoSkills.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoSkills.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoSkills.this.selPath);
                JMenu jMenu = this.menu.getResortMenu();
                if (jMenu != null) {
                    jMenu.setEnabled(selectedOutputOrder == 4);
                }
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class QualifyFilter
    extends AbstractPObjectFilter {
        private QualifyFilter() {
            super("Miscellaneous", "Qualify");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_qual_tooltip"));
            }
        }

        public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pCClass = InfoSkills.this.getSelectedPCClass();
                Skill skill = (Skill)pObject;
                return pCClass != null && (!skill.isExclusive() || skill.isClassSkill(pCClass, playerCharacter));
            }
            return true;
        }
    }

    private class ExclusiveSkillFilter
    extends AbstractPObjectFilter {
        private ExclusiveSkillFilter() {
            super("Skill", "Exclusive");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_exclusive_tooltip"));
            }
        }

        public String getName(PlayerCharacter playerCharacter) {
            PCClass pCClass = InfoSkills.this.getSelectedPCClass();
            if (pCClass != null) {
                return super.getName(playerCharacter) + " (" + pCClass.getDisplayName() + ")";
            }
            return super.getName(playerCharacter);
        }

        public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pCClass = InfoSkills.this.getSelectedPCClass();
                Skill skill = (Skill)pObject;
                return pCClass != null && !skill.isClassSkill(pCClass, playerCharacter) && skill.isExclusive();
            }
            return true;
        }
    }

    private class CrossClassSkillFilter
    extends AbstractPObjectFilter {
        private CrossClassSkillFilter() {
            super("Skill", "Cross-Class");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_crossclass_tooltip"));
            }
        }

        public String getName(PlayerCharacter playerCharacter) {
            PCClass pCClass = InfoSkills.this.getSelectedPCClass();
            if (pCClass != null) {
                return super.getName(playerCharacter) + " (" + pCClass.getDisplayName() + ")";
            }
            return super.getName(playerCharacter);
        }

        public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pCClass = InfoSkills.this.getSelectedPCClass();
                Skill skill = (Skill)pObject;
                return pCClass != null && !skill.isClassSkill(pCClass, playerCharacter) && !skill.isExclusive();
            }
            return true;
        }
    }

    private class ClassSkillFilter
    extends AbstractPObjectFilter {
        private ClassSkillFilter() {
            super("Skill", "Class");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_class_tooltip"));
            }
        }

        public final String getName(PlayerCharacter playerCharacter) {
            PCClass pCClass = InfoSkills.this.getSelectedPCClass();
            if (pCClass != null) {
                return super.getName(playerCharacter) + " (" + pCClass.getDisplayName() + ")";
            }
            return super.getName(playerCharacter);
        }

        public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pCClass = InfoSkills.this.getSelectedPCClass();
                return pCClass != null && ((Skill)pObject).isClassSkill(pCClass, playerCharacter);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SkillModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        private static final int COL_NAME = 0;
        private static final int COL_TOTAL = 1;
        private static final int COL_MOD = 2;
        private static final int COL_RANK = 3;
        private static final int COL_COST = 4;
        private static final int COL_SRC = 5;
        private static final int COL_INDEX = 6;
        private String[] names;
        private int[] widths;
        private List<Boolean> displayList;
        private int modelType;

        private SkillModel(int n, boolean bl) {
            super(null);
            this.names = new String[]{"Skill", "Total", "Modifier", "Ranks", "Cost", "Source", "Order", "+", "-"};
            this.widths = new int[]{100, 100, 100, 100, 100, 100, 100, 30, 30};
            this.modelType = 0;
            if (!bl) {
                this.modelType = 1;
            }
            this.resetModel(n, bl);
            int n2 = 1;
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            if (bl) {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
            } else {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
            }
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 0 || this.modelType == 1 && n == 5 && ((PObjectNode)object).getItem() instanceof SkillWrapper;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    GameMode gameMode = SettingsHandler.getGame();
                    if (gameMode.hasSkillRankDisplayText()) {
                        return String.class;
                    }
                    return Float.class;
                }
                case 1: {
                    GameMode gameMode = SettingsHandler.getGame();
                    if (gameMode.hasSkillRankDisplayText()) {
                        return String.class;
                    }
                    return Integer.class;
                }
                case 4: {
                    return Integer.class;
                }
                case 6: {
                    return Integer.class;
                }
                case 7: 
                case 8: {
                    return String.class;
                }
                case 5: {
                    break;
                }
                default: {
                    Logging.errorPrintLocalised("in_iskErr_message_08", "InfoSkills.SkillModel.getColumnClass", String.valueOf(n));
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.names[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public void setValueAt(Object object, Object object2, int n) {
            boolean bl = false;
            if (this.modelType != 1) {
                return;
            }
            if (!(((PObjectNode)object2).getItem() instanceof SkillWrapper)) {
                return;
            }
            PObjectNode pObjectNode = (PObjectNode)object2;
            SkillWrapper skillWrapper = (SkillWrapper)pObjectNode.getItem();
            Skill skill = skillWrapper.getSkWrapSkill();
            if (skill != null) {
                switch (n) {
                    case 5: {
                        int n2 = (Integer)object;
                        if (n2 == 1000) {
                            n2 = InfoSkills.this.getHighestOutputIndex() + 1;
                        } else if (n2 == 0) {
                            bl = true;
                            n2 = 2;
                            for (Skill skill2 : InfoSkills.this.pc.getSkillListInOutputOrder()) {
                                if (skill2.getOutputIndex() <= -1 || skill2 == skill) continue;
                                skill2.setOutputIndex(n2++);
                            }
                            n2 = 1;
                        } else if (n2 != -1) {
                            int n3 = 1;
                            bl = true;
                            for (Skill skill3 : InfoSkills.this.pc.getSkillListInOutputOrder()) {
                                if (n3 == n2) {
                                    ++n3;
                                }
                                if (skill3.getOutputIndex() <= -1 || skill3 == skill) continue;
                                skill3.setOutputIndex(n3++);
                            }
                        }
                        skill.setOutputIndex(n2);
                        skillWrapper = new SkillWrapper(skill, skill.modifier(InfoSkills.this.pc), skill.getTotalRank(InfoSkills.this.pc), skill.getOutputIndex());
                        pObjectNode.setItem(skillWrapper);
                        if (!bl) break;
                        InfoSkills.this.updateSelectedModel();
                        break;
                    }
                    default: {
                        Logging.errorPrintLocalised("in_iskErr_message_08", "InfoSkills.SkillModel.setValueAt", String.valueOf(n));
                    }
                }
            }
        }

        @Override
        public Object getValueAt(Object object, int n) {
            PObjectNode pObjectNode = (PObjectNode)object;
            if (pObjectNode == null) {
                Logging.errorPrint(PropertyFactory.getString("in_iskErr_message_09"));
                return null;
            }
            if (!(pObjectNode.getItem() instanceof SkillWrapper)) {
                return n == 0 ? pObjectNode.toString() : null;
            }
            Object object2 = (SkillWrapper)pObjectNode.getItem();
            Skill skill = ((SkillWrapper)object2).getSkWrapSkill();
            Integer n2 = ((SkillWrapper)object2).getSkWrapMod();
            Float f = ((SkillWrapper)object2).getSkWrapRank();
            Integer n3 = ((SkillWrapper)object2).getSkWrapOutputIndex();
            switch (n) {
                case 0: {
                    return pObjectNode.toString();
                }
                case 2: {
                    return n2;
                }
                case 3: {
                    object2 = SettingsHandler.getGame();
                    if (((GameMode)object2).hasSkillRankDisplayText()) {
                        return ((GameMode)object2).getSkillRankDisplayText(f.intValue());
                    }
                    return f;
                }
                case 1: {
                    object2 = SettingsHandler.getGame();
                    if (((GameMode)object2).hasSkillRankDisplayText()) {
                        return ((GameMode)object2).getSkillRankDisplayText(n2 + f.intValue());
                    }
                    return n2 + f.intValue();
                }
                case 4: {
                    if (skill != null) {
                        return skill.costForPCClass(InfoSkills.this.getSelectedPCClass(), InfoSkills.this.pc);
                    }
                    return "0";
                }
                case 5: {
                    if (skill != null) {
                        return skill.getDefaultSourceString();
                    }
                    return pObjectNode.getSource();
                }
                case 6: {
                    return n3;
                }
                case 7: {
                    return "+";
                }
                case 8: {
                    return "-";
                }
                case -1: {
                    return pObjectNode.getItem();
                }
            }
            Logging.errorPrintLocalised("in_iskErr_message_08", "InfoSkills.SkillModel.getValueAt", String.valueOf(n));
            return null;
        }

        private void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        private void createRootNode(PObjectNode pObjectNode, ResetableListIterator resetableListIterator, InfoSkillsSorter infoSkillsSorter, boolean bl) {
            this.populateNode(pObjectNode, resetableListIterator, infoSkillsSorter, bl);
            if (infoSkillsSorter.nodeHaveNext()) {
                while (pObjectNode.hasNext()) {
                    this.createRootNode((PObjectNode)pObjectNode.next(), resetableListIterator, infoSkillsSorter.nextSorter(), bl);
                }
            }
        }

        private void initRoot(boolean bl, InfoSkillsSorter infoSkillsSorter) {
            PObjectNode pObjectNode = new PObjectNode();
            this.createRootNode(pObjectNode, new DisplayableSkillsIterator(bl), infoSkillsSorter, bl);
            this.setRoot(infoSkillsSorter.finalPass(pObjectNode));
        }

        private void populateNode(PObjectNode pObjectNode, ResetableListIterator resetableListIterator, InfoSkillsSorter infoSkillsSorter, boolean bl) {
            TreeSet<Object> treeSet = new TreeSet<Object>(new StringIgnoreCaseComparator());
            String string = this.getQFilter();
            treeSet.clear();
            resetableListIterator.reset();
            while (resetableListIterator.hasNext()) {
                Iterator iterator;
                Skill skill = (Skill)resetableListIterator.next();
                if (string != null && skill.getDisplayName().toLowerCase().indexOf(string) < 0 && skill.getType().toLowerCase().indexOf(string) < 0 || !infoSkillsSorter.nodeGoHere(pObjectNode, skill)) continue;
                Object object = infoSkillsSorter.whatPart(bl, skill, InfoSkills.this.pc);
                if (object instanceof Iterator) {
                    iterator = (Iterator)object;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e instanceof String && Globals.isSkillTypeHidden(e.toString())) {
                            PObjectNode pObjectNode2 = new PObjectNode(InfoSkills.createSkillWrapper(bl, skill, InfoSkills.this.pc));
                            PrereqHandler.passesAll(skill.getPreReqList(), InfoSkills.this.pc, skill);
                            treeSet.add(pObjectNode2);
                            continue;
                        }
                        treeSet.add(new PObjectNode(e));
                    }
                    continue;
                }
                if (bl && skill.getVisibility() == Visibility.OUTPUT_ONLY) continue;
                iterator = new PObjectNode(object);
                PrereqHandler.passesAll(skill.getPreReqList(), InfoSkills.this.pc, skill);
                treeSet.add(iterator);
            }
            for (Object object : treeSet) {
                pObjectNode.addChild((PObjectNode)object);
            }
        }

        protected void resetModel(int n, boolean bl) {
            switch (n) {
                case 0: {
                    this.initRoot(bl, new InfoSkillsSorters.KeystatSubtypeName_Primary(InfoSkills.this));
                    break;
                }
                case 1: {
                    this.initRoot(bl, new InfoSkillsSorters.KeystatName_Primary(InfoSkills.this));
                    break;
                }
                case 2: {
                    this.initRoot(bl, new InfoSkillsSorters.SubtypeName_Primary(InfoSkills.this));
                    break;
                }
                case 3: {
                    this.initRoot(bl, new InfoSkillsSorters.CostSubtypeName_Primary(InfoSkills.this));
                    break;
                }
                case 4: {
                    this.initRoot(bl, new InfoSkillsSorters.CostName_Primary(InfoSkills.this));
                    break;
                }
                case 5: {
                    this.initRoot(bl, new InfoSkillsSorters.Name_Primary(InfoSkills.this));
                    break;
                }
                default: {
                    Logging.errorPrintLocalised("in_iskErr_message_07", String.valueOf(n));
                }
            }
            PObjectNode pObjectNode = (PObjectNode)super.getRoot();
            if (pObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(Skill skill) {
            return this.modelType == 1 || InfoSkills.this.accept(InfoSkills.this.pc, skill);
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption("InfoSkills.sizecol." + this.names[n], this.widths[n]);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.modelType + "." + this.names[n], bl);
            this.displayList.set(n, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoSkills.viewcol." + string, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            if (SettingsHandler.getGame().getSkillTabColumnVisible(n)) {
                return this.displayList.get(n);
            }
            return false;
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption("InfoSkills.sizecol." + this.names[n], n2);
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.names.length; ++i) {
                arrayList.add(this.names[i]);
            }
            return arrayList;
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoSkills.viewcol." + string, bl);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
            int n2 = tableColumn.getModelIndex();
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    tableColumn.setCellRenderer(new JTableEx.AlignCellRenderer(0));
                    break;
                }
                case 6: {
                    tableColumn.setCellEditor(new OutputOrderEditor(new String[]{PropertyFactory.getString("in_iskFirst"), PropertyFactory.getString("in_iskLast"), PropertyFactory.getString("in_iskHidden")}));
                    break;
                }
                case 7: 
                case 8: {
                    tableColumn.setCellRenderer(InfoSkills.this.plusMinusRenderer);
                    tableColumn.setMaxWidth(30);
                    tableColumn.setMinWidth(30);
                    break;
                }
            }
        }

        private class DisplayableSkillsIterator
        implements ResetableListIterator {
            private boolean available;
            private int index;
            private int listSize;
            List<Skill> skillList;

            public DisplayableSkillsIterator(boolean bl) {
                this.available = bl;
                this.reset();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.nextIndex() < this.listSize;
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object next() {
                Skill skill;
                while (!SkillModel.this.shouldDisplayThis(skill = this.skillList.get(this.index++))) {
                }
                return skill;
            }

            public int nextIndex() {
                Skill skill;
                int n;
                for (n = this.index; n < this.listSize && !SkillModel.this.shouldDisplayThis(skill = this.skillList.get(n)); ++n) {
                }
                return n;
            }

            public Object previous() {
                Skill skill;
                while (!SkillModel.this.shouldDisplayThis(skill = this.skillList.get(--this.index))) {
                }
                return skill;
            }

            public int previousIndex() {
                Skill skill;
                int n;
                for (n = this.index - 1; n >= 0 && !SkillModel.this.shouldDisplayThis(skill = this.skillList.get(n)); --n) {
                }
                return n;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void reset() {
                this.skillList = this.available ? Globals.getPartialSkillList(Visibility.DISPLAY_ONLY) : InfoSkills.this.pc.getPartialSkillList(Visibility.DISPLAY_ONLY);
                this.listSize = this.skillList.size();
                this.index = 0;
                this.index = this.nextIndex();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class ResortActionListener
    implements ActionListener {
        boolean sortOrder;
        int sort;

        public ResortActionListener(int n, boolean bl) {
            this.sort = n;
            this.sortOrder = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoSkills.this.resortSelected(this.sort, this.sortOrder);
        }
    }

    private static final class OutputOrderEditor
    extends JComboBoxEx
    implements TableCellEditor {
        private final transient List<CellEditorListener> d_listeners = new ArrayList<CellEditorListener>();
        private transient int d_originalValue;

        private OutputOrderEditor(String[] stringArray) {
            super(stringArray);
            this.setEditable(true);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutputOrderEditor.this.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1000;
                }
                case 2: {
                    return -1;
                }
            }
            return Integer.valueOf((String)this.getSelectedItem());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.d_originalValue = this.getSelectedIndex();
            if (object instanceof Integer) {
                int n3 = (Integer)object;
                if (n3 == -1) {
                    this.setSelectedItem(PropertyFactory.getString("in_iskHidden"));
                } else {
                    this.setSelectedItem(String.valueOf(n3));
                }
            } else {
                this.setSelectedItem(PropertyFactory.getString("in_iskHidden"));
            }
            jTable.setRowSelectionInterval(n, n);
            jTable.setColumnSelectionInterval(n2, n2);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setSelectedIndex(this.d_originalValue);
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingCanceled(changeEvent);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingStopped(changeEvent);
            }
        }
    }

    public static final class SkillWrapper {
        private Float _ranks;
        private Integer _mod;
        private Integer _outputIndex;
        private Skill _aSkill = null;

        private SkillWrapper(Skill skill, Integer n, Float f, Integer n2) {
            this._aSkill = skill;
            this._mod = n;
            this._ranks = f;
            this._outputIndex = n2;
        }

        public String toString() {
            if (this._aSkill == null) {
                return "";
            }
            return this._aSkill.piString();
        }

        protected Integer getSkWrapMod() {
            return this._mod;
        }

        protected Integer getSkWrapOutputIndex() {
            return this._outputIndex;
        }

        protected Float getSkWrapRank() {
            return this._ranks;
        }

        protected Skill getSkWrapSkill() {
            return this._aSkill;
        }
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Skill skill = InfoSkills.this.getSelectedSkill();
                    if (skill != null) {
                        int n;
                        if (skill.getChoiceString() == null) {
                            n = 1;
                        } else {
                            n = skill.costForPCClass(InfoSkills.this.getSelectedPCClass(), InfoSkills.this.pc);
                            int n2 = Globals.getGameModeSkillCost_Class();
                            if (n2 > 1) {
                                n /= n2;
                            }
                        }
                        InfoSkills.this.addSkill(-n);
                    }
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoSkills.this.addSkill(1);
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }
}

