/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.SettingsHandler;
import pcgen.core.spell.Spell;
import pcgen.gui.filter.AffordableFilter;
import pcgen.gui.filter.AlignmentFilter;
import pcgen.gui.filter.AutomaticFeatFilter;
import pcgen.gui.filter.CastingTimeFilter;
import pcgen.gui.filter.ComponentFilter;
import pcgen.gui.filter.CompoundFilter;
import pcgen.gui.filter.DeityAlignmentFilter;
import pcgen.gui.filter.DescriptorFilter;
import pcgen.gui.filter.DomainFilter;
import pcgen.gui.filter.EffectTypeFilter;
import pcgen.gui.filter.FavoredClassFilter;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterConstants;
import pcgen.gui.filter.FilterParseException;
import pcgen.gui.filter.FilterParser;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GenreFilter;
import pcgen.gui.filter.InverseFilter;
import pcgen.gui.filter.NamedFilter;
import pcgen.gui.filter.NonMagicFilter;
import pcgen.gui.filter.NormalFeatFilter;
import pcgen.gui.filter.PCAlignmentFilter;
import pcgen.gui.filter.PCClassFilter;
import pcgen.gui.filter.PCSizeFilter;
import pcgen.gui.filter.PCTemplateFilter;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.filter.PantheonFilter;
import pcgen.gui.filter.QualifyFilter;
import pcgen.gui.filter.RaceFilter;
import pcgen.gui.filter.RangeFilter;
import pcgen.gui.filter.RankFilter;
import pcgen.gui.filter.RankModifierFilter;
import pcgen.gui.filter.SchoolFilter;
import pcgen.gui.filter.SettingFilter;
import pcgen.gui.filter.SizeFilter;
import pcgen.gui.filter.SourceFilter;
import pcgen.gui.filter.SpellResistanceFilter;
import pcgen.gui.filter.SpellTypeFilter;
import pcgen.gui.filter.StatFilter;
import pcgen.gui.filter.SubschoolFilter;
import pcgen.gui.filter.TypeFilter;
import pcgen.gui.filter.UntrainedSkillFilter;
import pcgen.gui.filter.VirtualFeatFilter;
import pcgen.gui.filter.WeaponFilter;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterFactory
implements FilterConstants {
    private static List<PObjectFilter> campaignFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> classFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> deityFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> equipmentFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> featFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> prereqAlignmentFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> raceFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> sizeFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> skillFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> sourceFilters = new ArrayList<PObjectFilter>();
    private static List<PObjectFilter> spellFilters = new ArrayList<PObjectFilter>();
    private static Map<String, String> filterSettings = new HashMap<String, String>();
    private static final String MODE_SETTING = "mode";
    private static final String AVAILABLE_SETTING = "available";
    private static final String SELECTED_SETTING = "selected";
    private static final String REMOVED_SETTING = "removed";

    public static void clearFilterCache() {
        campaignFilters.clear();
        classFilters.clear();
        deityFilters.clear();
        equipmentFilters.clear();
        featFilters.clear();
        prereqAlignmentFilters.clear();
        raceFilters.clear();
        skillFilters.clear();
        sourceFilters.clear();
        spellFilters.clear();
    }

    public static PObjectFilter createPCClassFilter() {
        return new PCClassFilter();
    }

    public static String filterListToString(List<?> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object obj : list) {
            stringBuffer.append('[').append(obj.getClass().getName());
            stringBuffer.append("|").append(obj.toString()).append(']');
        }
        return stringBuffer.toString();
    }

    public static void registerAllClassFilters(FilterAdapterPanel filterAdapterPanel) {
        if (classFilters.size() == 0) {
            classFilters.add(FilterFactory.createQualifyFilter());
            Iterator<Object> iterator = Globals.getPCClassTypeList().iterator();
            while (iterator.hasNext()) {
                String object;
                classFilters.add(FilterFactory.createTypeFilter(object, (object = (String)iterator.next()).length() > 3));
            }
            classFilters.add(FilterFactory.createSpellTypeFilter("Arcane"));
            classFilters.add(FilterFactory.createSpellTypeFilter("Divine"));
            classFilters.add(FilterFactory.createSpellTypeFilter("Psionic"));
        }
        for (PObjectFilter pObjectFilter : classFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void registerAllDeityFilters(FilterAdapterPanel filterAdapterPanel) {
        if (deityFilters.size() == 0) {
            void iterator;
            deityFilters.add(FilterFactory.createQualifyFilter());
            deityFilters.add(FilterFactory.createPCAlignmentFilter());
            int n = SettingsHandler.getGame().getUnmodifiableAlignmentList().size();
            boolean i = false;
            while (iterator < n) {
                deityFilters.add(FilterFactory.createAlignmentFilter((int)iterator));
                ++iterator;
            }
            for (Domain domain : Globals.getDomainList()) {
                deityFilters.add(FilterFactory.createDomainFilter(domain));
            }
            deityFilters.add(FilterFactory.createPantheonFilter(PantheonFilter.ALL, PantheonFilter.Detail.HIGH));
            Iterator iterator2 = Globals.getPantheons().iterator();
            while (iterator2.hasNext()) {
                String string;
                deityFilters.add(FilterFactory.createPantheonFilter(string, (string = (String)iterator2.next()).indexOf(" (") > -1 ? PantheonFilter.Detail.HIGH : PantheonFilter.Detail.LOW));
            }
        }
        for (PObjectFilter pObjectFilter : deityFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllEquipmentFilters(FilterAdapterPanel filterAdapterPanel) {
        if (equipmentFilters.size() == 0) {
            equipmentFilters.add(FilterFactory.createQualifyFilter());
            equipmentFilters.add(FilterFactory.createNonMagicFilter());
            equipmentFilters.add(FilterFactory.createAffordableFilter());
            for (String object : Equipment.getEquipmentTypes()) {
                equipmentFilters.add(FilterFactory.createTypeFilter(object));
            }
            for (String string : Globals.getWeaponTypeList()) {
                equipmentFilters.add(FilterFactory.createWeaponFilter(string));
            }
            equipmentFilters.add(FilterFactory.createPCSizeFilter());
        }
        for (PObjectFilter pObjectFilter : equipmentFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllFeatFilters(FilterAdapterPanel filterAdapterPanel) {
        if (featFilters.size() == 0) {
            featFilters.add(FilterFactory.createQualifyFilter());
            featFilters.add(FilterFactory.createAutomaticFeatFilter());
            featFilters.add(FilterFactory.createNormalFeatFilter());
            featFilters.add(FilterFactory.createVirtualFeatFilter());
        }
        for (PObjectFilter pObjectFilter : featFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllPrereqAlignmentFilters(FilterAdapterPanel filterAdapterPanel) {
        if (prereqAlignmentFilters.size() == 0) {
            int n = SettingsHandler.getGame().getUnmodifiableAlignmentList().size();
            for (int i = 0; i < n; ++i) {
                prereqAlignmentFilters.add(FilterFactory.createAlignmentFilter(i, AlignmentFilter.Mode.ALLOWED));
                prereqAlignmentFilters.add(FilterFactory.createAlignmentFilter(i, AlignmentFilter.Mode.REQUIRED));
            }
            prereqAlignmentFilters.add(FilterFactory.createPCAlignmentFilter(AlignmentFilter.Mode.ALLOWED));
            prereqAlignmentFilters.add(FilterFactory.createPCAlignmentFilter(AlignmentFilter.Mode.REQUIRED));
        }
        for (PObjectFilter pObjectFilter : prereqAlignmentFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllRaceFilters(FilterAdapterPanel filterAdapterPanel) {
        if (raceFilters.size() == 0) {
            for (String iterator : Globals.getRaceTypes()) {
                raceFilters.add(FilterFactory.createTypeFilter(iterator));
            }
            raceFilters.add(FilterFactory.createQualifyFilter());
            PObjectFilter pObjectFilter = FilterFactory.createCompoundFilter(new TypeFilter("Base"), new TypeFilter("PC"), "AND");
            for (PCClass pCClass : Globals.getClassList()) {
                if (!pCClass.getVisibility().equals((Object)Visibility.DEFAULT) || !pObjectFilter.accept(null, pCClass)) continue;
                raceFilters.add(FilterFactory.createFavoredClassFilter(pCClass.getKeyName()));
            }
            raceFilters.add(FilterFactory.createPCTemplateFilter());
            raceFilters.add(FilterFactory.createRaceFilter());
        }
        for (PObjectFilter pObjectFilter : raceFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllSizeFilters(FilterAdapterPanel filterAdapterPanel) {
        if (sizeFilters.size() == 0) {
            for (int i = 0; i < SettingsHandler.getGame().getSizeAdjustmentListSize(); ++i) {
                sizeFilters.add(FilterFactory.createSizeFilter(i));
            }
        }
        for (PObjectFilter pObjectFilter : sizeFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllSkillFilters(FilterAdapterPanel filterAdapterPanel) {
        if (skillFilters.size() == 0) {
            skillFilters.add(FilterFactory.createUntrainedSkillFilter());
            skillFilters.add(FilterFactory.createRankFilter(0.0));
            skillFilters.add(FilterFactory.createRankModifierFilter(0.0));
            for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
                skillFilters.add(FilterFactory.createStatFilter(SettingsHandler.getGame().s_ATTRIBSHORT[i]));
            }
        }
        for (PObjectFilter pObjectFilter : skillFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllSourceFilters(FilterAdapterPanel filterAdapterPanel) {
        if (sourceFilters.size() == 0) {
            for (String object2 : PersistenceManager.getInstance().getSources()) {
                sourceFilters.add(FilterFactory.createSourceFilter(object2));
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<PObjectFilter> arrayList2 = new ArrayList<PObjectFilter>();
        for (Campaign campaign : Globals.getCampaignList()) {
            if (!campaign.getSetting().equals("")) {
                arrayList.add(FilterFactory.createSettingFilter(campaign.getSetting()));
            }
            if (campaign.getGenre().equals("")) continue;
            arrayList2.add(FilterFactory.createGenreFilter(campaign.getGenre()));
        }
        sourceFilters.addAll(arrayList);
        sourceFilters.addAll(arrayList2);
        for (PObjectFilter pObjectFilter : sourceFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static void registerAllSpellFilters(FilterAdapterPanel filterAdapterPanel) {
        if (spellFilters.size() == 0) {
            spellFilters.add(FilterFactory.createComponentFilter(Spell.Component.VERBAL.toString()));
            spellFilters.add(FilterFactory.createComponentFilter(Spell.Component.SOMATIC.toString()));
            spellFilters.add(FilterFactory.createComponentFilter(Spell.Component.MATERIAL.toString()));
            spellFilters.add(FilterFactory.createComponentFilter(Spell.Component.DIVINEFOCUS.toString()));
            spellFilters.add(FilterFactory.createComponentFilter(Spell.Component.FOCUS.toString()));
            spellFilters.add(FilterFactory.createComponentFilter(Spell.Component.EXPERIENCE.toString()));
            for (String object : Globals.getCastingTimesSet()) {
                spellFilters.add(FilterFactory.createCastingTimeFilter(object));
            }
            for (String string : Globals.getDescriptorSet()) {
                spellFilters.add(FilterFactory.createDescriptorFilter(string));
            }
            for (String string : Globals.getTargetSet()) {
                spellFilters.add(FilterFactory.createEffectTypeFilter(string));
            }
            for (String string : Globals.getRangesSet()) {
                spellFilters.add(FilterFactory.createRangeFilter(string));
            }
            for (String string : SettingsHandler.getGame().getUnmodifiableSchoolsList()) {
                spellFilters.add(FilterFactory.createSchoolFilter(string));
            }
            for (String string : Globals.getSrSet()) {
                spellFilters.add(FilterFactory.createSpellResistanceFilter(string));
            }
            for (String string : Globals.getSubschools()) {
                spellFilters.add(FilterFactory.createSubschoolFilter(string));
            }
        }
        for (PObjectFilter pObjectFilter : spellFilters) {
            filterAdapterPanel.registerFilter(pObjectFilter);
        }
    }

    public static boolean restoreFilterSettings(Filterable filterable) {
        filterable.getAvailableFilters().clear();
        filterable.getSelectedFilters().clear();
        filterable.getRemovedFilters().clear();
        filterable.initializeFilters();
        String string = filterable.getName();
        if (string == null) {
            return false;
        }
        try {
            filterable.setFilterMode(Integer.parseInt(SettingsHandler.retrieveFilterSettings(string + '.' + MODE_SETTING)));
        }
        catch (NumberFormatException numberFormatException) {
            filterable.setFilterMode(0);
        }
        filterSettings.clear();
        List<String[]> list = FilterFactory.preprocessFilterList(AVAILABLE_SETTING, SettingsHandler.retrieveFilterSettings(string + '.' + AVAILABLE_SETTING));
        List<String[]> list2 = FilterFactory.preprocessFilterList(SELECTED_SETTING, SettingsHandler.retrieveFilterSettings(string + '.' + SELECTED_SETTING));
        List<String[]> list3 = FilterFactory.preprocessFilterList(REMOVED_SETTING, SettingsHandler.retrieveFilterSettings(string + '.' + REMOVED_SETTING));
        Object object = filterable.getAvailableFilters().iterator();
        while (object.hasNext()) {
            PObjectFilter pObjectFilter = object.next();
            String string2 = filterSettings.get(pObjectFilter.toString());
            if (string2 == null || AVAILABLE_SETTING.equals(string2)) continue;
            if (SELECTED_SETTING.equals(string2)) {
                object.remove();
                filterable.getSelectedFilters().add(pObjectFilter);
                continue;
            }
            if (!REMOVED_SETTING.equals(string2)) continue;
            object.remove();
            filterable.getRemovedFilters().add(pObjectFilter);
        }
        object = new FilterParser(new List[]{filterable.getAvailableFilters(), filterable.getSelectedFilters(), filterable.getRemovedFilters()});
        FilterFactory.parseCustomFilterList((FilterParser)object, filterable.getAvailableFilters(), list);
        FilterFactory.parseCustomFilterList((FilterParser)object, filterable.getSelectedFilters(), list2);
        FilterFactory.parseCustomFilterList((FilterParser)object, filterable.getRemovedFilters(), list3);
        filterable.refreshFiltering();
        return filterable.getAvailableFilters().size() + filterable.getSelectedFilters().size() > 0;
    }

    static PObjectFilter createCompoundFilter(PObjectFilter pObjectFilter, PObjectFilter pObjectFilter2, String string) {
        return new CompoundFilter(pObjectFilter, pObjectFilter2, string);
    }

    static PObjectFilter createInverseFilter(PObjectFilter pObjectFilter) {
        return new InverseFilter(pObjectFilter);
    }

    static PObjectFilter createNamedFilter(PObjectFilter pObjectFilter, String string, String string2) {
        return new NamedFilter(pObjectFilter, string, string2);
    }

    private static PObjectFilter createAffordableFilter() {
        return new AffordableFilter();
    }

    private static PObjectFilter createAlignmentFilter(int n) {
        return new DeityAlignmentFilter(n);
    }

    private static PObjectFilter createAlignmentFilter(int n, AlignmentFilter.Mode mode) {
        return new DeityAlignmentFilter(n, mode);
    }

    private static PObjectFilter createAutomaticFeatFilter() {
        return new AutomaticFeatFilter();
    }

    private static PObjectFilter createCastingTimeFilter(String string) {
        return new CastingTimeFilter(string);
    }

    private static PObjectFilter createComponentFilter(String string) {
        return new ComponentFilter(string);
    }

    private static PObjectFilter createDescriptorFilter(String string) {
        return new DescriptorFilter(string);
    }

    private static PObjectFilter createDomainFilter(Domain domain) {
        return new DomainFilter(domain);
    }

    private static PObjectFilter createEffectTypeFilter(String string) {
        return new EffectTypeFilter(string);
    }

    private static PObjectFilter createFavoredClassFilter(String string) {
        return new FavoredClassFilter(string);
    }

    private static PObjectFilter createGenreFilter(String string) {
        return new GenreFilter(string);
    }

    private static PObjectFilter createNonMagicFilter() {
        return new NonMagicFilter();
    }

    private static PObjectFilter createNormalFeatFilter() {
        return new NormalFeatFilter();
    }

    private static PObjectFilter createPCAlignmentFilter() {
        return new PCAlignmentFilter();
    }

    private static PObjectFilter createPCAlignmentFilter(AlignmentFilter.Mode mode) {
        return new PCAlignmentFilter(mode);
    }

    private static PObjectFilter createPCSizeFilter() {
        return new PCSizeFilter();
    }

    private static PObjectFilter createPCTemplateFilter() {
        return new PCTemplateFilter();
    }

    private static PObjectFilter createPantheonFilter(String string, PantheonFilter.Detail detail) {
        return new PantheonFilter(string, detail);
    }

    private static PObjectFilter createQualifyFilter() {
        return new QualifyFilter();
    }

    private static PObjectFilter createRaceFilter() {
        return new RaceFilter();
    }

    private static PObjectFilter createRangeFilter(String string) {
        return new RangeFilter(string);
    }

    private static PObjectFilter createRankFilter(double d) {
        return new RankFilter(d);
    }

    private static PObjectFilter createRankModifierFilter(double d) {
        return new RankModifierFilter(d);
    }

    private static PObjectFilter createSchoolFilter(String string) {
        return new SchoolFilter(string);
    }

    private static PObjectFilter createSettingFilter(String string) {
        return new SettingFilter(string);
    }

    private static PObjectFilter createSizeFilter(int n) {
        return new SizeFilter(n);
    }

    private static PObjectFilter createSourceFilter(String string) {
        return new SourceFilter(string, 1);
    }

    private static PObjectFilter createSpellResistanceFilter(String string) {
        return new SpellResistanceFilter(string);
    }

    private static PObjectFilter createSpellTypeFilter(String string) {
        return new SpellTypeFilter(string);
    }

    private static PObjectFilter createStatFilter(String string) {
        return new StatFilter(string);
    }

    private static PObjectFilter createSubschoolFilter(String string) {
        return new SubschoolFilter(string);
    }

    private static PObjectFilter createTypeFilter(String string) {
        return new TypeFilter(string);
    }

    private static PObjectFilter createTypeFilter(String string, boolean bl) {
        return new TypeFilter(string, bl);
    }

    private static PObjectFilter createUntrainedSkillFilter() {
        return new UntrainedSkillFilter();
    }

    private static PObjectFilter createVirtualFeatFilter() {
        return new VirtualFeatFilter();
    }

    private static PObjectFilter createWeaponFilter(String string) {
        return new WeaponFilter(string);
    }

    private static void parseCustomFilterList(FilterParser filterParser, List<PObjectFilter> list, List<String[]> list2) {
        for (String[] stringArray : list2) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], "()", true);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (FilterParser.isLegalToken(((String)object).trim())) {
                    stringBuffer.append((String)object);
                    continue;
                }
                stringBuffer.append('[');
                stringBuffer.append((String)object);
                stringBuffer.append(']');
            }
            try {
                object = filterParser.parse(stringBuffer.toString());
                if ((stringArray[1] + stringArray[2]).length() > 0) {
                    object = FilterFactory.createNamedFilter((PObjectFilter)object, stringArray[1], stringArray[2]);
                }
                list.add((PObjectFilter)object);
            }
            catch (FilterParseException filterParseException) {
                Logging.errorPrintLocalised("Errors.FilterFactory.ParseError", filterParseException);
            }
        }
    }

    private static List<String[]> preprocessFilterList(String string, String string2) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (string2.length() == 0) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "[]");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "|");
            String string4 = stringTokenizer2.nextToken();
            String string5 = stringTokenizer2.nextToken();
            String string6 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
            String string7 = string3 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
            if (string4.endsWith("CompoundFilter") || string4.endsWith("InverseFilter") || string4.endsWith("NamedFilter")) {
                arrayList.add(new String[]{string5, string6, string3});
                continue;
            }
            filterSettings.put(string5, string);
        }
        return arrayList;
    }
}

