/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pcgen.core.Ability;
import pcgen.core.AbilityInfo;
import pcgen.core.DamageReduction;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.Movement;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.QualifiedObject;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SourceEntry;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellSupport;
import pcgen.core.Variable;
import pcgen.core.Vision;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.AdvancedPanel;
import pcgen.gui.editor.AgePanel;
import pcgen.gui.editor.AppearancePanel;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.ClassAbilityPanel;
import pcgen.gui.editor.ClassLevelPanel;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.EditorAddFilter;
import pcgen.gui.editor.EditorBasePanel;
import pcgen.gui.editor.LevelAbilitiesPanel;
import pcgen.gui.editor.MovementPanel;
import pcgen.gui.editor.NaturalAttacksPanel;
import pcgen.gui.editor.QualifiedAvailableSelectedPanel;
import pcgen.gui.editor.SourceFilesPanel;
import pcgen.gui.editor.SpellBasePanel2;
import pcgen.gui.editor.VisionPanel;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorMainForm
extends JDialog {
    static final long serialVersionUID = 608648521263089459L;
    private static final String[] qualifiers = new String[]{"(None)", "VARDEFINED"};
    private AgePanel pnlAge;
    private AppearancePanel pnlAppearance;
    private AvailableSelectedPanel pnlBonusLang;
    private AvailableSelectedPanel pnlClasses;
    private AvailableSelectedPanel pnlDomains;
    private AvailableSelectedPanel pnlFeats;
    private AvailableSelectedPanel pnlLanguages;
    private AvailableSelectedPanel pnlRaces;
    private AvailableSelectedPanel pnlSkills;
    private AvailableSelectedPanel pnlTemplates;
    private AvailableSelectedPanel pnlVFeats;
    private AvailableSelectedPanel pnlWeapons;
    private ClassAbilityPanel pnlClassAbility;
    private ClassLevelPanel pnlClassLevel;
    private EditorBasePanel pnlMainTab;
    private JButton btnCancel;
    private JButton btnSave;
    private AdvancedPanel pnlAdvanced;
    private JPanel pnlBase2;
    private JPanel pnlButtons;
    private JPanel pnlMainDialog;
    private JPanel pnlTabs;
    private JTabbedPane jTabbedPane1;
    private LevelAbilitiesPanel pnlLevelAbilities;
    private MovementPanel pnlMovement;
    private NaturalAttacksPanel pnlNaturalAttacks;
    private PObject thisPObject = null;
    private QualifiedAvailableSelectedPanel pnlFollowers;
    private QualifiedAvailableSelectedPanel pnlQClasses;
    private QualifiedAvailableSelectedPanel pnlQDomains;
    private QualifiedAvailableSelectedPanel pnlQSpells;
    private QualifiedAvailableSelectedPanel pnlSynergy;
    private SourceFilesPanel pnlFileTypes;
    private VisionPanel pnlVision;
    private boolean wasCancelled = true;
    private int editType = -1;

    public EditorMainForm(JFrame jFrame, PObject pObject, int n) throws Exception {
        super(jFrame);
        if (pObject == null) {
            throw new NullPointerException();
        }
        this.setModal(true);
        this.editType = n;
        this.thisPObject = pObject;
        this.initComponents();
        this.initComponentContents();
        this.setLocationRelativeTo(jFrame);
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private static void addVariables(List<String> list, Collection collection) {
        for (Object e : collection) {
            if (e instanceof PObject) {
                PObject pObject = (PObject)e;
                Iterator<Variable> iterator = pObject.getVariableIterator();
                while (iterator.hasNext()) {
                    Variable variable = iterator.next();
                    if (variable.getUpperName().startsWith("LOCK.") || list.contains(variable.getName())) continue;
                    list.add(variable.getName());
                }
                continue;
            }
            Logging.errorPrint(PropertyFactory.getString("in_demEr1") + ": " + e.getClass().getName());
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void cmbQualifierItemStateChanged() {
        String string = (String)this.pnlFollowers.getQualifierSelectedItem();
        if (string != null && !"(None)".equalsIgnoreCase(string)) {
            this.pnlFollowers.setVariableEnabled(true);
        } else {
            this.pnlFollowers.setVariableEnabled(false);
        }
    }

    private static String decodeDomainEntry(String string) {
        int n = string.indexOf(61);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String decodeFollowerEntry(String string) {
        int n = -1;
        if (string.indexOf(91) >= 0) {
            String string2;
            for (int i = 0; i < this.pnlFollowers.getQualifierItemCount() && (n = string.indexOf(string2 = " [" + (String)this.pnlFollowers.getQualifierItemAt(i) + ":")) < 0; ++i) {
            }
        }
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String decodeSynergyEntry(String string) {
        int n = -1;
        if (string.indexOf(61) >= 0) {
            String string2;
            for (int i = 0; i < this.pnlSynergy.getQualifierItemCount() && (n = string.indexOf(string2 = "=" + (String)this.pnlSynergy.getQualifierItemAt(i) + "=")) < 0; ++i) {
            }
        }
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String encodeDomainEntry(QualifiedAvailableSelectedPanel qualifiedAvailableSelectedPanel, String string) {
        String string2 = null;
        if (qualifiedAvailableSelectedPanel.getQualifierSelectedIndex() >= 0) {
            string2 = qualifiedAvailableSelectedPanel.getQualifierSelectedItem().toString();
        }
        return EditorMainForm.encodeDomainEntry(string, string2);
    }

    private static String encodeDomainEntry(String string, String string2) {
        if (string2 != null) {
            string = string + "=" + string2;
        }
        return string;
    }

    private String encodeSpellEntry(QualifiedAvailableSelectedPanel qualifiedAvailableSelectedPanel, String string) {
        String string2 = null;
        if (qualifiedAvailableSelectedPanel.getQualifierSelectedIndex() >= 0) {
            string2 = qualifiedAvailableSelectedPanel.getQualifierSelectedItem().toString();
        }
        return EditorMainForm.encodeSpellEntry(string, string2);
    }

    private static String encodeSpellEntry(String string, String string2) {
        if (string2 != null) {
            string = "Level " + string2 + "= " + string;
        }
        return string;
    }

    private static Spell decodeSpellEntry(String string) {
        int n = string.indexOf(61);
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        return Globals.getSpellKeyed(string);
    }

    private String encodeFollowerEntry(String string) {
        String string2 = null;
        String string3 = (String)this.pnlFollowers.getQualifierSelectedItem();
        if (string3 != null && !"(None)".equalsIgnoreCase(string3)) {
            string2 = " [" + string3 + ":" + (String)this.pnlFollowers.getVariableSelectedItem() + ']';
        }
        if (string2 != null) {
            string = string + string2;
        }
        return string;
    }

    private String encodeSynergyEntry(String string) {
        String string2 = null;
        String string3 = null;
        if (this.pnlSynergy.getQualifierSelectedIndex() >= 0) {
            string3 = this.pnlSynergy.getQualifierSelectedItem().toString();
            if (this.pnlSynergy.getVariableSelectedIndex() >= 0) {
                string2 = this.pnlSynergy.getVariableSelectedItem().toString();
            }
        }
        return EditorMainForm.encodeSynergyEntry(string, string3, string2);
    }

    private static String encodeSynergyEntry(String string, String string2, String string3) {
        if (string2 != null && string3 != null) {
            string = string + "=" + string2 + "=" + string3;
        }
        return string;
    }

    private void btnCancelActionPerformed() {
        this.wasCancelled = true;
        this.closeDialog();
    }

    private void btnSaveActionPerformed() {
        String string = this.pnlMainTab.getNameText();
        if (string.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demMes1"), "PCGen", MessageType.ERROR);
            return;
        }
        this.thisPObject.setName(string);
        try {
            this.copyDataToObject();
        }
        catch (Exception exception) {
            Logging.errorPrint("Failed to save custom object due to ", exception);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demSaveFailed"), "PCGen", MessageType.ERROR);
            return;
        }
        this.thisPObject.setTypeInfo("CUSTOM");
        this.wasCancelled = false;
        this.closeDialog();
    }

    private void copyDataToObject() {
        Object[] objectArray;
        Comparable<Object> comparable;
        Object object;
        String string = this.pnlMainTab.getSourceText();
        if (string.length() != 0) {
            object = this.thisPObject.getSourceEntry();
            ((SourceEntry)object).setPageNumber(string);
        }
        this.thisPObject.setNameIsPI(this.pnlMainTab.getProductIdentity());
        this.pnlMainTab.updateData(this.thisPObject);
        this.thisPObject.getBonusList().clear();
        this.thisPObject.clearVariableList();
        this.thisPObject.clearDR();
        this.thisPObject.clearPreReq();
        this.thisPObject.clearSpecialAbilityList();
        this.thisPObject.clearSRList();
        this.thisPObject.getSpellSupport().clearSpellList();
        this.thisPObject.clearAutoMap();
        object = this.thisPObject.getSpellSupport();
        switch (this.editType) {
            case 1: {
                int n;
                int n2;
                ArrayList<QualifiedObject<Domain>> arrayList;
                comparable = (Deity)this.thisPObject;
                if (this.pnlDomains.getAvailableList().length == 0) {
                    ((Deity)comparable).setDomainList(null);
                } else {
                    objectArray = this.pnlDomains.getSelectedList();
                    arrayList = new ArrayList();
                    Object[] objectArray2 = objectArray;
                    n2 = objectArray2.length;
                    for (n = 0; n < n2; ++n) {
                        Object object2 = objectArray2[n];
                        arrayList.add(new QualifiedObject<Domain>((Domain)object2));
                    }
                    ((Deity)comparable).setDomainList(arrayList);
                }
                objectArray = this.pnlFollowers.getSelectedList();
                arrayList = new StringBuffer(100);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = null;
                    string = (String)objectArray[i];
                    n = string.indexOf(" [VARDEFINED:");
                    if (n >= 0) {
                        string2 = string.substring(n + 1);
                        if (string2.endsWith("]")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        string2 = string2.replace(':', '=');
                        string = string.substring(0, n);
                    }
                    for (int j = 0; j < SettingsHandler.getGame().getUnmodifiableAlignmentList().size(); ++j) {
                        if (!string.equals(SettingsHandler.getGame().getLongAlignmentAtIndex(j))) continue;
                        if (string2 != null) {
                            ((StringBuffer)((Object)arrayList)).append(string2).append('=');
                        }
                        ((StringBuffer)((Object)arrayList)).append(j);
                        if (string2 == null) continue;
                        ((StringBuffer)((Object)arrayList)).append(']');
                    }
                }
                ((Deity)this.thisPObject).setFollowerAlignments(((StringBuffer)((Object)arrayList)).toString());
                objectArray = this.pnlRaces.getSelectedList();
                ArrayList<String> arrayList2 = new ArrayList<String>(objectArray.length);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    arrayList2.add(((Race)objectArray[n2]).getKeyName());
                }
                ((Deity)this.thisPObject).setRacePantheonList(arrayList2);
                break;
            }
            case 2: {
                ((Domain)this.thisPObject).addFeat(".CLEAR");
                objectArray = this.pnlFeats.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                ((Domain)this.thisPObject).addFeat(string);
                objectArray = this.pnlQSpells.getSelectedList();
                if (this.thisPObject.isNewItem()) {
                    this.thisPObject.setNewItem(false);
                }
                ((SpellSupport)object).clearSpellLevelMap();
                this.thisPObject.getSpellSupport().clearSpellInfoMap();
                for (int i = 0; i < objectArray.length; ++i) {
                    string = objectArray[i].toString();
                    int n = string.indexOf(61);
                    String string3 = this.thisPObject.getKeyName();
                    if (n <= 0) continue;
                    String string4 = string.substring(n + 2);
                    String string5 = string.substring(n - 1, n);
                    ((SpellSupport)object).putLevel("DOMAIN", string3, string4, string5);
                    ((SpellSupport)object).putInfo("DOMAIN", string4, string3, string5);
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Race race = (Race)this.thisPObject;
                Movement movement = Movement.getMovementFrom(this.pnlMovement.getMoveValues());
                movement.setMovementTypes(this.pnlMovement.getMoveTypes());
                race.setMovement(movement, -9);
                race.clearVisionList();
                List<Vision> list = this.pnlVision.getVision();
                for (Vision vision : list) {
                    race.addVision(vision);
                }
                race.setNaturalWeapons(this.pnlNaturalAttacks.getNaturalWeapons());
                this.pnlAppearance.updateData(this.thisPObject);
                this.pnlAge.updateData(this.thisPObject);
                race.addTemplate(".CLEAR");
                objectArray = this.pnlTemplates.getSelectedList();
                for (int i = 0; i < objectArray.length; ++i) {
                    race.addTemplate((String)objectArray[i]);
                }
                objectArray = this.pnlTemplates.getSelectedList2();
                string = EditUtil.delimitArray(objectArray, '|');
                if (string != null && string.length() > 0) {
                    race.addTemplate("CHOOSE:" + string);
                }
                objectArray = this.pnlClasses.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                race.setFavoredClass(string);
                objectArray = this.pnlLanguages.getSelectedList2();
                string = EditUtil.delimitArray(objectArray, '|');
                race.setChooseLanguageAutos(string);
                objectArray = this.pnlFeats.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                race.setFeatList(string);
                objectArray = this.pnlFeats.getSelectedList2();
                string = EditUtil.delimitArray(objectArray, '|');
                race.setMFeatList(string);
                race.setLanguageBonus(".CLEAR");
                objectArray = this.pnlBonusLang.getSelectedList();
                string = EditUtil.delimitArray(objectArray, ',');
                race.setLanguageBonus(string);
                break;
            }
            case 6: {
                Object object3;
                int n;
                objectArray = this.pnlSynergy.getSelectedList();
                for (n = 0; n < objectArray.length; ++n) {
                    StringTokenizer stringTokenizer = new StringTokenizer(objectArray[n].toString(), "=");
                    if (stringTokenizer.countTokens() == 3) {
                        String string6 = stringTokenizer.nextToken();
                        object3 = stringTokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer(50);
                        stringBuffer.append("SKILL|").append(this.thisPObject.getKeyName());
                        stringBuffer.append('|').append(stringTokenizer.nextToken());
                        stringBuffer.append("|PRESKILL:1,").append(string6).append('=').append((String)object3);
                        stringBuffer.append("|TYPE=Synergy.STACK");
                        this.thisPObject.addBonusList(stringBuffer.toString());
                        continue;
                    }
                    Logging.errorPrint("Synergy has invalid format: " + objectArray[n].toString());
                }
                ((Skill)this.thisPObject).getClassList().clear();
                objectArray = this.pnlClasses.getSelectedList2();
                for (n = 0; n < objectArray.length; ++n) {
                    ((Skill)this.thisPObject).addClassList('!' + objectArray[n].toString());
                }
                objectArray = this.pnlClasses.getSelectedList();
                for (n = 0; n < objectArray.length; ++n) {
                    ((Skill)this.thisPObject).addClassList(objectArray[n].toString());
                }
                break;
            }
            case 7: {
                int n;
                int n3;
                ((SpellBasePanel2)this.pnlBase2).updateData(this.thisPObject);
                ((Spell)this.thisPObject).clearLevelInfo("CLASS");
                ((Spell)this.thisPObject).clearLevelInfo("DOMAIN");
                objectArray = this.pnlQClasses.getSelectedList();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    string = objectArray[n3].toString();
                    n = string.indexOf(61);
                    if (n <= 0) continue;
                    ((Spell)this.thisPObject).setLevelInfo("CLASS|" + string.substring(0, n), string.substring(n + 1));
                }
                objectArray = this.pnlQDomains.getSelectedList();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    string = objectArray[n3].toString();
                    n = string.indexOf(61);
                    if (n <= 0) continue;
                    ((Spell)this.thisPObject).setLevelInfo("DOMAIN|" + string.substring(0, n), string.substring(n + 1));
                }
                break;
            }
            case 8: {
                int n;
                Object object4;
                PCTemplate pCTemplate = (PCTemplate)this.thisPObject;
                Movement movement = Movement.getMovementFrom(this.pnlMovement.getMoveValues());
                movement.setMoveRatesFlag(this.pnlMovement.getMoveRateType());
                pCTemplate.setMovement(movement, -9);
                pCTemplate.clearVisionList();
                Object object3 = this.pnlVision.getVision();
                Iterator<Vision> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object4 = iterator.next();
                    pCTemplate.addVision((Vision)object4);
                }
                pCTemplate.addTemplate(".CLEAR");
                objectArray = this.pnlTemplates.getSelectedList();
                for (n = 0; n < objectArray.length; ++n) {
                    pCTemplate.addTemplate((String)objectArray[n]);
                }
                objectArray = this.pnlTemplates.getSelectedList2();
                string = EditUtil.delimitArray(objectArray, '|');
                if (string != null && string.length() > 0) {
                    pCTemplate.addTemplate("CHOOSE:" + string);
                }
                objectArray = this.pnlClasses.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                pCTemplate.setFavoredClass(string);
                objectArray = this.pnlLanguages.getSelectedList2();
                string = EditUtil.delimitArray(objectArray, '|');
                pCTemplate.setChooseLanguageAutos(string);
                pCTemplate.addFeatString(".CLEAR");
                objectArray = this.pnlFeats.getSelectedList();
                string = EditUtil.delimitArray(objectArray, '|');
                pCTemplate.addFeatString(string);
                pCTemplate.setLanguageBonus(".CLEAR");
                objectArray = this.pnlBonusLang.getSelectedList();
                string = EditUtil.delimitArray(objectArray, ',');
                pCTemplate.setLanguageBonus(string);
                pCTemplate.clearHitDiceStrings();
                pCTemplate.clearLevelAbilities();
                objectArray = this.pnlLevelAbilities.getSelectedList();
                for (n = 0; n < objectArray.length; ++n) {
                    int n4;
                    string = (String)objectArray[n];
                    if (string.startsWith("HD:")) {
                        pCTemplate.addHitDiceString(string.substring(3));
                        continue;
                    }
                    if (!string.startsWith("LEVEL:")) continue;
                    object4 = new StringTokenizer(string, ":");
                    ((StringTokenizer)object4).nextToken();
                    String string7 = ((StringTokenizer)object4).nextToken();
                    try {
                        n4 = Integer.parseInt(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    String string8 = ((StringTokenizer)object4).nextToken();
                    pCTemplate.addLevelAbility(n4, string8, ((StringTokenizer)object4).nextToken());
                }
                break;
            }
            case 9: {
                this.pnlFileTypes.updateData(this.thisPObject);
                break;
            }
            case 0: {
                PCClass pCClass = (PCClass)this.thisPObject;
                pCClass.clearTemplates();
                pCClass.addUmult(".CLEAR");
                pCClass.clearFeatAutos();
                pCClass.addUdamList(".CLEAR");
                break;
            }
        }
        if (this.pnlLanguages != null) {
            this.thisPObject.clearLanguageAuto();
            objectArray = this.pnlLanguages.getSelectedList();
            for (int i = 0; i < objectArray.length; ++i) {
                this.thisPObject.addLanguageAuto(objectArray[i].toString());
            }
        }
        if (this.pnlWeapons != null) {
            int n;
            this.thisPObject.clearAutoTag("WEAPONPROF");
            objectArray = this.pnlWeapons.getSelectedList();
            comparable = new StringBuffer();
            for (n = 0; n < objectArray.length; ++n) {
                if (n > 0) {
                    ((StringBuffer)comparable).append('|');
                }
                ((StringBuffer)comparable).append((String)objectArray[n]);
            }
            this.thisPObject.addAutoArray("WEAPONPROF", ((StringBuffer)comparable).toString());
            objectArray = this.pnlWeapons.getSelectedList2();
            if (objectArray != null && (this.editType == 0 || this.editType == 5)) {
                for (n = 0; n < objectArray.length; ++n) {
                    this.thisPObject.addWeaponProfBonus((String)objectArray[n]);
                }
            }
        }
        if (this.pnlSkills != null) {
            int n;
            this.thisPObject.clearCSkills();
            objectArray = this.pnlSkills.getSelectedList();
            for (n = 0; n < objectArray.length; ++n) {
                this.thisPObject.addCSkill(objectArray[n].toString());
            }
            this.thisPObject.clearCcSkills();
            objectArray = this.pnlSkills.getSelectedList2();
            for (n = 0; n < objectArray.length; ++n) {
                this.thisPObject.addCcSkill(string);
            }
        }
        switch (this.editType) {
            case 1: {
                ((Deity)this.thisPObject).getPantheonList().clear();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                ((Skill)this.thisPObject).setChoiceString(null);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
        if (this.editType == 6) {
            ((Skill)this.thisPObject).setChoiceString(null);
        } else if (this.editType == 2 || this.editType == 3) {
            this.thisPObject.setChoiceString("");
        }
        if (this.editType != 2) {
            this.thisPObject.getSpellSupport().clearSpellLevelMap();
            this.thisPObject.getSpellSupport().clearSpellInfoMap();
        }
        objectArray = this.pnlAdvanced.getSelectedList();
        if (this.editType == 0) {
            this.pnlClassAbility.updateData(this.thisPObject);
            this.pnlClassLevel.updateData(this.thisPObject);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)objectArray[i];
            try {
                PObjectLoader.parseTag(this.thisPObject, string);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint(persistenceLayerException.getMessage() + " while parsing " + string, persistenceLayerException);
            }
            if (this.editType != 1 || !string.startsWith("PANTHEON:")) continue;
            ((Deity)this.thisPObject).addPantheon(string.substring(9));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initComponentContents() {
        StringTokenizer stringTokenizer;
        String string4;
        ArrayList<String> arrayList;
        Object object3;
        List<String> list;
        String[] stringArray;
        this.pnlMainTab.setNameText(this.thisPObject.getKeyName());
        this.pnlMainTab.setProductIdentity(this.thisPObject.getNameIsPI());
        this.pnlMainTab.setSourceText(this.thisPObject.getSourceEntry().getPageNumber());
        this.pnlMainTab.updateView(this.thisPObject);
        switch (this.editType) {
            case 0: {
                break;
            }
            case 1: {
                Object object4;
                stringArray = new ArrayList();
                list = new ArrayList();
                for (PCAlignment cloneable22 : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
                    if (!cloneable22.isValidForFollower()) continue;
                    stringArray.add(cloneable22.getKeyName());
                }
                object3 = ((Deity)this.thisPObject).getFollowerAlignments();
                this.parseAlignment((List<String>)stringArray, list, (String)object3, null);
                this.pnlFollowers.setAvailableList((List)stringArray, true);
                this.pnlFollowers.setSelectedList(list, true);
                ArrayList<Domain> i = new ArrayList<Domain>();
                ArrayList<Domain> arrayList2 = new ArrayList<Domain>();
                for (Domain domain : Globals.getDomainList()) {
                    if (((Deity)this.thisPObject).hasDomain(domain)) {
                        i.add(domain);
                        continue;
                    }
                    arrayList2.add(domain);
                }
                this.pnlDomains.setAvailableList(arrayList2, true);
                this.pnlDomains.setSelectedList(i, true);
                ArrayList<Race> arrayList3 = new ArrayList<Race>();
                ArrayList<Race> arrayList4 = new ArrayList<Race>();
                arrayList = ((Deity)this.thisPObject).getRacePantheonList();
                for (Race race : Globals.getAllRaces()) {
                    object4 = race.getKeyName();
                    if (((String)object4).equals("<none selected>")) continue;
                    if (arrayList.contains(object4)) {
                        arrayList3.add(race);
                        continue;
                    }
                    arrayList4.add(race);
                }
                this.pnlRaces.setAvailableList(arrayList4, true);
                this.pnlRaces.setSelectedList(arrayList3, true);
                break;
            }
            case 2: {
                Object object7;
                Object object2;
                ArrayList<String> arrayList5 = new ArrayList<String>();
                ArrayList<String> arrayList6 = new ArrayList<String>();
                Object object4 = Globals.getAbilityKeyIterator("FEAT");
                while (object4.hasNext()) {
                    object2 = (Ability)object4.next();
                    arrayList5.add(((PObject)object2).getKeyName());
                }
                object4 = ((Domain)this.thisPObject).getFeatIterator();
                while (object4.hasNext()) {
                    object2 = (AbilityInfo)object4.next();
                    string4 = ((AbilityInfo)object2).getKeyName();
                    if (arrayList6.contains(string4)) continue;
                    arrayList5.remove(string4);
                    arrayList6.add(string4);
                }
                this.pnlFeats.setAvailableList(arrayList5, true);
                this.pnlFeats.setSelectedList(arrayList6, true);
                object4 = new ArrayList();
                object2 = new ArrayList();
                SpellSupport spellSupport = this.thisPObject.getSpellSupport();
                if (this.thisPObject.isNewItem()) {
                    spellSupport.clearSpellInfoMap();
                    spellSupport.clearSpellLevelMap();
                    for (ArrayList<String> arrayList7 : Globals.getSpellMap().values()) {
                        if (!(arrayList7 instanceof Spell)) continue;
                        object4.add((Spell)((Object)arrayList7));
                    }
                } else {
                    object4 = new ArrayList<Spell>(Globals.getSpellMap().values().size());
                    for (ArrayList<String> arrayList7 : Globals.getSpellMap().values()) {
                        if (!(arrayList7 instanceof Spell)) continue;
                        object7 = ((Object)arrayList7).toString();
                        if (spellSupport.containsInfoFor("DOMAIN", (String)object7)) {
                            int n = spellSupport.getInfo((String)"DOMAIN", (String)object7).level;
                            object2.add(EditorMainForm.encodeSpellEntry(((Object)arrayList7).toString(), Integer.toString(n)));
                            continue;
                        }
                        object4.add((Spell)((Object)arrayList7));
                    }
                }
                Globals.sortPObjectList(object4);
                this.pnlQSpells.setAvailableList((List)object4, true);
                this.pnlQSpells.setSelectedList((List)object2, true);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Object object;
                Movement movement;
                Object object5;
                Cloneable cloneable;
                Object object6;
                ArrayList<String> arrayList7;
                Iterator<?> iterator = new ArrayList<String>();
                arrayList7 = new ArrayList<String>();
                Object object7 = new ArrayList<String>();
                for (PCTemplate pCTemplate : Globals.getTemplateList()) {
                    string4 = pCTemplate.getKeyName();
                    if (iterator.contains(string4)) continue;
                    iterator.add((String)string4);
                }
                EditorMainForm.moveGrantedTemplatesFromAvailableToSelected(((Race)this.thisPObject).getTemplateList(), arrayList7, object7, iterator);
                this.pnlTemplates.setAvailableList((List)((Object)iterator), true);
                this.pnlTemplates.setSelectedList(arrayList7, true);
                this.pnlTemplates.setSelectedList2((List)object7, true);
                ArrayList arrayList8 = new ArrayList();
                ArrayList arrayList9 = new ArrayList();
                for (PCClass pCClass : Globals.getClassList()) {
                    arrayList8.add(pCClass.getKeyName());
                }
                arrayList8.add("Any");
                string4 = ((Race)this.thisPObject).getFavoredClass();
                stringTokenizer = new StringTokenizer(string4, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    object6 = stringTokenizer.nextToken();
                    if (arrayList9.contains(object6)) continue;
                    int n = arrayList8.indexOf(object6);
                    if (n < 0) {
                        Logging.errorPrint("Unknown class: " + object6);
                        continue;
                    }
                    arrayList8.remove(n);
                    arrayList9.add(object6);
                }
                this.pnlClasses.setAvailableList(arrayList8, true);
                this.pnlClasses.setSelectedList(arrayList9, true);
                object6 = new ArrayList<String>();
                ArrayList arrayList10 = new ArrayList();
                ArrayList arrayList11 = new ArrayList();
                Object object8 = Globals.getAbilityKeyIterator("FEAT");
                while (object8.hasNext()) {
                    cloneable = (Ability)object8.next();
                    object6.add(((PObject)cloneable).getKeyName());
                }
                string4 = ((Race)this.thisPObject).getFeatList(null, false);
                stringTokenizer = new StringTokenizer(string4, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    object8 = stringTokenizer.nextToken();
                    if (arrayList10.contains(object8)) continue;
                    object6.remove(object8);
                    arrayList10.add(object8);
                }
                string4 = ((Race)this.thisPObject).getMFeatList();
                stringTokenizer = new StringTokenizer(string4, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    object8 = stringTokenizer.nextToken();
                    if (arrayList11.contains(object8)) continue;
                    object6.remove(object8);
                    arrayList11.add(object8);
                }
                this.pnlFeats.setAvailableList((List)object6, true);
                this.pnlFeats.setSelectedList(arrayList10, true);
                this.pnlFeats.setSelectedList2(arrayList11, true);
                object8 = new ArrayList<String>();
                cloneable = new ArrayList();
                Object object9 = Globals.getAbilityKeyIterator("FEAT");
                while (object9.hasNext()) {
                    Ability ability = (Ability)object9.next();
                    object8.add(ability.getKeyName());
                }
                for (Ability ability : ((Race)this.thisPObject).getVirtualFeatList()) {
                    object5 = ability.getKeyName();
                    if (cloneable.contains(object5)) continue;
                    object8.remove(object5);
                    cloneable.add(object5);
                }
                this.pnlVFeats.setAvailableList((List)object8, true);
                this.pnlVFeats.setSelectedList((List)((Object)cloneable), true);
                object9 = new ArrayList();
                ArrayList<Language> arrayList12 = new ArrayList<Language>();
                object5 = this.thisPObject.getLanguageBonus();
                for (Language language : Globals.getLanguageList()) {
                    if (object5.contains(language)) {
                        arrayList12.add(language);
                        continue;
                    }
                    object9.add(language);
                }
                this.pnlBonusLang.setAvailableList((List)object9, true);
                this.pnlBonusLang.setSelectedList(arrayList12, true);
                ArrayList<String> arrayList13 = new ArrayList();
                List<Movement> list2 = this.thisPObject.getMovements();
                if (list2 != null && !list2.isEmpty() && (movement = (Movement)list2.get(0)) != null && movement.getNumberOfMovementTypes() > 0) {
                    for (int i = 0; i < movement.getNumberOfMovementTypes(); ++i) {
                        object = MovementPanel.makeMoveString(movement.getMovementType(i), movement.getMovement(i), null, null);
                        arrayList13.add((String)object);
                    }
                }
                this.pnlMovement.setSelectedList(arrayList13);
                List<Vision> list3 = this.thisPObject.getVision();
                List<String> list4 = this.buildVisionValues(list3);
                this.pnlVision.setSelectedList(list4);
                List<Equipment> list5 = this.thisPObject.getNaturalWeapons();
                this.pnlNaturalAttacks.setSelectedList(list5);
                ArrayList<String> arrayList14 = new ArrayList<String>();
                ArrayList<String> arrayList15 = new ArrayList<String>();
                object = new ArrayList();
                for (Race race : Globals.getAllRaces()) {
                    String string2;
                    List<String> list6;
                    string4 = race.getRegionString();
                    if (string4 == null) {
                        string4 = "None";
                    }
                    if ((list6 = Globals.getBioSet().getTagForRace(string4, race.getKeyName(), "HAIR")) != null) {
                        for (String string3 : list6) {
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "|", false);
                            while (stringTokenizer2.hasMoreTokens()) {
                                string2 = stringTokenizer2.nextToken();
                                if (arrayList15.contains(string2)) continue;
                                arrayList15.add(string2);
                            }
                        }
                    }
                    if ((list6 = Globals.getBioSet().getTagForRace(string4, race.getKeyName(), "EYES")) != null) {
                        for (String string3 : list6) {
                            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, "|", false);
                            while (stringTokenizer3.hasMoreTokens()) {
                                string2 = stringTokenizer3.nextToken();
                                if (arrayList14.contains(string2)) continue;
                                arrayList14.add(string2);
                            }
                        }
                    }
                    if ((list6 = Globals.getBioSet().getTagForRace(string4, race.getKeyName(), "SKINTONE")) == null) continue;
                    for (String string3 : list6) {
                        StringTokenizer stringTokenizer4 = new StringTokenizer(string3, "|", false);
                        while (stringTokenizer4.hasMoreTokens()) {
                            string2 = stringTokenizer4.nextToken();
                            if (object.contains(string2)) continue;
                            object.add(string2);
                        }
                    }
                }
                this.pnlAppearance.setEyeColorAvailableList(arrayList14, true);
                this.pnlAppearance.setHairColorAvailableList(arrayList15, true);
                this.pnlAppearance.setSkinToneAvailableList((List)object, true);
                this.pnlAppearance.updateView(this.thisPObject);
                this.pnlAge.updateView(this.thisPObject);
                break;
            }
            case 6: {
                ArrayList<String> arrayList16 = new ArrayList<String>();
                ArrayList<String> arrayList17 = new ArrayList<String>();
                Iterator<String> iterator = new ArrayList<String>();
                for (PCClass pCClass : Globals.getClassList()) {
                    arrayList16.add(pCClass.getKeyName());
                }
                for (String string4 : ((Skill)this.thisPObject).getClassList()) {
                    boolean bl;
                    if (string4.length() <= 0) continue;
                    if (string4.charAt(0) == '!') {
                        string4 = string4.substring(1);
                        bl = true;
                    } else {
                        bl = false;
                    }
                    int n = arrayList16.indexOf(string4);
                    if (n < 0) {
                        Logging.errorPrint("Unknown class: " + string4);
                        continue;
                    }
                    arrayList16.remove(n);
                    if (bl) {
                        iterator.add(string4);
                        continue;
                    }
                    arrayList17.add(string4);
                }
                this.pnlClasses.setAvailableList(arrayList16, true);
                this.pnlClasses.setSelectedList(arrayList17, true);
                this.pnlClasses.setSelectedList2((List)((Object)iterator), true);
                this.pnlClasses.setLblSelectedText("Class Skill");
                this.pnlClasses.setLblSelected2Text("Not allowed");
                break;
            }
            case 7: {
                Serializable serializable;
                Object object11;
                ((SpellBasePanel2)this.pnlBase2).updateView(this.thisPObject);
                Map<String, Integer> map = ((Spell)this.thisPObject).getLevelInfo(null);
                int n = 0;
                ArrayList<String> arrayList18 = new ArrayList<String>();
                ArrayList<String> arrayList19 = new ArrayList<String>();
                for (Domain domain : Globals.getDomainList()) {
                    object11 = null;
                    if (map != null) {
                        object11 = map.get("DOMAIN|" + domain.getKeyName());
                    }
                    if (object11 != null) {
                        arrayList19.add(EditorMainForm.encodeDomainEntry(domain.getKeyName(), ((Integer)object11).toString()));
                        ++n;
                        continue;
                    }
                    arrayList18.add(domain.getKeyName());
                }
                this.pnlQDomains.setAvailableList(arrayList18, true);
                this.pnlQDomains.setSelectedList(arrayList19, true);
                ArrayList arrayList20 = new ArrayList();
                ArrayList<String> arrayList21 = new ArrayList<String>();
                for (PCClass pCClass : Globals.getClassList()) {
                    serializable = null;
                    if (map != null) {
                        serializable = map.get("CLASS|" + pCClass.getKeyName());
                    }
                    if (serializable != null) {
                        arrayList21.add(EditorMainForm.encodeDomainEntry(pCClass.getKeyName(), ((Integer)serializable).toString()));
                        ++n;
                        continue;
                    }
                    arrayList20.add(pCClass.getKeyName());
                }
                this.pnlQClasses.setAvailableList(arrayList20, true);
                this.pnlQClasses.setSelectedList(arrayList21, true);
                if (map == null || map.size() == n) break;
                Logging.errorPrint(Integer.toString(n) + " classes and domains found. Should have been " + Integer.toString(map.size()) + "\n" + map);
                break;
            }
            case 8: {
                ArrayList<Language> arrayList22;
                Object object;
                List<Movement> list7;
                Object object10;
                Object object11 = new ArrayList<String>();
                ArrayList<String> arrayList23 = new ArrayList<String>();
                Serializable serializable = new ArrayList<String>();
                for (PCTemplate pCTemplate : Globals.getTemplateList()) {
                    string4 = pCTemplate.getKeyName();
                    if (object11.contains(string4)) continue;
                    object11.add((String)string4);
                }
                EditorMainForm.moveGrantedTemplatesFromAvailableToSelected(((PCTemplate)this.thisPObject).getTemplateList(), arrayList23, serializable, object11);
                this.pnlTemplates.setAvailableList((List)object11, true);
                this.pnlTemplates.setSelectedList(arrayList23, true);
                this.pnlTemplates.setSelectedList2((List)((Object)serializable), true);
                ArrayList arrayList24 = new ArrayList();
                ArrayList arrayList25 = new ArrayList();
                for (PCClass pCClass : Globals.getClassList()) {
                    arrayList24.add(pCClass.getKeyName());
                }
                arrayList24.add("Any");
                string4 = ((PCTemplate)this.thisPObject).getFavoredClass();
                stringTokenizer = new StringTokenizer(string4, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    object10 = stringTokenizer.nextToken();
                    if (arrayList25.contains(object10)) continue;
                    int n = arrayList24.indexOf(object10);
                    if (n < 0) {
                        Logging.errorPrint("Unknown class: " + object10);
                        continue;
                    }
                    arrayList24.remove(n);
                    arrayList25.add(object10);
                }
                this.pnlClasses.setAvailableList(arrayList24, true);
                this.pnlClasses.setSelectedList(arrayList25, true);
                object10 = new ArrayList<String>();
                ArrayList<String> arrayList26 = new ArrayList<String>();
                Object object12 = Globals.getAbilityKeyIterator("FEAT");
                while (object12.hasNext()) {
                    list7 = (Ability)object12.next();
                    object10.add(((PObject)((Object)list7)).getKeyName());
                }
                object12 = ((PCTemplate)this.thisPObject).feats(-1, -1, null, false);
                list7 = object12.iterator();
                while (list7.hasNext()) {
                    string4 = (String)list7.next();
                    if (arrayList26.contains(string4)) continue;
                    object10.remove(string4);
                    arrayList26.add(string4);
                }
                this.pnlFeats.setAvailableList((List)object10, true);
                this.pnlFeats.setSelectedList(arrayList26, true);
                ArrayList<String> arrayList13 = new ArrayList<String>();
                list7 = this.thisPObject.getMovements();
                if (list7 != null && !list7.isEmpty() && (object = list7.get(0)) != null && ((Movement)object).getNumberOfMovementTypes() > 0) {
                    for (int i = 0; i < ((Movement)object).getNumberOfMovementTypes(); ++i) {
                        arrayList22 = MovementPanel.makeMoveString(((Movement)object).getMovementType(i), ((Movement)object).getMovement(i), ((Movement)object).getMovementMult(i), ((Movement)object).getMovementMultOp(i));
                        arrayList13.add((String)((Object)arrayList22));
                    }
                    this.pnlMovement.setMoveRateType(((Movement)object).getMoveRatesFlag());
                }
                this.pnlMovement.setSelectedList(arrayList13);
                List<Vision> list3 = this.thisPObject.getVision();
                List<String> list4 = this.buildVisionValues(list3);
                this.pnlVision.setSelectedList(list4);
                object = new ArrayList();
                object.addAll(((PCTemplate)this.thisPObject).getLevelAbilities());
                List<String> list8 = ((PCTemplate)this.thisPObject).getHitDiceStrings();
                if (list8 != null) {
                    for (String string4 : list8) {
                        object.add("HD:" + string4);
                    }
                }
                this.pnlLevelAbilities.setSelectedList((List)object);
                arrayList22 = new ArrayList<Language>();
                ArrayList<Language> arrayList27 = new ArrayList<Language>();
                Set<Language> set = ((PCTemplate)this.thisPObject).getLanguageBonus();
                for (Language language : Globals.getLanguageList()) {
                    if (set.contains(language)) {
                        arrayList27.add(language);
                        continue;
                    }
                    arrayList22.add(language);
                }
                this.pnlBonusLang.setAvailableList(arrayList22, true);
                this.pnlBonusLang.setSelectedList(arrayList27, true);
                break;
            }
            case 9: {
                this.pnlFileTypes.updateView(this.thisPObject);
                break;
            }
        }
        if (this.pnlLanguages != null) {
            stringArray = new ArrayList();
            list = new ArrayList();
            object3 = new ArrayList();
            List<Language> list9 = this.thisPObject.getSafeListFor(ListKey.AUTO_LANGUAGES);
            for (Language language : Globals.getLanguageList()) {
                if (list9.contains(language)) {
                    list.add((String)((Object)language));
                    continue;
                }
                stringArray.add((String)((Object)language));
            }
            if (this.editType == 8 || this.editType == 5) {
                string4 = this.editType == 8 ? ((PCTemplate)this.thisPObject).getChooseLanguageAutos() : ((Race)this.thisPObject).getChooseLanguageAutos();
                stringTokenizer = new StringTokenizer(string4, "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    Language language = Globals.getLanguageKeyed(stringTokenizer.nextToken());
                    if (language == null) continue;
                    object3.add(language);
                    stringArray.remove(language);
                }
                this.pnlLanguages.setSelectedList2((List)object3, true);
            }
            this.pnlLanguages.setAvailableList((List)stringArray, true);
            this.pnlLanguages.setSelectedList(list, true);
        }
        if (this.pnlWeapons != null) {
            void var14_55;
            void var12_22;
            stringArray = new ArrayList();
            list = Globals.getWeaponProfNames("|", false);
            object3 = ((String)((Object)list)).split("\\|");
            ArrayList<String> arrayList28 = new ArrayList<String>();
            boolean bl = false;
            while (var12_22 < ((Object)object3).length) {
                arrayList28.add((String)object3[var12_22]);
                ++var12_22;
            }
            Set<String> set = Globals.getWeaponProfTypes();
            for (String string5 : set) {
                arrayList28.add("TYPE." + string5.toUpperCase());
            }
            ArrayList arrayList29 = new ArrayList();
            this.thisPObject.addAutoTagsToList("WEAPONPROF", arrayList29, null, false);
            Iterator iterator = arrayList29.iterator();
            while (iterator.hasNext()) {
                this.moveProfToSelectedList(arrayList28, (List<String>)stringArray, (String)iterator.next());
            }
            Object var14_51 = null;
            if (this.editType == 0) {
                Iterator<String> iterator2 = ((PCClass)this.thisPObject).getWeaponProfBonus().iterator();
            } else if (this.editType == 5) {
                Iterator<String> iterator3 = ((Race)this.thisPObject).getWeaponProfBonus().iterator();
            } else {
                Object var14_54 = null;
            }
            if (var14_55 != null) {
                arrayList = new ArrayList();
                while (var14_55.hasNext()) {
                    this.moveProfToSelectedList(arrayList28, arrayList, (String)var14_55.next());
                }
                this.pnlWeapons.setSelectedList2(arrayList, true);
                this.pnlWeapons.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlWeapons.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
            }
            this.pnlWeapons.setAvailableList(arrayList28, true);
            this.pnlWeapons.setSelectedList((List)stringArray, true);
        }
        switch (this.editType) {
            case 1: {
                this.pnlFollowers.setQualifierModel(new DefaultComboBoxModel<String>(qualifiers));
                list = new ArrayList();
                EditorMainForm.addVariables(list, Globals.getClassList());
                EditorMainForm.addVariables(list, Globals.getUnmodifiableAbilityList("FEAT"));
                EditorMainForm.addVariables(list, Globals.getAllRaces());
                EditorMainForm.addVariables(list, Globals.getSkillList());
                EditorMainForm.addVariables(list, EquipmentList.getModifierCollection());
                EditorMainForm.addVariables(list, Globals.getTemplateList());
                EditorMainForm.addVariables(list, Globals.getAllCompanionMods());
                Collections.sort(list);
                this.pnlFollowers.setVariableModel(new DefaultComboBoxModel<Object>(list.toArray()));
                break;
            }
            case 2: {
                void var11_11;
                object3 = new ArrayList();
                boolean bl = true;
                while (var11_11 <= 9) {
                    object3.add(String.valueOf((int)var11_11));
                    ++var11_11;
                }
                this.pnlQSpells.setQualifierModel(new DefaultComboBoxModel<Object>(object3.toArray()));
                this.pnlQSpells.setQualifierSelectedIndex(0);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                void var13_42;
                ArrayList<String> arrayList30 = new ArrayList<String>();
                ArrayList<String> arrayList31 = new ArrayList<String>();
                for (Skill skill : Globals.getSkillList()) {
                    if (skill.getKeyName().equals(this.thisPObject.getKeyName())) continue;
                    arrayList30.add(skill.getKeyName());
                }
                Iterator<BonusObj> iterator = this.thisPObject.getBonusList().iterator();
                while (iterator.hasNext()) {
                    EditorMainForm.parseSynergyBonus(iterator.next(), arrayList30, arrayList31);
                }
                this.pnlSynergy.setAvailableList(arrayList30, true);
                this.pnlSynergy.setSelectedList(arrayList31, true);
                stringArray = new String[30];
                boolean bl = false;
                while (var13_42 < stringArray.length) {
                    stringArray[var13_42] = String.valueOf((int)(var13_42 + true));
                    ++var13_42;
                }
                this.pnlSynergy.setQualifierModel(new DefaultComboBoxModel<String>(stringArray));
                this.pnlSynergy.setVariableModel(new DefaultComboBoxModel<String>(stringArray));
                this.pnlSynergy.setQualifierSelectedIndex(4);
                this.pnlSynergy.setVariableSelectedIndex(1);
                break;
            }
            case 7: {
                void var14_60;
                ArrayList<String> arrayList32 = new ArrayList<String>();
                boolean bl = true;
                while (var14_60 <= 9) {
                    arrayList32.add(String.valueOf((int)var14_60));
                    ++var14_60;
                }
                this.pnlQDomains.setQualifierModel(new DefaultComboBoxModel<Object>(arrayList32.toArray()));
                this.pnlQDomains.setQualifierSelectedIndex(0);
                arrayList32.add(0, "0");
                this.pnlQClasses.setQualifierModel(new DefaultComboBoxModel<Object>(arrayList32.toArray()));
                this.pnlQClasses.setQualifierSelectedIndex(0);
                break;
            }
            case 8: {
                break;
            }
        }
        if (this.pnlSkills != null) {
            list = new ArrayList<String>();
            object3 = new ArrayList();
            for (Skill skill : Globals.getSkillList()) {
                string4 = skill.getKeyName();
                if (!list.contains(string4)) {
                    list.add(string4);
                }
                for (String string6 : skill.getTypeList(false)) {
                    string4 = "TYPE." + string6;
                    if (list.contains(string4)) continue;
                    list.add(string4);
                }
            }
            List<String> list9 = this.thisPObject.getCSkillList();
            if (list9 != null) {
                for (String string4 : list9) {
                    object3.add(string4);
                    if (!list.contains(string4)) continue;
                    list.remove(string4);
                }
            }
            this.pnlSkills.setSelectedList((List)object3, true);
            ArrayList<String> arrayList33 = new ArrayList<String>();
            List<String> list10 = this.thisPObject.getCcSkillList();
            if (list10 != null) {
                for (String string4 : list10) {
                    arrayList33.add(string4);
                    if (!list.contains(string4)) continue;
                    list.remove(string4);
                }
            }
            this.pnlSkills.setSelectedList2(arrayList33, true);
            this.pnlSkills.setAvailableList(list, true);
        }
        this.pnlAdvanced.setAvailableTagList(this.editType);
        list = this.buildAdvancedSelectedList(this.editType);
        this.pnlAdvanced.setSelected(list);
    }

    private List<String> buildVisionValues(List<Vision> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (Vision vision : list) {
                StringBuffer stringBuffer = new StringBuffer(25);
                stringBuffer.append(vision.getType());
                stringBuffer.append(',').append(vision.getDistance());
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList;
    }

    private void moveProfToSelectedList(List<String> list, List<String> list2, String string) {
        if (string.startsWith("TYPE")) {
            list2.add(string);
            list.remove(string.toUpperCase());
        } else {
            WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
            if (weaponProf != null) {
                list2.add(weaponProf.toString());
                list.remove(weaponProf.toString());
            }
        }
    }

    private static void moveGrantedTemplatesFromAvailableToSelected(List<String> list, List<String> list2, List<String> list3, List<String> list4) {
        for (String string : list) {
            if (string.startsWith("CHOOSE:")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(7), "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (list2.contains(string2)) continue;
                    list3.add(string2);
                }
                continue;
            }
            list2.add(string);
            list4.remove(string);
        }
    }

    private void initComponents() {
        this.btnCancel = new JButton();
        this.btnSave = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlAdvanced = new AdvancedPanel(this.thisPObject);
        this.pnlButtons = new JPanel();
        this.pnlMainDialog = new JPanel();
        this.pnlTabs = new JPanel();
        switch (this.editType) {
            case 0: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel(true);
                this.pnlClassAbility = new ClassAbilityPanel();
                this.pnlClassAbility.updateView(this.thisPObject);
                this.pnlClassLevel = new ClassLevelPanel();
                this.pnlClassLevel.updateView(this.thisPObject);
                break;
            }
            case 1: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlDomains = new AvailableSelectedPanel();
                this.pnlFollowers = new QualifiedAvailableSelectedPanel("in_demQualifier", "in_demVariable", new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeFollowerEntry((String)object);
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.this.decodeFollowerEntry((String)object);
                    }
                }, new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        EditorMainForm.this.cmbQualifierItemStateChanged();
                    }
                });
                this.pnlRaces = new AvailableSelectedPanel();
                break;
            }
            case 2: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlQSpells = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeSpellEntry(EditorMainForm.this.pnlQSpells, object.toString());
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.decodeSpellEntry(object.toString());
                    }
                }, null);
                break;
            }
            case 3: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.pnlMovement = new MovementPanel(true);
                this.pnlVision = new VisionPanel();
                this.pnlNaturalAttacks = new NaturalAttacksPanel();
                this.pnlLanguages = new AvailableSelectedPanel(true);
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlTemplates = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel(true);
                this.pnlClasses = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel(true);
                this.pnlVFeats = new AvailableSelectedPanel();
                this.pnlBonusLang = new AvailableSelectedPanel();
                this.pnlAppearance = new AppearancePanel();
                this.pnlAge = new AgePanel();
                break;
            }
            case 6: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlClasses = new AvailableSelectedPanel(true);
                this.pnlSynergy = new QualifiedAvailableSelectedPanel("in_demSkillRank", "in_demSynergyBonus", new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeSynergyEntry((String)object);
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.this.decodeSynergyEntry((String)object);
                    }
                }, null);
                break;
            }
            case 7: {
                this.pnlBase2 = new SpellBasePanel2();
                this.pnlQClasses = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeDomainEntry(EditorMainForm.this.pnlQClasses, (String)object);
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.decodeDomainEntry((String)object);
                    }
                }, null);
                this.pnlQDomains = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object object) {
                        return EditorMainForm.this.encodeDomainEntry(EditorMainForm.this.pnlQDomains, (String)object);
                    }

                    public Object decode(Object object) {
                        return EditorMainForm.decodeDomainEntry((String)object);
                    }
                }, null);
                break;
            }
            case 8: {
                this.pnlVision = new VisionPanel();
                this.pnlMovement = new MovementPanel(false);
                this.pnlLevelAbilities = new LevelAbilitiesPanel();
                this.pnlLanguages = new AvailableSelectedPanel(true);
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlTemplates = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlClasses = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel();
                this.pnlBonusLang = new AvailableSelectedPanel();
                break;
            }
            case 9: {
                this.pnlFileTypes = new SourceFilesPanel();
                break;
            }
        }
        this.getContentPane().setLayout(new GridBagLayout());
        String string = "";
        switch (this.editType) {
            case 0: {
                string = "Class";
                break;
            }
            case 1: {
                string = "Deity";
                break;
            }
            case 2: {
                string = "Domain";
                break;
            }
            case 3: {
                string = "Feat";
                break;
            }
            case 4: {
                string = "Language";
                break;
            }
            case 5: {
                string = "Race";
                break;
            }
            case 6: {
                string = "Skill";
                break;
            }
            case 7: {
                string = "Spell";
                break;
            }
            case 8: {
                string = "Template";
                break;
            }
        }
        this.setTitle(PropertyFactory.getString("in_demTitle" + string));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EditorMainForm.this.wasCancelled = true;
                EditorMainForm.this.closeDialog();
            }
        });
        this.pnlMainDialog.setLayout(new GridBagLayout());
        this.pnlMainDialog.setPreferredSize(new Dimension(640, 460));
        this.pnlTabs.setLayout(new BorderLayout());
        this.pnlTabs.setMinimumSize(new Dimension(128, 88));
        this.pnlTabs.setPreferredSize(new Dimension(640, 440));
        this.jTabbedPane1.setName(PropertyFactory.getString("in_demDeitytab"));
        this.pnlMainTab = new EditorBasePanel(this.editType);
        this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBase"), this.pnlMainTab);
        switch (this.editType) {
            case 0: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_classability"), this.pnlClassAbility);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_classlevel"), this.pnlClassLevel);
                break;
            }
            case 1: {
                this.pnlDomains.setHeader(PropertyFactory.getString("in_demGrantDom"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_domains"), this.pnlDomains);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demFollowers"), this.pnlFollowers);
                this.pnlRaces.setHeader(PropertyFactory.getString("in_demRacWors"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_race"), this.pnlRaces);
                break;
            }
            case 2: {
                this.jTabbedPane1.addTab("Spell Lists", this.pnlQSpells);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.pnlClasses.setHeader(PropertyFactory.getString("in_demFavoredClasses"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                this.pnlTemplates.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlTemplates.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlLanguages.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlLanguages.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlBonusLang.setHeader(PropertyFactory.getString("in_demBonusLang"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBonusLangAbbrev"), this.pnlBonusLang);
                this.pnlFeats.setLblSelectedText(PropertyFactory.getString("in_demSelFeats"));
                this.pnlFeats.setLblSelected2Text(PropertyFactory.getString("in_demSelMFeats"));
                break;
            }
            case 6: {
                this.pnlSynergy.setHeader(" ");
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demSynergy"), this.pnlSynergy);
                this.pnlClasses.setHeader(" ");
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                break;
            }
            case 7: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBase2"), this.pnlBase2);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlQClasses);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_domains"), this.pnlQDomains);
                break;
            }
            case 8: {
                this.pnlClasses.setHeader(PropertyFactory.getString("in_demFavoredClasses"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                this.pnlTemplates.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlTemplates.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlLanguages.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlLanguages.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlBonusLang.setHeader(PropertyFactory.getString("in_demBonusLang"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBonusLangAbbrev"), this.pnlBonusLang);
                break;
            }
            case 9: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_fileTypes"), this.pnlFileTypes);
                break;
            }
        }
        if (this.pnlLanguages != null) {
            this.pnlLanguages.setHeader(PropertyFactory.getString("in_demGrantLang"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_languages"), this.pnlLanguages);
        }
        if (this.pnlWeapons != null) {
            this.pnlWeapons.setHeader(PropertyFactory.getString("in_demGraWeaPro"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_weapon"), this.pnlWeapons);
        }
        if (this.pnlSkills != null) {
            this.pnlSkills.setHeader(PropertyFactory.getString("in_demGraSkil"));
            this.pnlSkills.setLblSelectedText(PropertyFactory.getString("in_demSelClaSkil"));
            this.pnlSkills.setLblSelected2Text(PropertyFactory.getString("in_demSelCroCla"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_skills"), this.pnlSkills);
        }
        if (this.pnlLevelAbilities != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_specialabilities"), this.pnlLevelAbilities);
        }
        if (this.pnlMovement != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_movement"), this.pnlMovement);
        }
        if (this.pnlTemplates != null) {
            this.pnlTemplates.setHeader(PropertyFactory.getString("in_demGraTemp"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_templates"), this.pnlTemplates);
        }
        if (this.pnlVision != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demVision"), this.pnlVision);
        }
        if (this.pnlAge != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAge"), this.pnlAge);
        }
        if (this.pnlAppearance != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAppearance"), this.pnlAppearance);
        }
        if (this.pnlNaturalAttacks != null) {
            this.jTabbedPane1.addTab("Natural Weapons", this.pnlNaturalAttacks);
        }
        if (this.pnlFeats != null) {
            this.pnlFeats.setHeader(PropertyFactory.getString("in_demGraFeat"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_feats"), this.pnlFeats);
        }
        if (this.pnlVFeats != null) {
            this.pnlVFeats.setHeader(PropertyFactory.getString("in_demGraVFeat"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demVFeats"), this.pnlVFeats);
        }
        if (this.editType != 9) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAdv"), this.pnlAdvanced);
        }
        this.pnlTabs.add((Component)this.jTabbedPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 6.0;
        this.pnlMainDialog.add((Component)this.pnlTabs, gridBagConstraints);
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.btnCancel.setMnemonic(PropertyFactory.getMnemonic("in_mn_cancel"));
        this.btnCancel.setText(PropertyFactory.getString("in_cancel"));
        this.btnCancel.setPreferredSize(new Dimension(80, 26));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorMainForm.this.btnCancelActionPerformed();
            }
        });
        this.pnlButtons.add(this.btnCancel);
        this.btnSave.setMnemonic(PropertyFactory.getMnemonic("in_mn_save"));
        this.btnSave.setText(PropertyFactory.getString("in_save"));
        this.btnSave.setPreferredSize(new Dimension(80, 26));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorMainForm.this.btnSaveActionPerformed();
            }
        });
        this.pnlButtons.add(this.btnSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlMainDialog.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlMainDialog, gridBagConstraints);
        this.pack();
    }

    private void parseAlignment(List<String> list, List<String> list2, String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            if (c == '[') {
                n = string.indexOf(93, i);
                if (n < 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(i + 1, n), "=", false);
                if (stringTokenizer.countTokens() == 3) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    this.parseAlignment(list, list2, stringTokenizer.nextToken(), " [" + string3 + ":" + string4 + ']');
                }
                i = n;
                continue;
            }
            if (c < '0' || c > '9') continue;
            n = c - 48;
            list.remove(SettingsHandler.getGame().getLongAlignmentAtIndex(n));
            list2.add(SettingsHandler.getGame().getLongAlignmentAtIndex(n) + (string2 == null ? "" : string2));
        }
    }

    private static boolean parseSynergyBonus(BonusObj bonusObj, List<String> list, List<String> list2) {
        List<String> list3;
        String string = bonusObj.toString();
        if (string.startsWith("SKILL|") && (list3 = CoreUtility.split(string, '|')).size() == 5 && list3.get(3).startsWith("PRESKILL:1,") && list3.get(4).equalsIgnoreCase("TYPE=Synergy.STACK")) {
            String string2 = list3.get(2);
            String string3 = list3.get(3).substring(11);
            int n = string3.indexOf(61);
            if (n > 0) {
                String string4 = string3.substring(n + 1);
                string3 = string3.substring(0, n);
                if (list != null) {
                    list.remove(string3);
                }
                if (list2 != null) {
                    list2.add(EditorMainForm.encodeSynergyEntry(string3, string4, string2));
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    List<String> buildAdvancedSelectedList(int n) {
        String string;
        List<PCSpell> list;
        List<SpecialAbility> list2;
        Object object2;
        Iterator<String> iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.clear();
        switch (n) {
            case 1: {
                iterator = ((Deity)this.thisPObject).getPantheonList().iterator();
                while (iterator.hasNext()) {
                    arrayList.add("PANTHEON:" + iterator.next());
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.thisPObject.getChoiceString().length() == 0) break;
                arrayList.add("CHOOSE:" + this.thisPObject.getChoiceString());
                break;
            }
            case 6: {
                iterator = this.thisPObject.getChoiceString();
                if (iterator == null || ((String)((Object)iterator)).length() <= 0) break;
                arrayList.add("CHOOSE:" + iterator);
                break;
            }
        }
        iterator = this.thisPObject.getAutoMapKeys();
        if (iterator != null) {
            Iterator<Object> iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                String object3 = (String)iterator2.next();
                if (object3.equalsIgnoreCase("WEAPONPROF")) continue;
                arrayList.add("AUTO:" + object3 + "|" + this.thisPObject.getAuto(object3));
            }
        }
        if (n != 0) {
            for (BonusObj bonusObj : this.thisPObject.getBonusList()) {
                if (EditorMainForm.parseSynergyBonus(bonusObj, null, null)) continue;
                arrayList.add("BONUS:" + bonusObj.getPCCText());
            }
        }
        if (this.thisPObject.hasPreReqs()) {
            for (Prerequisite prerequisite : this.thisPObject.getPreReqList()) {
                StringWriter stringWriter = new StringWriter();
                object2 = new PrerequisiteWriter();
                try {
                    ((PrerequisiteWriter)object2).write(stringWriter, prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    persistenceLayerException.printStackTrace();
                }
                arrayList.add(stringWriter.toString());
            }
        }
        if (n != 0) {
            int n2 = this.thisPObject.getVariableCount();
            for (int i = 0; i < n2; ++i) {
                void var6_19;
                String string2 = this.thisPObject.getVariableDefinition(i);
                if (string2.startsWith("-9|")) {
                    String string3 = string2.substring(3);
                }
                arrayList.add("DEFINE:" + (String)var6_19);
            }
        }
        if ((list2 = this.thisPObject.getListFor(ListKey.SPECIAL_ABILITY)) != null && list2.size() != 0 && n != 0) {
            for (SpecialAbility specialAbility : list2) {
                object2 = specialAbility.getSASource();
                String string4 = ((String)object2).substring(((String)object2).indexOf("|") + 1);
                String string5 = specialAbility.toString();
                if (string4.length() > 0) {
                    string4 = string4 + "|";
                }
                arrayList.add("SA:" + string4 + string5);
            }
            list2.clear();
        }
        List<DamageReduction> list3 = this.thisPObject.getDRList();
        for (Object object2 : list3) {
            boolean bl = false;
            if (n == 0) {
                bl = ((DamageReduction)object2).isForClassLevel(this.thisPObject.getKeyName());
            }
            if (bl) continue;
            arrayList.add(((DamageReduction)object2).getPCCText(true));
        }
        if (n != 0 && (list = this.thisPObject.getSpellList()) != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                arrayList.add("SPELLS:" + ((PCSpell)object2.next()).getPCCText());
            }
        }
        if ((string = this.thisPObject.getSRFormula()) != null) {
            arrayList.add("SR:" + string);
        }
        if (n != 2) {
            object2 = this.thisPObject.getSpellSupport().getPCCText();
            arrayList.addAll(Arrays.asList(((String)object2).split("\t")));
        }
        return arrayList;
    }
}

