/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.DoubleKeyMap;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassBasePanel
extends BasePanel {
    private JCheckBox chkVisible;
    private JCheckBox hasSubClass;
    private JCheckBox modToSkills;
    private JCheckBox multiPreReq;
    private JTextField abbreviation;
    private JTextField exClass;
    private JTextField exchangeLevel;
    private JTextField qualify;
    private JTextField startSkillPoints;
    private JTextField txtDisplayName;
    private TypePanel pnlTemplateTypes;

    public ClassBasePanel() {
        this.initComponents();
    }

    public void setTypesAvailableList(List<String> list, boolean bl) {
        this.pnlTemplateTypes.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<String> list, boolean bl) {
        this.pnlTemplateTypes.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    @Override
    public void updateData(PObject pObject) {
        if (!(pObject instanceof PCClass)) {
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        pCClass.setOutputName(this.txtDisplayName.getText().trim());
        pCClass.setAbbrev(this.abbreviation.getText().trim());
        pCClass.setLevelExchange(this.exchangeLevel.getText().trim());
        pCClass.setSkillPointFormula(this.startSkillPoints.getText().trim());
        GlobalLstToken globalLstToken = (GlobalLstToken)TokenStore.inst().getTokenMap(GlobalLstToken.class).get("QUALIFY");
        try {
            globalLstToken.parse(pCClass, this.qualify.getText(), -9);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Invalid QUALIFY: " + this.qualify.getText(), persistenceLayerException);
        }
        pCClass.setExClass(this.exClass.getText().trim());
        pCClass.setHasSubClass(this.hasSubClass.getSelectedObjects() != null);
        pCClass.setModToSkills(this.modToSkills.getSelectedObjects() != null);
        pCClass.setMultiPreReqs(this.multiPreReq.getSelectedObjects() != null);
        pCClass.setVisibility(this.chkVisible.getSelectedObjects() == null ? Visibility.HIDDEN : Visibility.DEFAULT);
        Object[] objectArray = this.getTypesSelectedList();
        pObject.setTypeInfo(".CLEAR");
        for (int i = 0; i < objectArray.length; ++i) {
            pObject.setTypeInfo(objectArray[i].toString());
        }
    }

    @Override
    public void updateView(PObject pObject) {
        List<String> list;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PCClass object32 : Globals.getClassList()) {
            for (String string : object32.getTypeList(false)) {
                if (string.equals("CUSTOM") || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        for (String string : pObject.getTypeList(false)) {
            if (string.equals("CUSTOM")) continue;
            arrayList2.add(string);
            arrayList.remove(string);
        }
        PCClass pCClass = (PCClass)pObject;
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        this.txtDisplayName.setText(pCClass.getOutputName());
        this.abbreviation.setText(pCClass.getAbbrev());
        this.exchangeLevel.setText(pCClass.getLevelExchange());
        this.startSkillPoints.setText(pCClass.getSkillPointFormula());
        DoubleKeyMap<Class, String, List<String>> doubleKeyMap = pCClass.getQualifyMap();
        if (doubleKeyMap != null && (list = doubleKeyMap.get(Object.class, null)) != null && !list.isEmpty()) {
            this.qualify.setText(CoreUtility.join(list, "|"));
        }
        this.exClass.setText(pCClass.getExClass());
        this.hasSubClass.setSelected(pCClass.hasSubClass());
        this.modToSkills.setSelected(pCClass.getModToSkills());
        this.multiPreReq.setSelected(pCClass.multiPreReqs());
        this.chkVisible.setSelected(pCClass.getVisibility().equals((Object)Visibility.DEFAULT));
    }

    private static GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, boolean bl) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        if (bl) {
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        }
        return gridBagConstraints;
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.txtDisplayName = new JTextField();
        this.abbreviation = new JTextField();
        this.qualify = new JTextField();
        this.exchangeLevel = new JTextField();
        this.startSkillPoints = new JTextField();
        this.exClass = new JTextField();
        this.hasSubClass = new JCheckBox();
        this.modToSkills = new JCheckBox();
        this.chkVisible = new JCheckBox();
        this.multiPreReq = new JCheckBox();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Display Name");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 0, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 0, true);
        gridBagConstraints.gridwidth = 5;
        this.add((Component)this.txtDisplayName, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.16;
        jLabel = new JLabel("ABB:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 1, true);
        this.add((Component)this.abbreviation, gridBagConstraints);
        jLabel = new JLabel("Ex-Class:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 1, true);
        this.add((Component)this.exClass, gridBagConstraints);
        jLabel = new JLabel("Exchange Level:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 1, true);
        this.add((Component)this.exchangeLevel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel("Has SubClass:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 2, true);
        this.add((Component)this.hasSubClass, gridBagConstraints);
        jLabel = new JLabel("Mod To Skills:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 2, true);
        this.add((Component)this.modToSkills, gridBagConstraints);
        jLabel = new JLabel("Starting Skill Points:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 2, true);
        this.add((Component)this.startSkillPoints, gridBagConstraints);
        jLabel = new JLabel("Qualify:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 3, true);
        this.add((Component)this.qualify, gridBagConstraints);
        jLabel = new JLabel("Multi-Class Pre-Reqs:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 3, true);
        this.add((Component)this.multiPreReq, gridBagConstraints);
        jLabel = new JLabel("Visible:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 3, true);
        this.add((Component)this.chkVisible, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

