/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KitSelector
extends JFrame {
    static final long serialVersionUID = -7963863233576905914L;
    private static final int USER_NO = 0;
    private static final int USER_YES = 1;
    private FlippingSplitPane spChoices;
    private FlippingSplitPane spMain;
    private JButton btnAdd;
    private JButton btnOk;
    private JButton btnRemove;
    private JLabel lblAvailable;
    private JLabel lblSelected;
    private JLabelPane txtInfo;
    private JPanel pnlAvailable;
    private JPanel pnlBottom;
    private JPanel pnlFrame;
    private JPanel pnlInfo;
    private JPanel pnlSelected;
    private JScrollPane scpAvailable;
    private JScrollPane scpInfo;
    private JScrollPane scpSelected;
    private JList lstAvailable;
    private JList lstSelected;
    private PlayerCharacter aPC = null;
    private int userResponse = 0;

    KitSelector(PlayerCharacter playerCharacter) {
        this.aPC = playerCharacter;
        this.initComponents();
        this.initComponentContents();
        this.setSize(new Dimension(640, 460));
        Utility.centerFrame(this, false);
    }

    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private static boolean isDoubleClick(MouseEvent mouseEvent, JButton jButton) {
        return mouseEvent.getClickCount() == 2 && jButton.isEnabled();
    }

    private void addKit(Kit kit) {
        if (kit == null || !this.kitPassesPrereqs(kit)) {
            return;
        }
        ArrayList<BaseKit> arrayList = new ArrayList<BaseKit>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        kit.testApplyKit(this.aPC, arrayList, arrayList2);
        if (arrayList2.size() != 0 && this.showWarnings(arrayList2) == 0) {
            return;
        }
        kit.processKit(this.aPC, arrayList);
        KitSelector.forceTabUpdate();
        if (kit.getApplyMode() == 0) {
            ((KitListModel)this.lstAvailable.getModel()).removeItem(kit);
            ((KitListModel)this.lstSelected.getModel()).addItem(kit);
            this.lstSelected.updateUI();
            this.lstAvailable.updateUI();
        }
    }

    private void addSelections(JList jList, Collection<Kit> collection, List<Kit> list, PlayerCharacter playerCharacter) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        for (Kit kit : collection) {
            if (!kit.isVisible(playerCharacter) || list != null && list.contains(kit)) continue;
            ((KitListModel)jList.getModel()).addItem(kit);
        }
    }

    private void btnAddActionPerformed() {
        this.btnAdd.setEnabled(false);
        Kit kit = (Kit)this.lstAvailable.getSelectedValue();
        if (kit != null) {
            this.addKit(kit);
            this.requestFocus();
        }
        this.btnAdd.setEnabled(true);
    }

    private void btnOKActionPerformed() {
        this.closeDialog();
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
    }

    private static void forceTabUpdate() {
        PCGen_Frame1.getInst().updateByKludge();
    }

    private void initComponentContents() {
        IconUtilitities.maybeSetIcon(this, "PcgenIcon.gif");
        this.lstAvailable = new JList(new KitListModel(new ArrayList<Kit>()));
        this.lstAvailable.setCellRenderer(new MyCellRenderer());
        this.lstAvailable.setSelectionMode(0);
        this.scpAvailable.setViewportView(this.lstAvailable);
        this.lstSelected = new JList(new KitListModel(new ArrayList<Kit>()));
        this.lstSelected.setCellRenderer(new MyCellRenderer());
        this.lstSelected.setSelectionMode(0);
        this.scpSelected.setViewportView(this.lstSelected);
        List<Kit> list = this.aPC.getKitInfo();
        this.addSelections(this.lstAvailable, Globals.getKitInfo().values(), list, this.aPC);
        this.addSelections(this.lstSelected, list, null, this.aPC);
        if (!this.lstAvailable.isSelectionEmpty()) {
            this.btnAdd.setEnabled(true);
        }
        if (!this.lstSelected.isSelectionEmpty()) {
            this.btnRemove.setEnabled(true);
        }
        this.lstAvailable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                KitSelector.this.lstAvailableMouseClicked(mouseEvent);
            }
        });
        this.lstAvailable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                KitSelector.this.lstAvailableSelectionChanged();
            }
        });
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                KitSelector.this.lstSelectedMouseClicked(mouseEvent);
            }
        });
        this.lstSelected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                KitSelector.this.lstSelectedSelectionChanged();
            }
        });
    }

    private void initComponents() {
        this.pnlFrame = new JPanel();
        this.spMain = new FlippingSplitPane();
        this.spChoices = new FlippingSplitPane();
        this.pnlAvailable = new JPanel();
        this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.lblAvailable = new JLabel();
        this.scpAvailable = new JScrollPane();
        this.pnlSelected = new JPanel();
        this.lblSelected = new JLabel();
        this.scpSelected = new JScrollPane();
        this.pnlBottom = new JPanel();
        this.pnlInfo = new JPanel();
        this.scpInfo = new JScrollPane();
        this.txtInfo = new JLabelPane();
        this.btnOk = new JButton();
        this.setTitle("Kit Selection");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KitSelector.this.closeDialog();
            }
        });
        this.pnlFrame.setLayout(new BorderLayout());
        this.pnlFrame.setBorder(new EmptyBorder(new Insets(3, 3, 3, 1)));
        this.spMain.setOrientation(0);
        this.spMain.setResizeWeight(0.5);
        this.spMain.setOneTouchExpandable(true);
        this.spMain.setDividerSize(10);
        this.spChoices.setResizeWeight(0.5);
        this.spChoices.setOneTouchExpandable(true);
        this.spChoices.setDividerSize(10);
        this.pnlAvailable.setLayout(new GridBagLayout());
        this.pnlAvailable.setBorder(new EmptyBorder(new Insets(1, 3, 1, 3)));
        this.btnAdd.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.btnAddActionPerformed();
            }
        });
        this.pnlAvailable.add((Component)this.btnAdd, new GridBagConstraints());
        this.lblAvailable.setText("Available");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlAvailable.add((Component)this.lblAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAvailable.add((Component)this.scpAvailable, gridBagConstraints);
        this.spChoices.setLeftComponent(this.pnlAvailable);
        this.pnlSelected.setLayout(new GridBagLayout());
        this.pnlSelected.setBorder(new EmptyBorder(new Insets(1, 3, 1, 3)));
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.btnRemoveActionPerformed();
            }
        });
        this.pnlSelected.add((Component)this.btnRemove, new GridBagConstraints());
        this.lblSelected.setText("Selected");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.spChoices.setRightComponent(this.pnlSelected);
        this.spMain.setLeftComponent(this.spChoices);
        this.pnlBottom.setLayout(new GridBagLayout());
        this.pnlInfo.setLayout(new BoxLayout(this.pnlInfo, 0));
        this.pnlInfo.setBorder(new TitledBorder("Kit Info"));
        this.txtInfo.setEditable(false);
        this.txtInfo.setBackground(this.pnlInfo.getBackground());
        this.scpInfo.setViewportView(this.txtInfo);
        this.pnlInfo.add(this.scpInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlBottom.add((Component)this.pnlInfo, gridBagConstraints);
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KitSelector.this.btnOKActionPerformed();
            }
        });
        this.pnlBottom.add((Component)this.btnOk, new GridBagConstraints());
        this.spMain.setRightComponent(this.pnlBottom);
        this.pnlFrame.add((Component)this.spMain, "Center");
        this.getContentPane().add((Component)this.pnlFrame, "Center");
    }

    private boolean kitPassesPrereqs(Kit kit) {
        return PrereqHandler.passesAll(kit.getPreReqList(), this.aPC, null);
    }

    private void lstAvailableMouseClicked(MouseEvent mouseEvent) {
        if (KitSelector.isDoubleClick(mouseEvent, this.btnAdd)) {
            this.btnAddActionPerformed();
        }
    }

    private void lstAvailableSelectionChanged() {
        boolean bl = false;
        Kit kit = (Kit)this.lstAvailable.getSelectedValue();
        if (kit != null) {
            this.showKitInfo(kit);
            bl = true;
        }
        this.btnAdd.setEnabled(bl);
    }

    private void lstSelectedMouseClicked(MouseEvent mouseEvent) {
        if (KitSelector.isDoubleClick(mouseEvent, this.btnRemove)) {
            this.btnRemoveActionPerformed();
        }
    }

    private void lstSelectedSelectionChanged() {
        boolean bl = false;
        Kit kit = (Kit)this.lstSelected.getSelectedValue();
        if (kit != null) {
            this.showKitInfo(kit);
            bl = true;
        }
        this.btnRemove.setEnabled(bl);
    }

    private void showKitInfo(Kit kit) {
        if (kit == null) {
            this.txtInfo.setText();
            return;
        }
        this.txtInfo.setText(kit.getInfo(this.aPC));
    }

    private int showWarnings(List<String> list) {
        this.userResponse = 0;
        try {
            final JDialog jDialog = new JDialog(this, "Warnings", true);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JLabel jLabel = new JLabel("The following warnings were encountered");
            JButton jButton = new JButton("Apply");
            JButton jButton2 = new JButton("Abort");
            jPanel.add(jLabel);
            jPanel2.setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)jPanel, "North");
            jDialog.getContentPane().add((Component)jPanel2, "Center");
            jDialog.getContentPane().add((Component)jPanel3, "South");
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<html>");
            for (String object2 : list) {
                stringBuffer.append(object2).append("<br>");
            }
            stringBuffer.append("</html>");
            JEditorPane jEditorPane = new JEditorPane("text/html", stringBuffer.toString());
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(jEditorPane);
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel3.add(jButton2);
            jPanel3.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KitSelector.this.userResponse = 1;
                    jDialog.dispose();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KitSelector.this.userResponse = 0;
                    jDialog.dispose();
                }
            });
            jDialog.setSize(new Dimension(456, 352));
            jDialog.setLocationRelativeTo(this);
            jDialog.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.userResponse;
    }

    private class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            if (object instanceof Kit) {
                Kit kit = (Kit)object;
                if (!KitSelector.this.kitPassesPrereqs(kit)) {
                    string = "<html>" + SettingsHandler.getPrereqFailColorAsHtmlStart() + kit.getDisplayName() + SettingsHandler.getPrereqFailColorAsHtmlStart() + "</html>";
                } else {
                    string = "";
                    if (kit.getApplyMode() == 1) {
                        string = "<html><font color=\"" + SettingsHandler.getFeatVirtualColor() + "\">";
                    }
                    string = string + kit.getDisplayName();
                    if (kit.getApplyMode() == 1) {
                        string = string + "<html></font>";
                    }
                }
            }
            super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KitListModel
    extends AbstractListModel {
        private List<Kit> theList = null;

        public KitListModel(List<Kit> list) {
            this.theList = new ArrayList<Kit>(list);
        }

        @Override
        public Object getElementAt(int n) {
            return this.theList.get(n);
        }

        @Override
        public int getSize() {
            return this.theList.size();
        }

        public void addItem(Kit kit) {
            this.theList.add(kit);
            Collections.sort(this.theList);
        }

        public void removeItem(Object object) {
            this.theList.remove(object);
        }
    }
}

