/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrerequisiteUtilities {
    private PrerequisiteUtilities() {
    }

    public static final String preReqHTMLStringsForList(PlayerCharacter playerCharacter, PObject pObject, List<Prerequisite> list, boolean bl) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(list.size() * 20);
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        int n = 0;
        for (Prerequisite prerequisite : list) {
            arrayList.clear();
            arrayList.add(prerequisite);
            if (n++ > 0) {
                stringBuffer.append(" and ");
            }
            String string = PrereqHandler.toHtmlString(arrayList);
            boolean bl2 = pObject instanceof Equipment ? PrereqHandler.passesAll(arrayList, (Equipment)pObject, playerCharacter) : PrereqHandler.passesAll(arrayList, playerCharacter, null);
            if (!bl2) {
                stringBuffer.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                stringBuffer.append("<i>");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&<>", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("<")) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (string2.equals(">")) {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (string2.equals("&")) {
                    stringBuffer.append("&amp;");
                    continue;
                }
                stringBuffer.append(string2);
            }
            if (bl2) continue;
            stringBuffer.append("</i>");
            stringBuffer.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
        }
        if (stringBuffer.toString().indexOf(60) >= 0) {
            stringBuffer.insert(0, "<font>");
            stringBuffer.append("</font>");
            if (bl && stringBuffer.toString().indexOf(60) >= 0) {
                stringBuffer.insert(0, "<html>");
                stringBuffer.append("</html>");
            }
        }
        return stringBuffer.toString();
    }

    public static String getPrerequisitePCCText(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null && list.size() > 0) {
            StringWriter stringWriter = new StringWriter();
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Prerequisite prerequisite = (Prerequisite)iterator.next();
                try {
                    prerequisiteWriter.write(stringWriter, prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Failed to encode prereq: ", persistenceLayerException);
                }
                if (!iterator.hasNext()) continue;
                stringWriter.write(string);
            }
            stringBuffer.append(string);
            stringBuffer.append(stringWriter.toString());
        }
        return stringBuffer.toString();
    }
}

