/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.pclevelinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.core.pclevelinfo.PCLevelInfoStat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCLevelInfo
implements Cloneable {
    private List<PCLevelInfoStat> statsPostModified = null;
    private List<PCLevelInfoStat> statsPreModified = null;
    private String classKeyName = "";
    private int level = 0;
    private int skillPointsGained = 0;
    private int skillPointsRemaining = 0;
    private PlayerCharacter aPC;
    private List<PObject> objects = new ArrayList<PObject>(1);

    public PCLevelInfo(PlayerCharacter playerCharacter, String string) {
        this.aPC = playerCharacter;
        this.classKeyName = string;
    }

    public void setClassKeyName(String string) {
        this.classKeyName = string;
    }

    public String getClassKeyName() {
        return this.classKeyName;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public List<PCLevelInfoStat> getModifiedStats(boolean bl) {
        List<PCLevelInfoStat> list = this.statsPostModified;
        if (bl) {
            list = this.statsPreModified;
        }
        return list;
    }

    public void setSkillPointsGained(int n) {
        int n2 = this.getBonusSkillPool();
        this.skillPointsGained = n + n2;
    }

    public int getSkillPointsGained() {
        if (this.skillPointsGained == 0 && this.classKeyName.length() > 0) {
            PCClass pCClass = Globals.getClassKeyed(this.classKeyName);
            this.skillPointsGained = pCClass.recalcSkillPointMod(this.aPC, this.level) + this.getBonusSkillPool();
        }
        return this.skillPointsGained;
    }

    public void setSkillPointsRemaining(int n) {
        this.skillPointsRemaining = n;
    }

    public int getSkillPointsRemaining() {
        return this.skillPointsRemaining;
    }

    public int getTotalStatMod(String string, boolean bl) {
        int n = 0;
        if (this.statsPreModified != null) {
            for (PCLevelInfoStat pCLevelInfoStat : this.statsPreModified) {
                if (!pCLevelInfoStat.getStatAbb().equals(string)) continue;
                n += pCLevelInfoStat.getStatMod();
            }
        }
        if (bl && this.statsPostModified != null) {
            for (PCLevelInfoStat pCLevelInfoStat : this.statsPostModified) {
                if (!pCLevelInfoStat.getStatAbb().equals(string)) continue;
                n += pCLevelInfoStat.getStatMod();
            }
        }
        return n;
    }

    public void addModifiedStat(String string, int n, boolean bl) {
        List<PCLevelInfoStat> list;
        if (bl) {
            if (this.statsPreModified == null) {
                this.statsPreModified = new ArrayList<PCLevelInfoStat>();
            }
            list = this.statsPreModified;
        } else {
            if (this.statsPostModified == null) {
                this.statsPostModified = new ArrayList<PCLevelInfoStat>();
            }
            list = this.statsPostModified;
        }
        for (int i = 0; i < list.size(); ++i) {
            PCLevelInfoStat pCLevelInfoStat = list.get(i);
            if (!string.equals(pCLevelInfoStat.getStatAbb())) continue;
            pCLevelInfoStat.modifyStat(n);
            if (pCLevelInfoStat.getStatMod() == 0) {
                list.remove(pCLevelInfoStat);
            }
            return;
        }
        list.add(new PCLevelInfoStat(string, n));
    }

    private int getBonusSkillPool() {
        int n = 0;
        PCClass pCClass = this.aPC.getClassKeyed(this.classKeyName);
        String string = SettingsHandler.getGame().getPurchaseModeMethodName();
        if (string != null) {
            PointBuyMethod pointBuyMethod = SettingsHandler.getGame().getPurchaseMethodByName(string);
            n += (int)this.aPC.calcBonusFromList(pointBuyMethod.getBonusListOfType("SKILLPOOL", "NUMBER"));
        }
        if (pCClass != null) {
            n += (int)pCClass.getBonusTo("SKILLPOOL", "NUMBER", this.level, this.aPC);
            n -= (int)pCClass.getBonusTo("SKILLPOOL", "NUMBER", this.level - 1, this.aPC);
        }
        if (this.level == 1) {
            n += (int)this.aPC.getTotalBonusTo("SKILLPOOL", "CLASS." + this.classKeyName);
        }
        n += (int)this.aPC.getTotalBonusTo("SKILLPOOL", "CLASS." + this.classKeyName + ";LEVEL." + Integer.toString(this.level));
        return n += (int)this.aPC.getTotalBonusTo("SKILLPOOL", "LEVEL." + this.aPC.getCharacterLevel(this));
    }

    public void addObject(PObject pObject) {
        this.objects.add(pObject);
    }

    public List<? extends PObject> getObjects() {
        return this.objects;
    }

    public Object clone() {
        PCLevelInfo pCLevelInfo = new PCLevelInfo(this.aPC, this.classKeyName);
        Iterator<Serializable> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            pCLevelInfo.objects.add(iterator.next());
        }
        if (this.statsPostModified != null) {
            for (PCLevelInfoStat pCLevelInfoStat : this.statsPostModified) {
                if (pCLevelInfo.statsPostModified == null) {
                    pCLevelInfo.statsPostModified = new ArrayList<PCLevelInfoStat>();
                }
                pCLevelInfo.statsPostModified.add(pCLevelInfoStat);
            }
        }
        if (this.statsPreModified != null) {
            for (PCLevelInfoStat pCLevelInfoStat : this.statsPreModified) {
                if (pCLevelInfo.statsPreModified == null) {
                    pCLevelInfo.statsPreModified = new ArrayList<PCLevelInfoStat>();
                }
                pCLevelInfo.statsPreModified.add(pCLevelInfoStat);
            }
        }
        return pCLevelInfo;
    }
}

