/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Categorisable;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Names;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.character.CharacterSpell;
import pcgen.core.npcgen.AlignGeneratorOption;
import pcgen.core.npcgen.ClassGeneratorOption;
import pcgen.core.npcgen.Configuration;
import pcgen.core.npcgen.GenderGeneratorOption;
import pcgen.core.npcgen.LevelGeneratorOption;
import pcgen.core.npcgen.RaceGeneratorOption;
import pcgen.core.npcgen.SkillChoice;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;
import pcgen.core.system.GameModeRollMethod;
import pcgen.gui.NameElement;
import pcgen.util.Logging;
import pcgen.util.WeightedList;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPCGenerator {
    private static final NPCGenerator theInstance = new NPCGenerator();
    private Configuration theConfiguration = null;
    private int theSubSkillWeightAdd = 10;

    private NPCGenerator() {
    }

    public static NPCGenerator getInst() {
        theInstance.setConfiguration(SettingsHandler.getGame());
        return theInstance;
    }

    private void setConfiguration(GameMode gameMode) {
        this.theConfiguration = Configuration.get(gameMode);
    }

    public static int getSubSkillWeightAdd() {
        return NPCGenerator.getInst().theSubSkillWeightAdd;
    }

    public List<AlignGeneratorOption> getAlignmentOptions() {
        return this.theConfiguration.getAlignmentOptions();
    }

    public List<RaceGeneratorOption> getCustomRaceOptions() {
        return this.theConfiguration.getRaceOptions();
    }

    public List<GenderGeneratorOption> getCustomGenderOptions() {
        return this.theConfiguration.getGenderOptions();
    }

    public List<ClassGeneratorOption> getCustomClassOptions() {
        return this.theConfiguration.getClassOptions();
    }

    public List<LevelGeneratorOption> getCustomLevelOptions() {
        return this.theConfiguration.getLevelOptions();
    }

    private WeightedList<SkillChoice> getSkillWeights(PCClass pCClass, PlayerCharacter playerCharacter) {
        WeightedList<SkillChoice> weightedList = this.theConfiguration.getSkillWeights(pCClass.getKeyName());
        if (weightedList == null) {
            weightedList = new WeightedList();
            for (Skill skill : Globals.getSkillList()) {
                if (skill.getVisibility() != Visibility.DEFAULT) continue;
                if (skill.isClassSkill(pCClass, playerCharacter)) {
                    weightedList.add(8, new SkillChoice(skill.getKeyName()));
                    continue;
                }
                if (skill.isExclusive()) continue;
                weightedList.add(1, new SkillChoice(skill.getKeyName()));
            }
        }
        return weightedList;
    }

    private void selectSkills(PlayerCharacter playerCharacter, List<SkillChoice> list, PCClass pCClass, int n) {
        List<PCLevelInfo> list2 = playerCharacter.getLevelInfo();
        PCLevelInfo pCLevelInfo = null;
        int n2 = 0;
        for (PCLevelInfo object : list2) {
            if (object.getClassKeyName().equals(pCClass.getKeyName())) {
                ++n2;
            }
            if (n2 != n) continue;
            pCLevelInfo = object;
            break;
        }
        if (pCLevelInfo == null) {
            return;
        }
        int n3 = pCLevelInfo.getSkillPointsRemaining();
        Logging.debugPrint("NPCGenerator: Selecting " + n3 + " skill points for " + pCClass + "/" + n);
        Logging.debugPrint("NPCGenerator: Initial skillList is " + list);
        while (n3 > 0) {
            SkillChoice skillChoice = list.get(Globals.getRandomInt(list.size()));
            Skill skill = skillChoice.getSkill();
            Logging.debugPrint("NPCGenerator: Selected " + skill);
            if (skill == null) {
                Logging.debugPrint("NPCGenerator: Skill not found");
                continue;
            }
            Skill skill2 = playerCharacter.getSkillKeyed(skill.getKeyName());
            int n4 = skill.costForPCClass(pCClass, playerCharacter);
            double d = 1.0 / (double)n4;
            Logging.debugPrint("NPCGenerator: Adding " + (int)d + "ranks");
            if (!Globals.checkRule("SKILLMAX")) {
                double d2;
                double d3 = playerCharacter.getMaxRank(skill.getKeyName(), pCClass).doubleValue();
                double d4 = d2 = skill2 == null ? 0.0 : skill2.getRank().doubleValue();
                if (d2 + d > d3) {
                    Logging.debugPrint("NPCGenerator: Skill already at max.");
                    boolean bl = false;
                    for (SkillChoice skillChoice2 : list) {
                        Skill skill3 = skillChoice2.getSkill();
                        if (skill3 == null) continue;
                        Skill skill4 = playerCharacter.getSkillKeyed(skill3.getKeyName());
                        if (skill4 == null) {
                            bl = true;
                            break;
                        }
                        if (!(skill4.getRank().doubleValue() < playerCharacter.getMaxRank(skill4.getKeyName(), pCClass).doubleValue())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    Logging.errorPrint("Unable to spend all skill points.");
                    break;
                }
            }
            if (skill2 == null) {
                skill2 = playerCharacter.addSkill(skill);
            }
            skill2.modRanks(d, pCClass, playerCharacter);
            list.add(4 / n4, skillChoice);
            pCLevelInfo.setSkillPointsRemaining(--n3);
            Logging.debugPrint("NPCGenerator: Skill list now " + list);
        }
    }

    private int getAlignment(AlignGeneratorOption alignGeneratorOption) {
        if (alignGeneratorOption == null) {
            return -1;
        }
        WeightedList<PCAlignment> weightedList = alignGeneratorOption.getList();
        int n = Globals.getRandomInt(weightedList.size());
        return SettingsHandler.getGame().getIndexOfAlignment(weightedList.get(n).getKeyName());
    }

    private Race getRace(RaceGeneratorOption raceGeneratorOption) {
        WeightedList<Race> weightedList = raceGeneratorOption.getList();
        int n = Globals.getRandomInt(weightedList.size());
        return weightedList.get(n);
    }

    private String getGender(GenderGeneratorOption genderGeneratorOption) {
        WeightedList<String> weightedList = genderGeneratorOption.getList();
        int n = Globals.getRandomInt(weightedList.size());
        return weightedList.get(n);
    }

    private PCClass getClass(ClassGeneratorOption classGeneratorOption) {
        WeightedList<PCClass> weightedList = classGeneratorOption.getList();
        int n = Globals.getRandomInt(weightedList.size());
        return weightedList.get(n);
    }

    private int getLevel(LevelGeneratorOption levelGeneratorOption) {
        WeightedList<Integer> weightedList = levelGeneratorOption.getList();
        int n = Globals.getRandomInt(weightedList.size());
        return weightedList.get(n);
    }

    private List<PCStat> getStatWeights(PCClass pCClass) {
        WeightedList<String> weightedList = new WeightedList<String>(this.theConfiguration.getStatWeights(pCClass.getKeyName()));
        List<PCStat> list = SettingsHandler.getGame().getUnmodifiableStatList();
        ArrayList<PCStat> arrayList = new ArrayList<PCStat>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            int n = Globals.getRandomInt(weightedList.size());
            String string = weightedList.get(n);
            int n2 = SettingsHandler.getGame().getStatFromAbbrev(string);
            PCStat pCStat = list.get(n2);
            arrayList.add(pCStat);
            weightedList.remove(string);
        }
        return arrayList;
    }

    private void generateStats(PlayerCharacter playerCharacter, PCClass pCClass, GameModeRollMethod gameModeRollMethod) {
        List<PCStat> list = this.getStatWeights(pCClass);
        Logging.debugPrint("NPCGenerator: Stat order is " + list);
        playerCharacter.rollStats(3, list, gameModeRollMethod, true);
        List<PCStat> list2 = playerCharacter.getStatList().getStatList();
        for (int i = 0; i < list.size(); ++i) {
            PCStat pCStat = list.get(i);
            PCStat pCStat2 = list2.get(playerCharacter.getStatList().getIndexOfStatFor(pCStat.getAbb()));
            Logging.debugPrint("NPCGenerator: Setting stat " + pCStat2.getAbb() + " to " + pCStat.getBaseScore());
            pCStat2.setBaseScore(pCStat.getBaseScore());
        }
    }

    private WeightedList<Ability> getFeatWeights(PCClass pCClass) {
        WeightedList<Ability> weightedList = this.theConfiguration.getAbilityWeights(pCClass.getKeyName(), AbilityCategory.FEAT);
        if (weightedList == null) {
            weightedList = new WeightedList();
            Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
            while (iterator.hasNext()) {
                int n = 1;
                Ability ability = (Ability)iterator.next();
                if (ability.getVisibility() != Visibility.DEFAULT) continue;
                if (ability.isType("GENERAL")) {
                    n = 5;
                }
                weightedList.add(n, ability);
            }
        }
        return weightedList;
    }

    private void selectFeats(PlayerCharacter playerCharacter, List<Ability> list) {
        while ((int)playerCharacter.getFeats() > 0) {
            Ability ability = list.get(Globals.getRandomInt(list.size()));
            if (!PrereqHandler.passesAll(ability.getPreReqList(), playerCharacter, ability)) continue;
            AbilityUtilities.modFeat(playerCharacter, null, ability.getKeyName(), true, false);
        }
    }

    private void selectDeity(PlayerCharacter playerCharacter, PCClass pCClass) {
        WeightedList<Deity> weightedList = new WeightedList<Deity>(this.theConfiguration.getDeityWeights(pCClass.getKeyName()));
        boolean bl = false;
        while (weightedList.size() > 0) {
            Deity deity = (Deity)weightedList.get(Globals.getRandomInt(weightedList.size()));
            if (playerCharacter.canSelectDeity(deity)) {
                playerCharacter.setDeity(deity);
                bl = true;
                break;
            }
            weightedList.remove(deity);
        }
        if (!bl) {
            Logging.errorPrintLocalised("NPCGen.Errors.CantSelectDeity");
        }
    }

    private void selectDomains(PlayerCharacter playerCharacter, PCClass pCClass) {
        while (playerCharacter.getCharacterDomainUsed() < playerCharacter.getMaxCharacterDomains()) {
            Domain domain;
            WeightedList<Domain> weightedList = this.theConfiguration.getDomainWeights(playerCharacter.getDeity().getKeyName(), pCClass.getKeyName());
            Domain domain2 = (Domain)weightedList.get(Globals.getRandomInt(weightedList.size()));
            if (!domain2.qualifiesForDomain(playerCharacter)) continue;
            CharacterDomain characterDomain = playerCharacter.getCharacterDomainForDomain(domain2.getKeyName());
            if (characterDomain == null) {
                characterDomain = playerCharacter.getNewCharacterDomain();
            }
            if ((domain = characterDomain.getDomain()) != null && domain.equals(domain2)) {
                playerCharacter.removeCharacterDomain(characterDomain);
            }
            if (domain != null) continue;
            domain2.setIsLocked(true, playerCharacter);
            characterDomain.setDomain(domain2, playerCharacter);
            playerCharacter.addCharacterDomain(characterDomain);
            playerCharacter.calcActiveBonuses();
        }
    }

    private WeightedList<Spell> getKnownSpellWeights(PCClass pCClass, int n) {
        WeightedList<Spell> weightedList = this.theConfiguration.getKnownSpellWeights(pCClass.getKeyName(), n);
        if (weightedList == null) {
            weightedList = new WeightedList();
            for (Spell spell : Globals.getSpellsIn(n, pCClass.getKeyName(), "")) {
                weightedList.add(1, spell);
            }
        }
        return weightedList;
    }

    private WeightedList<Spell> getPreparedSpellWeights(PCClass pCClass, int n) {
        WeightedList<Spell> weightedList = this.theConfiguration.getPreparedSpellWeights(pCClass.getKeyName(), n);
        if (weightedList == null) {
            weightedList = new WeightedList();
            for (Spell spell : Globals.getSpellsIn(n, pCClass.getKeyName(), "")) {
                weightedList.add(1, spell);
            }
        }
        return weightedList;
    }

    private void selectDomainSpell(PlayerCharacter playerCharacter, PCClass pCClass, int n) {
        Object object;
        int n2 = playerCharacter.getCharacterDomainList().size();
        if (n2 < 1) {
            return;
        }
        WeightedList<Domain> weightedList = new WeightedList<Domain>();
        for (int i = 0; i < n2; ++i) {
            object = playerCharacter.getCharacterDomainList().get(i);
            Domain domain = ((CharacterDomain)object).getDomain();
            if (domain == null || !((CharacterDomain)object).isFromPCClass(pCClass.getKeyName())) continue;
            weightedList.add(domain);
        }
        Domain domain = (Domain)weightedList.getRandomValue();
        object = new WeightedList<Spell>(Globals.getSpellsIn(n, "", domain.getKeyName()));
        this.selectSpell(playerCharacter, pCClass, domain, "Prepared Spells", (WeightedList<Spell>)object, n);
    }

    private void selectSpell(PlayerCharacter playerCharacter, PCClass pCClass, Domain domain, String string, WeightedList<Spell> weightedList, int n) {
        boolean bl = false;
        while (!bl) {
            Spell spell = weightedList.get(Globals.getRandomInt(weightedList.size()));
            CharacterSpell characterSpell = domain != null ? new CharacterSpell(domain, spell) : new CharacterSpell(pCClass, spell);
            String string2 = playerCharacter.addSpell(characterSpell, new ArrayList<Ability>(), pCClass.getKeyName(), string, n, n);
            if (string2.length() != 0) {
                Logging.debugPrint("Add spell failed: " + string2);
                continue;
            }
            bl = true;
        }
    }

    private void selectSubClass(PlayerCharacter playerCharacter, PCClass pCClass) {
        WeightedList<String> weightedList = this.theConfiguration.getSubClassWeights(pCClass.getKeyName());
        if (weightedList != null && weightedList.size() > 0) {
            pCClass.setSubClassKey(weightedList.get(Globals.getRandomInt(weightedList.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(PlayerCharacter playerCharacter, AlignGeneratorOption alignGeneratorOption, RaceGeneratorOption raceGeneratorOption, GenderGeneratorOption genderGeneratorOption, List<ClassGeneratorOption> list, List<LevelGeneratorOption> list2, GameModeRollMethod gameModeRollMethod, NameElement nameElement) {
        String string = ChooserFactory.getInterfaceClassname();
        ChooserFactory.setInterfaceClassname("pcgen.util.chooser.RandomChooser");
        boolean bl = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        int n = SettingsHandler.getSingleChoicePreference();
        SettingsHandler.setSingleChoicePreference(2);
        try {
            Object object;
            List<String> list3;
            List<String> list4;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n2;
            for (int i = 0; i < 5; ++i) {
                Race race;
                n2 = this.getAlignment(alignGeneratorOption);
                if (n2 > 0) {
                    Logging.debugPrint("NPCGenerator: Selected " + n2 + " for alignment " + alignGeneratorOption);
                    playerCharacter.setAlignment(n2, false);
                }
                if ((race = this.getRace(raceGeneratorOption)) == null) {
                    Logging.debugPrint("NPCGenerator: Got null race.  Retrying.");
                    continue;
                }
                Logging.debugPrint("NPCGenerator: Selected " + race + " for race " + raceGeneratorOption);
                if (!PrereqHandler.passesAll(race.getPreReqList(), playerCharacter, race)) continue;
                Logging.debugPrint("NPCGenerator: PC qualifies for race " + race);
                playerCharacter.setRace(race);
                break;
            }
            if (playerCharacter.getRace() == Globals.s_EMPTYRACE) {
                Logging.errorPrint("Unable to select race");
                return;
            }
            String string2 = this.getGender(genderGeneratorOption);
            Logging.debugPrint("NPCGenerator: Selecting " + string2 + " for gender " + genderGeneratorOption);
            playerCharacter.setGender(string2);
            n2 = 0;
            for (int i = 0; i < list.size(); ++i) {
                int n3 = this.getLevel(list2.get(i));
                Logging.debugPrint("NPCGenerator: Selecting " + n3 + " for level " + list2.get(i));
                object5 = null;
                if (n2 == 0 && playerCharacter.getClassList().size() > 0) {
                    object5 = playerCharacter.getClassList().get(0);
                    n3 = ((PCClass)object5).getLevel();
                    n2 = 1;
                    --i;
                } else {
                    n2 = 1;
                    object5 = this.getClass(list.get(i));
                    if (object5 != null) {
                        if (((PObject)object5).getVisibility().equals((Object)Visibility.DEFAULT) && PrereqHandler.passesAll(((PrereqObject)object5).getPreReqList(), playerCharacter, (PObject)object5) && ((PCClass)object5).isQualified(playerCharacter)) {
                            Logging.debugPrint("NPCGenerator: Selecting " + object5 + " for class " + list.get(i));
                        } else {
                            object5 = null;
                        }
                    }
                }
                if (object5 == null) continue;
                object4 = ((PCClass)object5).clone();
                if (((PCClass)object4).hasSubClass()) {
                    this.selectSubClass(playerCharacter, (PCClass)object4);
                }
                if (i == 0) {
                    this.generateStats(playerCharacter, (PCClass)object4, gameModeRollMethod);
                    this.selectDeity(playerCharacter, (PCClass)object4);
                }
                int n4 = ((PCClass)object5).getHighestLevelSpell(playerCharacter);
                object3 = new int[n4 + 1];
                for (int j = 0; j < n4; ++j) {
                    object3[j] = false;
                }
                object2 = new int[n4 + 1];
                for (int j = 0; j < n4; ++j) {
                    object2[j] = false;
                }
                list4 = new WeightedList<SkillChoice>(this.getSkillWeights((PCClass)object4, playerCharacter));
                list3 = new WeightedList<Ability>(this.getFeatWeights((PCClass)object4));
                for (int j = 0; j < n3; ++j) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    if (i >= 0) {
                        playerCharacter.incrementClassLevel(1, (PCClass)object4, true);
                    }
                    object = playerCharacter.getClassKeyed(((PObject)object4).getKeyName());
                    this.selectSkills(playerCharacter, list4, (PCClass)object, j + 1);
                    this.selectFeats(playerCharacter, list3);
                    this.selectDomains(playerCharacter, (PCClass)object);
                    if (((PCClass)object).getSpellType().equals("None")) continue;
                    if (((PCClass)object).hasKnownList() || ((PCClass)object).hasKnownSpells(playerCharacter)) {
                        Logging.debugPrint("NPCGenerator: known spells to select");
                        for (n8 = 0; n8 <= n4; ++n8) {
                            if (!playerCharacter.availableSpells(n8, (PCClass)object, Globals.getDefaultSpellBook(), true, true)) continue;
                            n7 = ((PCClass)object).getKnownForLevel(n8, playerCharacter);
                            n6 = ((PCClass)object).getSpecialtyKnownForLevel(n8, playerCharacter);
                            Logging.debugPrint("NPCGenerator: " + n7 + "known spells to select");
                            WeightedList<Spell> weightedList = this.getKnownSpellWeights((PCClass)object, n8);
                            int n9 = n7 - object3[n8];
                            for (n5 = 0; n5 < n9; ++n5) {
                                this.selectSpell(playerCharacter, (PCClass)object, null, Globals.getDefaultSpellBook(), weightedList, n8);
                                Object object6 = object3;
                                int n10 = n8;
                                object6[n10] = object6[n10] + true;
                            }
                        }
                        continue;
                    }
                    Logging.debugPrint("NPCGenerator: prepared spells to select");
                    playerCharacter.addSpellBook("Prepared Spells");
                    for (n8 = 0; n8 <= n4; ++n8) {
                        n7 = ((PCClass)object).getCastForLevel(n8, "Prepared Spells", true, true, playerCharacter);
                        n6 = ((PCClass)object).getCastForLevel(n8, "Prepared Spells", false, true, playerCharacter);
                        int n11 = n7 - n6;
                        Logging.debugPrint("NPCGenerator: " + n7 + "+" + n11 + " prepared spells to select");
                        if (n11 - object2[n8] > 0) {
                            this.selectDomainSpell(playerCharacter, (PCClass)object, n8);
                            Object object7 = object2;
                            int n12 = n8;
                            object7[n12] = object7[n12] + true;
                        }
                        if (n7 <= 0) continue;
                        WeightedList<Spell> weightedList = this.getPreparedSpellWeights((PCClass)object, n8);
                        n5 = n6 - object3[n8];
                        for (int k = 0; k < n5; ++k) {
                            this.selectSpell(playerCharacter, (PCClass)object, null, "Prepared Spells", weightedList, n8);
                            Object object8 = object3;
                            int n13 = n8;
                            object8[n13] = object8[n13] + true;
                        }
                    }
                }
            }
            Globals.getBioSet().randomize("EYES.HAIR.SKIN.HT.WT.AGE.", playerCharacter);
            List<String> list5 = SystemCollections.getUnmodifiableHairStyleList();
            playerCharacter.setHairStyle(list5.get(Globals.getRandomInt(list5.size())));
            object5 = SystemCollections.getUnmodifiableSpeechList();
            playerCharacter.setSpeechTendency(object5.get(Globals.getRandomInt(object5.size())));
            object4 = SystemCollections.getUnmodifiablePhobiaList();
            playerCharacter.setPhobias(object4.get(Globals.getRandomInt(object4.size())));
            List<String> list6 = SystemCollections.getUnmodifiableInterestsList();
            playerCharacter.setInterests(list6.get(Globals.getRandomInt(list6.size())));
            object3 = SystemCollections.getUnmodifiablePhraseList();
            playerCharacter.setCatchPhrase(object3.get(Globals.getRandomInt(object3.size())));
            object2 = SystemCollections.getUnmodifiableTraitList();
            playerCharacter.setTrait1(object2.get(Globals.getRandomInt(object2.size())));
            playerCharacter.setTrait2(object2.get(Globals.getRandomInt(object2.size())));
            list4 = SystemCollections.getUnmodifiableCityList();
            playerCharacter.setResidence(list4.get(Globals.getRandomInt(list4.size())));
            list3 = SystemCollections.getUnmodifiableLocationList();
            playerCharacter.setLocation(list3.get(Globals.getRandomInt(list3.size())));
            List<String> list7 = SystemCollections.getUnmodifiableBirthplaceList();
            playerCharacter.setBirthplace(list7.get(Globals.getRandomInt(list7.size())));
            object = Names.getInstance();
            ((Names)object).init(nameElement, playerCharacter);
            playerCharacter.setName(((Names)object).getRandomName());
        }
        catch (Exception exception) {
            Logging.errorPrint("Problem generation NPC", exception);
        }
        finally {
            SettingsHandler.setShowHPDialogAtLevelUp(bl);
            SettingsHandler.setSingleChoicePreference(n);
            ChooserFactory.setInterfaceClassname(string);
        }
    }
}

