/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.npcgen.AlignGeneratorOption;
import pcgen.core.npcgen.ClassData;
import pcgen.core.npcgen.ClassDataParser;
import pcgen.core.npcgen.ClassGeneratorOption;
import pcgen.core.npcgen.GenderGeneratorOption;
import pcgen.core.npcgen.GeneratorOption;
import pcgen.core.npcgen.LevelGeneratorOption;
import pcgen.core.npcgen.OptionsParser;
import pcgen.core.npcgen.RaceGeneratorOption;
import pcgen.core.npcgen.SkillChoice;
import pcgen.core.spell.Spell;
import pcgen.util.WeightedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static List<Configuration> theConfigurations = new ArrayList<Configuration>();
    private static Configuration theDefaultConfiguration = new Configuration();
    private GameMode theMode = null;
    private List<GeneratorOption> theGeneratorOptions = new ArrayList<GeneratorOption>();
    private Map<String, ClassData> theClassData = new HashMap<String, ClassData>();
    private static File optionsDir = new File(SettingsHandler.getPcgenSystemDir() + File.separator + "npcgen" + File.separator + "options");
    private static File classDataDir = new File(SettingsHandler.getPcgenSystemDir() + File.separator + "npcgen" + File.separator + "classdata");

    public static Configuration get(GameMode gameMode) {
        for (Configuration object : theConfigurations) {
            if (!object.theMode.equals(gameMode)) continue;
            return object;
        }
        Configuration configuration = new Configuration();
        configuration.theMode = gameMode;
        try {
            File[] fileArray;
            OptionsParser exception = new OptionsParser(gameMode);
            File[] fileArray2 = optionsDir.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".xml");
                }
            });
            for (File file : fileArray2) {
                List<GeneratorOption> list = exception.parse(file);
                configuration.theGeneratorOptions.addAll(list);
            }
            ClassDataParser classDataParser = new ClassDataParser(gameMode);
            for (File file : fileArray = classDataDir.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".xml");
                }
            })) {
                List<ClassData> list = classDataParser.parse(file);
                for (ClassData classData : list) {
                    configuration.theClassData.put(classData.getClassKey(), classData);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return theDefaultConfiguration;
        }
        theConfigurations.add(configuration);
        return configuration;
    }

    public List<AlignGeneratorOption> getAlignmentOptions() {
        ArrayList<AlignGeneratorOption> arrayList = new ArrayList<AlignGeneratorOption>();
        for (GeneratorOption object : this.theGeneratorOptions) {
            if (!(object instanceof AlignGeneratorOption)) continue;
            arrayList.add((AlignGeneratorOption)object);
        }
        for (PCAlignment pCAlignment : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
            boolean bl = false;
            for (AlignGeneratorOption alignGeneratorOption : arrayList) {
                if (!alignGeneratorOption.getName().equals(pCAlignment.getDisplayName())) continue;
                bl = true;
                break;
            }
            if (pCAlignment.getDisplayName().equals("None") || bl) continue;
            AlignGeneratorOption alignGeneratorOption = new AlignGeneratorOption();
            alignGeneratorOption.setName(pCAlignment.getDisplayName());
            alignGeneratorOption.addChoice(1, pCAlignment.getKeyName());
            arrayList.add(alignGeneratorOption);
        }
        return arrayList;
    }

    public List<RaceGeneratorOption> getRaceOptions() {
        ArrayList<RaceGeneratorOption> arrayList = new ArrayList<RaceGeneratorOption>();
        for (GeneratorOption object : this.theGeneratorOptions) {
            if (!(object instanceof RaceGeneratorOption)) continue;
            arrayList.add((RaceGeneratorOption)object);
        }
        for (Race race : Globals.getAllRaces()) {
            RaceGeneratorOption raceGeneratorOption = new RaceGeneratorOption();
            raceGeneratorOption.setName(race.getDisplayName());
            raceGeneratorOption.addChoice(1, race.getKeyName());
            arrayList.add(raceGeneratorOption);
        }
        return arrayList;
    }

    public List<GenderGeneratorOption> getGenderOptions() {
        ArrayList<GenderGeneratorOption> arrayList = new ArrayList<GenderGeneratorOption>();
        for (GeneratorOption object : this.theGeneratorOptions) {
            if (!(object instanceof GenderGeneratorOption)) continue;
            arrayList.add((GenderGeneratorOption)object);
        }
        for (String string : Globals.getAllGenders()) {
            GenderGeneratorOption genderGeneratorOption = new GenderGeneratorOption();
            genderGeneratorOption.setName(string);
            genderGeneratorOption.addChoice(1, string);
            arrayList.add(genderGeneratorOption);
        }
        return arrayList;
    }

    public List<ClassGeneratorOption> getClassOptions() {
        ArrayList<ClassGeneratorOption> arrayList = new ArrayList<ClassGeneratorOption>();
        for (GeneratorOption object : this.theGeneratorOptions) {
            if (!(object instanceof ClassGeneratorOption)) continue;
            arrayList.add((ClassGeneratorOption)object);
        }
        for (PCClass pCClass : Globals.getClassList()) {
            ClassGeneratorOption classGeneratorOption = new ClassGeneratorOption();
            classGeneratorOption.setName(pCClass.getDisplayName());
            classGeneratorOption.addChoice(1, pCClass.getKeyName());
            arrayList.add(classGeneratorOption);
        }
        return arrayList;
    }

    public List<LevelGeneratorOption> getLevelOptions() {
        ArrayList<LevelGeneratorOption> arrayList = new ArrayList<LevelGeneratorOption>();
        for (GeneratorOption generatorOption : this.theGeneratorOptions) {
            if (!(generatorOption instanceof LevelGeneratorOption)) continue;
            arrayList.add((LevelGeneratorOption)generatorOption);
        }
        for (int i = 1; i <= 20; ++i) {
            GeneratorOption generatorOption;
            generatorOption = new LevelGeneratorOption();
            generatorOption.setName(String.valueOf(i));
            ((LevelGeneratorOption)generatorOption).addChoice(1, String.valueOf(i));
            arrayList.add((LevelGeneratorOption)generatorOption);
        }
        return arrayList;
    }

    public WeightedList<String> getStatWeights(String string) {
        ClassData classData = this.theClassData.get(string);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getStatWeights();
    }

    public WeightedList<SkillChoice> getSkillWeights(String string) {
        ClassData classData = this.theClassData.get(string);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getSkillWeights();
    }

    public WeightedList<Ability> getAbilityWeights(String string, AbilityCategory abilityCategory) {
        ClassData classData = this.theClassData.get(string);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getAbilityWeights(abilityCategory);
    }

    public WeightedList<Deity> getDeityWeights(String string) {
        ClassData classData = this.theClassData.get(string);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getDeityWeights();
    }

    public WeightedList<Domain> getDomainWeights(String string, String string2) {
        ClassData classData = this.theClassData.get(string2);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getDomainWeights(string);
    }

    public WeightedList<Spell> getKnownSpellWeights(String string, int n) {
        ClassData classData = this.theClassData.get(string);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getKnownSpellWeights(n);
    }

    public WeightedList<Spell> getPreparedSpellWeights(String string, int n) {
        ClassData classData = this.theClassData.get(string);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getPreparedSpellWeights(n);
    }

    public WeightedList<String> getSubClassWeights(String string) {
        ClassData classData = this.theClassData.get(string);
        if (classData == null) {
            classData = new ClassData("");
        }
        return classData.getSubClassWeights();
    }
}

