/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.levelability;

import java.util.Collections;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LevelAbilityEquipment
extends LevelAbility {
    LevelAbilityEquipment(PObject pObject, int n, String string) {
        super(pObject, n, string);
    }

    @Override
    List<String> getChoicesList(String string, PlayerCharacter playerCharacter) {
        List<String> list = super.getChoicesList(string.substring(6), playerCharacter);
        Collections.sort(list);
        return list;
    }

    @Override
    String prepareChooser(ChooserInterface chooserInterface, PlayerCharacter playerCharacter) {
        super.prepareChooser(chooserInterface, playerCharacter);
        chooserInterface.setTitle("Equipment Choice");
        return this.rawTagData;
    }

    @Override
    public boolean processChoice(List<String> list, List<String> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        for (String string : list2) {
            Equipment equipment = EquipmentList.getEquipmentNamed(string);
            if (equipment == null) {
                Logging.errorPrint("LevelAbilityEquipment: Equipment not found: " + string);
                break;
            }
            Equipment equipment2 = equipment.clone();
            equipment2.setQty(1.0);
            playerCharacter.addEquipment(equipment2);
        }
        return true;
    }

    @Override
    void processToken(String string, List<String> list, PlayerCharacter playerCharacter) {
        if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
            String string2 = string.substring(5);
            List<Equipment> list2 = EquipmentList.getEquipmentOfType(string2, "");
            for (Equipment equipment : list2) {
                list.add(equipment.getDisplayName());
            }
        } else {
            String string3 = string;
            Equipment equipment = EquipmentList.getEquipmentNamed(string3);
            if (equipment == null) {
                Logging.errorPrint("LevelAbilityEquipment: Equipment not found: " + string3);
                return;
            }
            if (!playerCharacter.getEquipmentMasterList().contains(equipment) && PrereqHandler.passesAll(equipment.getPreReqList(), playerCharacter, equipment)) {
                list.add(string);
            }
        }
    }
}

