/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.StatList;
import pcgen.core.kit.BaseKit;
import pcgen.core.pclevelinfo.PCLevelInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitStat
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String theStatName = null;
    private String theStatValue = "";
    private transient PCStat theStat = null;

    public KitStat(String string, String string2) {
        this.theStatName = string;
        this.theStatValue = string2;
    }

    public String getStatName() {
        return this.theStatName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.theStatName).append("=").append(this.theStatValue);
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        boolean bl = false;
        int n = playerCharacter.getVariableValue(this.theStatValue, "").intValue();
        StatList statList = playerCharacter.getStatList();
        for (int i = 0; i < statList.size(); ++i) {
            PCStat pCStat = statList.getStatAt(i);
            if (playerCharacter.isNonAbility(i) || !pCStat.getAbb().equals(this.getStatName())) continue;
            pCStat.setBaseScore(n);
            this.theStat = pCStat.clone();
            bl = true;
            if (!"INT".equals(pCStat.getAbb())) break;
            this.recalculateSkillPoints(playerCharacter);
            break;
        }
        if (!bl && list != null) {
            list.add("STAT: Could not find stat \"" + this.getStatName() + "\"");
        }
        return false;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        StatList statList = playerCharacter.getStatList();
        for (PCStat pCStat : statList) {
            if (!pCStat.getAbb().equals(this.theStat.getAbb())) continue;
            pCStat.setBaseScore(this.theStat.getBaseScore());
            if (!"INT".equals(pCStat.getAbb())) break;
            this.recalculateSkillPoints(playerCharacter);
            break;
        }
    }

    @Override
    public String getObjectName() {
        return "Stats";
    }

    private void recalculateSkillPoints(PlayerCharacter playerCharacter) {
        ArrayList<PCClass> arrayList = playerCharacter.getClassList();
        playerCharacter.calcActiveBonuses();
        if (arrayList != null && arrayList.size() != 0) {
            playerCharacter.setSkillPoints(0);
            for (PCClass pCClass : arrayList) {
                pCClass.setSkillPool(0);
                if (playerCharacter.getLevelInfoSize() <= 0 || !pCClass.getModToSkills()) continue;
                List<PCLevelInfo> list = playerCharacter.getLevelInfo();
                for (int i = 0; i < list.size(); ++i) {
                    PCLevelInfo pCLevelInfo = list.get(i);
                    if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName())) continue;
                    int n = pCClass.recalcSkillPointMod(playerCharacter, i + 1);
                    pCLevelInfo.setSkillPointsGained(n);
                    pCLevelInfo.setSkillPointsRemaining(pCLevelInfo.getSkillPointsGained());
                    pCClass.setSkillPool(pCClass.skillPool() + n);
                    playerCharacter.setSkillPoints(n + playerCharacter.getSkillPoints());
                }
            }
        }
    }
}

