/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;
import pcgen.core.prereq.PrereqHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitClass
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String theClassName = null;
    private String theSubClass = null;
    private String theLevelString = "";
    private transient PCClass theClass = null;
    private transient int theLevel = -1;
    private transient boolean doLevelAbilities = true;

    public KitClass(String string) {
        this.theClassName = string;
    }

    public String getClassName() {
        return this.theClassName;
    }

    public void setLevel(String string) {
        this.theLevelString = string;
    }

    public String getLevelString() {
        return this.theLevelString;
    }

    public void setSubClass(String string) {
        this.theSubClass = string;
    }

    public String getSubClass() {
        return this.theSubClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.theClassName).append(this.theLevelString);
        return stringBuffer.toString();
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        this.theClass = null;
        this.theClass = Globals.getClassKeyed(this.getClassName());
        if (this.theClass == null) {
            list.add("CLASS: Class not found \"" + this.getClassName() + "\"");
            return false;
        }
        if (this.getSubClass() != null) {
            this.theClass.setSubClassKey(this.getSubClass());
        }
        if (!PrereqHandler.passesAll(this.theClass.getPreReqList(), playerCharacter, kit)) {
            PrereqHandler.toHtmlString(this.theClass.getPreReqList());
            list.add("CLASS: Not qualified for class \"" + this.getClassName() + "\".");
            return false;
        }
        this.doLevelAbilities = kit.doLevelAbilities();
        this.theLevel = playerCharacter.getVariableValue(this.theLevelString, "").intValue();
        this.addLevel(playerCharacter, this.theLevel, this.theClass, this.doLevelAbilities);
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        this.addLevel(playerCharacter, this.theLevel, this.theClass, this.doLevelAbilities);
        this.theClass = null;
    }

    @Override
    public KitClass clone() {
        return (KitClass)super.clone();
    }

    private void addLevel(PlayerCharacter playerCharacter, int n, PCClass pCClass, boolean bl) {
        boolean bl2 = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        int n2 = SettingsHandler.getSingleChoicePreference();
        SettingsHandler.setSingleChoicePreference(2);
        boolean bl3 = playerCharacter.doLevelAbilities();
        playerCharacter.setDoLevelAbilities(bl);
        playerCharacter.incrementClassLevel(n, pCClass, true);
        playerCharacter.setDoLevelAbilities(bl3);
        SettingsHandler.setSingleChoicePreference(n2);
        SettingsHandler.setShowHPDialogAtLevelUp(bl2);
    }

    @Override
    public String getObjectName() {
        return "Classes";
    }
}

