/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.Prerequisite;
import pcgen.util.Logging;
import pcgen.util.UnreachableError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseKit
implements Cloneable {
    protected int choiceCount = 1;
    private List<Prerequisite> prereqs = null;
    private List<Range> options = new ArrayList<Range>();
    private List<String> lookups = new ArrayList<String>();

    public void setChoiceCount(String string) {
        try {
            this.choiceCount = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Invalid choice count \"" + string + "\" in BaseKit.setChoiceCount");
        }
    }

    public int getChoiceCount() {
        return this.choiceCount;
    }

    public List<Prerequisite> getPrereqs() {
        return this.prereqs;
    }

    public void addPreReq(Prerequisite prerequisite) {
        if (this.prereqs == null) {
            this.prereqs = new ArrayList<Prerequisite>();
        }
        this.prereqs.add(prerequisite);
    }

    public void addLookup(String string) {
        this.lookups.add(string);
    }

    public List<String> getLookups() {
        return Collections.unmodifiableList(this.lookups);
    }

    public BaseKit clone() {
        BaseKit baseKit = null;
        try {
            baseKit = (BaseKit)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnreachableError(cloneNotSupportedException);
        }
        if (this.prereqs != null) {
            baseKit.prereqs = new ArrayList<Prerequisite>(this.prereqs);
        }
        baseKit.choiceCount = this.choiceCount;
        if (this.options != null) {
            baseKit.options = new ArrayList<Range>(this.options);
        }
        if (this.lookups != null) {
            baseKit.lookups = new ArrayList<String>(this.lookups);
        }
        return baseKit;
    }

    public void addOptionRange(String string, String string2) {
        this.options.add(new Range(string, string2));
    }

    public boolean isOption(PlayerCharacter playerCharacter, int n) {
        if (this.options.size() == 0) {
            return true;
        }
        for (Range range : this.options) {
            if (!range.isIn(playerCharacter, n)) continue;
            return true;
        }
        return false;
    }

    public static String eval(PlayerCharacter playerCharacter, String string) {
        String string2 = string;
        int n = string.indexOf("EVAL(");
        if (n == -1) {
            return string;
        }
        while (n != -1) {
            int n2;
            int n3;
            String string3 = string.substring(n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
            int n4 = 1;
            int n5 = 4;
            for (n3 = n5 + 1; n3 < string.length() - 1; ++n3) {
                n2 = string3.charAt(n3);
                if (n2 == 40) {
                    ++n4;
                    continue;
                }
                if (n2 == 41 && --n4 == 0) break;
            }
            if (n4 != 0) {
                return string;
            }
            string3 = string3.substring(5, n3);
            n2 = playerCharacter.getVariableValue(string3, "").intValue();
            String string4 = "" + n2;
            stringBuffer.append(string4);
            stringBuffer.append(string.substring(n3 + 5));
            string2 = stringBuffer.toString();
            n = string2.indexOf("EVAL(");
        }
        return string2;
    }

    public abstract boolean testApply(Kit var1, PlayerCharacter var2, List<String> var3);

    public abstract void apply(PlayerCharacter var1);

    public abstract String getObjectName();

    static class Range {
        private String lowValue = "-2147483648";
        private String highValue = "2147483647";

        public Range(String string, String string2) {
            this.lowValue = string;
            this.highValue = string2;
        }

        public boolean isIn(PlayerCharacter playerCharacter, int n) {
            int n2 = playerCharacter.getVariableValue(this.lowValue, "").intValue();
            int n3 = playerCharacter.getVariableValue(this.highValue, "").intValue();
            return n >= n2 && n <= n3;
        }
    }
}

