/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.AssociatedChoice;
import pcgen.core.Constants;
import pcgen.core.FeatMultipleChoice;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.chooser.AbstractComplexChoiceManager;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellListChoiceManager
extends AbstractComplexChoiceManager<String> {
    int idxSelected = -1;
    FeatMultipleChoice fmc = null;

    public SpellListChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.title = "Spell choice";
        this.chooserHandled = "SPELLLIST";
        if (this.choices != null && this.choices.size() > 0 && ((String)this.choices.get(0)).equals(this.chooserHandled)) {
            this.choices = this.choices.subList(1, this.choices.size());
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        if (Ability.class.isInstance(this.pobject) && this.chooseAbility()) {
            this.setSpellListSelections(playerCharacter, list, list2);
            if (this.idxSelected >= 0) {
                this.fmc = (FeatMultipleChoice)this.pobject.getAssociatedObject(this.idxSelected);
                this.requestedSelections = this.maxNewSelections = this.fmc.getMaxChoices();
            }
        } else {
            list.clear();
            list2.clear();
        }
    }

    @Override
    protected void cleanUpAssociated(PlayerCharacter playerCharacter, int n) {
        if (this.idxSelected >= 0) {
            this.pobject.removeAssociated(this.idxSelected);
            if (n == 0) {
                playerCharacter.adjustFeats(1.0);
            }
        } else if (n != 0) {
            playerCharacter.adjustFeats(-1.0);
        }
        this.fmc = null;
    }

    @Override
    protected void associateChoice(PlayerCharacter playerCharacter, String string, String string2) {
        if (this.fmc == null) {
            this.fmc = new FeatMultipleChoice();
            this.fmc.setMaxChoices(this.maxNewSelections);
            this.pobject.addAssociated(this.fmc);
        }
        this.fmc.addChoice(string);
    }

    @Override
    protected void adjustFeats(PlayerCharacter playerCharacter, List<String> list) {
    }

    private boolean chooseAbility() {
        Object object;
        Ability ability = (Ability)this.pobject;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("New");
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < ability.getAssociatedCount(); ++i) {
            this.fmc = (FeatMultipleChoice)ability.getAssociatedList().get(i);
            stringBuffer.append(ability.getKeyName()).append(" (");
            stringBuffer.append(this.fmc.getChoiceCount());
            stringBuffer.append(" of ").append(this.fmc.getMaxChoices()).append(") ");
            for (int j = 0; j < this.fmc.getChoiceCount(); ++j) {
                if (j != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.fmc.getChoice(j));
            }
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        if (arrayList.size() > 1) {
            InputInterface inputInterface = InputFactory.getInputInstance();
            object = inputInterface.showInputDialog(null, "Please select the instance of the feat you wish to" + Constants.s_LINE_SEP + "modify, or New, from the list below.", "PCGen", MessageType.INFORMATION, arrayList.toArray(), arrayList.get(0));
        } else {
            object = arrayList.get(0);
        }
        if (object == null) {
            return false;
        }
        this.idxSelected = arrayList.indexOf(object) - 1;
        return true;
    }

    private void setSpellListSelections(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        PObject pObject;
        boolean bl;
        Iterator iterator = this.choices.iterator();
        switch (((String)iterator.next()).charAt(0)) {
            case '1': 
            case 'Y': {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        ArrayList<PCClass> arrayList = null;
        int n = 0;
        while ((pObject = playerCharacter.getSpellClassAtIndex(n)) != null) {
            if (pObject instanceof PCClass && ((PCClass)pObject).getSpellBookUsed() == bl) {
                if (arrayList == null) {
                    arrayList = new ArrayList<PCClass>();
                }
                arrayList.add((PCClass)pObject);
            }
            ++n;
        }
        if (arrayList != null) {
            Object object;
            this.maxNewSelections = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                pObject = (PCClass)arrayList.get(n);
                object = pObject.getSpellSupport().getCharacterSpell(null, Globals.getDefaultSpellBook(), -1);
                Iterator<CharacterSpell> iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    CharacterSpell characterSpell = iterator2.next();
                    Spell spell = characterSpell.getSpell();
                    if (this.pobject.containsAssociated(spell.getKeyName()) || list.contains(spell.getKeyName())) continue;
                    list.add(spell.getKeyName());
                }
                int n2 = playerCharacter.getStatList().getStatModFor(((PCClass)pObject).getSpellBaseStat());
                if (n2 <= 0) continue;
                this.maxNewSelections = n2;
            }
            ArrayList<AssociatedChoice<String>> arrayList2 = this.pobject.getAssociatedList();
            if (arrayList2 != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object = (FeatMultipleChoice)arrayList2.get(i);
                    Collection collection = ((FeatMultipleChoice)object).getChoices();
                    if (collection == null) continue;
                    for (int j = 0; j < collection.size(); ++j) {
                        if (i == this.idxSelected) {
                            list2.add((String)collection.get(j));
                            continue;
                        }
                        list.remove(collection.get(j));
                    }
                }
            }
        }
    }
}

