/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.CategorisableStore;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.chooser.AbstractSimpleChoiceManager;
import pcgen.core.utils.ListKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWeaponProfChoiceManager
extends AbstractSimpleChoiceManager<String> {
    final CategorisableStore weaponToProfMap = new CategorisableStore();

    public SimpleWeaponProfChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        this.weaponToProfMap.clear();
        this.dupsAllowed = false;
        this.title = "Weapon Choice(s)";
        list2.addAll(this.pobject.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS));
        for (String string : this.choices) {
            boolean bl = false;
            String string2 = string;
            String string3 = string;
            if (string.lastIndexOf(91) >= 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
                String string4 = stringTokenizer.nextToken();
                bl = true;
                while (stringTokenizer.hasMoreTokens()) {
                    this.weaponToProfMap.addCategorisable(new weaponToProf(string4, stringTokenizer.nextToken()));
                }
                string2 = string4;
            }
            if ("DEITYWEAPON".equals(string2)) {
                this.buildWeaponProfDeityChoices(string3, list, bl, playerCharacter);
                continue;
            }
            if (string2.startsWith("TYPE=") || string2.startsWith("TYPE.")) {
                this.buildWeaponProfTypeChoices(string3, list, string2, playerCharacter);
                continue;
            }
            if (string2.startsWith("WIELD=") || string2.startsWith("WIELD.")) {
                this.buildWeaponProfWeildChoices(string3, list, string2, playerCharacter);
                continue;
            }
            if (string2.startsWith("!TYPE=") || string2.startsWith("!TYPE.")) {
                this.removeExcludedWeaponProfTypeChoices(string2, list, playerCharacter);
                continue;
            }
            list.add(string2);
        }
    }

    private void buildWeaponProfDeityChoices(String string, List<String> list, boolean bl, PlayerCharacter playerCharacter) {
        if (playerCharacter.getDeity() != null) {
            String string2 = playerCharacter.getDeity().getFavoredWeapon();
            if ("ALL".equalsIgnoreCase(string2) || "ANY".equalsIgnoreCase(string2)) {
                string2 = Globals.getWeaponProfNames("|", false);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                list.add(string3);
                if (!bl) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, "[]");
                stringTokenizer2.nextToken();
                while (stringTokenizer2.hasMoreTokens()) {
                    this.weaponToProfMap.addCategorisable(new weaponToProf(string3, stringTokenizer2.nextToken()));
                }
            }
        }
    }

    private void buildWeaponProfTypeChoices(String string, List<String> list, String string2, PlayerCharacter playerCharacter) {
        Object object;
        String string3 = string2.substring(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = -1;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).startsWith("SIZE=") || string2.startsWith("SIZE.")) {
                n = Globals.sizeInt(((String)object).substring(5));
                continue;
            }
            arrayList.add(object);
        }
        object = EquipmentList.getEquipmentListIterator();
        while (object.hasNext()) {
            String string4;
            Equipment equipment = (Equipment)((Map.Entry)object.next()).getValue();
            if (!equipment.isWeapon()) continue;
            boolean bl = true;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && equipment.isType(string4 = (String)iterator.next())) {
                if (n >= 0) {
                    bl &= Globals.sizeInt(equipment.getSize()) == n;
                }
                if (!bl) continue;
                String string5 = equipment.profKey(playerCharacter);
                this.addtoToAvailableAndMap(string, list, string5);
            }
        }
    }

    private void buildWeaponProfWeildChoices(String string, List<String> list, String string2, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(6), ".");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        Iterator<Map.Entry<String, Equipment>> iterator = EquipmentList.getEquipmentListIterator();
        block1: while (iterator.hasNext()) {
            Equipment equipment = iterator.next().getValue();
            if (!equipment.isWeapon()) continue;
            for (String string3 : arrayList) {
                if (!equipment.hasWield() || !equipment.getWield().equalsIgnoreCase(string3)) continue block1;
                String string4 = equipment.profKey(playerCharacter);
                this.addtoToAvailableAndMap(string, list, string4);
            }
        }
    }

    private void addtoToAvailableAndMap(String string, List<String> list, String string2) {
        WeaponProf weaponProf = Globals.getWeaponProfKeyed(string2);
        if (weaponProf != null && !list.contains(weaponProf.getKeyName())) {
            String string3 = weaponProf.getKeyName();
            list.add(string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    this.weaponToProfMap.addCategorisable(new weaponToProf(string3, stringTokenizer.nextToken()));
                }
            }
        }
    }

    private void removeExcludedWeaponProfTypeChoices(String string, List<String> list, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(6), ".");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        Iterator<Map.Entry<String, Equipment>> iterator = EquipmentList.getEquipmentListIterator();
        while (iterator.hasNext()) {
            String string2;
            Equipment equipment = iterator.next().getValue();
            if (!equipment.isWeapon()) continue;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext() && equipment.isType(string2 = (String)iterator2.next())) {
                WeaponProf weaponProf = Globals.getWeaponProfKeyed(equipment.profKey(playerCharacter));
                if (weaponProf == null || !list.contains(weaponProf.getKeyName())) continue;
                String string3 = weaponProf.getKeyName();
                list.remove(string3);
            }
        }
    }

    @Override
    public void applyChoices(PlayerCharacter playerCharacter, List<String> list) {
        this.pobject.clearSelectedWeaponProfBonus();
        playerCharacter.setAutomaticAbilitiesStable(null, false);
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext() && !this.weaponToProfMap.isEmpty()) {
            String string = iterator.next();
            Iterator<Categorisable> iterator2 = this.weaponToProfMap.getKeyIterator(string);
            while (iterator2.hasNext()) {
                Ability ability;
                String string2;
                String string3 = iterator2.next().toString();
                if (string3 == null) continue;
                if (string3.startsWith("WEAPONPROF")) {
                    this.pobject.addSelectedWeaponProfBonus(string);
                    continue;
                }
                if (!string3.startsWith("FEAT=") && !string3.startsWith("FEAT.")) continue;
                if (this.pobject instanceof Domain) {
                    this.pobject.clearAssociated();
                    string2 = string3.substring(5);
                    ability = Globals.getAbilityKeyed("FEAT", string2);
                    if (ability == null) continue;
                    this.pobject.addAssociated("FEAT?" + ability.getKeyName() + "(" + string + ")");
                    continue;
                }
                string2 = string3.substring(5);
                ability = playerCharacter.getFeatNamed(string2);
                if (ability == null) {
                    ability = Globals.getAbilityKeyed("FEAT", string2);
                    if ((ability = ability.clone()) != null) {
                        playerCharacter.addFeat(ability, null);
                    }
                }
                if (ability == null || ability.containsAssociated(string)) continue;
                ability.addAssociated(string);
            }
        }
        playerCharacter.setAggregateAbilitiesStable(null, false);
    }

    @Override
    public String typeHandled() {
        return this.chooserHandled;
    }

    public class weaponToProf
    implements Categorisable {
        String category;
        String keyName;

        public weaponToProf(String string, String string2) {
            this.category = string;
            this.keyName = string2;
        }

        public String getCategory() {
            return this.category;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getDisplayName() {
            return this.keyName;
        }

        public String toString() {
            return this.keyName;
        }
    }
}

