/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleChoiceManager<T>
implements ChoiceManagerList<T> {
    protected final PlayerCharacter pc;
    protected final PObject pobject;
    protected List<String> choices;
    protected String chooserHandled = "";
    protected int numberOfChoices = 0;
    protected boolean dupsAllowed = false;
    protected String title = "";
    protected List<T> uniqueList = new ArrayList<T>();

    public AbstractSimpleChoiceManager(PObject pObject, PlayerCharacter playerCharacter) {
        this.pobject = pObject;
        this.pc = playerCharacter;
    }

    public AbstractSimpleChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        this.pobject = pObject;
        this.pc = playerCharacter;
        this.initialise(string, playerCharacter);
    }

    private void initialise(String string, PlayerCharacter playerCharacter) {
        List<String> list = Arrays.asList(string.split("[|]", 3));
        if (list.size() < 3) {
            this.choices = Collections.emptyList();
            return;
        }
        this.chooserHandled = list.get(0);
        this.numberOfChoices = playerCharacter.getVariableValue(list.get(1), "").intValue();
        this.choices = Arrays.asList(list.get(2).split("[|]"));
    }

    @Override
    public abstract void getChoices(PlayerCharacter var1, List<T> var2, List<T> var3);

    @Override
    public List<T> doChooser(PlayerCharacter playerCharacter, List<T> list, List<T> list2) {
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setAllowsDups(this.dupsAllowed);
        if (this.title.length() != 0) {
            chooserInterface.setTitle(this.title);
        }
        Globals.sortChooserLists(list, list2);
        chooserInterface.setAvailableList(list);
        chooserInterface.setSelectedList(list2);
        chooserInterface.setUniqueList(this.uniqueList);
        this.numberOfChoices -= chooserInterface.getSelectedList().size();
        chooserInterface.setPool(Math.max(0, this.numberOfChoices));
        chooserInterface.setPoolFlag(false);
        chooserInterface.setVisible(true);
        return chooserInterface.getSelectedList();
    }

    @Override
    public void doChooserRemove(PlayerCharacter playerCharacter, List<T> list, List<T> list2) {
    }

    @Override
    public abstract void applyChoices(PlayerCharacter var1, List<T> var2);
}

