/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.CharacterDomain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentUtilities;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.VariableProcessor;
import pcgen.core.character.Follower;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableProcessorPC
extends VariableProcessor {
    public VariableProcessorPC(PlayerCharacter playerCharacter) {
        super(playerCharacter);
    }

    @Override
    public Float lookupVariable(String string, String string2, Spell spell) {
        Float f;
        Object object;
        Float f2 = null;
        if (this.getPc().hasVariable(string)) {
            object = this.getPc().getVariable(string, true, true, string2, "", this.decrement);
            Logging.debugPrint(this.jepIndent + "variable for: '" + string + "' = " + object);
            f2 = new Float(((Float)object).doubleValue());
        }
        if (f2 == null && (object = this.getInternalVariable(spell, string, string2)) != null) {
            f = null;
            try {
                f = new Float((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (f != null && !f.isNaN()) {
                f2 = f;
                Logging.debugPrint(this.jepIndent + "internal variable for: '" + string + "' = " + f);
            }
        }
        if (f2 == null && (object = this.getExportVariable(string)) != null) {
            f = null;
            try {
                f = new Float((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (f != null && !f.isNaN()) {
                f2 = f;
                Logging.debugPrint(this.jepIndent + "export variable for: '" + string + "' = " + f);
            }
        }
        return f2;
    }

    private int countVisibleFeat(Ability ability, boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        if (bl && ability.getVisibility() != Visibility.DISPLAY_ONLY && ability.getVisibility() != Visibility.HIDDEN) {
            n = bl3 ? ++n : (n += Math.max(1, ability.getAssociatedCount()));
        }
        if (bl2 && (ability.getVisibility() == Visibility.DISPLAY_ONLY || ability.getVisibility() == Visibility.HIDDEN)) {
            n = bl3 ? ++n : (n += Math.max(1, ability.getAssociatedCount()));
        }
        return n;
    }

    private int countVisibleFeatTypes(List<Ability> list, List<String> list2, boolean bl, boolean bl2) {
        int n = 0;
        block0: for (Ability ability : list) {
            for (String string : list2) {
                if (!ability.isType(string)) continue;
                n += this.countVisibleFeat(ability, bl, bl2, false);
                continue block0;
            }
        }
        return n;
    }

    private int countVisibleFeatsOfKey(List<Ability> list, String string, boolean bl, boolean bl2) {
        int n = 0;
        for (Ability ability : list) {
            if (!ability.getKeyName().equalsIgnoreCase(string)) continue;
            n += this.countVisibleFeat(ability, bl, bl2, false);
            break;
        }
        return n;
    }

    private int countVisibleFeats(List<Ability> list, boolean bl, boolean bl2) {
        int n = 0;
        for (Ability ability : list) {
            n += this.countVisibleFeat(ability, bl, bl2, true);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected String getInternalVariable(Spell spell, String string, String string2) {
        if (!Globals.checkRule("SYS_LDPACSK") && string.equals(this.getPc().getStatList().getPenaltyVar("DEX"))) {
            string = "1000";
        }
        if ("SCORE".equals(string) && string2.startsWith("STAT:")) {
            string = String.valueOf(this.getPc().getStatList().getTotalStatFor(string2.substring(5)));
        } else if ("SPELLBASESTATSCORE".equals(string)) {
            PCClass pCClass = this.getPc().getClassKeyed(string2.substring(6));
            if (pCClass != null) {
                string = pCClass.getSpellBaseStat() + "SCORE";
                if ("SPELLSCORE".equals(string)) {
                    string = "10";
                }
            } else {
                string = "0";
            }
        } else if ("SPELLBASESTAT".equals(string)) {
            PCClass pCClass = this.getPc().getClassKeyed(string2.substring(6));
            if (pCClass != null) {
                string = pCClass.getSpellBaseStat();
                if ("SPELL".equals(string)) {
                    string = "0";
                }
            } else {
                string = "0";
            }
        } else if ("BASESPELLSTAT".equals(string)) {
            PCClass pCClass = null;
            if (string2.length() < 7) {
                string = "0";
            } else {
                pCClass = this.getPc().getClassKeyed(string2.substring(6));
            }
            if (pCClass != null) {
                string = String.valueOf(this.getPc().getBaseSpellStatBonus(pCClass));
            }
        } else if ("SPELLLEVEL".equals(string)) {
            string = String.valueOf(this.getPc().getSpellLevelTemp());
        } else if (string.length() > 0 && SettingsHandler.getGame().getStatFromAbbrev(string) > -1) {
            int n = SettingsHandler.getGame().getStatFromAbbrev(string);
            int n2 = this.getPc().getStatList().getTotalStatFor(string);
            int n3 = this.getPc().getStatList().getModForNumber(n2, n);
            string = Integer.toString(n3);
        } else if (string.length() == 8 && SettingsHandler.getGame().getStatFromAbbrev(string.substring(0, 3)) > -1 && string.endsWith(".BASE")) {
            string = Integer.toString(this.getPc().getStatList().getBaseStatFor(string.substring(0, 3)));
        } else if (string.length() >= 8 && string.substring(3).startsWith("SCORE")) {
            string = string.endsWith(".BASE") ? Integer.toString(this.getPc().getStatList().getBaseStatFor(string.substring(0, 3))) : Integer.toString(this.getPc().getStatList().getTotalStatFor(string.substring(0, 3)));
        } else if ("CASTERLEVEL".equals(string) && string2.startsWith("RACE:")) {
            int n = this.getPc().getTotalCasterLevelWithSpellBonus(spell, "None", "RACE." + string2.substring(5), 0);
            if (n > 0) {
                string = Integer.toString(n);
            }
        } else if ("CASTERLEVEL.TOTAL".equals(string) || "CASTERLEVEL".equals(string) && !string2.startsWith("CLASS:")) {
            int n = 0;
            for (PCClass pCClass : this.getPc().getClassList()) {
                void string4;
                if (pCClass.getSpellType().equals("None")) continue;
                String string3 = pCClass.getKeyName();
                String n2 = "None";
                int n3 = (int)this.getPc().getTotalBonusTo("PCLEVEL", string3);
                if (pCClass != null && !pCClass.getSpellType().equals("None")) {
                    String object = pCClass.getSpellType();
                }
                if (CoreUtility.doublesEqual(this.getPc().getTotalBonusTo("CASTERLEVEL", string3), 0.0)) {
                    int n4 = Integer.parseInt(this.getPc().getClassLevelString(string3, false));
                    n += this.getPc().getTotalCasterLevelWithSpellBonus(spell, (String)string4, string3, n4 + n3);
                    continue;
                }
                n += this.getPc().getTotalCasterLevelWithSpellBonus(spell, (String)string4, string3, n3);
            }
            string = Integer.toString(n);
        } else if ("CASTERLEVEL".equals(string) && string2.startsWith("CLASS:")) {
            String string5 = string2.substring(6);
            CharacterDomain characterDomain = this.getPc().getCharacterDomainForDomain(string5);
            if (characterDomain != null) {
                string5 = characterDomain.getObjectName();
            }
            PCClass pCClass = Globals.getClassKeyed(string5);
            String string6 = "None";
            if (pCClass != null && !pCClass.getSpellType().equals("None")) {
                string6 = pCClass.getSpellType();
            }
            int object = (int)this.getPc().getTotalBonusTo("PCLEVEL", string5);
            int n = (int)this.getPc().getTotalBonusTo("CASTERLEVEL", string5);
            if (n == 0) {
                n = Integer.parseInt(this.getPc().getClassLevelString(string5, false));
                n = this.getPc().getTotalCasterLevelWithSpellBonus(spell, string6, string5, n + object);
            } else {
                n = this.getPc().getTotalCasterLevelWithSpellBonus(spell, string6, string5, object);
            }
            string = Integer.toString(n);
        } else if ("CASTERLEVEL".equals(string)) {
            Logging.debugPrint("src for CASTERLEVEL: " + string2);
        } else if ("CL".equals(string) && string2.startsWith("CLASS:")) {
            string = this.getPc().getClassLevelString(string2.substring(6), false);
        } else if (string.startsWith("CL=") || string.startsWith("CL.")) {
            string = this.getPc().getClassLevelString(string.substring(3), false);
        } else if ((string.startsWith("CL;BEFORELEVEL=") || string.startsWith("CL;BEFORELEVEL.")) && string2.startsWith("CLASS:")) {
            string = this.getPc().getClassLevelString(string2.substring(6) + string.substring(2), false);
        } else if ("BL".equals(string) && string2.startsWith("CLASS:")) {
            string = Integer.toString((int)this.getPc().getTotalBonusTo("PCLEVEL", string2.substring(6)));
        } else if (string.startsWith("BL=") || string.startsWith("BL.")) {
            string = Integer.toString((int)this.getPc().getTotalBonusTo("PCLEVEL", string.substring(3)));
        } else if ("BAB".equals(string)) {
            string = Integer.toString(this.getPc().baseAttackBonus());
        } else if (string.startsWith("CLASSLEVEL=") || string.startsWith("CLASSLEVEL.")) {
            string = this.getPc().getClassLevelString(string.substring(11), true);
        } else if (string.startsWith("CLASS=") || string.startsWith("CLASS.")) {
            PCClass pCClass = null;
            if (string.length() > 6) {
                pCClass = this.getPc().getClassKeyed(string.substring(6));
            } else {
                Logging.errorPrint("Error! Cannot determine CLASS!");
            }
            string = pCClass != null ? "1" : "0";
        } else if (string.startsWith("SKILLRANK=") || string.startsWith("SKILLRANK.")) {
            Skill skill = this.getPc().getSkillKeyed(string.substring(10).replace('{', '(').replace('}', ')'));
            string = skill != null ? skill.getRank().toString() : "0";
        } else if (string.startsWith("SKILLTOTAL=") || string.startsWith("SKILLTOTAL.")) {
            Skill skill = this.getPc().getSkillKeyed(string.substring(11).replace('{', '(').replace('}', ')'));
            string = skill != null ? Integer.toString(skill.getTotalRank(this.getPc()).intValue() + skill.modifier(this.getPc())) : "0";
        } else if ("TL".equals(string)) {
            string = Integer.toString(this.getPc().getTotalLevels());
        } else if ("HD".equals(string)) {
            string = Integer.toString(this.getPc().totalHitDice());
        } else if ("PROFACCHECK".equals(string) && string2.startsWith("EQ:")) {
            Equipment equipment = EquipmentList.getEquipmentNamed(string2.substring(3));
            string = equipment != null && !this.getPc().isProficientWith(equipment) ? Integer.toString(equipment.acCheck(this.getPc())) : "0";
        } else if ("ACCHECK".equals(string) || "ACHECK".equals(string)) {
            int n = 0;
            for (Equipment equipment : this.getPc().getEquipmentOfType("Armor", 1)) {
                n += equipment.acCheck(this.getPc()).intValue();
            }
            for (Equipment equipment : this.getPc().getEquipmentOfType("Shield", 1)) {
                n += equipment.acCheck(this.getPc()).intValue();
            }
            string = Integer.toString(n);
        } else if ("ARMORACCHECK".equals(string) || "ARMORACHECK".equals(string)) {
            int n = 0;
            for (Equipment equipment : this.getPc().getEquipmentOfType("Armor", 1)) {
                n += equipment.acCheck(this.getPc()).intValue();
            }
            string = Integer.toString(n);
        } else if ("SHIELDACCHECK".equals(string) || "SHIELDACHECK".equals(string)) {
            int n = 0;
            for (Equipment equipment : this.getPc().getEquipmentOfType("Shield", 1)) {
                n += equipment.acCheck(this.getPc()).intValue();
            }
            string = Integer.toString(n);
        } else if ("SIZE".equals(string)) {
            string = String.valueOf(this.getPc().sizeInt());
        } else if ("SIZEMOD".equals(string)) {
            string = String.valueOf((int)this.getPc().getSizeAdjustmentBonusTo("COMBAT", "AC"));
        } else if ("RACESIZE".equals(string)) {
            string = String.valueOf(Globals.sizeInt(this.getPc().getRace().getSize()));
        } else if ("ENCUMBERANCE".equals(string)) {
            int n = this.getVariableValue(null, "LOADSCORE", "", this.getPc().getSpellLevelTemp()).intValue();
            string = String.valueOf((Object)Globals.loadTypeForLoadScore(n, this.getPc().totalWeight(), this.getPc()));
        } else if ("MOVEBASE".equals(string)) {
            string = this.getPc().getRace().getMovements().get(0).getDoubleMovement().toString();
        } else if (string.startsWith("MOVE[")) {
            String string7 = string.substring(5, string.lastIndexOf("]"));
            string = String.valueOf(this.getPc().movementOfType(string7));
        } else if ("COUNT[ATTACKS]".equals(string)) {
            string = Integer.toString(this.getPc().getNumAttacks());
        } else if ("COUNT[CHECKS]".equals(string)) {
            string = String.valueOf(SettingsHandler.getGame().getUnmodifiableCheckList().size());
        } else if ("COUNT[FOLLOWERS]".equals(string)) {
            string = Integer.toString(this.getPc().getFollowerList().size());
        } else if ("COUNT[STATS]".equals(string)) {
            string = Integer.toString(SettingsHandler.getGame().s_ATTRIBLONG.length);
        } else if ("COUNT[SKILLS]".equals(string)) {
            ArrayList<Skill> arrayList = this.getPc().getSkillListInOutputOrder();
            arrayList.trimToSize();
            string = Integer.toString(arrayList.size());
        } else if (string.startsWith("COUNT[SKILLTYPE=") || string.startsWith("COUNT[SKILLTYPE.")) {
            if (string.endsWith("]")) {
                ArrayList<Skill> arrayList = this.getPc().getSkillListInOutputOrder(new ArrayList<Skill>(this.getPc().getAllSkillList(true)));
                int n = 0;
                string = string.substring(16);
                string = string.substring(0, string.length() - 1);
                for (Skill skill : arrayList) {
                    if (!skill.isType(string)) continue;
                    ++n;
                }
                string = Integer.toString(n);
            }
        } else if ("COUNT[FEATS.ALL]".equals(string)) {
            string = Integer.toString(this.getPc().getRealAbilitiesListAnyCat(AbilityCategory.FEAT).size());
        } else if ("COUNT[FEATS.HIDDEN]".equals(string)) {
            string = Integer.toString(this.countVisibleFeats(this.getPc().getRealAbilitiesListAnyCat(AbilityCategory.FEAT), false, true));
        } else if ("COUNT[FEATS]".equals(string) || "COUNT[FEATS.VISIBLE]".equals(string)) {
            string = Integer.toString(this.countVisibleFeats(this.getPc().getRealAbilitiesListAnyCat(AbilityCategory.FEAT), true, false));
        } else if ("COUNT[VFEATS.ALL]".equals(string)) {
            string = Integer.toString(this.getPc().getVirtualFeatList().size());
        } else if ("COUNT[VFEATS.HIDDEN]".equals(string)) {
            string = Integer.toString(this.countVisibleFeats(this.getPc().getVirtualFeatList(), false, true));
        } else if ("COUNT[VFEATS]".equals(string) || "COUNT[VFEATS.VISIBLE]".equals(string)) {
            string = Integer.toString(this.countVisibleFeats(this.getPc().getVirtualFeatList(), true, false));
        } else if ("COUNT[FEATSAUTO.ALL]".equals(string)) {
            string = Integer.toString(this.getPc().featAutoList().size());
        } else if ("COUNT[FEATSAUTO]".equals(string) || "COUNT[FEATSAUTO.VISIBLE]".equals(string)) {
            string = Integer.toString(this.countVisibleFeats(this.getPc().featAutoList(), true, false));
        } else if ("COUNT[FEATSAUTO.HIDDEN]".equals(string)) {
            string = Integer.toString(this.countVisibleFeats(this.getPc().featAutoList(), false, true));
        } else if ("COUNT[FEATSALL]".equals(string) || "COUNT[FEATSALL.VISIBLE]".equals(string)) {
            string = Integer.toString(this.getPc().aggregateVisibleFeatList().size());
        } else if ("COUNT[FEATSALL.ALL]".equals(string)) {
            string = Integer.toString(this.getPc().aggregateFeatList().size());
        } else if ("COUNT[FEATSALL.HIDDEN]".equals(string)) {
            string = Integer.toString(this.countVisibleFeats(this.getPc().aggregateFeatList(), false, true));
        } else if ((string.startsWith("COUNT[FEATTYPE=") || string.startsWith("COUNT[FEATTYPE.")) && string.endsWith(".ALL]")) {
            List<String> list = CoreUtility.split(string.substring(15, string.length() - 5), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().aggregateFeatList(), list, true, true));
        } else if ((string.startsWith("COUNT[FEATTYPE=") || string.startsWith("COUNT[FEATTYPE.")) && string.endsWith(".HIDDEN]")) {
            List<String> list = CoreUtility.split(string.substring(15, string.length() - 8), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().aggregateFeatList(), list, false, true));
        } else if ((string.startsWith("COUNT[FEATTYPE=") || string.startsWith("COUNT[FEATTYPE.")) && string.endsWith(".VISIBLE]")) {
            List<String> list = CoreUtility.split(string.substring(15, string.length() - 9), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().aggregateFeatList(), list, true, false));
        } else if ((string.startsWith("COUNT[FEATTYPE=") || string.startsWith("COUNT[FEATTYPE.")) && string.endsWith("]")) {
            List<String> list = CoreUtility.split(string.substring(15, string.length() - 1), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().aggregateFeatList(), list, true, false));
        } else if ((string.startsWith("COUNT[VFEATTYPE=") || string.startsWith("COUNT[VFEATTYPE.")) && string.endsWith(".ALL]")) {
            List<String> list = CoreUtility.split(string.substring(16, string.length() - 5), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().getVirtualFeatList(), list, true, true));
        } else if ((string.startsWith("COUNT[VFEATTYPE=") || string.startsWith("COUNT[VFEATTYPE.")) && string.endsWith(".HIDDEN]")) {
            List<String> list = CoreUtility.split(string.substring(16, string.length() - 8), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().getVirtualFeatList(), list, false, true));
        } else if ((string.startsWith("COUNT[VFEATTYPE=") || string.startsWith("COUNT[VFEATTYPE.")) && string.endsWith(".VISIBLE]")) {
            List<String> list = CoreUtility.split(string.substring(16, string.length() - 9), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().getVirtualFeatList(), list, true, false));
        } else if ((string.startsWith("COUNT[VFEATTYPE=") || string.startsWith("COUNT[VFEATTYPE.")) && string.endsWith("]")) {
            List<String> list = CoreUtility.split(string.substring(16, string.length() - 1), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().getVirtualFeatList(), list, true, false));
        } else if ((string.startsWith("COUNT[FEATAUTOTYPE=") || string.startsWith("COUNT[FEATAUTOTYPE.")) && string.endsWith(".ALL]")) {
            List<String> list = CoreUtility.split(string.substring(19, string.length() - 5), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().featAutoList(), list, true, true));
        } else if ((string.startsWith("COUNT[FEATAUTOTYPE=") || string.startsWith("COUNT[FEATAUTOTYPE.")) && string.endsWith(".HIDDEN]")) {
            List<String> list = CoreUtility.split(string.substring(19, string.length() - 8), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().featAutoList(), list, false, true));
        } else if ((string.startsWith("COUNT[FEATAUTOTYPE=") || string.startsWith("COUNT[FEATAUTOTYPE.")) && string.endsWith(".VISIBLE]")) {
            List<String> list = CoreUtility.split(string.substring(19, string.length() - 9), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().featAutoList(), list, true, false));
        } else if ((string.startsWith("COUNT[FEATAUTOTYPE=") || string.startsWith("COUNT[FEATAUTOTYPE.")) && string.endsWith("]")) {
            List<String> list = CoreUtility.split(string.substring(19, string.length() - 1), '.');
            string = Integer.toString(this.countVisibleFeatTypes(this.getPc().featAutoList(), list, true, false));
        } else if ((string.startsWith("COUNT[FEATNAME=") || string.startsWith("COUNT[FEATNAME.")) && string.endsWith(".ALL]")) {
            String string8 = string.substring(15, string.length() - 5);
            string = Integer.toString(this.countVisibleFeatsOfKey(this.getPc().aggregateFeatList(), string8, true, true));
        } else if ((string.startsWith("COUNT[FEATNAME=") || string.startsWith("COUNT[FEATNAME.")) && string.endsWith(".HIDDEN]")) {
            String string9 = string.substring(15, string.length() - 8);
            string = Integer.toString(this.countVisibleFeatsOfKey(this.getPc().aggregateFeatList(), string9, false, true));
        } else if ((string.startsWith("COUNT[FEATNAME=") || string.startsWith("COUNT[FEATNAME.")) && string.endsWith(".VISIBLE]")) {
            String string10 = string.substring(15, string.length() - 9);
            string = Integer.toString(this.countVisibleFeatsOfKey(this.getPc().aggregateFeatList(), string10, true, false));
        } else if ((string.startsWith("COUNT[FEATNAME=") || string.startsWith("COUNT[FEATNAME.")) && string.endsWith("]")) {
            String string11 = string.substring(15, string.length() - 1);
            string = Integer.toString(this.countVisibleFeatsOfKey(this.getPc().aggregateFeatList(), string11, true, false));
        } else if (string.startsWith("COUNT[SPELLSKNOWN") && string.endsWith("]")) {
            int n = 0;
            if (SettingsHandler.getPrintSpellsWithPC()) {
                n = this.getPc().countSpellListBook(string);
            }
            string = Integer.toString(n);
        } else if (string.startsWith("COUNT[SPELLSINBOOK") && string.endsWith("]")) {
            string = string.substring(18);
            string = string.substring(0, string.length() - 1);
            int n = 0;
            if (SettingsHandler.getPrintSpellsWithPC()) {
                n = this.getPc().countSpellsInBook(string);
            }
            string = Integer.toString(n);
        } else if (string.startsWith("COUNT[SPELLSLEVELSINBOOK") && string.endsWith("]")) {
            string = string.substring(24);
            string = string.substring(0, string.length() - 1);
            int n = this.getPc().countSpellLevelsInBook(string);
            string = Integer.toString(n);
        } else if (string.startsWith("COUNT[SPELLTIMES") && string.endsWith("]")) {
            string = string.substring(6);
            string = string.substring(0, string.length() - 1);
            string = String.valueOf(this.getPc().countSpellTimes(string));
        } else if (string.startsWith("COUNT[SPELLBOOKS") && string.endsWith("]")) {
            string = Integer.toString(this.getPc().getSpellBooks().size());
        } else if ("COUNT[SPELLCLASSES]".equals(string)) {
            string = String.valueOf(this.getPc().getSpellClassCount());
        } else if ("COUNT[SPELLRACE]".equals(string)) {
            PObject pObject = this.getPc().getSpellClassAtIndex(0);
            string = pObject instanceof Race ? "1" : "0";
        } else if ("COUNT[TEMPBONUSNAMES]".equals(string)) {
            string = String.valueOf(this.getPc().getNamedTempBonusList().size());
        } else if ("COUNT[CLASSES]".equals(string)) {
            this.getPc().getClassList().trimToSize();
            int n = this.getPc().getClassList().size();
            if (SettingsHandler.hideMonsterClasses()) {
                for (PCClass pCClass : this.getPc().getClassList()) {
                    if (!pCClass.isMonster()) continue;
                    --n;
                }
            }
            string = Integer.toString(n);
        } else if ("COUNT[DOMAINS]".equals(string)) {
            string = Integer.toString(this.getPc().getCharacterDomainList().size());
        } else if (string.startsWith("COUNT[EQUIPMENT") && string.endsWith("]")) {
            int n = 0;
            if (string.indexOf("MERGENONE") > 0) {
                n = 1;
            } else if (string.indexOf("MERGELOC") > 0) {
                n = 2;
            }
            ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
            List<Equipment> list = this.getPc().getEquipmentListInOutputOrder(n);
            for (Equipment equipment : list) {
                arrayList.add(equipment);
            }
            if ("COUNT[EQUIPMENT]".equals(string)) {
                string = Integer.toString(arrayList.size());
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(16, string.length() - 1), ".");
                while (stringTokenizer.hasMoreTokens()) {
                    String n7 = stringTokenizer.nextToken();
                    if ("NOT".equalsIgnoreCase(n7)) {
                        arrayList = new ArrayList<Equipment>(EquipmentUtilities.removeEqType(arrayList, stringTokenizer.nextToken()));
                        continue;
                    }
                    if ("ADD".equalsIgnoreCase(n7)) {
                        arrayList = new ArrayList<Equipment>(this.getPc().addEqType(arrayList, stringTokenizer.nextToken()));
                        continue;
                    }
                    if (!"IS".equalsIgnoreCase(n7)) continue;
                    arrayList = new ArrayList<Equipment>(EquipmentUtilities.removeNotEqType(arrayList, stringTokenizer.nextToken()));
                }
                string = Integer.toString(arrayList.size());
            }
            arrayList.clear();
        } else if (string.startsWith("COUNT[EQTYPE.") && string.endsWith("]")) {
            int n = 0;
            List<Object> list = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(13, string.length() - 1), ".");
            String string12 = stringTokenizer.nextToken();
            if ("MERGENONE".equals(string12)) {
                n = 1;
                string12 = stringTokenizer.nextToken();
            } else if ("MERGELOC".equals(string12)) {
                n = 2;
                string12 = stringTokenizer.nextToken();
            }
            if ("CONTAINER".equals(string12)) {
                list.clear();
                List<Equipment> list2 = this.getPc().getEquipmentListInOutputOrder(n);
                for (Equipment equipment : list2) {
                    if (!equipment.acceptsChildren()) continue;
                    list.add(equipment);
                }
            } else if ("WEAPON".equalsIgnoreCase(string12)) {
                list = this.getPc().getExpandedWeapons(n);
            } else if ("ACITEM".equalsIgnoreCase(string12)) {
                List<Equipment> list3 = this.getPc().getEquipmentListInOutputOrder(n);
                for (Equipment equipment : list3) {
                    if (!equipment.getBonusListString("AC") || equipment.isArmor() || equipment.isShield()) continue;
                    list.add(equipment);
                }
            } else {
                list = this.getPc().getEquipmentOfTypeInOutputOrder(string12, 3, n);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if ("NOT".equalsIgnoreCase(string3)) {
                    list = new ArrayList<Equipment>(EquipmentUtilities.removeEqType(list, stringTokenizer.nextToken()));
                    continue;
                }
                if ("ADD".equalsIgnoreCase(string3)) {
                    list = new ArrayList<Equipment>(this.getPc().addEqType(list, stringTokenizer.nextToken()));
                    continue;
                }
                if ("IS".equalsIgnoreCase(string3)) {
                    list = new ArrayList<Equipment>(EquipmentUtilities.removeNotEqType(list, stringTokenizer.nextToken()));
                    continue;
                }
                if (!"EQUIPPED".equalsIgnoreCase(string3) && !"NOTEQUIPPED".equalsIgnoreCase(string3)) continue;
                boolean bl = "EQUIPPED".equalsIgnoreCase(string3);
                for (int i = list.size() - 1; i >= 0; --i) {
                    Equipment equipment = (Equipment)list.get(i);
                    if (equipment.isEquipped() == bl) continue;
                    list.remove(equipment);
                }
            }
            string = Integer.toString(list.size());
            list.clear();
        } else if ("COUNT[CONTAINERS]".equals(string)) {
            ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
            List<Equipment> list = this.getPc().getEquipmentListInOutputOrder(0);
            for (Equipment equipment : list) {
                if (!equipment.acceptsChildren()) continue;
                arrayList.add(equipment);
            }
            string = Integer.toString(arrayList.size());
        } else if ("COUNT[SA]".equals(string)) {
            string = String.valueOf(this.getPc().getSpecialAbilityTimesList().size());
        } else if ("COUNT[TEMPLATES]".equals(string)) {
            this.getPc().getTemplateList().trimToSize();
            string = String.valueOf(this.getPc().getTemplateList().size());
        } else if ("COUNT[RACESUBTYPES]".equals(string)) {
            string = Integer.toString(this.getPc().getRacialSubTypes().size());
        } else if ("COUNT[VISIBLETEMPLATES]".equals(string)) {
            int n = 0;
            for (PCTemplate pCTemplate : this.getPc().getTemplateList()) {
                Visibility visibility = pCTemplate.getVisibility();
                if (visibility != Visibility.DEFAULT && visibility != Visibility.OUTPUT_ONLY) continue;
                ++n;
            }
            string = Integer.toString(n);
        } else if ("COUNT[LANGUAGES]".equals(string)) {
            string = Integer.toString(this.getPc().getLanguagesList().size());
        } else if ("COUNT[MOVE]".equals(string)) {
            string = Integer.toString(this.getPc().getNumberOfMovements());
        } else if ("COUNT[NOTES]".equals(string)) {
            string = Integer.toString(this.getPc().getNotesList().size());
        } else if ("COUNT[VISION]".equals(string)) {
            string = Integer.toString(this.getPc().getVisionList().size());
        } else if ("COUNT[MISC.FUNDS]".equals(string)) {
            string = Integer.toString(Arrays.asList(this.getPc().getMiscList().get(0).split("\r?\n")).size());
        } else if ("COUNT[MISC.COMPANIONS]".equals(string)) {
            string = Integer.toString(Arrays.asList(this.getPc().getMiscList().get(1).split("\r?\n")).size());
        } else if ("COUNT[MISC.MAGIC]".equals(string)) {
            string = Integer.toString(Arrays.asList(this.getPc().getMiscList().get(2).split("\r?\n")).size());
        } else if (string.startsWith("COUNT[FOLLOWERTYPE.") && string.endsWith("]")) {
            if (string.indexOf(".") == string.lastIndexOf(".")) {
                int n = 0;
                String string13 = string.substring(19);
                string13 = string13.substring(0, string13.length() - 1);
                for (Follower follower : this.getPc().getFollowerList()) {
                    if (!follower.getType().equalsIgnoreCase(string13)) continue;
                    ++n;
                }
                string = String.valueOf(n);
            } else {
                List<Follower> list = this.getPc().getFollowerList();
                if (!list.isEmpty()) {
                    void var8_109;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "[]");
                    stringTokenizer.nextToken();
                    String string14 = stringTokenizer.nextToken();
                    stringTokenizer = new StringTokenizer(string14, ".");
                    stringTokenizer.nextToken();
                    String string15 = stringTokenizer.nextToken();
                    String string4 = "";
                    int n = -1;
                    if (stringTokenizer.hasMoreTokens()) {
                        void var8_106;
                        String string5 = stringTokenizer.nextToken();
                        n = Integer.parseInt(string5);
                        String string6 = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            String string7 = (String)var8_106 + "." + stringTokenizer.nextToken();
                        }
                        if (var8_106.indexOf(".") == 0) {
                            String string8 = var8_106.substring(1);
                        }
                    }
                    String string9 = "COUNT[" + (String)var8_109 + "]";
                    ArrayList<Follower> arrayList = new ArrayList<Follower>();
                    for (Cloneable cloneable : list) {
                        if (!cloneable.getType().equalsIgnoreCase(string15)) continue;
                        arrayList.add((Follower)cloneable);
                    }
                    if (n < arrayList.size()) {
                        Follower follower = (Follower)arrayList.get(n);
                        for (PlayerCharacter playerCharacter : Globals.getPCList()) {
                            Cloneable cloneable;
                            if (!follower.getFileName().equals(playerCharacter.getFileName())) continue;
                            cloneable = this.getPc();
                            Globals.setCurrentPC(playerCharacter);
                            string = playerCharacter.getVariableValue(string9, "").toString();
                            Globals.setCurrentPC((PlayerCharacter)cloneable);
                        }
                    }
                }
            }
        } else if (string.startsWith("EQTYPE")) {
            EqTypeToken eqTypeToken = new EqTypeToken();
            string = eqTypeToken.getToken(string, this.getPc(), null);
        } else if (string.startsWith("VARDEFINED:")) {
            string = this.getPc().hasVariable(string.substring(11).trim()) ? "1" : "0";
        } else if (string.startsWith("HASFEAT:")) {
            string = string.substring(8).trim();
            string = this.getPc().hasRealFeatNamed(string) ? "1" : "0";
        } else if (string.startsWith("HASDEITY:")) {
            string = string.substring(9).trim();
            string = this.getPc().hasDeity(string) ? "1" : "0";
        } else if (string.startsWith("MODEQUIP")) {
            string = String.valueOf(this.getPc().modToFromEquipment(string.substring(8)));
        } else if (string.startsWith("WEIGHT.")) {
            if ("CARRIED".equals(string = string.substring(7))) {
                string = this.getPc().totalWeight().toString();
            } else if ("EQUIPPED".equals(string)) {
                string = this.getPc().totalWeight().toString();
            } else if ("PC".equals(string)) {
                string = String.valueOf(this.getPc().getWeight());
            } else if ("TOTAL".equals(string)) {
                Float f = new Float(this.getPc().totalWeight().floatValue() + new Float(this.getPc().getWeight()).floatValue());
                string = f.toString();
            }
        } else if (string.startsWith("PC.SIZE")) {
            Equipment equipment;
            int n = 0;
            if (string2.startsWith("EQ:") && (equipment = this.getPc().getEquipmentNamed(string2.substring(3))) != null) {
                n = (int)this.getPc().getTotalBonusTo("WEAPONPROF=" + equipment.profKey(this.getPc()), "PCSIZE");
                for (String string17 : equipment.typeList()) {
                    int n5 = (int)this.getPc().getTotalBonusTo("WEAPONPROF=TYPE." + string17, "PCSIZE");
                    if (n >= n5) continue;
                    n = n5;
                }
            }
            if (string.equals("PC.SIZE")) {
                string = this.getPc().getSize();
            } else if (string.substring(8).equals("INT")) {
                string = String.valueOf(this.getPc().sizeInt() + n);
            }
        } else {
            string = string.startsWith("PC.HEIGHT") ? Integer.toString(this.getPc().getHeight()) : (string.startsWith("PC.WEIGHT") ? Integer.toString(this.getPc().getWeight()) : null);
        }
        return string;
    }
}

