/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pcgen.core.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableList
implements Cloneable {
    private ArrayList<Variable> list = new ArrayList();
    private List<Variable> unmodifiableList = Collections.unmodifiableList(this.list);
    private Set<String> nameSet = null;

    public final String getDefinition(int n) {
        Variable variable = this.list.get(n);
        return variable.getDefinition();
    }

    public final Variable getVariable(int n) {
        Variable variable = this.list.get(n);
        return variable;
    }

    public final Set<String> getVariableNamesAsUnmodifiableSet() {
        if (this.nameSet == null) {
            this.cacheNames();
        }
        return Collections.unmodifiableSet(this.nameSet);
    }

    public final void add(int n, String string, String string2) {
        Variable variable = new Variable(n, string, string2);
        this.list.add(variable);
        this.clearNameCache();
    }

    public void clear() {
        this.list.clear();
        this.nameSet = null;
    }

    public Object clone() throws CloneNotSupportedException {
        VariableList variableList = (VariableList)super.clone();
        variableList.list = (ArrayList)this.list.clone();
        return variableList;
    }

    public final boolean hasVariableNamed(String string) {
        String string2 = string.toUpperCase();
        if (this.nameSet == null) {
            this.cacheNames();
        }
        return this.nameSet.contains(string2);
    }

    public final Iterator<Variable> iterator() {
        return this.unmodifiableList.iterator();
    }

    public final void set(int n, int n2, String string, String string2) {
        Variable variable = new Variable(n2, string, string2);
        this.list.set(n, variable);
        this.clearNameCache();
    }

    public final int size() {
        return this.list.size();
    }

    protected final void addAll(VariableList variableList) {
        this.list.addAll(variableList.list);
        this.clearNameCache();
    }

    private final void cacheNames() {
        this.nameSet = new HashSet<String>();
        for (Variable variable : this.list) {
            this.nameSet.add(variable.getUpperName());
        }
    }

    private final void clearNameCache() {
        this.nameSet = null;
    }
}

