/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.text.ParseException;
import java.util.Map;
import pcgen.core.Globals;
import pcgen.core.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceEntry {
    private Source theSourceBook = new Source();
    private String thePageNumber = null;

    public SourceEntry() {
    }

    public SourceEntry(Source source) {
        this.theSourceBook = source;
    }

    public SourceEntry(Map<String, String> map) throws ParseException {
        this.theSourceBook = Source.getSource(map);
        this.thePageNumber = map.get((Object)SourceFormat.PAGE);
    }

    public void setFromMap(Map<String, String> map) throws ParseException {
        if (map == null) {
            return;
        }
        this.theSourceBook = Source.getSource(map);
        if (this.thePageNumber == null) {
            this.thePageNumber = map.get((Object)SourceFormat.PAGE);
        }
    }

    public String getPageNumber() {
        return this.thePageNumber;
    }

    public void setPageNumber(String string) {
        this.thePageNumber = string;
    }

    public Source getSourceBook() {
        return this.theSourceBook;
    }

    public void setSourceBook(Source source) {
        this.theSourceBook = source;
    }

    public String getFormattedString(SourceFormat sourceFormat, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getFieldByType(sourceFormat);
        String string2 = null;
        if (this.theSourceBook.getCampaign() != null) {
            string2 = this.theSourceBook.getCampaign().getPublisherWithKey(sourceFormat.toString());
            if (string == null) {
                string = this.theSourceBook.getCampaign().getSourceEntry().getFieldByType(sourceFormat);
            }
        }
        if (string == null) {
            string = "";
        }
        if (sourceFormat.includesPublisher() && string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(" - ");
        }
        stringBuffer.append(string);
        if (bl && sourceFormat.allowsPage() && this.thePageNumber != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.thePageNumber);
        }
        return stringBuffer.toString();
    }

    public String getFieldByType(SourceFormat sourceFormat) {
        switch (sourceFormat) {
            case LONG: {
                return this.theSourceBook.getLongName();
            }
            case MEDIUM: {
                return this.theSourceBook.getLongName();
            }
            case SHORT: {
                return this.theSourceBook.getShortName();
            }
            case WEB: {
                return this.theSourceBook.getWebsite();
            }
            case DATE: {
                if (this.theSourceBook.getDate() != null) {
                    return this.theSourceBook.getDate().toString();
                }
                return "";
            }
            case PAGE: {
                return this.thePageNumber;
            }
        }
        return this.theSourceBook.getLongName();
    }

    public String toString() {
        return this.getFormattedString(Globals.getSourceDisplay(), true);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.thePageNumber == null ? 0 : this.thePageNumber.hashCode());
        n = 31 * n + (this.theSourceBook == null ? 0 : this.theSourceBook.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SourceEntry sourceEntry = (SourceEntry)object;
        if (this.thePageNumber != null && sourceEntry.thePageNumber != null && !this.thePageNumber.equals(sourceEntry.thePageNumber)) {
            return false;
        }
        return !(this.theSourceBook == null ? sourceEntry.theSourceBook != null : !this.theSourceBook.equals(sourceEntry.theSourceBook));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceFormat {
        LONG("LONG"),
        MEDIUM("LONG"),
        SHORT("SHORT"),
        WEB("WEB"),
        DATE("DATE"),
        PAGE("PAGE");

        private final String theKey;

        private SourceFormat(String string2) {
            this.theKey = string2;
        }

        public String toString() {
            return this.theKey;
        }

        public final boolean includesPublisher() {
            return this != SHORT && this != MEDIUM;
        }

        public final boolean allowsPage() {
            return this != WEB;
        }

        public static SourceFormat valueOf(int n) {
            return SourceFormat.values()[n];
        }
    }
}

