/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.CharacterDomain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.KitUtilities;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Skill
extends PObject {
    public static final String COST_CLASS = "CLASS";
    public static final String COST_XCLASS = "CROSS-CLASS";
    public static final String COST_EXCL = "EXCLUSIVE";
    private static final String COST_UNK = "UNKNOWN";
    private static final int ACHECK_NONE = 0;
    private static final int ACHECK_YES = 1;
    private static final int ACHECK_NONPROF = 2;
    private static final int ACHECK_WEIGHT = 3;
    private static final int ACHECK_DOUBLE = 4;
    public static final int INCLUDE_SKILLS_NONE = 0;
    public static final int INCLUDE_SKILLS_UNTRAINED = 1;
    public static final int INCLUDE_SKILLS_ALL = 2;
    public static final int INCLUDE_SKILLS_AS_UI = 3;
    private List<String> classList = new ArrayList<String>();
    private List<String> rankList = new ArrayList<String>();
    private String keyStat = "";
    private String rootName = "";
    private boolean skillReadOnly = false;
    private boolean canUseUntrained = true;
    private boolean isExclusive = false;
    private boolean required = false;
    private int aCheck = 0;
    private int outputIndex = 0;

    public void setACheck(String string) {
        if (string.length() != 0) {
            switch (string.charAt(0)) {
                case 'N': {
                    this.aCheck = 0;
                    break;
                }
                case 'Y': {
                    this.aCheck = 1;
                    break;
                }
                case 'P': {
                    this.aCheck = 2;
                    break;
                }
                case 'D': {
                    this.aCheck = 4;
                    break;
                }
                case 'W': {
                    this.aCheck = 3;
                    break;
                }
            }
        }
    }

    public void setACheck(int n) {
        this.aCheck = n;
    }

    public int getACheck() {
        return this.aCheck;
    }

    public List<String> getClassList() {
        return this.classList;
    }

    public boolean isClassSkill(PCClass pCClass, PlayerCharacter playerCharacter) {
        if (playerCharacter == null || pCClass == null) {
            return false;
        }
        if (playerCharacter.getRace().hasCSkill(this.keyName)) {
            return true;
        }
        if (pCClass.hasSkill(this.keyName)) {
            return true;
        }
        if (pCClass.hasCSkill(this.keyName)) {
            return true;
        }
        if (pCClass.hasClassSkill(this.keyName)) {
            return true;
        }
        if (pCClass.isMonster() && playerCharacter.getRace().hasMonsterCSkill(this.keyName)) {
            return true;
        }
        for (String object2 : this.classList) {
            if (object2.length() > 0 && object2.charAt(0) == '!' && (object2.substring(1).equalsIgnoreCase(pCClass.getKeyName()) || object2.substring(1).equalsIgnoreCase(pCClass.getSubClassKey()))) {
                return false;
            }
            if (!"ALL".equals(object2) && !object2.equalsIgnoreCase(pCClass.getKeyName()) && !object2.equalsIgnoreCase(pCClass.getSubClassKey()) && (pCClass.getClassSkillList() == null || !pCClass.getClassSkillList().contains(object2))) continue;
            return true;
        }
        for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
            if (characterDomain.getDomain() == null || !characterDomain.isFromPCClass(pCClass.getKeyName()) || !characterDomain.getDomain().hasCSkill(this.keyName)) continue;
            return true;
        }
        if (playerCharacter.getDeity() != null && playerCharacter.getDeity().hasCSkill(this.keyName)) {
            return true;
        }
        for (Ability ability : playerCharacter.aggregateFeatList()) {
            if (!ability.hasCSkill(this.keyName)) continue;
            return true;
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            if (!skill.hasCSkill(this.keyName)) continue;
            return true;
        }
        for (Equipment equipment : playerCharacter.getEquipmentList()) {
            if (!equipment.isEquipped()) continue;
            if (equipment.hasCSkill(this.keyName)) {
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                if (!equipmentModifier.hasCSkill(this.keyName)) continue;
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                if (!equipmentModifier.hasCSkill(this.keyName)) continue;
                return true;
            }
        }
        for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
            if (!pCTemplate.hasCSkill(this.keyName)) continue;
            return true;
        }
        return false;
    }

    public String getExclusive() {
        return this.isExclusive ? "Y" : "N";
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setIsExclusive(boolean bl) {
        this.isExclusive = bl;
    }

    public void setKeyStat(String string) {
        this.keyStat = string;
    }

    public String getKeyStat() {
        return this.keyStat;
    }

    public void setOutputIndex(int n) {
        this.outputIndex = n;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    @Override
    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        if (this.keyStat.length() != 0) {
            stringBuffer.append("\tKEYSTAT:").append(this.keyStat);
        }
        if (this.isExclusive) {
            stringBuffer.append("\tEXCLUSIVE:YES");
        }
        if (!this.isUntrained()) {
            stringBuffer.append("\tUSEUNTRAINED:NO");
        }
        StringBuffer stringBuffer2 = new StringBuffer(100);
        for (String string : this.getClassList()) {
            if (stringBuffer2.length() != 0) {
                stringBuffer2.append('|');
            }
            stringBuffer2.append(string);
        }
        if (stringBuffer2.length() != 0) {
            stringBuffer.append("\tCLASSES:").append(stringBuffer2);
        }
        if (this.aCheck != 0) {
            stringBuffer.append("\tACHECK:");
            switch (this.aCheck) {
                case 1: {
                    stringBuffer.append("YES");
                    break;
                }
                case 2: {
                    stringBuffer.append("PROFICIENT");
                    break;
                }
                case 3: {
                    stringBuffer.append("WEIGHT");
                    break;
                }
                case 4: {
                    stringBuffer.append("DOUBLE");
                    break;
                }
                default: {
                    stringBuffer.append("ERROR");
                }
            }
        }
        if (this.getVisibility() != Visibility.DEFAULT) {
            stringBuffer.append("\tVISIBLE:");
            switch (this.getVisibility()) {
                case OUTPUT_ONLY: {
                    stringBuffer.append("EXPORT");
                    break;
                }
                case DISPLAY_ONLY: {
                    stringBuffer.append("GUI");
                    break;
                }
                default: {
                    stringBuffer.append("YES");
                }
            }
        }
        stringBuffer.append(super.getPCCText(false));
        return stringBuffer.toString();
    }

    public Float getRank() {
        double d = 0.0;
        for (int i = 0; i < this.rankList.size(); ++i) {
            String string = this.rankList.get(i);
            int n = string.indexOf(58);
            d += Double.parseDouble(string.substring(n + 1));
        }
        return new Float(d);
    }

    public List<String> getRankList() {
        return this.rankList;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setRootName(String string) {
        this.rootName = string;
    }

    public String getSkillCostType(PCClass pCClass, PlayerCharacter playerCharacter) {
        if (this.costForPCClass(pCClass, playerCharacter) == Globals.getGameModeSkillCost_Class()) {
            return COST_CLASS;
        }
        if (this.costForPCClass(pCClass, playerCharacter) == Globals.getGameModeSkillCost_CrossClass()) {
            return COST_XCLASS;
        }
        if (this.isExclusive) {
            return COST_EXCL;
        }
        return COST_UNK;
    }

    public int getSubtypeCount() {
        int n = this.getMyTypeCount();
        if (n == 0) {
            return 0;
        }
        return n - 1;
    }

    public Iterator<String> getSubtypeIterator() {
        Iterator<String> iterator = this.getTypeList(false).iterator();
        if (iterator.hasNext() && this.keyStat.length() != 0) {
            iterator.next();
        }
        return iterator;
    }

    public Float getTotalRank(PlayerCharacter playerCharacter) {
        double d = this.getRank().doubleValue();
        double d2 = d + this.getRankAdj(playerCharacter).doubleValue();
        if (!Globals.checkRule("SKILLMAX") && playerCharacter.getClassList().size() > 0) {
            double d3 = playerCharacter.getMaxRank(this.getKeyName(), playerCharacter.getClassList().get(0)).doubleValue();
            d3 = Math.max(d3, d);
            d2 = Math.min(d3, d2);
        }
        return new Float(d2);
    }

    public void setUntrained(boolean bl) {
        this.canUseUntrained = bl;
    }

    public boolean isUntrained() {
        return this.canUseUntrained;
    }

    public void setZeroRanks(PCClass pCClass, PlayerCharacter playerCharacter) {
        int n;
        if (pCClass == null) {
            return;
        }
        String string = pCClass.getKeyName();
        String string2 = "";
        String string3 = string + ":";
        for (n = 0; n < this.rankList.size() && !(string2 = this.rankList.get(n)).startsWith(string3); ++n) {
        }
        if (n >= this.rankList.size()) {
            return;
        }
        double d = Double.parseDouble(string2.substring(string.length() + 1));
        String string4 = this.modRanks(-d, pCClass, false, playerCharacter);
        if (string4.length() != 0) {
            Logging.debugPrint(string4);
        }
    }

    public void addClassList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() > 0 && string2.charAt(0) == '!' && this.classList.size() > 0) {
                this.classList.add(0, string2);
                continue;
            }
            this.classList.add(string2);
        }
    }

    public static boolean chooseLanguageForSkill(PlayerCharacter playerCharacter) {
        Skill skill = null;
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        for (Skill skill2 : arrayList) {
            if (skill2.getChoiceString().toLowerCase().indexOf("language") < 0) continue;
            skill = skill2;
        }
        return Skill.chooseLanguageForSkill(playerCharacter, skill);
    }

    public static boolean chooseLanguageForSkill(PlayerCharacter playerCharacter, Skill skill) {
        if (playerCharacter != null) {
            int n;
            String[] stringArray;
            Object object;
            String[] stringArray2;
            if (skill == null) {
                ShowMessageDelegate.showMessageDialog("You do not have enough ranks in Speak Language", "PCGen", MessageType.ERROR);
                return false;
            }
            int n2 = skill.getTotalRank(playerCharacter).intValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Language> arrayList2 = new ArrayList<Language>();
            ArrayList<Language> arrayList3 = new ArrayList<Language>();
            ArrayList<Language> arrayList4 = new ArrayList<Language>();
            String string = null;
            if (skill.getChoiceString().toLowerCase().indexOf("language(") >= 0 && (stringArray2 = skill.getChoiceString().split("[\\(\\)]")).length >= 2) {
                string = stringArray2[1];
            }
            if (string == null) {
                stringArray2 = null;
            } else {
                object = string.split(",");
                stringArray2 = new String[((String[])object).length][];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    stringArray2[i] = ((String)object[i]).split("\\.");
                }
            }
            skill.addAssociatedTo(arrayList);
            for (String string2 : arrayList) {
                stringArray = Globals.getLanguageKeyed(string2);
                if (stringArray == null) continue;
                if (stringArray2 == null) {
                    arrayList2.add((Language)stringArray);
                    continue;
                }
                String[] stringArray3 = stringArray2;
                n = stringArray3.length;
                block2: for (int i = 0; i < n; ++i) {
                    String string3;
                    String string4 = string3 = stringArray3[i];
                    int n3 = ((String)string4).length;
                    for (int j = 0; j < n3; ++j) {
                        String string5 = string4[j];
                        if (!stringArray.isType(string5)) continue block2;
                    }
                    arrayList2.add((Language)stringArray);
                }
            }
            for (Language language : Globals.getLanguageList()) {
                if (!PrereqHandler.passesAll(language.getPreReqList(), playerCharacter, language)) continue;
                if (stringArray2 == null) {
                    arrayList3.add(language);
                    continue;
                }
                stringArray = stringArray2;
                int n4 = stringArray.length;
                block5: for (n = 0; n < n4; ++n) {
                    String string6;
                    for (String string7 : string6 = stringArray[n]) {
                        if (!language.isType(string7)) continue block5;
                    }
                    arrayList3.add(language);
                }
            }
            for (Language language : playerCharacter.getAutoLanguages()) {
                arrayList3.remove(language);
                arrayList4.add(language);
            }
            for (Language language : playerCharacter.getLanguagesList()) {
                if (arrayList2.contains(language)) continue;
                if (string == null || language.isType(string)) {
                    arrayList3.remove(language);
                }
                arrayList4.add(language);
            }
            Globals.sortChooserLists(arrayList3, arrayList2);
            object = ChooserFactory.getChooserInstance();
            object.setVisible(false);
            object.setAvailableList(arrayList3);
            object.setSelectedList(arrayList2);
            object.setPool(n2 - arrayList2.size());
            object.setPoolFlag(false);
            object.setVisible(true);
            playerCharacter.clearLanguages();
            playerCharacter.addLanguages(arrayList2);
            playerCharacter.addLanguages(arrayList4);
            skill.clearAssociated();
            Iterator iterator = object.getSelectedList().iterator();
            while (iterator.hasNext()) {
                skill.addAssociated(((Language)iterator.next()).getKeyName());
            }
            playerCharacter.setDirty(true);
            return true;
        }
        return false;
    }

    public void setReadOnly(boolean bl) {
        this.skillReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.skillReadOnly;
    }

    @Override
    public Skill clone() {
        Skill skill = null;
        try {
            skill = (Skill)super.clone();
            skill.required = this.required;
            skill.setRootName(this.rootName);
            skill.setKeyStat(this.getKeyStat());
            skill.setIsExclusive(this.isExclusive());
            skill.rankList = new ArrayList<String>(this.rankList);
            skill.setUntrained(this.isUntrained());
            skill.classList = new ArrayList<String>(this.classList);
            skill.aCheck = this.aCheck;
            skill.skillReadOnly = this.skillReadOnly;
            skill.outputIndex = this.outputIndex;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return skill;
    }

    public int costForPCClass(PCClass pCClass, PlayerCharacter playerCharacter) {
        int n = this.isClassSkill(pCClass, playerCharacter) ? Globals.getGameModeSkillCost_Class() : (!this.isCrossClassSkill(pCClass, playerCharacter) && this.isExclusive ? Globals.getGameModeSkillCost_Exclusive() : Globals.getGameModeSkillCost_CrossClass());
        return n;
    }

    public String modRanks(double d, PCClass pCClass, PlayerCharacter playerCharacter) {
        return this.modRanks(d, pCClass, false, playerCharacter);
    }

    public String modRanks(double d, PCClass pCClass, boolean bl, PlayerCharacter playerCharacter) {
        int n;
        double d2;
        int n2;
        int n3 = 0;
        if (!bl) {
            if (pCClass == null) {
                return "You must be at least level one before you can purchase skills.";
            }
            if (d > 0.0 && !PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this)) {
                return "You do not meet the prerequisites required to take this skill.";
            }
            n3 = this.costForPCClass(pCClass, playerCharacter);
            if (n3 == Globals.getGameModeSkillCost_Exclusive()) {
                return "You cannot purchase this exclusive skill.";
            }
            if (d > 0.0 && (double)pCClass.getSkillPool(playerCharacter) < d * (double)n3) {
                return "You do not have enough skill points.";
            }
            double d3 = playerCharacter.getMaxRank(this.keyName, pCClass).doubleValue();
            if (!Globals.checkRule("SKILLMAX") && d > 0.0) {
                double d4 = this.getTotalRank(playerCharacter).doubleValue();
                if (d4 >= d3) {
                    return "Skill rank at maximum (" + d3 + ") for your level.";
                }
                if (d4 + d > d3) {
                    return "Raising skill would make it above maximum (" + d3 + ") for your level.";
                }
            }
        }
        if (this.getRank().doubleValue() + d < 0.0) {
            return "Cannot lower rank below 0";
        }
        String string = "None";
        if (pCClass != null) {
            string = pCClass.getKeyName();
        }
        String string2 = "";
        String string3 = string + ":";
        for (n2 = 0; n2 < this.rankList.size() && !(string2 = this.rankList.get(n2)).startsWith(string3); ++n2) {
        }
        if (n2 >= this.rankList.size()) {
            if (d < 0.0) {
                for (n2 = 0; n2 < this.rankList.size() && !(string2 = this.rankList.get(n2)).startsWith("None:"); ++n2) {
                }
            }
            if (n2 >= this.rankList.size()) {
                string2 = string + ":0";
            }
        }
        if (CoreUtility.doublesEqual(d2 = Double.parseDouble(string2.substring((n = string2.indexOf(58)) + 1)), 0.0) && d < 0.0) {
            return "No more ranks found for class: " + string + ". Try a different one.";
        }
        if (n2 >= this.rankList.size()) {
            this.rankList.add(n2, string2);
        }
        d = this.modRanks2(d, n2, string2, playerCharacter);
        if (!bl) {
            if (pCClass != null) {
                pCClass.setSkillPool(pCClass.getSkillPool(playerCharacter) - (int)((double)n3 * d));
            }
            playerCharacter.setSkillPoints(playerCharacter.getSkillPoints() - (int)((double)n3 * d));
        }
        return "";
    }

    public Integer modifier(PlayerCharacter playerCharacter) {
        String string2;
        int n = 0;
        if (playerCharacter == null) {
            return 0;
        }
        int n2 = SettingsHandler.getGame().getStatFromAbbrev(this.keyStat);
        if (n2 >= 0) {
            n = playerCharacter.getStatList().getStatModFor(this.keyStat);
            n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "STAT." + this.keyStat));
        }
        n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", this.keyName));
        for (String string2 : this.getTypeList(false)) {
            n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "TYPE." + string2));
        }
        n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "LIST"));
        n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "ALL"));
        if (this.isClassSkill(playerCharacter.getClassList(), playerCharacter)) {
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CSKILL", this.keyName));
            for (String string2 : this.getTypeList(false)) {
                n = (int)((double)n + playerCharacter.getTotalBonusTo("CSKILL", "TYPE." + string2));
            }
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CSKILL", "LIST"));
        }
        if (!this.isClassSkill(playerCharacter.getClassList(), playerCharacter) && !this.isExclusive()) {
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CCSKILL", this.keyName));
            for (String string2 : this.getTypeList(false)) {
                n = (int)((double)n + playerCharacter.getTotalBonusTo("CCSKILL", "TYPE." + string2));
            }
            n = (int)((double)n + playerCharacter.getTotalBonusTo("CCSKILL", "LIST"));
        }
        n += playerCharacter.getRace().bonusForSkill(this.getKeyName());
        int n3 = this.calcACheckBonus(playerCharacter);
        n += n3;
        string2 = Globals.getGameModeRankModFormula();
        if (string2.length() != 0) {
            string2 = CoreUtility.replaceAll(string2, "$$RANK$$", this.getTotalRank(playerCharacter).toString());
            n += playerCharacter.getVariableValue(string2, "").intValue();
        }
        return n;
    }

    private int calcACheckBonus(PlayerCharacter playerCharacter) {
        if (this.aCheck == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        Float f = playerCharacter.totalWeight();
        if (Globals.checkRule("SYS_WTPSK")) {
            if (this.aCheck == 3 && Globals.checkRule("SYS_WTPSK")) {
                n2 = -((int)(f.doubleValue() / 5.0));
            } else if (this.aCheck != 3) {
                Object object;
                if (this.aCheck != 2 && Globals.checkRule("SYS_LDPACSK")) {
                    object = Globals.loadTypeForLoadScore(playerCharacter.getVariableValue("LOADSCORE", "").intValue(), playerCharacter.totalWeight(), playerCharacter);
                    int n3 = 0;
                    switch (1.$SwitchMap$pcgen$util$enumeration$Load[((Enum)object).ordinal()]) {
                        case 1: {
                            n3 = SystemCollections.getLoadInfo().getLoadCheckPenalty("LIGHT");
                            break;
                        }
                        case 2: {
                            n3 = SystemCollections.getLoadInfo().getLoadCheckPenalty("MEDIUM");
                            break;
                        }
                        case 3: 
                        case 4: {
                            n3 = SystemCollections.getLoadInfo().getLoadCheckPenalty("HEAVY");
                            break;
                        }
                        default: {
                            Logging.errorPrint(this.getDisplayName() + ":in Skill.modifier the load " + object + " is not supported.");
                        }
                    }
                    n = this.aCheck == 4 ? 2 * n3 : n3;
                }
                object = playerCharacter.getEquipmentOfType("Armor", 1);
                for (Equipment equipment : playerCharacter.getEquipmentOfType("Shield", 1)) {
                    if (object.contains(equipment)) continue;
                    object.add(equipment);
                }
                Iterator<Equipment> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Equipment equipment;
                    equipment = iterator.next();
                    if (this.aCheck == 1 || this.aCheck == 2 && !playerCharacter.isProficientWith(equipment)) {
                        n2 += equipment.acCheck(playerCharacter).intValue();
                        continue;
                    }
                    if (this.aCheck != 4) continue;
                    n2 += 2 * equipment.acCheck(playerCharacter);
                }
            }
        }
        return Math.min(n2 += (int)playerCharacter.getTotalBonusTo("MISC", "ACCHECK"), n);
    }

    public String qualifiedName() {
        if (this.getAssociatedCount() == 0) {
            return this.getOutputName();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getAssociatedCount() * 20);
        stringBuffer.append(this.getOutputName()).append("(");
        for (int i = 0; i < this.getAssociatedCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getAssociated(i));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean isClassSkill(PlayerCharacter playerCharacter) {
        return this.isClassSkill(playerCharacter.getClassList(), playerCharacter);
    }

    boolean isClassSkill(List<PCClass> list, PlayerCharacter playerCharacter) {
        for (PCClass pCClass : list) {
            if (!this.isClassSkill(pCClass, playerCharacter)) continue;
            return true;
        }
        return false;
    }

    boolean isRequired() {
        return this.required;
    }

    public String getRootName() {
        return this.rootName;
    }

    public int costForPCClassList(List<PCClass> list, PlayerCharacter playerCharacter) {
        int n = Globals.getGameModeSkillCost_Exclusive();
        int n2 = list.size();
        if (n2 == 0) {
            return n;
        }
        for (PCClass pCClass : list) {
            int n3 = this.costForPCClass(pCClass, playerCharacter);
            if (n3 == Globals.getGameModeSkillCost_Class()) {
                return n3;
            }
            if (n3 == n) continue;
            n = n3;
        }
        return n;
    }

    void replaceClassRank(String string, String string2) {
        String string3 = string + ":";
        for (int i = 0; i < this.rankList.size(); ++i) {
            String string4 = this.rankList.get(i);
            if (!string4.startsWith(string3)) continue;
            this.rankList.set(i, string2 + string4.substring(string.length()));
        }
    }

    private boolean isCrossClassSkill(PCClass pCClass, PlayerCharacter playerCharacter) {
        if (this.isClassSkill(pCClass, playerCharacter)) {
            return false;
        }
        if (playerCharacter == null || pCClass == null) {
            return false;
        }
        if (playerCharacter.getRace().hasCcSkill(this.keyName)) {
            return true;
        }
        for (CharacterDomain object2 : playerCharacter.getCharacterDomainList()) {
            if (object2.getDomain() == null || !object2.isFromPCClass(pCClass.getKeyName()) || !object2.getDomain().hasCcSkill(this.keyName)) continue;
            return true;
        }
        if (playerCharacter.getDeity() != null && playerCharacter.getDeity().hasCcSkill(this.keyName)) {
            return true;
        }
        if (pCClass.hasCcSkill(this.keyName)) {
            return true;
        }
        if (pCClass.isMonster() && playerCharacter.getRace().hasMonsterCCSkill(this.keyName)) {
            return true;
        }
        for (Ability ability : playerCharacter.aggregateFeatList()) {
            if (!ability.hasCcSkill(this.keyName)) continue;
            return true;
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            if (!skill.hasCcSkill(this.keyName)) continue;
            return true;
        }
        for (Equipment equipment : playerCharacter.getEquipmentList()) {
            if (!equipment.isEquipped()) continue;
            if (equipment.hasCcSkill(this.keyName)) {
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                if (!equipmentModifier.hasCcSkill(this.keyName)) continue;
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                if (!equipmentModifier.hasCcSkill(this.keyName)) continue;
                return true;
            }
        }
        for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
            if (!pCTemplate.hasCcSkill(this.keyName)) continue;
            return true;
        }
        return false;
    }

    private Float getRankAdj(PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            return Float.valueOf(0.0f);
        }
        return new Float(this.getSkillRankBonusTo(playerCharacter));
    }

    private double modRanks2(double d, int n, String string, PlayerCharacter playerCharacter) {
        String string2;
        int n2 = string.indexOf(58);
        double d2 = Double.parseDouble(string.substring(n2 + 1));
        double d3 = d2 + d;
        if (!(playerCharacter.isImporting() || (string2 = this.getChoiceString()).length() <= 0 || CoreUtility.doublesEqual(d, 0.0) || CoreUtility.doublesEqual(d2, (int)d3))) {
            ArrayList arrayList = new ArrayList();
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string2.startsWith("Language")) {
                string = string.substring(0, n2 + 1) + d3;
                this.rankList.set(n, string);
                if (!Skill.chooseLanguageForSkill(playerCharacter, this)) {
                    d3 = d2;
                } else {
                    int n3;
                    int n4 = this.getAssociatedCount();
                    if (n4 > (n3 = this.getTotalRank(playerCharacter).intValue())) {
                        d3 = d2;
                    }
                }
                d = d3 - d2;
            } else {
                ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
                if (string3.length() != 0) {
                    chooserInterface.setTitle(string3);
                }
                chooserInterface.setPool((int)(d + d2 + 0.0) - this.getAssociatedCount());
                chooserInterface.setPoolFlag(false);
                chooserInterface.setAvailableList(arrayList);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                this.addAssociatedTo(arrayList2);
                chooserInterface.setSelectedList(arrayList2);
                chooserInterface.setVisible(true);
                int n5 = chooserInterface.getSelectedList().size();
                d3 = (double)n5 - 0.0;
                d = d3 - this.getRank().doubleValue();
            }
        }
        if (CoreUtility.doublesEqual(d3, 0.0)) {
            this.rankList.remove(n);
        } else {
            string = string.substring(0, n2 + 1) + d3;
            this.rankList.set(n, string);
        }
        playerCharacter.calcActiveBonuses();
        return d;
    }

    public String getModifierExplanation(PlayerCharacter playerCharacter, boolean bl) {
        String string2;
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        for (BonusObj bonusObj : this.getBonusList()) {
            double d2 = bonusObj.getCalculatedValue(playerCharacter);
            if (!bonusObj.isApplied() || CoreUtility.doublesEqual(d2, 0.0) || "VAR".equals(bonusObj.getBonusName())) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(bonusObj.getDescription(bl, playerCharacter));
            d += d2;
        }
        if (SettingsHandler.getGame().getStatFromAbbrev(this.keyStat) >= 0) {
            double d3 = playerCharacter.getStatList().getStatModFor(this.keyStat);
            this.appendBonusDesc(stringBuffer, d3 += playerCharacter.getTotalBonusTo("SKILL", "STAT." + this.keyStat), "STAT");
        }
        double d4 = playerCharacter.getTotalBonusTo("SKILL", this.keyName) - d;
        this.appendBonusDesc(stringBuffer, d4, "OTHER");
        for (String string2 : this.getTypeList(false)) {
            d4 = playerCharacter.getTotalBonusTo("SKILL", "TYPE." + string2);
            this.appendBonusDesc(stringBuffer, d4, "TYPE." + string2);
        }
        d4 = playerCharacter.getTotalBonusTo("SKILL", "LIST");
        this.appendBonusDesc(stringBuffer, d4, "LIST");
        d4 = playerCharacter.getTotalBonusTo("SKILL", "ALL");
        this.appendBonusDesc(stringBuffer, d4, "ALL");
        if (this.isClassSkill(playerCharacter.getClassList(), playerCharacter)) {
            d4 = playerCharacter.getTotalBonusTo("CSKILL", this.keyName);
            this.appendBonusDesc(stringBuffer, d4, "CSKILL");
            for (String string2 : this.getTypeList(false)) {
                d4 = playerCharacter.getTotalBonusTo("CSKILL", "TYPE." + string2);
                this.appendBonusDesc(stringBuffer, d4, "CSKILL");
            }
            d4 = playerCharacter.getTotalBonusTo("CSKILL", "LIST");
            this.appendBonusDesc(stringBuffer, d4, "CSKILL");
        }
        if (!this.isClassSkill(playerCharacter.getClassList(), playerCharacter) && !this.isExclusive()) {
            d4 = playerCharacter.getTotalBonusTo("CCSKILL", this.keyName);
            this.appendBonusDesc(stringBuffer, d4, "CCSKILL");
            for (String string2 : this.getTypeList(false)) {
                d4 = playerCharacter.getTotalBonusTo("CCSKILL", "TYPE." + string2);
                this.appendBonusDesc(stringBuffer, d4, "CCSKILL");
            }
            d4 = playerCharacter.getTotalBonusTo("CCSKILL", "LIST");
            this.appendBonusDesc(stringBuffer, d4, "CCSKILL");
        }
        d4 = playerCharacter.getRace().bonusForSkill(this.getKeyName());
        this.appendBonusDesc(stringBuffer, d4, "RACE");
        int n = this.calcACheckBonus(playerCharacter);
        this.appendBonusDesc(stringBuffer, n, "ARMOR");
        string2 = Globals.getGameModeRankModFormula();
        if (string2.length() != 0) {
            string2 = CoreUtility.replaceAll(string2, "$$RANK$$", this.getTotalRank(playerCharacter).toString());
            d4 = playerCharacter.getVariableValue(string2, "").intValue();
            this.appendBonusDesc(stringBuffer, d4, "RANKS");
        }
        return stringBuffer.toString();
    }

    public String getRanksExplanation() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getRankList().size(); ++i) {
            stringBuffer.append(this.getRankList().get(i));
            if (i + 1 >= this.getRankList().size()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void appendBonusDesc(StringBuffer stringBuffer, double d, String string) {
        String string2;
        if (CoreUtility.doublesEqual(d, 0.0)) {
            return;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        if ((string2 = Delta.toString((float)d)).endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        stringBuffer.append(string2);
        stringBuffer.append('[').append(string).append(']');
    }

    public double getSkillRankBonusTo(PlayerCharacter playerCharacter) {
        double d = playerCharacter.getTotalBonusTo("SKILLRANK", this.getKeyName());
        for (String string : this.getTypeList(false)) {
            d += playerCharacter.getTotalBonusTo("SKILLRANK", "TYPE." + string);
        }
        this.updateAdds(playerCharacter, d);
        return d;
    }

    private void updateAdds(PlayerCharacter playerCharacter, double d) {
        List<LevelAbility> list = this.getLevelAbilityList();
        if (list != null) {
            int n = 0;
            for (LevelAbility levelAbility : list) {
                n += levelAbility.getAssociatedCount();
            }
            if (CoreUtility.doublesEqual(this.getRank().doubleValue() + d, 0.0)) {
                if (n != 0) {
                    this.subAddsForLevel(-9, playerCharacter);
                }
            } else if (n == 0) {
                this.addAddsForLevel(-9, playerCharacter, null);
            }
        }
    }

    @Override
    protected void globalChecks(boolean bl, PlayerCharacter playerCharacter) {
        playerCharacter.setArmorProfListStable(false);
        List<String> list = this.getSafeListFor(ListKey.KITS);
        for (int i = 0; i > list.size(); ++i) {
            KitUtilities.makeKitSelections(0, list.get(i), i, playerCharacter);
        }
        this.makeRegionSelection(playerCharacter);
        if (bl) {
            this.makeChoices(playerCharacter);
        }
        this.activateBonuses(playerCharacter);
    }

    public String getKeyStatFromStats() {
        String string = this.getKeyStat();
        if (string.length() == 0 && Globals.getGameModeHasPointPool()) {
            List<PCStat> list = this.getKeyStatList(null);
            for (int i = 0; i < list.size(); ++i) {
                PCStat pCStat = list.get(i);
                if (string.length() != 0) {
                    string = string + '/';
                }
                string = string + pCStat.getAbb();
            }
        }
        return string;
    }

    public int getStatMod(PlayerCharacter playerCharacter) {
        String string = this.getKeyStat();
        if (string.length() != 0) {
            return playerCharacter.getStatList().getStatModFor(string);
        }
        int n = 0;
        if (Globals.getGameModeHasPointPool()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.getKeyStatList(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                n = (int)((double)n + playerCharacter.getTotalBonusTo("SKILL", "TYPE." + arrayList.get(i)));
            }
        }
        return n;
    }

    public List<PCStat> getKeyStatList(List<String> list) {
        ArrayList<PCStat> arrayList = new ArrayList<PCStat>();
        if (Globals.getGameModeHasPointPool()) {
            for (String string : this.getTypeList(false)) {
                List<PCStat> list2 = SettingsHandler.getGame().getUnmodifiableStatList();
                for (int i = list2.size() - 1; i >= 0; --i) {
                    PCStat pCStat = list2.get(i);
                    List<BonusObj> list3 = this.getBonusListOfType(pCStat, Bonus.getBonusTypeFromName("SKILL"), "TYPE." + string);
                    if (list3.size() <= 0) continue;
                    for (int j = list3.size() - 1; j >= 0; --j) {
                        arrayList.add(pCStat);
                    }
                    if (list == null || list.contains(string)) continue;
                    list.add(string);
                }
            }
        }
        return arrayList;
    }

    private List<BonusObj> getBonusListOfType(PCStat pCStat, int n, String string) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : pCStat.getBonusList()) {
            if (bonusObj.getTypeOfBonusAsInt() != n) continue;
            if (bonusObj.getBonusInfoList().size() > 1) {
                StringTokenizer stringTokenizer = new StringTokenizer(bonusObj.getBonusInfo(), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string2.equalsIgnoreCase(string)) continue;
                    arrayList.add(bonusObj);
                }
                continue;
            }
            if (!bonusObj.getBonusInfo().equalsIgnoreCase(string)) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    @Override
    boolean isTypeHidden(String string) {
        return Globals.isSkillTypeHidden(string);
    }
}

