/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Campaign;
import pcgen.core.Categorisable;
import pcgen.core.CharacterDomain;
import pcgen.core.DamageReduction;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.EquipmentUtilities;
import pcgen.core.FollowerOption;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.HasCost;
import pcgen.core.Kit;
import pcgen.core.KitUtilities;
import pcgen.core.Language;
import pcgen.core.Movement;
import pcgen.core.NoteItem;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacterUtilities;
import pcgen.core.PointBuyMethod;
import pcgen.core.PrereqObject;
import pcgen.core.Race;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SkillComparator;
import pcgen.core.SkillUtilities;
import pcgen.core.SpecialAbility;
import pcgen.core.StatList;
import pcgen.core.SystemCollections;
import pcgen.core.VariableContainer;
import pcgen.core.VariableProcessor;
import pcgen.core.VariableProcessorPC;
import pcgen.core.Vision;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.spell.PCSpellTracker;
import pcgen.core.spell.Spell;
import pcgen.core.system.GameModeRollMethod;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.StringKey;
import pcgen.io.ExportHandler;
import pcgen.io.PCGFile;
import pcgen.io.exporttoken.BonusToken;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Delta;
import pcgen.util.DoubleKeyMap;
import pcgen.util.HashMapToList;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.AttackType;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Visibility;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlayerCharacter
extends Observable
implements Cloneable,
VariableContainer {
    public static final int ATTACKBONUS = 0;
    public static final int MONKBONUS = 4;
    private static String lastVariable = null;
    private final List<String> armorProfList = new ArrayList<String>();
    private final ArrayList<String> miscList = new ArrayList(3);
    private final ArrayList<NoteItem> notesList = new ArrayList();
    private final ArrayList<Equipment> primaryWeapons = new ArrayList();
    private final ArrayList<Equipment> secondaryWeapons = new ArrayList();
    private final ArrayList<String> shieldProfList = new ArrayList();
    private final ArrayList<Skill> skillList = new ArrayList();
    private final ArrayList<SpecialAbility> specialAbilityList = new ArrayList();
    private final ArrayList<PCTemplate> templateList = new ArrayList();
    private final ArrayList<String> variableList = new ArrayList();
    private BigDecimal gold = new BigDecimal(0);
    private Deity deity = null;
    private HashMap<String, String> domainSourceMap = new HashMap();
    private List<BonusObj> activeBonusList = new ArrayList<BonusObj>();
    private final List<CharacterDomain> characterDomainList = new ArrayList<CharacterDomain>();
    private ArrayList<PCClass> classList = new ArrayList();
    private final ArrayList<CompanionMod> companionModList = new ArrayList();
    private final List<Follower> followerList = new ArrayList<Follower>();
    private HashMapToList<Class, String> qualifyArrayMap = new HashMapToList();
    private Follower followerMaster = null;
    private final List<EquipSet> equipSetList = new ArrayList<EquipSet>();
    private List<Equipment> equipmentList = new ArrayList<Equipment>();
    private List<Equipment> equipmentMasterList = new ArrayList<Equipment>();
    private Map<String, Integer> autoEquipOutputOrderCache = new HashMap<String, Integer>();
    private List<PCLevelInfo> pcLevelInfo = new ArrayList<PCLevelInfo>();
    private List<BonusObj> processedBonusList = new ArrayList<BonusObj>();
    private final List<String> spellBooks = new ArrayList<String>();
    private Map<String, SpellBook> spellBookMap = new HashMap<String, SpellBook>();
    private List<Equipment> tempBonusItemList = new ArrayList<Equipment>();
    private List<BonusObj> tempBonusList = new ArrayList<BonusObj>();
    private Set<String> tempBonusFilters = new TreeSet<String>();
    private Map<String, String> activeBonusMap = new TreeMap<String, String>();
    private Race race = null;
    private final SortedSet<String> favoredClasses = new TreeSet<String>();
    private final StatList statList = new StatList(this);
    private List<Kit> kitList = null;
    private PCSpellTracker spellTracker = null;
    private final List<Language> templateAutoLanguages = new ArrayList<Language>();
    private final SortedSet<Language> templateLanguages = new TreeSet<Language>();
    private final SortedSet<Language> languages = new TreeSet<Language>();
    private Map<StringKey, String> stringChar = new HashMap<StringKey, String>();
    private String calcEquipSetId = "0.1";
    private String descriptionLst = "EMPTY";
    private String tabName = "";
    private String gender = Globals.getAllGenders().get(0);
    private HashSet<String> variableSet = new HashSet();
    private Double[] movementMult = Globals.EMPTY_DOUBLE_ARRAY;
    private String[] movementMultOp = Globals.EMPTY_STRING_ARRAY;
    private String[] movementTypes = Globals.EMPTY_STRING_ARRAY;
    private Double[] movements = Globals.EMPTY_DOUBLE_ARRAY;
    private boolean armorProfListStable = false;
    private boolean autoKnownSpells = true;
    private boolean useHigherKnownSlots = SettingsHandler.isUseHigherLevelSlotsDefault();
    private boolean useHigherPreppedSlots = SettingsHandler.isUseHigherLevelSlotsDefault();
    private boolean autoLoadCompanion = false;
    private boolean autoSortGear = true;
    private final boolean useMonsterDefault = SettingsHandler.isMonsterDefault();
    private String outputSheetHTML = "";
    private String outputSheetPDF = "";
    private boolean[] ageSetKitSelections = new boolean[10];
    private boolean dirtyFlag = false;
    private int serial = 0;
    private boolean displayUpdate = false;
    private boolean importing = false;
    private boolean useTempMods = true;
    private int age = 0;
    private int alignment = 9;
    private int costPool = 0;
    private int currentEquipSetNumber = 0;
    private int earnedXP = 0;
    private int equipOutputOrder = 0;
    private int freeLangs = 0;
    private int heightInInches = 0;
    private int poolAmount = 0;
    private int skillsOutputOrder = 0;
    private int spellLevelTemp = 0;
    private int weightInPounds = 0;
    private VariableProcessor variableProcessor;
    private int pointBuyPoints = -1;
    private boolean processLevelAbilities = true;
    private DoubleKeyMap<AbilityCategory, Ability.Nature, List<Ability>> theAbilities = new DoubleKeyMap();
    private Map<AbilityCategory, List<Ability>> realAbilities = new HashMap<AbilityCategory, List<Ability>>();
    private Map<AbilityCategory, BigDecimal> theUserPoolBonuses = null;
    private Set<WeaponProf> theWeaponProfs = null;
    private Map<String, WeaponProf> cachedWeaponProfs = null;
    private int cablInt = 1;
    private int lastCablInt = 0;
    private List<Ability> stableAggregateFeatList = null;
    private List<Ability> stableVirtualFeatList = null;
    private boolean aggregateFeatsStable = false;
    private boolean virtualFeatsStable = false;
    private boolean allowFeatPoolAdjustment = true;
    private double feats = 0.0;

    public PlayerCharacter() {
        int n;
        this.variableProcessor = new VariableProcessorPC(this);
        for (n = 0; n < 10; ++n) {
            this.ageSetKitSelections[n] = false;
        }
        Globals.setCurrentPC(this);
        int n2 = SettingsHandler.getGame().s_ATTRIBLONG.length;
        for (n = 0; n < n2; ++n) {
            PCStat pCStat = SettingsHandler.getGame().getUnmodifiableStatList().get(n);
            this.statList.addStat(pCStat.clone());
        }
        this.setRace(Globals.s_EMPTYRACE);
        this.setName("");
        this.setFeats(0.0);
        this.rollStats(SettingsHandler.getGame().getRollMethod());
        this.miscList.add("");
        this.miscList.add("");
        this.miscList.add("");
        this.addSpellBook(new SpellBook(Globals.getDefaultSpellBook(), 1));
        this.addSpellBook(new SpellBook("Innate", 1));
        this.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills());
        this.spellTracker = new PCSpellTracker(this);
        this.setStringFor(StringKey.HANDED, PropertyFactory.getString("in_right"));
    }

    public Map<String, String> getActiveBonusMap() {
        return this.activeBonusMap;
    }

    public void setAge(int n) {
        this.age = n;
        this.setDirty(true);
        this.calcActiveBonuses();
        if (!this.isImporting()) {
            Globals.getBioSet().makeKitSelectionFor(this);
        }
    }

    public int getAge() {
        return this.age;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public ArrayList<Skill> getAllSkillList(boolean bl) {
        if (!bl) {
            return this.skillList;
        }
        for (Skill skill : Globals.getSkillList()) {
            if (this.hasSkill(skill.getKeyName()) || CoreUtility.doublesEqual(skill.getSkillRankBonusTo(this), 0.0)) continue;
            this.addSkill(skill);
        }
        return this.skillList;
    }

    public ArrayList<Skill> getPartialSkillList(Visibility visibility) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        for (Skill skill : this.skillList) {
            Visibility visibility2 = skill.getVisibility();
            if (visibility != Visibility.DEFAULT && visibility2 != Visibility.DEFAULT && visibility2 != visibility) continue;
            arrayList.add(skill);
        }
        return arrayList;
    }

    public List<String> getArmorProfList() {
        if (this.armorProfListStable) {
            return this.armorProfList;
        }
        List<String> list = this.getAutoArmorProfList();
        this.addArmorProfs(list);
        List<String> list2 = this.getSelectedArmorProfList();
        this.addArmorProfs(list2);
        this.armorProfListStable = true;
        return this.armorProfList;
    }

    public void setArmorProfListStable(boolean bl) {
        this.armorProfListStable = bl;
        this.setDirty(true);
    }

    public int getBaseSpellStatBonus(PCClass pCClass) {
        int n;
        if (pCClass == null) {
            return 0;
        }
        int n2 = 0;
        String string = pCClass.getSpellBaseStat();
        if (!string.equals("None") && (n = this.getStatList().getIndexOfStatFor(string)) >= 0) {
            n2 = this.getStatList().getTotalStatFor(string);
            n2 += (int)this.getTotalBonusTo("STAT", "BASESPELLSTAT");
            n2 += (int)this.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS." + pCClass.getKeyName());
            n2 += (int)this.getTotalBonusTo("STAT", "CAST." + string);
            n2 = this.getStatList().getModForNumber(n2, n);
        }
        return n2;
    }

    public void setBio(String string) {
        this.setStringFor(StringKey.BIO, string);
    }

    public String getBio() {
        return this.getSafeStringFor(StringKey.BIO);
    }

    public void setBirthday(String string) {
        this.setStringFor(StringKey.BIRTHDAY, string);
    }

    public String getBirthday() {
        return this.getSafeStringFor(StringKey.BIRTHDAY);
    }

    public void setBirthplace(String string) {
        this.setStringFor(StringKey.BIRTHPLACE, string);
    }

    public String getBirthplace() {
        return this.getSafeStringFor(StringKey.BIRTHPLACE);
    }

    public void setCalcEquipSetId(String string) {
        this.calcEquipSetId = string;
        this.setDirty(true);
    }

    public String getCalcEquipSetId() {
        if (this.equipSetList.isEmpty()) {
            return this.calcEquipSetId;
        }
        if (this.getEquipSetByIdPath(this.calcEquipSetId) == null) {
            for (EquipSet equipSet : this.equipSetList) {
                if (!equipSet.getParentIdPath().equals("0")) continue;
                this.calcEquipSetId = equipSet.getIdPath();
                return this.calcEquipSetId;
            }
        }
        return this.calcEquipSetId;
    }

    public void setCalcEquipmentList() {
        this.setCalcEquipmentList(false);
    }

    public void setCalcEquipmentList(boolean bl) {
        Object object;
        String string = this.getCalcEquipSetId();
        EquipSet equipSet = this.getEquipSetByIdPath(string);
        if (equipSet == null) {
            Logging.debugPrint("No EquipSet has been selected for calculations yet.");
            return;
        }
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        this.setEquipmentList(arrayList);
        List<EquipSet> list = this.getEquipSet();
        if (list.isEmpty()) {
            return;
        }
        Collections.sort(list);
        for (EquipSet comparable : list) {
            Equipment equipment;
            object = string + ".";
            String string2 = comparable.getParentIdPath() + ".";
            if (!string2.startsWith((String)object) || (equipment = comparable.getItem()) == null) continue;
            Equipment equipment2 = comparable.getItem();
            String string3 = comparable.getName();
            String string4 = comparable.getNote();
            Float f = comparable.getQty();
            StringTokenizer stringTokenizer = new StringTokenizer(comparable.getIdPath(), ".");
            if (stringTokenizer.countTokens() > 3) {
                equipment2.setLocation(7);
                equipment2.setIsEquipped(false, this);
                equipment2.setNumberCarried(f);
                equipment2.setQty(f);
            } else if (string3.startsWith("Carried")) {
                equipment2.setLocation(6);
                equipment2.setIsEquipped(false, this);
                equipment2.setNumberCarried(f);
                equipment2.setQty(f);
            } else if (string3.startsWith("Not Carried")) {
                equipment2.setLocation(8);
                equipment2.setIsEquipped(false, this);
                equipment2.setNumberCarried(Float.valueOf(0.0f));
                equipment2.setQty(f);
            } else if (equipment2.isWeapon()) {
                if (string3.equals("Primary Hand") || string3.equals("Natural-Primary")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(f.intValue());
                    equipment2.setLocation(1);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.startsWith("Secondary Hand") || string3.equals("Natural-Secondary")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(f.intValue());
                    equipment2.setLocation(2);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Both Hands")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(f.intValue());
                    equipment2.setLocation(3);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Double Weapon")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(2);
                    equipment2.setLocation(4);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Unarmed")) {
                    equipment2.setLocation(0);
                    equipment2.setNumberEquipped(f.intValue());
                } else if (string3.equals("Two Weapons")) {
                    if (f.doubleValue() < 2.0) {
                        f = new Float(2.0);
                    }
                    comparable.setQty(f);
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(2);
                    equipment2.setLocation(4);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Shield")) {
                    equipment2.setLocation(0);
                    equipment2.setNumberEquipped(f.intValue());
                }
            } else {
                equipment2.setLocation(0);
                equipment2.setIsEquipped(true, this);
                equipment2.setNumberCarried(f);
                equipment2.setQty(f);
            }
            if (string4 != null && string4.length() > 0) {
                equipment2.setNote(string4);
            }
            this.addLocalEquipment(equipment2);
        }
        for (Equipment equipment : this.getEquipmentList()) {
            if (equipment.isContainer()) {
                equipment.updateContainerContentsString(this);
            }
            if ((object = this.getEquipmentNamed(equipment.getName())) == null) continue;
            equipment.setOutputIndex(((Equipment)object).getOutputIndex());
        }
        if (bl) {
            for (Equipment equipment : this.getTempBonusItemList()) {
                object = this.getEquipmentNamed(equipment.getName(), this.getEquipmentList());
                if (object == null) continue;
                equipment.setQty(((Equipment)object).getQty());
                equipment.setNumberCarried(((Equipment)object).getCarried());
                if (((Equipment)object).isEquipped()) {
                    if (equipment.isWeapon()) {
                        equipment.setSlots(0);
                        equipment.setCost("0");
                        equipment.setWeight("0");
                        equipment.setLocation(((Equipment)object).getLocation());
                    } else {
                        equipment.setLocation(((Equipment)object).getLocation());
                        this.removeLocalEquipment((Equipment)object);
                        ((Equipment)object).setIsEquipped(false, this);
                        ((Equipment)object).setLocation(8);
                        ((Equipment)object).setNumberCarried(Float.valueOf(0.0f));
                    }
                    equipment.setIsEquipped(true, this);
                    equipment.setNumberEquipped(1);
                } else {
                    equipment.setCost("0");
                    equipment.setWeight("0");
                    equipment.setLocation(5);
                    equipment.setIsEquipped(false, this);
                }
                equipment.setTypeInfo("TEMPORARY");
                this.addLocalEquipment(equipment);
            }
        }
    }

    public void setCalcFollowerBonus(PlayerCharacter playerCharacter) {
        this.setDirty(true);
        for (Follower follower : this.getFollowerList()) {
            String string = follower.getType().toUpperCase();
            String string2 = follower.getRace().toUpperCase();
            for (CompanionMod companionMod : Globals.getCompanionMods(string)) {
                String string3 = companionMod.getType().toUpperCase();
                int n = companionMod.getLevel(string2);
                if (!string3.equals(string) || n != 1) continue;
                this.addCompanionMod(companionMod);
                companionMod.activateBonuses(playerCharacter);
            }
        }
    }

    public void addCompanionMod(CompanionMod companionMod) {
        this.companionModList.add(companionMod);
    }

    public void setCatchPhrase(String string) {
        this.setStringFor(StringKey.CATCH_PHRASE, string);
    }

    public String getCatchPhrase() {
        return this.getSafeStringFor(StringKey.CATCH_PHRASE);
    }

    public PCClass getClassKeyed(String string) {
        for (PCClass pCClass : this.classList) {
            if (!pCClass.getKeyName().equalsIgnoreCase(string)) continue;
            return pCClass;
        }
        return null;
    }

    public ArrayList<PCClass> getClassList() {
        return this.classList;
    }

    public void setCostPool(int n) {
        this.costPool = n;
    }

    public int getCostPool() {
        return this.costPool;
    }

    public PCSpellTracker getSpellTracker() {
        return this.spellTracker;
    }

    @Deprecated
    public List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.race != null) {
            arrayList.add(this.race.getType());
        } else {
            arrayList.add("Humanoid");
        }
        for (PCTemplate pCTemplate : this.templateList) {
            arrayList.add(pCTemplate.getType());
        }
        return arrayList;
    }

    @Deprecated
    public String getCritterType() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.race != null) {
            stringBuffer.append(this.race.getType());
        } else {
            stringBuffer.append("Humanoid");
        }
        if (!this.templateList.isEmpty()) {
            for (PCTemplate pCTemplate : this.templateList) {
                String string = pCTemplate.getType();
                if ("".equals(string)) continue;
                stringBuffer.append('|').append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getRaceType() {
        String string;
        String string2 = "None";
        if (this.race != null) {
            string2 = this.race.getRaceType();
        }
        if (!this.companionModList.isEmpty()) {
            for (CompanionMod pObject : this.companionModList) {
                string = pObject.getRaceType();
                if ("".equals(string)) continue;
                string2 = string;
            }
        }
        if (!this.templateList.isEmpty()) {
            for (PCTemplate pCTemplate : this.templateList) {
                string = pCTemplate.getRaceType();
                if ("".equals(string)) continue;
                string2 = string;
            }
        }
        return string2;
    }

    public List<String> getRacialSubTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.race.getRacialSubTypes());
        if (!this.templateList.isEmpty()) {
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (PCTemplate object : this.templateList) {
                treeSet.addAll(object.getAddedSubTypes());
                treeSet2.addAll(object.getRemovedSubTypes());
            }
            for (String string : treeSet) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            for (String string : treeSet2) {
                arrayList.remove(string);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setCurrentEquipSetName(String string) {
        this.setStringFor(StringKey.CURRENT_EQUIP_SET_NAME, string);
    }

    public String getCurrentEquipSetName() {
        return this.getSafeStringFor(StringKey.CURRENT_EQUIP_SET_NAME);
    }

    public Deity getDeity() {
        return this.deity;
    }

    public void setDescription(String string) {
        this.setStringFor(StringKey.DESCRIPTION, string);
    }

    public String getDescription() {
        return this.getSafeStringFor(StringKey.DESCRIPTION);
    }

    public String getDescriptionLst() {
        return this.descriptionLst;
    }

    public void setDirty(boolean bl) {
        if (bl) {
            this.cachedWeaponProfs = null;
            ++this.serial;
            this.getVariableProcessor().setSerial(this.serial);
            this.setAggregateAbilitiesStable(null, false);
        }
        if (this.dirtyFlag != bl) {
            this.dirtyFlag = bl;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public int getSerial() {
        return this.serial;
    }

    public String getDisplayName() {
        String string = this.getTabName();
        if (!"".equals(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer().append(this.getName());
        switch (SettingsHandler.getNameDisplayStyle()) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append(" the ").append(this.getDisplayClassName());
                break;
            }
            case 2: {
                stringBuffer.append(" the ").append(this.getDisplayRaceName());
                break;
            }
            case 3: {
                stringBuffer.append(" the ").append(this.getDisplayRaceName()).append(' ').append(this.getDisplayClassName());
                break;
            }
            case 4: {
                return this.getFullDisplayName();
            }
        }
        return stringBuffer.toString();
    }

    public void setDisplayUpdate(boolean bl) {
        this.displayUpdate = bl;
    }

    public boolean isDisplayUpdate() {
        return this.displayUpdate;
    }

    public List<EquipSet> getEquipSet() {
        return this.equipSetList;
    }

    public EquipSet getEquipSetByIdPath(String string) {
        if (this.equipSetList.isEmpty()) {
            return null;
        }
        for (EquipSet equipSet : this.equipSetList) {
            if (!equipSet.getIdPath().equals(string)) continue;
            return equipSet;
        }
        return null;
    }

    public EquipSet getEquipSetByName(String string) {
        if (this.equipSetList.isEmpty()) {
            return null;
        }
        for (EquipSet equipSet : this.equipSetList) {
            if (!equipSet.getName().equals(string)) continue;
            return equipSet;
        }
        return null;
    }

    public void setEquipSetNumber(int n) {
        this.currentEquipSetNumber = n;
        this.setDirty(true);
    }

    public int getEquipSetNumber() {
        return this.currentEquipSetNumber;
    }

    public double getEquipSetWeightDouble(String string) {
        if (this.equipSetList.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (EquipSet equipSet : this.equipSetList) {
            Equipment equipment;
            String string2 = string + ".";
            String string3 = equipSet.getIdPath() + ".";
            if (!string3.startsWith(string2) || (equipment = equipSet.getItem()) == null || !(equipment.getCarried().floatValue() > 0.0f) || equipment.getParent() != null) continue;
            if (equipment.getChildCount() > 0) {
                d += equipment.getWeightAsDouble(this) + (double)equipment.getContainedWeight(this).floatValue();
                continue;
            }
            d += equipment.getWeightAsDouble(this) * (double)equipment.getCarried().floatValue();
        }
        return d;
    }

    public Float getEquipSetCount(String string, String string2) {
        float f = 0.0f;
        for (EquipSet equipSet : this.getEquipSet()) {
            String string3;
            String string4 = equipSet.getIdPath() + ".";
            if (!string4.startsWith(string3 = string + ".") || !equipSet.getValue().equals(string2)) continue;
            f += equipSet.getQty().floatValue();
        }
        return Float.valueOf(f);
    }

    public void setEquipmentList(List<Equipment> list) {
        this.equipmentList = list;
    }

    public List<Equipment> getEquipmentList() {
        return this.equipmentList;
    }

    public List<Equipment> getEquipmentListInOutputOrder() {
        return this.sortEquipmentList(this.getEquipmentList());
    }

    public List<Equipment> getEquipmentListInOutputOrder(int n) {
        return this.sortEquipmentList(this.getEquipmentList(), n);
    }

    public List<Equipment> getEquipmentMasterList() {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(this.equipmentMasterList);
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null) continue;
            pObject.addAutoTagsToList("EQUIP", arrayList, this, true);
        }
        return arrayList;
    }

    public List<Equipment> getEquipmentMasterListInOutputOrder() {
        return EquipmentUtilities.mergeEquipmentList(this.getEquipmentMasterList(), 1);
    }

    public Equipment getEquipmentNamed(String string, List<Equipment> list) {
        Equipment equipment = null;
        for (Equipment equipment2 : list) {
            if (!string.equalsIgnoreCase(equipment2.getName())) continue;
            equipment = equipment2;
        }
        return equipment;
    }

    public void setEyeColor(String string) {
        this.setStringFor(StringKey.EYE_COLOR, string);
    }

    public String getEyeColor() {
        return this.getSafeStringFor(StringKey.EYE_COLOR);
    }

    private double getBonusFeatPool() {
        String string = Globals.getBonusFeatString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        double d = this.getTotalBonusTo("FEAT", "POOL");
        double d2 = this.getTotalBonusTo("FEAT", "PCPOOL");
        double d3 = this.getTotalBonusTo("FEAT", "MONSTERPOOL");
        Logging.debugPrint("");
        Logging.debugPrint("==============");
        Logging.debugPrint("level " + this.getTotalPlayerLevels());
        Logging.debugPrint("POOL:   " + d);
        Logging.debugPrint("PCPOOL: " + d2);
        Logging.debugPrint("MPOOL:  " + d3);
        double d4 = n2 == 0 ? 0.0 : (double)(n / n2);
        d += Math.floor(this.getTotalCharacterLevel() >= n ? 1.0 + d2 - d4 + 1.0E-4 : d2 + 1.0E-4);
        Logging.debugPrint("");
        Logging.debugPrint("Total Bonus: " + (d += Math.floor(d3 + 1.0E-4)));
        Logging.debugPrint("==============");
        Logging.debugPrint("");
        return d;
    }

    public boolean canLevelUp() {
        return !SettingsHandler.getEnforceSpendingBeforeLevelUp() || this.getSkillPoints() <= 0 && !(this.getFeats() > 0.0);
    }

    public void setFileName(String string) {
        this.setStringFor(StringKey.FILE_NAME, string);
    }

    public String getFileName() {
        return this.getSafeStringFor(StringKey.FILE_NAME);
    }

    public List<Follower> getFollowerList() {
        return this.followerList;
    }

    public String getFullDisplayName() {
        int n = this.getTotalLevels();
        return new StringBuffer().append(this.getName()).append(" the ").append(n).append(this.getOrdinal(n)).append(" level ").append(this.getDisplayRaceName()).append(' ').append(this.classList.size() < 2 ? this.getDisplayClassName() : this.getFullDisplayClassName()).toString();
    }

    public String getFullRegion() {
        String string = this.getSubRegion();
        StringBuffer stringBuffer = new StringBuffer().append(this.getRegion());
        if (!string.equals("None")) {
            stringBuffer.append(" (").append(string).append(')');
        }
        return stringBuffer.toString();
    }

    public void setGender(String string) {
        String string2 = this.findTemplateGender();
        this.gender = string2.equals("None") ? string : string2;
        this.setDirty(true);
    }

    public String getGender() {
        String string = this.findTemplateGender();
        return string.equals("None") ? this.gender : string;
    }

    public boolean canSetGender() {
        String string = this.findTemplateGender();
        return string.equals("None");
    }

    public void setGold(String string) {
        this.gold = new BigDecimal(string);
        this.setDirty(true);
    }

    public BigDecimal getGold() {
        return this.gold;
    }

    public void setHairColor(String string) {
        this.setStringFor(StringKey.HAIR_COLOR, string);
    }

    public String getHairColor() {
        return this.getSafeStringFor(StringKey.HAIR_COLOR);
    }

    public void setHairStyle(String string) {
        this.setStringFor(StringKey.HAIR_STYLE, string);
    }

    public String getHairStyle() {
        return this.getSafeStringFor(StringKey.HAIR_STYLE);
    }

    public void setHanded(String string) {
        this.setStringFor(StringKey.HANDED, string);
    }

    public String getHanded() {
        return this.getSafeStringFor(StringKey.HANDED);
    }

    public void setHeight(int n) {
        this.heightInInches = n;
        this.setDirty(true);
    }

    public int getHeight() {
        return this.heightInInches;
    }

    public void setImporting(boolean bl) {
        this.importing = bl;
    }

    public void setInterests(String string) {
        this.setStringFor(StringKey.INTERESTS, string);
    }

    public String getInterests() {
        return this.getSafeStringFor(StringKey.INTERESTS);
    }

    public SortedSet<Language> getLanguagesList() {
        return Collections.unmodifiableSortedSet(this.languages);
    }

    public void clearLanguages() {
        this.languages.clear();
    }

    public void addLanguages(Collection<Language> collection) {
        this.languages.addAll(collection);
    }

    public String getLanguagesListNames() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Language language : this.languages) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(language.toString());
        }
        return stringBuffer.toString();
    }

    public void setLocation(String string) {
        this.setStringFor(StringKey.LOCATION, string);
    }

    public String getLocation() {
        return this.getSafeStringFor(StringKey.LOCATION);
    }

    public int getEffectiveCompanionLevel(String string) {
        Collection<CompanionMod> collection = Globals.getCompanionMods(string);
        for (CompanionMod companionMod : collection) {
            int n;
            for (String string2 : companionMod.getVarMap().keySet()) {
                n = this.getVariableValue(string2, "").intValue();
                if (n <= 0) continue;
                return n;
            }
            for (String string2 : companionMod.getClassMap().keySet()) {
                n = this.getClassKeyed(string2).getLevel();
                if (n <= 0) continue;
                return n;
            }
        }
        return 0;
    }

    public void clearCompanionMods() {
        this.companionModList.clear();
    }

    public void setMaster(Follower follower) {
        this.followerMaster = follower;
        PlayerCharacter playerCharacter = this.getMasterPC();
        if (playerCharacter == null) {
            return;
        }
        if (!follower.getFileName().equals(playerCharacter.getFileName())) {
            follower.setFileName(playerCharacter.getFileName());
            this.setDirty(true);
        }
        if (!follower.getName().equals(playerCharacter.getName())) {
            follower.setName(playerCharacter.getName());
            this.setDirty(true);
        }
        int n = 0;
        int n2 = 0;
        for (PCClass cloneable2 : playerCharacter.getClassList()) {
            boolean pCClass = false;
            for (CompanionMod companionMod : Globals.getCompanionMods(follower.getType())) {
                if (companionMod.getLevel(cloneable2.getKeyName()) <= 0 || pCClass) continue;
                n += cloneable2.getLevel();
                pCClass = true;
            }
        }
        ArrayList<CompanionMod> arrayList = new ArrayList<CompanionMod>(this.companionModList);
        ArrayList<CompanionMod> arrayList2 = new ArrayList<CompanionMod>();
        this.clearCompanionMods();
        for (CompanionMod companionMod : Globals.getCompanionMods(follower.getType())) {
            int n3;
            for (PCClass pCClass : playerCharacter.getClassList()) {
                n3 = pCClass.getLevel() + follower.getAdjustment();
                int n4 = companionMod.getLevel(pCClass.getKeyName());
                if (n4 < 0 || n4 > n3 && n4 > n || !PrereqHandler.passesAll(companionMod.getPreReqList(), this, companionMod)) continue;
                if (!arrayList.contains(companionMod)) {
                    arrayList2.add(companionMod);
                }
                this.addCompanionMod(companionMod);
                n2 += companionMod.getHitDie();
            }
            for (String string : companionMod.getVarMap().keySet()) {
                n3 = playerCharacter.getVariableValue(string, "").intValue() + follower.getAdjustment();
                if (n3 < companionMod.getLevel(string) || !PrereqHandler.passesAll(companionMod.getPreReqList(), this, companionMod)) continue;
                if (!arrayList.contains(companionMod)) {
                    arrayList2.add(companionMod);
                }
                this.addCompanionMod(companionMod);
                n2 += companionMod.getHitDie();
            }
        }
        PCClass pCClass = Globals.getClassKeyed(this.race.getMonsterClass(this, false));
        int n5 = this.followerMaster.getUsedHD();
        if (pCClass != null && (n2 -= n5) != 0) {
            this.incrementClassLevel(n2, pCClass, true);
            this.followerMaster.setUsedHD(n2 + n5);
            this.setDirty(true);
        }
        if (this.getUseMasterSkill()) {
            ArrayList<Skill> arrayList3 = playerCharacter.getSkillList();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (Skill skill : this.getAllSkillList(true)) {
                for (Skill skill2 : arrayList3) {
                    if (skill2.getKeyName().equals(skill.getKeyName()) && skill2.getRank().intValue() > skill.getRank().intValue()) {
                        skill.setZeroRanks(pCClass, this);
                        skill.modRanks(skill2.getRank().doubleValue(), null, true, this);
                    }
                    if (this.hasSkill(skill2.getKeyName()) || arrayList4.contains(skill2.getKeyName())) continue;
                    arrayList4.add(skill2.getKeyName());
                }
            }
            for (String string : arrayList4) {
                Skill skill = Globals.getSkillKeyed(string).clone();
                double d = playerCharacter.getSkillKeyed(string).getRank().doubleValue();
                if (skill.getChoiceString() != null && skill.getChoiceString().length() > 0) continue;
                skill.modRanks(d, null, true, this);
                this.getSkillList().add(skill);
            }
        }
        arrayList.removeAll(this.companionModList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CompanionMod companionMod = (CompanionMod)iterator.next();
            companionMod.subAddsForLevel(-9, this);
        }
        for (CompanionMod companionMod : arrayList2) {
            companionMod.addAddsForLevel(-9, this, null);
            for (String string : companionMod.getTemplateList()) {
                this.addTemplateKeyed(string);
            }
            List<String> list = companionMod.getSafeListFor(ListKey.KITS);
            for (int i = 0; i < list.size(); ++i) {
                KitUtilities.makeKitSelections(0, (String)list.get(i), i, this);
            }
        }
        this.setDirty(true);
    }

    public int getMaxFollowers(String string) {
        int n = -1;
        List<? extends PObject> list = this.getPObjectList();
        for (PObject pObject : list) {
            Iterator<String> iterator;
            if (pObject == null || (iterator = pObject.getNumFollowers(string)) == null) continue;
            Iterator<String> iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                int n2 = this.getVariableValue(string2, "", this).intValue();
                n = Math.max(n, n2);
            }
        }
        if (n == -1) {
            for (CompanionMod companionMod : Globals.getCompanionMods(string)) {
                for (String string3 : companionMod.getVarMap().keySet()) {
                    if (this.getVariableValue(string3, "").intValue() <= 0) continue;
                    return -1;
                }
                for (String string4 : companionMod.getClassMap().keySet()) {
                    for (PCClass pCClass : this.getClassList()) {
                        if (!pCClass.getKeyName().equals(string4)) continue;
                        return -1;
                    }
                }
            }
            return 0;
        }
        n = (int)((double)n + this.getTotalBonusTo("FOLLOWERS", string.toUpperCase()));
        return n;
    }

    public List<FollowerOption> getAvailableFollowers(String string) {
        ArrayList<FollowerOption> arrayList = new ArrayList<FollowerOption>();
        List<? extends PObject> list = this.getPObjectList();
        for (PObject pObject : list) {
            List<FollowerOption> list2;
            if (pObject == null || (list2 = pObject.getPotentialFollowers(string)) == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public Follower getMaster() {
        return this.followerMaster;
    }

    public PlayerCharacter getMasterPC() {
        if (this.followerMaster == null) {
            return null;
        }
        for (PlayerCharacter playerCharacter : Globals.getPCList()) {
            if (!this.followerMaster.getFileName().equals(playerCharacter.getFileName())) continue;
            return playerCharacter;
        }
        for (PlayerCharacter playerCharacter : Globals.getPCList()) {
            if (!this.followerMaster.getName().equals(playerCharacter.getName())) continue;
            return playerCharacter;
        }
        return null;
    }

    public boolean isMonsterDefault() {
        return this.useMonsterDefault;
    }

    public void setName(String string) {
        this.setStringFor(StringKey.NAME, string);
    }

    public String getName() {
        return this.getSafeStringFor(StringKey.NAME);
    }

    public List<String> getNamedTempBonusList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            String string;
            PObject pObject;
            if (bonusObj == null || !bonusObj.isApplied() || (pObject = (PObject)bonusObj.getCreatorObject()) == null || arrayList.contains(string = pObject.getKeyName())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getNamedTempBonusDescList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            String string;
            PObject pObject;
            if (bonusObj == null || !bonusObj.isApplied() || (pObject = (PObject)bonusObj.getCreatorObject()) == null || arrayList.contains(string = pObject.getDescription())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int getNonProficiencyPenalty() {
        int n = Globals.getGameModeNonProfPenalty();
        for (PCTemplate pCTemplate : this.templateList) {
            int n2 = pCTemplate.getNonProficiencyPenalty();
            if (n2 > 0) continue;
            n = n2;
        }
        return n;
    }

    public ArrayList<NoteItem> getNotesList() {
        return this.notesList;
    }

    public void setPhobias(String string) {
        this.setStringFor(StringKey.PHOBIAS, string);
    }

    public String getPhobias() {
        return this.getSafeStringFor(StringKey.PHOBIAS);
    }

    public void setPlayersName(String string) {
        this.setStringFor(StringKey.PLAYERS_NAME, string);
    }

    public String getPlayersName() {
        return this.getSafeStringFor(StringKey.PLAYERS_NAME);
    }

    public void setPoolAmount(int n) {
        this.poolAmount = n;
    }

    public int getPoolAmount() {
        return this.poolAmount;
    }

    public void setPortraitPath(String string) {
        this.setStringFor(StringKey.PORTRAIT_PATH, string);
    }

    public String getPortraitPath() {
        return this.getSafeStringFor(StringKey.PORTRAIT_PATH);
    }

    public List<Equipment> getPrimaryWeapons() {
        return this.primaryWeapons;
    }

    public Race getRace() {
        return this.race;
    }

    public void setRegion(String string) {
        this.setStringFor(StringKey.REGION, string);
    }

    public void setSubRegion(String string) {
        this.setStringFor(StringKey.SUB_REGION, string);
    }

    public String getRegion() {
        return this.getRegion(true);
    }

    public String getRegion(boolean bl) {
        String string = this.getStringFor(StringKey.REGION);
        if (string != null || !bl) {
            return string;
        }
        String string2 = "None";
        int n = this.templateList.size();
        for (int i = 0; i < n; ++i) {
            PCTemplate pCTemplate = this.templateList.get(i);
            String string3 = pCTemplate.getRegion();
            if (string3.equals("None")) continue;
            string2 = string3;
        }
        return string2;
    }

    public void setResidence(String string) {
        this.setStringFor(StringKey.RESIDENCE, string);
    }

    public String getResidence() {
        return this.getSafeStringFor(StringKey.RESIDENCE);
    }

    public List<Equipment> getSecondaryWeapons() {
        return this.secondaryWeapons;
    }

    public void setSelectedCharacterHTMLOutputSheet(String string) {
        this.outputSheetHTML = string;
    }

    public String getSelectedCharacterHTMLOutputSheet() {
        return this.outputSheetHTML;
    }

    public void setSelectedCharacterPDFOutputSheet(String string) {
        this.outputSheetPDF = string;
    }

    public String getSelectedCharacterPDFOutputSheet() {
        return this.outputSheetPDF;
    }

    public List<String> getShieldProfList() {
        this.shieldProfList.clear();
        List<String> list = this.getAutoShieldProfList();
        this.addShieldProfs(list);
        List<String> list2 = this.getSelectedShieldProfList();
        this.addShieldProfs(list2);
        return this.shieldProfList;
    }

    public String getSize() {
        SizeAdjustment sizeAdjustment = this.getSizeAdjustment();
        if (sizeAdjustment != null) {
            return sizeAdjustment.getAbbreviation();
        }
        return " ";
    }

    public ArrayList<Skill> getSkillList() {
        return this.getAllSkillList(false);
    }

    public ArrayList<Skill> getSkillListInOutputOrder() {
        return this.getSkillListInOutputOrder(new ArrayList<Skill>(this.getSkillList()));
    }

    public ArrayList<Skill> getSkillListInOutputOrder(ArrayList<Skill> arrayList) {
        Collections.sort(arrayList, new Comparator<Skill>(){

            @Override
            public int compare(Skill skill, Skill skill2) {
                int n = skill.getOutputIndex();
                int n2 = skill2.getOutputIndex();
                if (n == 0) {
                    n = 999;
                }
                if (n2 == 0) {
                    n2 = 999;
                }
                if (n > n2) {
                    return 1;
                }
                if (n < n2) {
                    return -1;
                }
                return skill.getOutputName().compareToIgnoreCase(skill2.getOutputName());
            }
        });
        Iterator<Skill> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = iterator.next();
            Visibility visibility = skill.getVisibility();
            if (skill.getOutputIndex() != -1 && !visibility.equals((Object)Visibility.HIDDEN) && !visibility.equals((Object)Visibility.DISPLAY_ONLY)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public void setSkillPoints(int n) {
        this.setDirty(true);
    }

    public int getSkillPoints() {
        int n = 0;
        for (PCLevelInfo object2 : this.getLevelInfo()) {
            n += object2.getSkillPointsGained();
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            for (String string : skill.getRankList()) {
                int n2 = string.indexOf(58);
                double d = Double.parseDouble(string.substring(n2 + 1));
                PCClass pCClass = this.getClassKeyed(string.substring(0, n2));
                if (pCClass == null) continue;
                double d2 = skill.costForPCClass(pCClass, this);
                n -= (int)(d2 * d);
            }
        }
        if (Globals.getGameModeHasPointPool()) {
            n += (int)this.getRawFeats(false);
        }
        return n;
    }

    public void setSkinColor(String string) {
        this.setStringFor(StringKey.SKIN_COLOR, string);
    }

    public String getSkinColor() {
        return this.getSafeStringFor(StringKey.SKIN_COLOR);
    }

    public List<SpecialAbility> getSpecialAbilityList() {
        ArrayList<SpecialAbility> arrayList = new ArrayList<SpecialAbility>(this.specialAbilityList);
        int n = this.getTotalLevels();
        int n2 = this.totalHitDice();
        for (PObject pObject : this.getPObjectList()) {
            Cloneable cloneable;
            if (pObject == null) continue;
            List<SpecialAbility> list = new ArrayList<SpecialAbility>();
            if (pObject instanceof PCTemplate) {
                cloneable = Globals.getTemplateKeyed(pObject.getKeyName());
                if (cloneable == null) continue;
                list = ((PCTemplate)cloneable).addSpecialAbilitiesToList(list, n, n2);
            } else {
                list = pObject.addSpecialAbilitiesToList(list, this);
            }
            cloneable = new ArrayList<SpecialAbility>(list);
            Iterator iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                SpecialAbility specialAbility = (SpecialAbility)iterator.next();
                if (!specialAbility.getKeyName().startsWith(".CLEAR.") || !specialAbility.qualifies(this)) continue;
                list.remove(specialAbility);
                String string = specialAbility.getKeyName().substring(7);
                Iterator<SpecialAbility> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    String string2 = iterator2.next().getKeyName();
                    if (!string2.startsWith(string)) continue;
                    int n3 = string.length();
                    int n4 = string2.length();
                    if (n4 == n3) {
                        iterator2.remove();
                        continue;
                    }
                    if (n4 <= n3 || string2.charAt(n3 + 1) != '(' && (n4 + 1 <= n3 || string2.charAt(n3 + 1) != ' ' || string2.charAt(n3 + 2) != '(')) continue;
                    iterator2.remove();
                }
            }
            arrayList.addAll(list);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getSpecialAbilityListStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SpecialAbility specialAbility : this.getSpecialAbilityList()) {
            String string;
            if (!PrereqHandler.passesAll(specialAbility.getPreReqList(), this, specialAbility) || (string = specialAbility.getParsedText(this, this)) == null || string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ArrayList<String> getSpecialAbilityTimesList() {
        List<String> list = this.getSpecialAbilityListStrings();
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                nArray[i] = 1;
                continue;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                String string2 = (String)arrayList.get(j);
                if (!string2.equals(string)) continue;
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (nArray[i] > 1) {
                string = string + " (" + nArray[i] + ")";
            }
            arrayList2.add(string);
        }
        return arrayList2;
    }

    public void setSpeechTendency(String string) {
        this.setStringFor(StringKey.SPEECH_TENDENCY, string);
    }

    public String getSpeechTendency() {
        return this.getSafeStringFor(StringKey.SPEECH_TENDENCY);
    }

    public void setSpellBookNameToAutoAddKnown(String string) {
        this.setStringFor(StringKey.SPELLBOOK_AUTO_ADD_KNOWN, string);
    }

    public String getSpellBookNameToAutoAddKnown() {
        return this.getSafeStringFor(StringKey.SPELLBOOK_AUTO_ADD_KNOWN);
    }

    public SpellBook getSpellBookByName(String string) {
        return this.spellBookMap.get(string);
    }

    public List<String> getSpellBooks() {
        return this.spellBooks;
    }

    public PObject getSpellClassAtIndex(int n) {
        List<? extends PObject> list = this.getSpellClassList();
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    public void setSpellLevelTemp(int n) {
        this.spellLevelTemp = n;
    }

    public int getSpellLevelTemp() {
        return this.spellLevelTemp;
    }

    public StatList getStatList() {
        return this.statList;
    }

    public String getSubRace() {
        String string = "None";
        int n = this.templateList.size();
        for (int i = 0; i < n; ++i) {
            PCTemplate pCTemplate = this.templateList.get(i);
            String string2 = pCTemplate.getSubRace();
            if (string2.equals("None")) continue;
            string = string2;
        }
        return string;
    }

    public String getSubRegion() {
        return this.getSubRegion(true);
    }

    public void setTabName(String string) {
        this.tabName = string;
        this.setDirty(true);
        this.setChanged();
        this.notifyObservers("TabName");
    }

    public String getTabName() {
        return this.tabName;
    }

    private List<Equipment> getTempBonusItemList() {
        return this.tempBonusItemList;
    }

    public void setTempBonusList(List<BonusObj> list) {
        this.tempBonusList = list;
        this.setDirty(true);
    }

    public List<BonusObj> getTempBonusList() {
        return this.tempBonusList;
    }

    public List<BonusObj> getFilteredTempBonusList() {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            if (this.tempBonusFilters.contains(bonusObj.getName())) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public Set<String> getTempBonusFilters() {
        return this.tempBonusFilters;
    }

    public void clearTempBonusFilters() {
        this.tempBonusFilters.clear();
    }

    public void setTempBonusFilter(String string) {
        this.tempBonusFilters.add(string);
        this.calcActiveBonuses();
    }

    public void unsetTempBonusFilter(String string) {
        this.tempBonusFilters.remove(string);
        this.calcActiveBonuses();
    }

    public List<BonusObj> getTempBonusList(String string, String string2) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            Object object = bonusObj.getTargetObject();
            Object object2 = bonusObj.getCreatorObject();
            String string3 = "";
            String string4 = "";
            if (object2 instanceof PObject) {
                string4 = ((PObject)object2).getKeyName();
            }
            if (object instanceof PlayerCharacter) {
                string3 = this.getName();
            } else if (object instanceof PObject) {
                string3 = ((PObject)object).getKeyName();
            }
            if (!string4.equals(string) || !string3.equals(string2)) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public ArrayList<PCTemplate> getTemplateList() {
        return this.templateList;
    }

    public List<PCTemplate> getOutputVisibleTemplateList() {
        ArrayList<PCTemplate> arrayList = new ArrayList<PCTemplate>();
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            if (pCTemplate.getVisibility() != Visibility.DEFAULT && pCTemplate.getVisibility() != Visibility.OUTPUT_ONLY) continue;
            arrayList.add(pCTemplate);
        }
        return arrayList;
    }

    public PCTemplate getTemplateKeyed(String string) {
        for (PCTemplate pCTemplate : this.templateList) {
            if (!pCTemplate.getKeyName().equalsIgnoreCase(string)) continue;
            return pCTemplate;
        }
        return null;
    }

    public void setTrait1(String string) {
        this.setStringFor(StringKey.TRAIT1, string);
    }

    public String getTrait1() {
        return this.getSafeStringFor(StringKey.TRAIT1);
    }

    public void setTrait2(String string) {
        this.setStringFor(StringKey.TRAIT2, string);
    }

    public String getTrait2() {
        return this.getSafeStringFor(StringKey.TRAIT2);
    }

    public Float getVariable(String string, boolean bl, boolean bl2, String string2, String string3, int n) {
        return this.getVariable(string, bl, bl2, string2, string3, true, n);
    }

    private double getMinMaxFirstValue(boolean bl, boolean bl2, double d, double d2) {
        if (!bl) {
            return d2;
        }
        if (bl2) {
            return Math.max(d, d2);
        }
        return Math.min(d, d2);
    }

    public Float getVariable(String string, boolean bl, boolean bl2, String string2, String string3, boolean bl3, int n) {
        String string4;
        String string5;
        String string6;
        String string7;
        double d = 0.0;
        boolean bl4 = false;
        if (lastVariable != null && lastVariable.equals(string)) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("This is a deliberate warning message, not an error - ");
            stringBuffer.append("Avoiding infinite loop in getVariable: repeated lookup ");
            stringBuffer.append("of \"").append(lastVariable).append("\" at ").append(d);
            Logging.debugPrint(stringBuffer.toString());
            lastVariable = null;
            return new Float(d);
        }
        for (String object22 : this.variableList) {
            String string8;
            StringTokenizer stringTokenizer = new StringTokenizer(object22, "|");
            string7 = stringTokenizer.nextToken();
            if (string2.length() > 0 && !string7.equals(string2)) continue;
            Iterator<EquipmentModifier> iterator = stringTokenizer.nextToken();
            if (string3.length() > 0 && !((String)((Object)iterator)).equals(string3) || !(string8 = stringTokenizer.nextToken()).equalsIgnoreCase(string)) continue;
            string6 = stringTokenizer.nextToken();
            double d2 = this.getVariableValue(string6, string7).doubleValue();
            d = this.getMinMaxFirstValue(bl4, bl, d, d2);
            bl4 = true;
        }
        for (Ability ability : this.getFullAbilitySet()) {
            String string9 = this.checkForVariableInList(ability, string, bl, "", "", bl4, d, n);
            if (string9.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string9));
            bl4 = true;
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            string7 = this.checkForVariableInList(skill, string, bl, "", "", bl4, d, 0);
            if (string7.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
            bl4 = true;
        }
        for (Equipment equipment : this.equipmentList) {
            string7 = this.checkForVariableInList(equipment, string, bl, "", "", bl4, d, 0);
            if (string7.length() > 0) {
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
                bl4 = true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                string6 = this.checkForVariableInList(equipmentModifier, string, bl, "", "", bl4, d, n);
                if (string6.length() <= 0) continue;
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string6));
                bl4 = true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                string6 = this.checkForVariableInList(equipmentModifier, string, bl, "", "", bl4, d, n);
                if (string6.length() <= 0) continue;
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string6));
                bl4 = true;
            }
        }
        for (PCTemplate pCTemplate : this.templateList) {
            string7 = this.checkForVariableInList(pCTemplate, string, bl, "", "", bl4, d, n);
            if (string7.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
            bl4 = true;
        }
        for (CompanionMod companionMod : this.companionModList) {
            string7 = this.checkForVariableInList(companionMod, string, bl, "", "", bl4, d, n);
            if (string7.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
            bl4 = true;
        }
        if (this.race != null && (string5 = this.checkForVariableInList(this.race, string, bl, "", "", bl4, d, n)).length() > 0) {
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string5));
            bl4 = true;
        }
        if (this.deity != null && (string4 = this.checkForVariableInList(this.deity, string, bl, "", "", bl4, d, n)).length() > 0) {
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
            bl4 = true;
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            if (characterDomain.getDomain() == null || (string7 = this.checkForVariableInList(characterDomain.getDomain(), string, bl, "", "", bl4, d, n)).length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
            bl4 = true;
        }
        for (PCStat pCStat : this.statList) {
            string7 = this.checkForVariableInList(pCStat, string, bl, "", "", bl4, d, n);
            if (string7.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
            bl4 = true;
        }
        for (PCAlignment pCAlignment : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
            string7 = this.checkForVariableInList(pCAlignment, string, bl, "", "", bl4, d, n);
            if (string7.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
            bl4 = true;
        }
        if (!bl4) {
            if (bl3) {
                lastVariable = string;
                d = this.getVariableValue(string, "").floatValue();
                bl2 = false;
                bl4 = true;
                lastVariable = null;
            } else {
                return null;
            }
        }
        if (bl4 && bl2) {
            d += this.getTotalBonusTo("VAR", string);
        }
        return new Float(d);
    }

    private Map<String, WeaponProf> buildWeaponProfCache() {
        HashMap<String, WeaponProf> hashMap = new HashMap<String, WeaponProf>();
        if (this.theWeaponProfs != null) {
            for (WeaponProf pObject : this.theWeaponProfs) {
                hashMap.put(pObject.getKeyName(), pObject);
            }
        }
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null) continue;
            TreeSet<String> treeSet = new TreeSet<String>(pObject.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS));
            pObject.addAutoTagsToList("WEAPONPROF", treeSet, this, true);
            for (String string : treeSet) {
                WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
                if (weaponProf == null) continue;
                hashMap.put(weaponProf.getKeyName(), weaponProf);
            }
        }
        return hashMap;
    }

    public SortedSet<WeaponProf> getWeaponProfs() {
        if (this.cachedWeaponProfs == null) {
            this.cachedWeaponProfs = this.buildWeaponProfCache();
        }
        return Collections.unmodifiableSortedSet(new TreeSet<WeaponProf>(this.cachedWeaponProfs.values()));
    }

    public void setWeight(int n) {
        this.weightInPounds = n;
        this.setDirty(true);
    }

    public int getWeight() {
        return this.weightInPounds;
    }

    public void setPointBuyPoints(int n) {
        this.pointBuyPoints = n;
    }

    public int getPointBuyPoints() {
        return this.pointBuyPoints + (int)this.getTotalBonusTo("POINTBUY", "POINTS");
    }

    public void setXP(int n) {
        int n2 = n - this.getLAXP();
        if (n2 < 0) {
            Logging.errorPrint("ERROR: too little experience: " + n2);
            n2 = 0;
        }
        this.setEarnedXP(n2);
    }

    public int getXP() {
        return this.earnedXP + this.getLAXP();
    }

    public void addArmorProf(String string) {
        if (!this.armorProfList.contains(string)) {
            if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
                this.armorProfList.add(0, string);
            } else {
                this.armorProfList.add(string);
            }
        }
    }

    public void addArmorProfs(List<String> list) {
        for (String string : list) {
            this.addArmorProf(string);
        }
    }

    public void addEquipSet(EquipSet equipSet) {
        this.equipSetList.add(equipSet);
        this.setDirty(true);
    }

    public void addEquipment(Equipment equipment) {
        this.equipmentList.add(equipment);
        if (!this.equipmentMasterList.contains(equipment)) {
            this.equipmentMasterList.add(equipment);
        }
        if (equipment.isType("SPELLBOOK")) {
            String string = equipment.getName();
            String string2 = equipment.getName();
            int n = (int)equipment.qty();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string2 = string + " #" + (i + 1);
                }
                SpellBook spellBook = new SpellBook(string2, 3);
                spellBook.setEquip(equipment);
                this.addSpellBook(spellBook);
            }
        }
        this.setDirty(true);
    }

    public void cacheOutputIndex(String string, int n) {
        Logging.errorPrint("Caching " + string + " - " + n + " direct");
        this.autoEquipOutputOrderCache.put(string, n);
    }

    public void cacheOutputIndex(Equipment equipment) {
        if (equipment.isAutomatic()) {
            Logging.errorPrint("Caching " + equipment.getKeyName() + " - " + equipment.getOutputIndex() + " item");
            this.autoEquipOutputOrderCache.put(equipment.getKeyName(), equipment.getOutputIndex());
        }
    }

    public int getCachedOutputIndex(String string) {
        Integer n = this.autoEquipOutputOrderCache.get(string);
        return n != null ? n : -1;
    }

    public void updateEquipmentQty(Equipment equipment, double d, double d2) {
        if (equipment.isType("SPELLBOOK")) {
            int n;
            String string = equipment.getName();
            String string2 = equipment.getName();
            int n2 = (int)d;
            int n3 = (int)d2;
            for (n = n2; n < n3; ++n) {
                if (n > 0) {
                    string2 = string + " #" + (n + 1);
                }
                SpellBook spellBook = new SpellBook(string2, 3);
                spellBook.setEquip(equipment);
                this.addSpellBook(spellBook);
            }
            for (n = n2; n > n3; --n) {
                if (n > 0) {
                    string2 = string + " #" + n;
                }
                this.delSpellBook(string2);
            }
        }
        this.setDirty(true);
    }

    public void addFollower(Follower follower) {
        this.followerList.add(follower);
        this.setDirty(true);
    }

    public void addLocalEquipment(Equipment equipment) {
        this.equipmentList.add(equipment);
    }

    public void addNotesItem(NoteItem noteItem) {
        this.notesList.add(noteItem);
        this.setDirty(true);
    }

    public void addTempBonus(BonusObj bonusObj) {
        this.getTempBonusList().add(bonusObj);
        this.setDirty(true);
    }

    public void addTempBonusItemList(Equipment equipment) {
        this.getTempBonusItemList().add(equipment);
        this.setDirty(true);
    }

    public double calcBonusFromList(List<BonusObj> list) {
        double d = 0.0;
        for (BonusObj bonusObj : list) {
            PObject pObject = (PObject)bonusObj.getCreatorObject();
            if (pObject == null) continue;
            d += pObject.calcBonusFrom(bonusObj, this, this);
        }
        return d;
    }

    public boolean checkQualifyList(PObject pObject) {
        for (PObject pObject2 : this.getPObjectList()) {
            if (pObject2 == null || !pObject2.grantsQualify(pObject)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWeaponProfKeyed(String string) {
        if (this.cachedWeaponProfs == null) {
            this.cachedWeaponProfs = this.buildWeaponProfCache();
        }
        for (WeaponProf weaponProf : this.cachedWeaponProfs.values()) {
            if (weaponProf == null || !weaponProf.getKeyName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWeaponProf(WeaponProf weaponProf) {
        if (this.cachedWeaponProfs == null) {
            this.cachedWeaponProfs = this.buildWeaponProfCache();
        }
        return this.cachedWeaponProfs.get(weaponProf.getKeyName()) != null;
    }

    public Equipment getEquipmentNamed(String string) {
        return this.getEquipmentNamed(string, this.getEquipmentMasterList());
    }

    public List<String> getMiscList() {
        return this.miscList;
    }

    public void buildVariableSet() {
        List<? extends PObject> list = this.getPObjectList();
        this.variableSet.clear();
        for (PObject pObject : list) {
            if (pObject == null) continue;
            this.variableSet.addAll(pObject.getVariableNamesAsUnmodifiableSet());
        }
        this.setVirtualFeatsStable(false);
    }

    public boolean delEquipSet(EquipSet equipSet) {
        if (this.equipSetList.isEmpty()) {
            return false;
        }
        boolean bl = false;
        String string = equipSet.getIdPath();
        this.equipSetList.remove(equipSet);
        Iterator<EquipSet> iterator = this.equipSetList.iterator();
        while (iterator.hasNext()) {
            String string2;
            EquipSet equipSet2 = iterator.next();
            String string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".")) continue;
            iterator.remove();
            bl = true;
        }
        this.setDirty(true);
        return bl;
    }

    public void delEquipSetItem(Equipment equipment) {
        if (this.equipSetList.isEmpty()) {
            return;
        }
        ArrayList<EquipSet> arrayList = new ArrayList<EquipSet>();
        for (EquipSet equipSet : this.equipSetList) {
            Equipment equipment2 = equipSet.getItem();
            if (equipment2 == null || !equipment.equals(equipment2)) continue;
            arrayList.add(equipSet);
        }
        for (EquipSet equipSet : arrayList) {
            this.delEquipSet(equipSet);
        }
        this.setDirty(true);
    }

    public void delFollower(Follower follower) {
        this.followerList.remove(follower);
        this.setDirty(true);
    }

    public void equipmentListAddAll(List<Equipment> list) {
        if (list.isEmpty()) {
            return;
        }
        this.equipmentList.addAll(list);
        this.equipmentMasterList.addAll(list);
        this.setDirty(true);
    }

    public boolean hasVariable(String string) {
        for (String string2 : this.variableList) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            if (!stringTokenizer.nextToken().equalsIgnoreCase(string)) continue;
            return true;
        }
        return this.variableSet.contains(string.toUpperCase());
    }

    private void putActiveBonusMap(String string, String string2, Map<String, String> map) {
        if (string.equalsIgnoreCase("SKILL.LIST")) {
            this.displayUpdate = true;
            return;
        }
        map.put(string, string2);
    }

    public int racialSizeInt() {
        int n = 0;
        if (this.race != null) {
            n = Globals.sizeInt(this.race.getSize());
            for (PCTemplate pCTemplate : this.getTemplateList()) {
                String string = pCTemplate.getTemplateSize();
                if (string.length() == 0 || (n = Globals.sizeInt(string)) != 0 || string.equals("F")) continue;
                n = this.getVariableValue(string, pCTemplate.getKeyName()).intValue();
            }
        }
        return n;
    }

    public void removeActiveBonus(BonusObj bonusObj) {
        this.activeBonusList.remove(bonusObj);
    }

    public void removeEquipment(Equipment equipment) {
        if (equipment.isType("SPELLBOOK")) {
            this.delSpellBook(equipment.getName());
        }
        this.equipmentList.remove(equipment);
        this.equipmentMasterList.remove(equipment);
        this.setDirty(true);
    }

    public void removeLocalEquipment(Equipment equipment) {
        this.equipmentList.remove(equipment);
        this.setDirty(true);
    }

    public int getACTotal() {
        return this.calcACOfType("Total");
    }

    public void setAlignment(int n, boolean bl) {
        this.setAlignment(n, bl, false);
    }

    public void setAlignment(int n, boolean bl, boolean bl2) {
        if (!bl2 && !this.race.canBeAlignment(Integer.toString(n))) {
            if (bl && n != SettingsHandler.getGame().getIndexOfAlignment("None")) {
                ShowMessageDelegate.showMessageDialog("Invalid alignment. Setting to <none selected>", "PCGen", MessageType.INFORMATION);
                this.alignment = SettingsHandler.getGame().getIndexOfAlignment("None");
            }
            throw new IllegalArgumentException("Invalid alignment");
        }
        this.alignment = n;
        this.setDirty(true);
    }

    public String getAttackString(AttackType attackType) {
        return this.getAttackString(attackType, 0);
    }

    public String getAttackString(AttackType attackType, int n) {
        return this.getAttackString(attackType, n, 0);
    }

    public String getAttackString(AttackType attackType, int n, int n2) {
        int n3;
        int n4;
        int n5;
        String string = "AttackString:" + attackType.getIdentifier() + "," + n + "," + n2;
        String string2 = this.getVariableProcessor().getCachedString(string);
        if (string2 != null) {
            return string2;
        }
        int n6 = -9999;
        int n7 = -9999;
        PlayerCharacter playerCharacter = this.getMasterPC();
        int n8 = this.getTotalCharacterLevel();
        HashMap<String, String> hashMap = null;
        if (n8 > SettingsHandler.getGame().getBabMaxLvl()) {
            hashMap = this.getTotalLevelHashMap();
            Map<String, String> map = this.getCharacterLevelHashMap(SettingsHandler.getGame().getBabMaxLvl());
            this.getVariableProcessor().pauseCache();
            this.setClassLevelsBrazenlyTo(map);
        }
        if (playerCharacter != null && this.getCopyMasterBAB().length() > 0) {
            n6 = playerCharacter.baseAttackBonus();
            String string3 = this.replaceMasterString(this.getCopyMasterBAB(), n6);
            n6 = this.getVariableValue(string3, "").intValue();
            n7 = n6 + n;
        }
        int n9 = this.baseAttackBonus();
        int n10 = 1;
        int n11 = n9 + n;
        int n12 = n9;
        int n13 = this.getRace().getBAB(this);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            arrayList.add(0);
        }
        for (PCClass pCClass : this.classList) {
            n5 = pCClass.baseAttackBonus(this);
            n4 = pCClass.attackCycle(attackType);
            int n14 = (Integer)arrayList.get(n4) + n5;
            arrayList.set(n4, n14);
            if (n4 == 3) continue;
            n13 += n5;
        }
        for (n3 = 2; n3 < 10; ++n3) {
            int n15 = (Integer)arrayList.get(n3);
            if (n15 / n3 <= (n5 = ((Integer)arrayList.get(n10)).intValue()) / n10) continue;
            n10 = n3;
        }
        if (hashMap != null) {
            this.setClassLevelsBrazenlyTo(hashMap);
            this.getVariableProcessor().restartCache();
        }
        n3 = (Integer)arrayList.get(n10);
        int n16 = SettingsHandler.getGame().getBabAttCyc();
        if (n3 == 0) {
            n10 = n16;
        }
        n11 = Math.max(n11, n7);
        n12 = Math.max(n12, n6);
        n13 = Math.max(n13, n6);
        if (n10 != n16) {
            if (n3 / n10 < n12 / n16) {
                n10 = n16;
                n3 = n12;
            } else {
                n11 -= n13;
                n12 -= n13;
            }
        }
        n5 = SettingsHandler.getGame().getBabMaxAtt();
        n4 = SettingsHandler.getGame().getBabMinVal();
        n3 += n2;
        n11 += n2;
        n12 += n2;
        do {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(Delta.toString(n11));
            n11 -= n10;
        } while (((n3 -= n10) >= n4 || (n12 -= n10) >= n4) && --n5 > 0);
        this.getVariableProcessor().addCachedString(string, stringBuffer.toString());
        return stringBuffer.toString();
    }

    public SortedSet<Language> getAutoLanguages() {
        boolean bl = false;
        TreeSet<Language> treeSet = new TreeSet<Language>();
        for (Language pObject : this.templateAutoLanguages) {
            String string = pObject.toString();
            if (".CLEARRACIAL".equals(string)) {
                bl = true;
                this.languages.removeAll(this.getRace().getSafeListFor(ListKey.AUTO_LANGUAGES));
                continue;
            }
            if (".CLEARALL".equals(string) || ".CLEAR".equals(string)) {
                bl = true;
                treeSet.clear();
                this.languages.clear();
                continue;
            }
            if (".CLEARTEMPLATES".equals(string)) {
                treeSet.clear();
                this.languages.removeAll(this.templateAutoLanguages);
                continue;
            }
            treeSet.add(pObject);
        }
        for (PObject pObject : this.getPObjectList()) {
            if (bl && pObject instanceof Race) {
                bl = false;
                continue;
            }
            treeSet.addAll(pObject.getSafeListFor(ListKey.AUTO_LANGUAGES));
        }
        this.languages.addAll(treeSet);
        return treeSet;
    }

    public void setAutoSortGear(boolean bl) {
        this.autoSortGear = bl;
        this.setDirty(true);
    }

    public boolean isAutoSortGear() {
        return this.autoSortGear;
    }

    public void setAutoSpells(boolean bl) {
        this.autoKnownSpells = bl;
        this.setDirty(true);
    }

    public boolean getAutoSpells() {
        return this.autoKnownSpells;
    }

    public boolean getUseHigherKnownSlots() {
        return this.useHigherKnownSlots;
    }

    public void setUseHigherKnownSlots(boolean bl) {
        this.useHigherKnownSlots = bl;
    }

    public boolean getUseHigherPreppedSlots() {
        return this.useHigherPreppedSlots;
    }

    public void setUseHigherPreppedSlots(boolean bl) {
        this.useHigherPreppedSlots = bl;
    }

    public int getBaseCheck(int n) {
        String string = "getBaseCheck:" + n;
        Float f = this.getVariableProcessor().getCachedVariable(string);
        if (f != null) {
            return f.intValue();
        }
        double d = 0.0;
        HashMap<String, String> hashMap = null;
        if (n >= 0 && n < SettingsHandler.getGame().getUnmodifiableCheckList().size()) {
            int n2 = this.getTotalCharacterLevel();
            if (n2 > SettingsHandler.getGame().getChecksMaxLvl()) {
                hashMap = this.getTotalLevelHashMap();
                Map<String, String> map = this.getCharacterLevelHashMap(SettingsHandler.getGame().getChecksMaxLvl());
                this.getVariableProcessor().pauseCache();
                this.setClassLevelsBrazenlyTo(map);
            }
            String string2 = SettingsHandler.getGame().getUnmodifiableCheckList().get(n).toString();
            d = this.getTotalBonusTo("CHECKS", "BASE." + string2);
            PlayerCharacter playerCharacter = this.getMasterPC();
            if (playerCharacter != null && this.getCopyMasterCheck().length() > 0) {
                int n3 = playerCharacter.getBaseCheck(n);
                String string3 = this.replaceMasterString(this.getCopyMasterCheck(), n3);
                n3 = this.getVariableValue(string3, "").intValue();
                d = Math.max(d, (double)n3);
            }
            if (hashMap != null) {
                this.setClassLevelsBrazenlyTo(hashMap);
                this.getVariableProcessor().restartCache();
            }
        }
        return (int)d;
    }

    public int getTotalCheck(int n) {
        int n2 = this.getBaseCheck(n);
        return n2 + (int)this.getTotalBonusTo("CHECKS", SettingsHandler.getGame().getCheckKey(n));
    }

    public double getBonusDueToType(String string, String string2, String string3) {
        String string4 = string + "." + string2 + ":" + string3;
        return this.sumActiveBonusMap(string4);
    }

    @Deprecated
    public double getBonusFeatsForNewLevel(PCClass pCClass) {
        double d = 0.0;
        Integer n = pCClass.getLevelsPerFeat();
        if (n != null && n >= 0) {
            int n2 = 0;
            if (this.getRace() != null && this.isMonsterDefault()) {
                n2 += this.getRace().getMonsterClassLevels(this);
            }
            n2 += pCClass.getLevel();
            int n3 = n;
            if (n3 > 0) {
                d = n2 % n3 == 0 ? 1.0 : 0.0;
            }
        } else {
            int n4 = 0;
            if (this.getRace() != null && this.isMonsterDefault()) {
                n4 += this.getRace().getMonsterClassLevels(this);
            }
            for (PCClass pCClass2 : this.classList) {
                Integer n5 = pCClass2.getLevelsPerFeat();
                if (n5 != null && n5 >= 0) continue;
                n4 += pCClass2.getLevel();
            }
            d = Globals.getBonusFeatsForLevel(n4);
        }
        return d;
    }

    public List<String> getChangeProfList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PObject pObject : this.getPObjectList()) {
            arrayList.addAll(pObject.getChangeProfList(this));
        }
        return arrayList;
    }

    public CharacterDomain getCharacterDomainForDomain(String string) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (domain == null || !domain.getKeyName().equalsIgnoreCase(string)) continue;
            return characterDomain;
        }
        return null;
    }

    public List<CharacterDomain> getCharacterDomainList() {
        return Collections.unmodifiableList(this.characterDomainList);
    }

    public boolean hasCharacterDomainList() {
        return this.characterDomainList != null && !this.characterDomainList.isEmpty();
    }

    public Domain getCharacterDomainKeyed(String string) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (domain == null || !domain.getKeyName().equalsIgnoreCase(string)) continue;
            return characterDomain.getDomain();
        }
        return null;
    }

    public int getCharacterDomainUsed() {
        return this.characterDomainList.size();
    }

    public List<CompanionMod> getCompanionModList() {
        return Collections.unmodifiableList(this.companionModList);
    }

    public String getCopyMasterBAB() {
        for (CompanionMod companionMod : this.companionModList) {
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType()) || companionMod.getCopyMasterBAB() == null) continue;
            return companionMod.getCopyMasterBAB();
        }
        return "";
    }

    public String getCopyMasterCheck() {
        for (CompanionMod companionMod : this.companionModList) {
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType()) || companionMod.getCopyMasterCheck() == null) continue;
            return companionMod.getCopyMasterCheck();
        }
        return "";
    }

    public String getCopyMasterHP() {
        for (CompanionMod companionMod : this.companionModList) {
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType()) || companionMod.getCopyMasterHP() == null) continue;
            return companionMod.getCopyMasterHP();
        }
        return "";
    }

    public void setCurrentHP(int n) {
        this.setDirty(true);
    }

    public boolean setDeity(Deity deity) {
        if (!this.canSelectDeity(deity)) {
            return false;
        }
        this.deity = deity;
        if (!this.isImporting()) {
            this.getSpellList();
            this.deity.globalChecks(this);
        }
        this.setDirty(true);
        this.calcActiveBonuses();
        return true;
    }

    public String getDomainSource(String string) {
        for (String string2 : this.domainSourceMap.keySet()) {
            String string3 = this.domainSourceMap.get(string2);
            int n = Integer.parseInt(string3);
            if (string == null && n > 0) {
                return string2;
            }
            if (string2.indexOf(string) < 0) continue;
            return string2;
        }
        return "";
    }

    public int getECL() {
        int n = 0;
        n += this.totalNonMonsterLevels();
        n += this.totalHitDice();
        return n += this.getLevelAdjustment(this);
    }

    public void setEquipOutputOrder(int n) {
        this.equipOutputOrder = n;
        this.setDirty(true);
    }

    public int getEquipOutputOrder() {
        return this.equipOutputOrder;
    }

    public List<Equipment> getEquipmentOfType(String string, int n) {
        return this.getEquipmentOfType(string, "", n);
    }

    public List<Equipment> getEquipmentOfType(String string, String string2, int n) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.typeStringContains(string) || !"".equals(string2) && !equipment.typeStringContains(string2) || n != 3 && (n != 2 || equipment.isEquipped()) && (n != 1 || !equipment.isEquipped())) continue;
            arrayList.add(equipment);
        }
        return arrayList;
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String string, int n) {
        return this.sortEquipmentList(this.getEquipmentOfType(string, n), 0);
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String string, int n, int n2) {
        return this.sortEquipmentList(this.getEquipmentOfType(string, n), n2);
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String string, String string2, int n, int n2) {
        return this.sortEquipmentList(this.getEquipmentOfType(string, string2, n), 0);
    }

    public List<Equipment> getExpandedWeapons(int n) {
        List<Equipment> list = this.sortEquipmentList(this.getEquipmentOfType("Weapon", 3), n);
        for (int i = 0; i < list.size(); ++i) {
            Equipment equipment;
            int n2;
            Equipment equipment2;
            int n3;
            Equipment equipment3;
            Equipment equipment4 = list.get(i);
            if (equipment4.isDouble() && equipment4.getLocation() == 4) {
                equipment3 = equipment4.clone();
                equipment3.removeType("Double");
                equipment3.setTypeInfo("Head1");
                equipment3.setWholeItemName(equipment3.getName());
                equipment3.setName(EquipmentUtilities.appendToName(equipment3.getName(), "Head 1 only"));
                if (equipment3.getOutputName().indexOf("Head 1 only") < 0) {
                    equipment3.setOutputName(EquipmentUtilities.appendToName(equipment3.getOutputName(), "Head 1 only"));
                }
                PlayerCharacterUtilities.setProf(equipment4, equipment3);
                list.add(i + 1, equipment3);
                equipment3 = equipment4.clone();
                String string = equipment3.getType(false);
                if (string.length() != 0) {
                    equipment3.setTypeInfo(".CLEAR." + string);
                }
                equipment3.removeType("Double");
                equipment3.setTypeInfo("Head2");
                equipment3.setDamage(equipment3.getAltDamage(this));
                equipment3.setCritMult(equipment3.getRawAltCritMult());
                equipment3.setCritRange(Integer.toString(equipment3.getRawCritRange(false)));
                equipment3.getEqModifierList(true).clear();
                equipment3.getEqModifierList(true).addAll(equipment3.getEqModifierList(false));
                equipment3.setWholeItemName(equipment3.getName());
                equipment3.setName(EquipmentUtilities.appendToName(equipment3.getName(), "Head 2 only"));
                if (equipment3.getOutputName().indexOf("Head 2 only") < 0) {
                    equipment3.setOutputName(EquipmentUtilities.appendToName(equipment3.getOutputName(), "Head 2 only"));
                }
                PlayerCharacterUtilities.setProf(equipment4, equipment3);
                list.add(i + 2, equipment3);
                continue;
            }
            if (!equipment4.isMelee() || !equipment4.isRanged() || equipment4.getRange(this) == 0) continue;
            equipment3 = equipment4.clone();
            equipment3.setTypeInfo("Both");
            equipment3.removeType("Ranged.Thrown");
            equipment3.setRange("0");
            PlayerCharacterUtilities.setProf(equipment4, equipment3);
            list.set(i, equipment3);
            for (n3 = this.getPrimaryWeapons().size() - 1; n3 >= 0 && (equipment2 = this.getPrimaryWeapons().get(n3)) != equipment4; --n3) {
            }
            if (n3 >= 0) {
                this.getPrimaryWeapons().set(n3, equipment3);
            }
            for (n2 = this.getSecondaryWeapons().size() - 1; n2 >= 0 && (equipment = this.getSecondaryWeapons().get(n2)) != equipment4; --n2) {
            }
            if (n2 >= 0) {
                this.getSecondaryWeapons().set(n2, equipment3);
            }
            equipment3 = equipment4.clone();
            equipment3.setTypeInfo("Ranged.Thrown.Both");
            equipment3.removeType("Melee");
            equipment3.setName(EquipmentUtilities.appendToName(equipment3.getName(), "Thrown"));
            if (equipment3.getOutputName().indexOf("Thrown") < 0) {
                equipment3.setOutputName(EquipmentUtilities.appendToName(equipment3.getOutputName(), "Thrown"));
            }
            PlayerCharacterUtilities.setProf(equipment4, equipment3);
            list.add(++i, equipment3);
            if (n3 >= 0) {
                this.getPrimaryWeapons().add(++n3, equipment3);
                continue;
            }
            if (n2 < 0) continue;
            this.getSecondaryWeapons().add(++n2, equipment3);
        }
        return list;
    }

    public SortedSet<String> getFavoredClasses() {
        TreeSet<String> treeSet = new TreeSet<String>(this.favoredClasses);
        for (PCTemplate pCTemplate : this.templateList) {
            String string = pCTemplate.getFavoredClass();
            if (string.length() == 0 || treeSet.contains(string)) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    public double getFeatBonusTo(String string, String string2, boolean bl) {
        return this.getPObjectWithCostBonusTo(this.aggregateFeatList(), string.toUpperCase(), string2.toUpperCase(), bl);
    }

    public Ability getFeatNamed(String string) {
        return AbilityUtilities.getAbilityFromList(this.aggregateFeatList(), "FEAT", string, Ability.Nature.ANY);
    }

    public Ability getFeatNamed(String string, Ability.Nature nature) {
        return AbilityUtilities.getAbilityFromList(this.aggregateFeatList(), "FEAT", string, nature);
    }

    public Ability getAbilityMatching(Ability ability) {
        return AbilityUtilities.getAbilityFromList(this.aggregateFeatList(), ability);
    }

    public int getFirstSpellLevel(Spell spell) {
        int n = 0;
        for (PCClass pCClass : this.getClassList()) {
            String string = pCClass.getSpellKey();
            int n2 = spell.getFirstLevelForKey(string, this);
            n = Math.min(n, n2);
        }
        return n;
    }

    public void setHasMadeKitSelectionForAgeSet(int n, boolean bl) {
        if (n >= 0 && n < 10) {
            this.ageSetKitSelections[n] = bl;
        }
        this.setDirty(true);
    }

    public List<Kit> getKitInfo() {
        List<Kit> list = this.kitList != null ? this.kitList : Collections.emptyList();
        return list;
    }

    public int getLevelAdjustment(PlayerCharacter playerCharacter) {
        int n = this.race.getLevelAdjustment(playerCharacter);
        for (PCTemplate pCTemplate : this.templateList) {
            n += pCTemplate.getLevelAdjustment(playerCharacter);
        }
        return n;
    }

    public List<PCLevelInfo> getLevelInfo() {
        return this.pcLevelInfo;
    }

    public String getLevelInfoClassKeyName(int n) {
        if (n >= 0 && n < this.getLevelInfoSize()) {
            return this.pcLevelInfo.get(n).getClassKeyName();
        }
        return "";
    }

    public int getLevelInfoClassLevel(int n) {
        if (n >= 0 && n < this.getLevelInfoSize()) {
            return this.pcLevelInfo.get(n).getLevel();
        }
        return 0;
    }

    public PCLevelInfo getLevelInfoFor(String string, int n) {
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            if (pCLevelInfo.getClassKeyName().equals(string)) {
                --n;
            }
            if (n > 0) continue;
            return pCLevelInfo;
        }
        return null;
    }

    public int getLevelInfoSize() {
        return this.pcLevelInfo.size();
    }

    public void setLoadCompanion(boolean bl) {
        this.autoLoadCompanion = bl;
        this.setDirty(true);
    }

    public boolean getLoadCompanion() {
        return this.autoLoadCompanion;
    }

    public int getMaxCharacterDomains() {
        return (int)this.getTotalBonusTo("DOMAIN", "NUMBER");
    }

    public int getMaxCharacterDomains(PCClass pCClass, PlayerCharacter playerCharacter) {
        int n = this.getMaxCharacterDomains();
        if (n == 0 && this.domainSourceMap.size() == 0) {
            n = (int)pCClass.getBonusTo("DOMAIN", "NUMBER", pCClass.getLevel(), playerCharacter);
        }
        return n;
    }

    public Float getMaxRank(String string, PCClass pCClass) {
        BigDecimal bigDecimal;
        Skill skill;
        int n = this.getTotalLevels();
        if (SettingsHandler.isMonsterDefault()) {
            n += this.totalHitDice();
        }
        if ((skill = Globals.getSkillKeyed(string)) == null) {
            return Float.valueOf(0.0f);
        }
        if (skill.isExclusive()) {
            n = 0;
            for (PCClass pCClass2 : this.classList) {
                if (!skill.isClassSkill(pCClass2, this)) continue;
                n += pCClass2.getLevel();
            }
            if (SettingsHandler.isMonsterDefault()) {
                n += this.totalHitDice();
            }
            if (n == 0) {
                n = SettingsHandler.isMonsterDefault() ? this.getTotalLevels() + this.totalHitDice() : this.getTotalLevels();
                bigDecimal = SkillUtilities.maxCrossClassSkillForLevel(n, this);
            } else {
                bigDecimal = SkillUtilities.maxClassSkillForLevel(n, this);
            }
        } else {
            bigDecimal = !skill.isClassSkill(this.classList, this) && skill.costForPCClass(pCClass, this) == Globals.getGameModeSkillCost_Class() ? new BigDecimal(SkillUtilities.maxCrossClassSkillForLevel(n, this).intValue()) : (!skill.isClassSkill(this.classList, this) ? SkillUtilities.maxCrossClassSkillForLevel(n, this) : SkillUtilities.maxClassSkillForLevel(n, this));
        }
        return new Float(bigDecimal.floatValue());
    }

    public Double getMovement(int n) {
        if (this.getMovements() != null && n < this.movements.length) {
            return this.movements[n];
        }
        return 0.0;
    }

    public String getMovementType(int n) {
        if (this.movementTypes != null && n < this.movementTypes.length) {
            return this.movementTypes[n];
        }
        return "";
    }

    public double movementOfType(String string) {
        if (this.movementTypes == null) {
            return 0.0;
        }
        for (int i = 0; i < this.movementTypes.length; ++i) {
            if (!this.movementTypes[i].equalsIgnoreCase(string)) continue;
            return this.movement(i);
        }
        return 0.0;
    }

    public CharacterDomain getNewCharacterDomain() {
        return this.getNewCharacterDomain(null);
    }

    public CharacterDomain getNewCharacterDomain(String string) {
        String string2 = this.getDomainSource(string);
        if (string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            CharacterDomain characterDomain = new CharacterDomain();
            if (string3.equalsIgnoreCase("PCClass")) {
                characterDomain.setFromPCClass(true);
            } else {
                characterDomain.setFromPCClass(false);
            }
            characterDomain.setObjectName(string4);
            characterDomain.setLevel(n);
            return characterDomain;
        }
        return null;
    }

    public boolean isNonAbility(int n) {
        if (this.race.isNonAbility(n)) {
            return true;
        }
        for (PCTemplate pCTemplate : this.templateList) {
            if (!pCTemplate.isNonAbility(n)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfMovements() {
        return this.movements != null ? this.movements.length : 0;
    }

    public int getOffHandLightBonus() {
        int n = this.getVariableValue("OFFHANDLIGHTBONUS", "").intValue();
        return n;
    }

    public boolean isPrimaryWeapon(Equipment equipment) {
        if (equipment == null) {
            return false;
        }
        for (Equipment equipment2 : this.primaryWeapons) {
            if (!equipment2.getName().equalsIgnoreCase(equipment.getName()) || equipment2.getLocation() != equipment.getLocation()) continue;
            return true;
        }
        return false;
    }

    public boolean isProficientWith(Equipment equipment) {
        if (equipment.isShield()) {
            List<String> list = this.getShieldProfList();
            return this.isProficientWith(equipment, list);
        }
        if (equipment.isArmor()) {
            List<String> list = this.getArmorProfList();
            return this.isProficientWith(equipment, list);
        }
        if (equipment.isWeapon()) {
            return this.isProficientWithWeapon(equipment);
        }
        return false;
    }

    public void setRace(Race race) {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        Race race2 = this.getRace();
        boolean bl2 = race2 == null;
        boolean bl3 = bl = this.getTotalClassLevels() == 1;
        if (!bl2) {
            String string;
            race2.getSpellSupport().clearCharacterSpells();
            if (PlayerCharacterUtilities.canReassignRacialFeats()) {
                object3 = new StringTokenizer(race2.getFeatList(this), "|");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    string = ((StringTokenizer)object3).nextToken();
                    if (string.endsWith(")") && Globals.getAbilityKeyed("FEAT", string) == null) {
                        object2 = string.substring(0, string.indexOf(40) - 1);
                        object = Globals.getAbilityKeyed("FEAT", (String)object2);
                        if (object == null) continue;
                        AbilityUtilities.modFeat(this, null, string, true, false);
                        this.adjustFeats(-((Ability)object).getCost(this));
                        continue;
                    }
                    object2 = Globals.getAbilityKeyed("FEAT", string);
                    if (object2 != null) {
                        object = ((PObject)object2).getKeyName();
                        if (!this.hasRealFeat((Ability)object2) && !this.hasFeatAutomatic((String)object)) continue;
                        AbilityUtilities.modFeat(this, null, string, true, false);
                        this.adjustFeats(-((Ability)object2).getCost(this));
                        continue;
                    }
                    ShowMessageDelegate.showMessageDialog("Removing unknown feat: " + string, "PCGen", MessageType.INFORMATION);
                }
            }
            this.languages.removeAll(race2.getSafeListFor(ListKey.AUTO_LANGUAGES));
            this.cachedWeaponProfs = null;
            if (this.stringChar.containsKey(StringKey.RACIAL_FAVORED_CLASS)) {
                this.favoredClasses.remove(this.stringChar.get(StringKey.RACIAL_FAVORED_CLASS));
            }
            this.removeNaturalWeapons(this.race);
            object3 = this.race.templatesAdded().iterator();
            while (object3.hasNext()) {
                string = object3.next();
                this.removeTemplate(this.getTemplateKeyed(string));
            }
            if (this.race.getMonsterClass(this) != null && this.race.getMonsterClassLevels(this) != 0 && (object3 = Globals.getClassKeyed(this.race.getMonsterClass(this))) != null) {
                this.incrementClassLevel(this.race.getMonsterClassLevels(this) * -1, (PCClass)object3, true);
            }
        }
        this.race = null;
        if (race != null) {
            this.race = race.clone();
        }
        if (this.race != null) {
            Object object4;
            this.race.activateBonuses(this);
            if (!this.isImporting()) {
                Globals.getBioSet().randomize("AGE.HT.WT", this);
            }
            object3 = new ArrayList<PCClass>(this.classList);
            this.classList.clear();
            for (int i = this.getLevelInfoSize() - 1; i >= 0; --i) {
                object2 = this.getLevelInfoClassKeyName(i);
                object = Globals.getClassKeyed((String)object2);
                if (object != null && !((PCClass)object).isMonster()) continue;
                this.removeLevelInfo(i);
            }
            ArrayList<PCLevelInfo> arrayList = new ArrayList<PCLevelInfo>(this.pcLevelInfo);
            this.pcLevelInfo.clear();
            if (!this.isImporting() && this.race.getMonsterClass(this) != null && this.race.getMonsterClassLevels(this) != 0 && (object2 = Globals.getClassKeyed(this.race.getMonsterClass(this))) != null) {
                this.incrementClassLevel(this.race.getMonsterClassLevels(this), (PCClass)object2, true);
            }
            this.pcLevelInfo.addAll(arrayList);
            if (!this.isImporting() && object3.size() != 0) {
                int n = this.getTotalLevels();
                object = object3.iterator();
                while (object.hasNext()) {
                    object4 = (PCClass)object.next();
                    if (((PCClass)object4).isMonster()) continue;
                    this.classList.add((PCClass)object4);
                    int n2 = ((PCClass)object4).getLevel();
                    ((PCClass)object4).setSkillPool(0);
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        n3 += ((PCClass)object4).recalcSkillPointMod(this, ++n);
                    }
                    ((PCClass)object4).setSkillPool(n3);
                }
            }
            this.addNaturalWeapons(this.race.getNaturalWeapons());
            if (PlayerCharacterUtilities.canReassignRacialFeats()) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.getRace().getFeatList(this), "|");
                while (stringTokenizer.hasMoreTokens()) {
                    Object object5;
                    object = stringTokenizer.nextToken();
                    if (((String)object).endsWith(")") && Globals.getAbilityKeyed("FEAT", (String)object) == null) {
                        object4 = ((String)object).substring(0, ((String)object).indexOf(40) - 1);
                        object5 = Globals.getAbilityKeyed("FEAT", (String)object4);
                        if (object5 == null) continue;
                        this.adjustFeats(((Ability)object5).getCost(this));
                        AbilityUtilities.modFeat(this, null, (String)object, true, true);
                        continue;
                    }
                    object4 = Globals.getAbilityKeyed("FEAT", (String)object);
                    if (object4 != null) {
                        object5 = ((PObject)object4).getKeyName();
                        if (this.hasRealFeat((Ability)object4) || this.hasFeatAutomatic((String)object5)) continue;
                        this.adjustFeats(((Ability)object4).getCost(this));
                        AbilityUtilities.modFeat(this, null, (String)object, true, true);
                        continue;
                    }
                    ShowMessageDelegate.showMessageDialog("Adding unknown feat: " + (String)object, "PCGen", MessageType.INFORMATION);
                }
            }
            this.getAutoLanguages();
            this.getRacialFavoredClasses();
            this.race.getTemplates(this.isImporting(), this);
            this.race.chooseLanguageAutos(this.isImporting(), this);
        }
        this.setAggregateFeatsStable(false);
        this.setAutomaticFeatsStable(false);
        this.setVirtualFeatsStable(false);
        if (!this.isImporting()) {
            this.getSpellList();
            this.race.globalChecks(this);
            this.adjustMoveRates();
            this.calcActiveBonuses();
        }
        this.setDirty(true);
    }

    public double getRaceBonusTo(String string, String string2) {
        if (this.getRace() == null) {
            return 0.0;
        }
        List<BonusObj> list = this.getRace().getBonusListOfType(string.toUpperCase(), string2.toUpperCase());
        return this.calcBonusFromList(list);
    }

    public int getSR() {
        return this.calcSR(true);
    }

    public boolean isSecondaryWeapon(Equipment equipment) {
        if (equipment == null) {
            return false;
        }
        for (Equipment equipment2 : this.secondaryWeapons) {
            if (!equipment2.getName().equalsIgnoreCase(equipment.getName()) || equipment2.getLocation() != equipment.getLocation()) continue;
            return true;
        }
        return false;
    }

    public double getSizeAdjustmentBonusTo(String string, String string2) {
        return this.getBonusDueToType(string.toUpperCase(), string2.toUpperCase(), "SIZE");
    }

    public Skill getSkillKeyed(String string) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill : arrayList) {
            if (!skill.getKeyName().equalsIgnoreCase(string)) continue;
            return skill;
        }
        return null;
    }

    public void setSkillsOutputOrder(int n) {
        this.skillsOutputOrder = n;
        this.setDirty(true);
    }

    public int getSkillsOutputOrder() {
        return this.skillsOutputOrder;
    }

    public boolean isSpellCaster(int n) {
        return this.isSpellCaster(n, false) > 0;
    }

    public int isSpellCaster(int n, boolean bl) {
        return this.isSpellCaster(null, n, bl);
    }

    public boolean isSpellCaster(String string, int n) {
        return this.isSpellCaster(string, n, false) > 0;
    }

    public int isSpellCaster(String string, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        for (PCClass pCClass : this.classList) {
            if (string != null && !string.equalsIgnoreCase(pCClass.getSpellType())) continue;
            int n4 = (int)this.getTotalBonusTo("CASTERLEVEL", pCClass.getKeyName());
            if (n4 == 0 && (this.canCastSpellTypeLevel(pCClass.getSpellType(), 0, 1) || this.canCastSpellTypeLevel(pCClass.getSpellType(), 1, 1))) {
                n4 = pCClass.getLevel();
            }
            n4 += (int)this.getTotalBonusTo("PCLEVEL", pCClass.getKeyName());
            if (bl) {
                n3 += n4;
                continue;
            }
            if (n4 < n) continue;
            ++n2;
        }
        if (bl) {
            return n3 >= n ? 1 : 0;
        }
        return n2;
    }

    public boolean isSpellCastermax(int n) {
        for (PCClass pCClass : this.classList) {
            if (pCClass.getSpellType().equalsIgnoreCase("None") || pCClass.getLevel() > n) continue;
            return true;
        }
        return false;
    }

    public Map<String, Integer> getSpellInfoMap(String string, String string2) {
        return this.spellTracker.getSpellInfoMap(string, string2);
    }

    public boolean isSpellLevelforKey(String string, int n) {
        return this.spellTracker.isSpellLevelforKey(string, n);
    }

    public int getSpellLevelforKey(String string, int n) {
        return this.spellTracker.getSpellLevelforKey(string, n);
    }

    public void getSpellList() {
        if (this.race == null) {
            return;
        }
        this.race.getSpellSupport().clearCharacterSpells();
        this.addSpells(this.race);
        if (this.deity != null) {
            this.addSpells(this.deity);
        }
        for (CharacterDomain iterator2 : this.characterDomainList) {
            this.addSpells(iterator2.getDomain());
        }
        for (PCClass pCClass : this.classList) {
            this.addSpells(pCClass);
        }
        for (Ability ability : this.getFullAbilitySet()) {
            this.addSpells(ability);
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            this.addSpells(skill);
        }
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            this.addSpells(equipment);
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                this.addSpells(equipmentModifier);
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                this.addSpells(equipmentModifier);
            }
        }
        for (PCTemplate pCTemplate : this.templateList) {
            this.addSpells(pCTemplate);
        }
    }

    public String getSpellRange(Spell spell, PObject pObject, SpellInfo spellInfo) {
        String string = spell.getRange();
        String string2 = "CLASS:" + (pObject != null ? pObject.getKeyName() : "");
        int n = 0;
        String string3 = Globals.getGameModeSpellRangeFormula(string.toUpperCase());
        if (string.equalsIgnoreCase("CLOSE") && string3 == null) {
            string3 = "((CASTERLEVEL/2).TRUNC*5)+25";
        } else if (string.equalsIgnoreCase("MEDIUM") && string3 == null) {
            string3 = "(CASTERLEVEL*10)+100";
        } else if (string.equalsIgnoreCase("LONG") && string3 == null) {
            string3 = "(CASTERLEVEL*40)+400";
        }
        if (string3 != null) {
            List<Ability> list = null;
            if (spellInfo != null) {
                list = spellInfo.getFeatList();
                n = this.getVariableValue(spell, string3, string2).intValue();
            }
            if (list != null && !list.isEmpty()) {
                for (Ability ability : list) {
                    n += (int)ability.bonusTo("SPELL", "RANGE", this, this);
                    int n2 = (int)ability.bonusTo("SPELL", "RANGEMULT", this, this);
                    if (n2 <= 0) continue;
                    n *= n2;
                }
            }
            string = string + " (" + Globals.getGameModeUnitSet().displayDistanceInUnitSet(n) + Globals.getGameModeUnitSet().getDistanceUnit() + ")";
        } else {
            string = this.parseSpellString(spell, string, pObject);
        }
        return string;
    }

    public int getCasterLevelForSpell(Spell spell, String string) {
        String string2 = "CLASS:" + string;
        int n = this.getVariableValue(spell, "CASTERLEVEL", string2).intValue();
        return n;
    }

    public int getClassCasterLevel(PCClass pCClass) {
        int n = this.getVariableValue("CASTERLEVEL", "CLASS:" + pCClass.getKeyName()).intValue();
        return n;
    }

    public int getRaceCasterLevel(Race race) {
        int n = this.getVariableValue("CASTERLEVEL", "RACE:" + race.getKeyName()).intValue();
        return n;
    }

    public double getStatBonusTo(String string, String string2) {
        List<BonusObj> list = this.statList.getBonusListOfType(string.toUpperCase(), string2.toUpperCase());
        return this.calcBonusFromList(list);
    }

    public double getTempBonusTo(String string, String string2) {
        double d = 0.0;
        if (!this.getUseTempMods()) {
            return d;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            PlayerCharacter playerCharacter;
            String string3 = bonusObj.toString();
            if (string3.indexOf(string) < 0 || string3.indexOf(string2) < 0) continue;
            Object object = bonusObj.getTargetObject();
            Object object2 = bonusObj.getCreatorObject();
            if (object2 == null || object == null || !(object2 instanceof PObject) || !(object instanceof PlayerCharacter) || (playerCharacter = (PlayerCharacter)object) != this) continue;
            PObject pObject = (PObject)object2;
            d += pObject.calcBonusFrom(bonusObj, this, this);
        }
        return d;
    }

    public double getTemplateBonusTo(String string, String string2, boolean bl) {
        return this.getPObjectWithCostBonusTo(this.templateList, string.toUpperCase(), string2.toUpperCase(), bl);
    }

    public double getTotalBonusTo(String string, String string2) {
        String string3 = new StringBuffer(string).append('.').append(string2).toString();
        return this.sumActiveBonusMap(string3);
    }

    public int getTotalLevels() {
        int n = 0;
        n += this.totalNonMonsterLevels();
        return n += this.totalHitDice();
    }

    public int getTotalPlayerLevels() {
        int n = 0;
        return n += this.totalNonMonsterLevels();
    }

    public int getTotalStatAtLevel(String string, int n, boolean bl) {
        int n2;
        int n3 = this.getStatList().getTotalStatFor(string);
        for (n2 = this.getLevelInfoSize() - 1; n2 >= n; --n2) {
            int n4 = this.pcLevelInfo.get(n2).getTotalStatMod(string, true);
            n3 -= n4;
        }
        if (!bl && n > 0) {
            n2 = this.pcLevelInfo.get(n - 1).getTotalStatMod(string, true);
            n3 -= (n2 -= this.pcLevelInfo.get(n - 1).getTotalStatMod(string, false));
        }
        return n3;
    }

    public int getTwoHandDamageDivisor() {
        int n = this.getVariableValue("TWOHANDDAMAGEDIVISOR", "").intValue();
        if (n == 0) {
            n = 2;
        }
        return n;
    }

    public String getUnarmedDamageString(boolean bl, boolean bl2, boolean bl3) {
        String string = "2|1d2";
        for (PCClass pObject : this.classList) {
            string = PlayerCharacterUtilities.getBestUDamString(string, pObject.getUdamForLevel(pObject.getLevel(), bl, bl2, this, bl3));
        }
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null || pObject instanceof PCClass) continue;
            string = PlayerCharacterUtilities.getBestUDamString(string, pObject.getUdamFor(bl, bl2, this));
        }
        return string.substring(string.indexOf(124) + 1);
    }

    public boolean getUseMasterSkill() {
        for (CompanionMod companionMod : this.companionModList) {
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType()) || !companionMod.getUseMasterSkill()) continue;
            return true;
        }
        return false;
    }

    public void setUseTempMods(boolean bl) {
        this.useTempMods = bl;
    }

    public boolean getUseTempMods() {
        return this.useTempMods;
    }

    public Float getVariableValue(String string, String string2) {
        return this.getVariableValue(null, string, string2);
    }

    @Override
    public Float getVariableValue(String string, String string2, PlayerCharacter playerCharacter) {
        return this.getVariableValue(null, string, string2);
    }

    private Float getVariableValue(Spell spell, String string, String string2) {
        VariableProcessor variableProcessor = this.getVariableProcessor();
        return variableProcessor.getVariableValue(spell, string, string2, this.getSpellLevelTemp());
    }

    public VariableProcessor getVariableProcessor() {
        return this.variableProcessor;
    }

    /*
     * WARNING - void declaration
     */
    int getTotalCasterLevelWithSpellBonus(Spell spell, String string, String string2, int n) {
        boolean bl;
        void var11_22;
        void var11_19;
        String string3;
        String string4;
        if (spell != null && spell.getFixedCasterLevel() != null) {
            return this.getVariableValue(spell.getFixedCasterLevel(), "").intValue();
        }
        int n3 = n;
        boolean bl2 = false;
        ArrayList<CasterLevelSpellBonus> arrayList = new ArrayList<CasterLevelSpellBonus>();
        if (string2 != null) {
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string2);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string2);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if (!string2.startsWith("RACE.") && (n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = "CLASS." + string2)) > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
        }
        if (spell == null) {
            return n3;
        }
        if (!string.equals("None")) {
            string3 = "TYPE." + string;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) > 0) {
                bl2 = true;
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
        }
        if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = "SPELL." + spell.getKeyName())) > 0) {
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) > 0) {
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        for (String object : spell.getSchools()) {
            string3 = "SCHOOL." + object;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 != 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        for (String string5 : spell.getSubschools()) {
            string3 = "SUBSCHOOL." + string5;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        for (String string6 : spell.getDescriptorList()) {
            string3 = "DESCRIPTOR." + string6;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        Map<String, Integer> map = spell.getLevelInfo(this);
        if (map != null) {
            for (Object object : map.keySet()) {
                if (!((String)object).startsWith("DOMAIN|")) continue;
                string3 = "DOMAIN." + ((String)object).substring(7);
                n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
                if (n3 > 0) {
                    string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                    arrayList.add(new CasterLevelSpellBonus(n3, string4));
                }
                if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
                bl2 = true;
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
        }
        boolean bl3 = false;
        while (var11_19 < arrayList.size() - 1) {
            Object object;
            object = (CasterLevelSpellBonus)arrayList.get((int)var11_19);
            String string7 = ((CasterLevelSpellBonus)object).getType();
            if (((CasterLevelSpellBonus)object).getBonus() != 0 && !string7.equals("")) {
                boolean bl4 = false;
                boolean bl5 = false;
                if (string7.endsWith(".REPLACE")) {
                    String string8 = string7.substring(0, string7.length() - 8);
                    bl4 = true;
                } else if (string7.endsWith(".STACK")) {
                    String string9 = string7.substring(0, string7.length() - 6);
                    bl5 = true;
                }
                for (void var16_33 = var11_19 + true; var16_33 < arrayList.size(); ++var16_33) {
                    void var13_25;
                    CasterLevelSpellBonus casterLevelSpellBonus = (CasterLevelSpellBonus)arrayList.get((int)var16_33);
                    String string10 = casterLevelSpellBonus.getType();
                    if (casterLevelSpellBonus.getBonus() == 0 || string10.equals("")) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    if (string10.endsWith(".REPLACE")) {
                        string10 = string10.substring(0, string10.length() - 8);
                        bl6 = true;
                    } else if (string10.endsWith(".STACK")) {
                        string10 = string10.substring(0, string10.length() - 6);
                        bl7 = true;
                    }
                    if (!var13_25.equals(string10)) continue;
                    if (bl4 && bl6) {
                        casterLevelSpellBonus.setBonus(((CasterLevelSpellBonus)object).getBonus() + casterLevelSpellBonus.getBonus());
                        ((CasterLevelSpellBonus)object).setBonus(0);
                        continue;
                    }
                    if (bl5 || bl7) continue;
                    if (((CasterLevelSpellBonus)object).getBonus() > casterLevelSpellBonus.getBonus()) {
                        casterLevelSpellBonus.setBonus(0);
                        continue;
                    }
                    ((CasterLevelSpellBonus)object).setBonus(0);
                }
            }
            ++var11_19;
        }
        int n2 = 0;
        if (!bl2) {
            int n4 = n2 + n;
        }
        for (CasterLevelSpellBonus casterLevelSpellBonus : arrayList) {
            var11_22 += casterLevelSpellBonus.getBonus();
        }
        if (var11_22 <= 0) {
            bl = true;
        }
        return bl ? 1 : 0;
    }

    private String getSpellBonusType(String string, String string2) {
        String string3 = new StringBuffer(string).append('.').append(string2).toString();
        string3 = string3.toUpperCase();
        Iterator<String> iterator = this.getActiveBonusMap().keySet().iterator();
        while (iterator.hasNext()) {
            String string4;
            String string5 = string4 = iterator.next();
            if (string4.endsWith(".STACK")) {
                string5 = string4.substring(0, string4.length() - 6);
            } else if (string4.endsWith(".REPLACE")) {
                string5 = string4.substring(0, string4.length() - 8);
            }
            if (string5.length() > string3.length() && !string5.startsWith(string3 + ":") || !string5.startsWith(string3)) continue;
            int n = string5.indexOf(":");
            if (n > 0) {
                return string4.substring(n + 1);
            }
            return "";
        }
        return "";
    }

    public List<Vision> getVisionList() {
        List<Vision> list = new ArrayList<Vision>();
        for (PObject serializable : this.getPObjectList()) {
            if (serializable == null) continue;
            list = this.addStringToVisionList(list, serializable.getVision());
        }
        for (VisionType visionType : VisionType.getAllVisionTypes()) {
            int n = (int)this.getTotalBonusTo("VISION", visionType.toString());
            if (n <= 0) continue;
            ArrayList<Vision> arrayList = new ArrayList<Vision>();
            arrayList.add(new Vision(visionType, "0"));
            list = this.addStringToVisionList(list, arrayList);
        }
        if (list.size() > 1) {
            Collections.sort(list);
        }
        return list;
    }

    public String getVision() {
        StringBuffer stringBuffer = new StringBuffer();
        List<Vision> list = this.getVisionList();
        for (Vision vision : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(vision);
        }
        return stringBuffer.toString();
    }

    public int abilityAC() {
        return this.calcACOfType("Ability");
    }

    public void addCharacterDomain(CharacterDomain characterDomain) {
        if (characterDomain != null && !this.characterDomainList.contains(characterDomain) && characterDomain.getDomain() != null) {
            this.characterDomainList.add(characterDomain);
            PCClass pCClass = this.getClassKeyed(characterDomain.getObjectName());
            if (pCClass != null) {
                int n = pCClass.getMaxCastLevel();
                characterDomain.getDomain().addSpellsToClassForLevels(pCClass, 0, n);
            }
            this.setDirty(true);
        }
    }

    public void addDomainSource(String string, String string2, int n, int n2) {
        String string3 = string + "|" + string2 + "|" + n;
        String string4 = Integer.toString(n2);
        this.domainSourceMap.put(string3, string4);
        this.setDirty(true);
    }

    public List<Equipment> addEqType(List<Equipment> list, String string) {
        for (Equipment equipment : this.getEquipmentList()) {
            if (equipment.typeStringContains(string)) {
                list.add(equipment);
                this.setDirty(true);
                continue;
            }
            if (!string.equalsIgnoreCase("CONTAINED") || equipment.getParent() == null) continue;
            list.add(equipment);
            this.setDirty(true);
        }
        return list;
    }

    public void addKit(Kit kit) {
        if (this.kitList == null) {
            this.kitList = new ArrayList<Kit>();
        }
        this.kitList.add(kit);
        this.setDirty(true);
    }

    public void addLanguage(Language language) {
        this.languages.add(language);
        this.setDirty(true);
    }

    public void addLanguageKeyed(String string) {
        Language language = Globals.getLanguageKeyed(string);
        if (language != null) {
            this.addLanguage(language);
        }
    }

    public void addNaturalWeapons(List<Equipment> list) {
        this.equipmentListAddAll(list);
        EquipSet equipSet = this.getEquipSetByIdPath("0.1");
        if (equipSet != null) {
            for (Equipment equipment : list) {
                this.addEquipToTarget(equipSet, null, "", equipment, null);
            }
        }
        this.setDirty(true);
    }

    public void addShieldProf(String string) {
        if (!this.shieldProfList.contains(string)) {
            if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
                this.shieldProfList.add(0, string);
            } else {
                this.shieldProfList.add(string);
            }
        }
    }

    public void addShieldProfs(List<String> list) {
        for (String string : list) {
            this.addShieldProf(string);
        }
    }

    public Skill addSkill(Skill skill) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill2 : arrayList) {
            if (!skill2.getKeyName().equals(skill.getKeyName())) continue;
            return skill2;
        }
        Skill skill3 = skill.clone();
        this.getSkillList().add(skill3);
        this.setDirty(true);
        if (!this.isImporting()) {
            skill3.globalChecks(this);
            this.calcActiveBonuses();
        }
        return skill3;
    }

    public String addSpell(CharacterSpell characterSpell, List<Ability> list, String string, String string2, int n, int n2) {
        Comparable<Object> comparable;
        int n3;
        if (characterSpell == null) {
            return "Invalid parameter to add spell";
        }
        PCClass pCClass = null;
        Spell spell = characterSpell.getSpell();
        if (string2 == null || string2.length() == 0) {
            return "Invalid spell list/book name.";
        }
        SpellBook spellBook = this.getSpellBookByName(string2);
        if (spellBook == null) {
            return "Could not find spell list/book " + string2;
        }
        if (string != null && (pCClass = this.getClassKeyed(string)) == null && string.lastIndexOf(40) >= 0) {
            pCClass = this.getClassKeyed(string.substring(0, string.lastIndexOf(40)).trim());
        }
        if (pCClass == null && spellBook.getType() == 3 && (pCClass = Globals.getClassKeyed(string)) == null && string.lastIndexOf(40) >= 0) {
            pCClass = Globals.getClassKeyed(string.substring(0, string.lastIndexOf(40)).trim());
        }
        if (pCClass == null) {
            return "No class keyed " + string;
        }
        if (!pCClass.getMemorizeSpells() && !string2.equals(Globals.getDefaultSpellBook())) {
            return pCClass.getDisplayName() + " can only add to " + Globals.getDefaultSpellBook();
        }
        if (spellBook.getType() != 3 && !characterSpell.isSpecialtySpell() && pCClass.isProhibited(spell, this)) {
            return characterSpell.getSpell().getDisplayName() + " is prohibited.";
        }
        int n4 = pCClass.getKnownForLevel(n2, this);
        int n5 = 0;
        int n6 = pCClass.getCastForLevel(n, string2, true, true, this);
        pCClass.memorizedSpellForLevelBook(n, string2);
        boolean bl = string2.equals(Globals.getDefaultSpellBook());
        if (bl) {
            n5 = pCClass.getSpecialtyKnownForLevel(n2, this);
        }
        int n7 = 0;
        if (spellBook.getType() == 3) {
            this.setSpellLevelTemp(n2);
            n7 = this.getVariableValue(characterSpell.getSpell(), spellBook.getPageFormula(), "").intValue();
            if (n7 + spellBook.getNumPagesUsed() > spellBook.getNumPages()) {
                return "There are not enough pages left to add this spell to the spell book.";
            }
            spellBook.setNumPagesUsed(n7 + spellBook.getNumPagesUsed());
            spellBook.setNumSpells(spellBook.getNumSpells() + 1);
        } else {
            if (!pCClass.getMemorizeSpells() && !this.availableSpells(n, pCClass, string2, true, characterSpell.isSpecialtySpell())) {
                int n8;
                String string3;
                if (!characterSpell.isSpecialtySpell() && this.availableSpells(n, pCClass, string2, true, true)) {
                    string3 = "Your remaining slot(s) must be filled with your speciality.";
                    n8 = n4;
                } else {
                    string3 = "You can only learn " + (n4 + n5) + " spells for level " + n + "\nand there are no higher-level slots available.";
                    n8 = n4 + n5;
                }
                int n9 = pCClass.memorizedSpellForLevelBook(n, string2);
                int n10 = n8 - n9;
                if (n10 > 0) {
                    string3 = string3 + "\n" + n10 + " spells from lower levels are using slots for this level.";
                }
                return string3;
            }
            if (pCClass.getMemorizeSpells() && !bl && !this.availableSpells(n, pCClass, string2, false, characterSpell.isSpecialtySpell())) {
                int n11;
                String string4;
                if (!characterSpell.isSpecialtySpell() && this.availableSpells(n, pCClass, string2, false, true)) {
                    string4 = "Your remaining slot(s) must be filled with your speciality or domain.";
                    n11 = pCClass.getCastForLevel(n, string2, false, true, this);
                } else {
                    string4 = "You can only prepare " + n6 + " spells for level " + n + "\nand there are no higher-level slots available.";
                    n11 = n6;
                }
                int n12 = pCClass.memorizedSpellForLevelBook(n, string2);
                int n13 = n11 - n12;
                if (n13 > 0) {
                    string4 = string4 + "\n" + n13 + " spells from lower levels are using slots for this level.";
                }
                return string4;
            }
        }
        SpellInfo spellInfo = null;
        List<CharacterSpell> list2 = pCClass.getSpellSupport().getCharacterSpell(characterSpell.getSpell(), string2, n);
        if (!list2.isEmpty()) {
            for (n3 = list2.size() - 1; n3 >= 0; --n3) {
                comparable = list2.get(n3);
                if (((CharacterSpell)comparable).equals(characterSpell)) continue;
                list2.remove(n3);
            }
        }
        if ((n3 = list2.isEmpty()) == 0) {
            if (list2.size() == 1) {
                comparable = list2.get(0);
                spellInfo = ((CharacterSpell)comparable).getSpellInfoFor(string2, n, -1, list);
            } else {
                spellInfo = characterSpell.getSpellInfoFor(string2, n, -1, list);
            }
        }
        if (spellInfo != null) {
            if (bl) {
                return "The Known Spells spellbook contains all spells of this level that you know. You cannot place spells in multiple times.";
            }
            spellInfo.setTimes(spellInfo.getTimes() + 1);
        } else {
            if (n3 != 0 && !pCClass.getSpellSupport().containsCharacterSpell(characterSpell)) {
                pCClass.getSpellSupport().addCharacterSpell(characterSpell);
            }
            spellInfo = characterSpell.addInfo(n, 1, string2, list);
            if (Spell.hasPPCost()) {
                comparable = characterSpell.getSpell();
                int n14 = ((Spell)comparable).getPPCost();
                for (Ability ability : list) {
                    n14 += (int)ability.bonusTo("PPCOST", ((PObject)comparable).getKeyName(), this, this);
                }
                spellInfo.setActualPPCost(n14);
            }
        }
        spellInfo.setNumPages(spellInfo.getNumPages() + n7);
        this.setDirty(true);
        return "";
    }

    public boolean addSpellBook(String string) {
        if (string != null && string.length() > 0 && !this.spellBooks.contains(string)) {
            return this.addSpellBook(new SpellBook(string, 2));
        }
        return false;
    }

    public boolean addSpellBook(SpellBook spellBook) {
        String string;
        if (spellBook != null && !this.spellBooks.contains(string = spellBook.getName())) {
            this.spellBooks.add(string);
            this.spellBookMap.put(string, spellBook);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public PCTemplate addTemplate(PCTemplate pCTemplate) {
        return this.addTemplate(pCTemplate, true);
    }

    public PCTemplate addTemplate(PCTemplate pCTemplate, boolean bl) {
        int n;
        int n2;
        int n3;
        PCTemplate pCTemplate2;
        if (pCTemplate == null) {
            return null;
        }
        if (this.templateList.contains(pCTemplate)) {
            return null;
        }
        for (PCTemplate object22 : this.templateList) {
            if (!object22.getKeyName().equals(pCTemplate.getKeyName())) continue;
            return null;
        }
        int n4 = 0;
        for (PCClass pCClass : this.classList) {
            if (!pCClass.isMonster()) continue;
            n4 = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            break;
        }
        try {
            pCTemplate2 = pCTemplate.clone();
            this.templateList.add(pCTemplate2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (!this.isImporting()) {
            for (String string : pCTemplate.getLevelMods()) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string2.startsWith("ADD")) continue;
                    String string3 = stringTokenizer.nextToken();
                    int n5 = this.getVariableValue(stringTokenizer.nextToken(), "").intValue();
                    PCClass pCClass = Globals.getClassKeyed(string3);
                    boolean bl2 = SettingsHandler.getShowHPDialogAtLevelUp();
                    SettingsHandler.setShowHPDialogAtLevelUp(false);
                    n3 = SettingsHandler.getShowFeatDialogAtLevelUp();
                    SettingsHandler.setShowFeatDialogAtLevelUp(false);
                    n2 = SettingsHandler.getSingleChoicePreference();
                    SettingsHandler.setSingleChoicePreference(2);
                    this.incrementClassLevel(n5, pCClass, true, true);
                    SettingsHandler.setSingleChoicePreference(n2);
                    SettingsHandler.setShowFeatDialogAtLevelUp(n3 != 0);
                    SettingsHandler.setShowHPDialogAtLevelUp(bl2);
                }
            }
        }
        this.setArmorProfListStable(false);
        List<String> list = pCTemplate2.getSafeListFor(ListKey.KITS);
        for (int i = 0; i < list.size(); ++i) {
            KitUtilities.makeKitSelections(0, list.get(i), i, this);
        }
        this.calcActiveBonuses();
        this.templateAutoLanguages.addAll(pCTemplate2.getSafeListFor(ListKey.AUTO_LANGUAGES));
        this.templateLanguages.addAll(pCTemplate2.getLanguageBonus());
        this.getAutoLanguages();
        this.addNaturalWeapons(pCTemplate2.getNaturalWeapons());
        pCTemplate2.chooseLanguageAutos(this.isImporting(), this);
        if (PlayerCharacterUtilities.canReassignTemplateFeats()) {
            List<String> list2 = pCTemplate2.feats(this.getTotalLevels(), this.totalHitDice(), this, true);
            int n6 = list2.size();
            for (int i = 0; i < n6; ++i) {
                AbilityUtilities.modFeatsFromList(this, null, list2.get(i), true, false);
            }
        } else {
            this.setAutomaticAbilitiesStable(null, false);
        }
        List<String> list3 = bl ? pCTemplate2.getTemplates(this.isImporting(), this) : pCTemplate2.templatesAdded();
        int n7 = list3.size();
        for (n = 0; n < n7; n += 1) {
            this.addTemplateKeyed(list3.get(n));
        }
        if (!this.isImporting()) {
            this.getSpellList();
            pCTemplate2.globalChecks(this);
            pCTemplate2.checkRemovals(this);
        }
        this.setAggregateAbilitiesStable(null, false);
        this.getAutomaticAbilityList(AbilityCategory.FEAT);
        this.calcActiveBonuses();
        n7 = 1;
        for (PCClass pCClass : this.classList) {
            if (pCClass.isMonster() && (n = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER")) != n4 && n > 0) {
                for (PCLevelInfo pCLevelInfo : this.getLevelInfo()) {
                    n3 = pCClass.recalcSkillPointMod(this, pCLevelInfo.getLevel());
                    if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName())) continue;
                    n2 = pCLevelInfo.getSkillPointsGained();
                    pCLevelInfo.setSkillPointsGained(n3);
                    pCLevelInfo.setSkillPointsRemaining(pCLevelInfo.getSkillPointsRemaining() + n3 - n2);
                    pCClass.setSkillPool(pCClass.getSkillPool(this) + n3 - n2);
                    this.setSkillPoints(this.getSkillPoints() + n3 - n2);
                }
            }
            if (!this.isImporting() && pCTemplate.getHitDieLock().length() != 0) {
                for (int i = 1; i <= pCClass.getLevel(); ++i) {
                    int n8 = pCClass.getBaseHitDie();
                    if (n8 == pCClass.getLevelHitDie(this, i)) continue;
                    pCClass.rollHP(this, i, n7 != 0);
                }
            }
            n7 = 0;
        }
        this.adjustMoveRates();
        this.setDirty(true);
        return pCTemplate2;
    }

    public PCTemplate addTemplateKeyed(String string) {
        PCTemplate pCTemplate;
        if (string == null) {
            return null;
        }
        if (string.startsWith("CHOOSE:")) {
            string = PCTemplate.chooseTemplate(null, string.substring(7), true, this);
        }
        if ((pCTemplate = Globals.getTemplateKeyed(string)) == null && string.endsWith(".REMOVE")) {
            pCTemplate = Globals.getTemplateKeyed(string.substring(0, string.length() - 7));
            this.removeTemplate(pCTemplate);
        } else {
            this.addTemplate(pCTemplate);
        }
        if (pCTemplate == null) {
            System.err.println("Template not found: '" + string + "'");
        }
        this.setDirty(true);
        return pCTemplate;
    }

    public void addWeaponProf(String string) {
        WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
        if (weaponProf != null) {
            if (this.theWeaponProfs == null) {
                this.theWeaponProfs = new TreeSet<WeaponProf>();
            }
            this.theWeaponProfs.add(weaponProf);
            this.setDirty(true);
        }
    }

    public void adjustGold(double d) {
        this.gold = new BigDecimal(this.gold.doubleValue() + d).divide(BigDecimal.ONE, 2, 6);
        this.setDirty(true);
    }

    public void adjustMoveRates() {
        this.movements = null;
        this.movementTypes = null;
        this.movementMult = null;
        this.movementMultOp = null;
        if (this.getRace() == null) {
            return;
        }
        List<Movement> list = this.getRace().getMovements();
        if (list == null || list.isEmpty() || !list.get(0).isInitialized()) {
            return;
        }
        Movement movement = list.get(0);
        this.movements = movement.getMovements();
        this.movementTypes = movement.getMovementTypes();
        this.movementMult = movement.getMovementMult();
        this.movementMultOp = movement.getMovementMultOp();
        this.setMoveFromList(this.getPObjectList());
        for (BonusObj bonusObj : this.getActiveBonusList()) {
            if (!bonusObj.getTypeOfBonus().equals("MOVEADD")) continue;
            String string = bonusObj.getBonusInfo();
            if (string.startsWith("TYPE")) {
                string = string.substring(5);
            }
            string = CoreUtility.capitalizeFirstLetter(string);
            boolean bl = false;
            for (int i = 0; i < this.movements.length; ++i) {
                if (!string.equals(this.movementTypes[i])) continue;
                bl = true;
            }
            if (bl) continue;
            this.setMyMoveRates(string, 0.0, 0.0, "", 1);
        }
        this.setDirty(true);
    }

    public List<Spell> aggregateSpellList(String string, String string2, String string3, String string4, int n, int n2) {
        ArrayList<Spell> arrayList = new ArrayList<Spell>();
        for (PCClass pCClass : this.classList) {
            String string5 = pCClass.getKeyName();
            if (pCClass.getCastAs().length() > 0) {
                string5 = pCClass.getCastAs();
            }
            if (!"Any".equalsIgnoreCase(string) && !string.equalsIgnoreCase(pCClass.getSpellType()) && !string.equalsIgnoreCase(string5)) continue;
            for (int i = n; i <= n2; ++i) {
                List<CharacterSpell> list = pCClass.getSpellSupport().getCharacterSpell(null, "", i);
                for (CharacterSpell characterSpell : list) {
                    Spell spell = characterSpell.getSpell();
                    if (string2.length() != 0 && !spell.getSchools().contains(string2) && string3.length() != 0 && !spell.getSubschools().contains(string3) && string4.length() != 0 && !spell.descriptorContains(string4)) continue;
                    arrayList.add(spell);
                }
            }
        }
        return arrayList;
    }

    public int altHP() {
        int n = (int)this.getTotalBonusTo("HP", "ALTHP");
        return n;
    }

    public int baseAC() {
        return this.calcACOfType("Base");
    }

    public int baseAttackBonus() {
        Float f = this.getVariableProcessor().getCachedVariable("BaseAttackBonus");
        if (f != null) {
            return f.intValue();
        }
        PlayerCharacter playerCharacter = this.getMasterPC();
        if (playerCharacter != null && this.getCopyMasterBAB().length() > 0) {
            int n = playerCharacter.baseAttackBonus();
            String string = this.replaceMasterString(this.getCopyMasterBAB(), n);
            n = this.getVariableValue(string, "").intValue();
            this.getVariableProcessor().addCachedVariable("BaseAttackBonus", Float.valueOf(n));
            return n;
        }
        int n = this.getTotalCharacterLevel();
        HashMap<String, String> hashMap = null;
        if (n > SettingsHandler.getGame().getBabMaxLvl()) {
            hashMap = this.getTotalLevelHashMap();
            Map<String, String> map = this.getCharacterLevelHashMap(SettingsHandler.getGame().getBabMaxLvl());
            this.getVariableProcessor().pauseCache();
            this.setClassLevelsBrazenlyTo(map);
        }
        int n2 = (int)this.getTotalBonusTo("COMBAT", "BAB");
        if (hashMap != null) {
            this.setClassLevelsBrazenlyTo(hashMap);
            this.getVariableProcessor().restartCache();
        }
        this.getVariableProcessor().addCachedVariable("BaseAttackBonus", Float.valueOf(n2));
        return n2;
    }

    public int basemovement(int n, Load load) {
        int n2 = this.getMovement(n).intValue();
        return n2;
    }

    public int calcACOfType(String string) {
        StringTokenizer stringTokenizer;
        PObject pObject;
        List<String> list = SettingsHandler.getGame().getACTypeAddString(string);
        List<String> list2 = SettingsHandler.getGame().getACTypeRemoveString(string);
        if (list == null && list2 == null) {
            Logging.errorPrint("Invalid ACType: " + string);
            return 0;
        }
        int n = 0;
        if (list != null) {
            for (String string2 : list) {
                pObject = new PObject();
                this.getPreReqFromACType(string2, pObject);
                if (!PrereqHandler.passesAll(pObject.getPreReqList(), this, pObject)) continue;
                stringTokenizer = new StringTokenizer(string2, "|");
                n += this.subCalcACOfType(stringTokenizer);
            }
        }
        if (list2 != null) {
            for (String string2 : list2) {
                pObject = new PObject();
                this.getPreReqFromACType(string2, pObject);
                if (!PrereqHandler.passesAll(pObject.getPreReqList(), this, pObject)) continue;
                stringTokenizer = new StringTokenizer(string2, "|");
                n -= this.subCalcACOfType(stringTokenizer);
            }
        }
        return n;
    }

    public void calcActiveBonuses() {
        if (this.isImporting() || this.race == null) {
            return;
        }
        this.buildVariableSet();
        String string = this.activeBonusMap.toString();
        this.setDirty(true);
        this.calcActiveBonusLoop();
        String string2 = this.activeBonusMap.toString();
        while (!string2.equals(string)) {
            this.setDirty(true);
            this.calcActiveBonusLoop();
            string = string2;
            string2 = this.activeBonusMap.toString();
        }
    }

    private List<BonusObj> getAllActiveBonuses() {
        List<BonusObj> list = new ArrayList<BonusObj>();
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null || pObject instanceof EquipmentModifier || pObject instanceof PCClass && ((PCClass)pObject).getLevel() <= 0) continue;
            pObject.activateBonuses(this);
            list.addAll(pObject.getActiveBonuses(this));
        }
        list.addAll(this.getPurchaseModeBonuses());
        if (this.getUseTempMods()) {
            list.addAll(this.getTempBonuses());
        }
        list = Bonus.sortBonusList(list);
        return list;
    }

    private void calcActiveBonusLoop() {
        if (this.cablInt == this.lastCablInt) {
            return;
        }
        this.lastCablInt = this.cablInt++;
        List<BonusObj> list = this.getAllActiveBonuses();
        this.activeBonusList = list;
        this.buildActiveBonusMap();
    }

    public int calcCR() {
        int n = 0;
        int n2 = this.race.hitDice(this);
        if (n2 > 0) {
            float f;
            for (f = (float)this.totalHitDice() / (float)n2; f >= 2.0f; f /= 2.0f) {
                n += 2;
            }
            if ((double)f >= 1.5) {
                ++n;
            }
        }
        for (PCClass pObject : this.classList) {
            n += pObject.calcCR(this);
        }
        for (PCTemplate pCTemplate : this.templateList) {
            n += pCTemplate.getCR(this.getTotalLevels(), this.totalHitDice());
        }
        int n3 = this.race.getCR();
        if (n3 > 0 || n == 0) {
            n += n3;
        }
        return n;
    }

    public List<DamageReduction> getDRList() {
        ArrayList<DamageReduction> arrayList = new ArrayList<DamageReduction>();
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null) continue;
            arrayList.addAll(pObject.getDRList());
        }
        return DamageReduction.getDRList(this, arrayList);
    }

    public String calcDR() {
        return DamageReduction.getDRString(this, this.getDRList());
    }

    public double calcMoveMult(double d, int n) {
        double d2 = 0.0;
        if (this.movementMultOp[n].charAt(0) == '*') {
            d2 = d * this.movementMult[n];
        } else if (this.movementMultOp[n].charAt(0) == '/') {
            d2 = d / this.movementMult[n];
        }
        if (d2 > 0.0) {
            return d2;
        }
        return d;
    }

    public int calcSR(boolean bl) {
        int n = this.race.getSR(this);
        if (this.deity != null) {
            n = Math.max(n, this.deity.getSR(this));
        }
        for (CompanionMod iterator2 : this.companionModList) {
            n = Math.max(n, iterator2.getSR(this));
        }
        for (PCClass pCClass : this.classList) {
            n = Math.max(n, pCClass.getSR(this));
        }
        for (Ability ability : this.aggregateFeatList()) {
            n = Math.max(n, ability.getSR(this));
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            n = Math.max(n, skill.getSR(this));
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            if (characterDomain.getDomain() == null) continue;
            n = Math.max(characterDomain.getDomain().getSR(this), n);
        }
        if (bl) {
            for (Equipment equipment : this.equipmentList) {
                if (!equipment.isEquipped()) continue;
                n = Math.max(n, equipment.getSR(this));
                for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                    n = Math.max(n, equipmentModifier.getSR(this));
                }
                for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                    n = Math.max(n, equipmentModifier.getSR(this));
                }
            }
        }
        int n2 = this.getTotalLevels();
        int n3 = this.totalHitDice();
        for (PCTemplate pCTemplate : this.templateList) {
            n = Math.max(n, pCTemplate.getSR(n2, n3, this));
        }
        n += (int)this.getTotalBonusTo("MISC", "SR");
        if (!bl) {
            n -= (int)this.getEquipmentBonusTo("MISC", "SR");
        }
        return n;
    }

    public boolean canCastSpellTypeLevel(String string, int n, int n2) {
        for (PCClass pCClass : this.classList) {
            String string2 = pCClass.getSpellType();
            if (!"Any".equalsIgnoreCase(string) && (!string2.equalsIgnoreCase(string) || string2.equalsIgnoreCase("None"))) continue;
            int n3 = pCClass.getKnownForLevel(n, this);
            if ((n3 += pCClass.getSpecialtyKnownForLevel(n, this)) >= n2) {
                return true;
            }
            if (pCClass.getCastForLevel(n, this) >= n2) {
                return true;
            }
            if (pCClass.getMemorizeSpells() || pCClass.hasKnownList() || !pCClass.zeroCastSpells()) continue;
            return true;
        }
        return false;
    }

    public boolean canSelectDeity(Deity deity) {
        if (deity == null) {
            return false;
        }
        return deity.canBeSelectedBy(this.classList, this.alignment, this);
    }

    public int classAC() {
        return this.calcACOfType("ClassDefense");
    }

    public String delSpell(SpellInfo spellInfo, PCClass pCClass, String string) {
        SpellBook spellBook;
        if (string == null || string.length() == 0) {
            return "Invalid spell book name.";
        }
        if (pCClass == null) {
            return "Error: Class is null";
        }
        CharacterSpell characterSpell = spellInfo.getOwner();
        boolean bl = string.equals(Globals.getDefaultSpellBook());
        if (bl && pCClass.isAutoKnownSpell(characterSpell.getSpell().getKeyName(), spellInfo.getActualLevel(), this)) {
            Logging.errorPrint("Notice: removing " + characterSpell.getSpell().getDisplayName() + " even though it is an auto known spell");
        }
        if ((spellBook = this.getSpellBookByName(string)).getType() == 3) {
            int n = spellInfo.getNumPages() / spellInfo.getTimes();
            spellBook.setNumPagesUsed(spellBook.getNumPagesUsed() - n);
            spellBook.setNumSpells(spellBook.getNumSpells() - 1);
            spellInfo.setNumPages(spellInfo.getNumPages() - n);
        }
        spellInfo.setTimes(spellInfo.getTimes() - 1);
        if (spellInfo.getTimes() <= 0) {
            characterSpell.removeSpellInfo(spellInfo);
        }
        pCClass.getSpellSupport().removeSpellIfUnused(characterSpell);
        return "";
    }

    public int calculateSaveBonus(int n, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = SettingsHandler.getGame().getIndexOfCheck(string);
        int n3 = 0;
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n4] = stringTokenizer.nextToken();
            if ("TOTAL".equals(stringArray[n4])) {
                n3 += this.getTotalCheck(n2);
            } else if ("BASE".equals(stringArray[n4])) {
                n3 += this.getBaseCheck(n2);
            } else if ("MISC".equals(stringArray[n4])) {
                n3 += (int)this.getTotalBonusTo("CHECKS", string);
            }
            if ("EPIC".equals(stringArray[n4])) {
                n3 += (int)this.getBonusDueToType("CHECKS", string, "EPIC");
            }
            if ("MAGIC".equals(stringArray[n4])) {
                n3 += (int)this.getEquipmentBonusTo("CHECKS", string);
            }
            if ("RACE".equals(stringArray[n4])) {
                n3 += this.calculateSaveBonusRace(n);
            }
            if ("FEATS".equals(stringArray[n4])) {
                n3 += (int)this.getFeatBonusTo("CHECKS", string, true);
            }
            if ("STATMOD".equals(stringArray[n4])) {
                n3 += (int)this.getCheckBonusTo("CHECKS", string);
            }
            if ("NOEPIC".equals(stringArray[n4])) {
                n3 -= (int)this.getBonusDueToType("CHECKS", string, "EPIC");
            }
            if ("NOMAGIC".equals(stringArray[n4])) {
                n3 -= (int)this.getEquipmentBonusTo("CHECKS", string);
            }
            if ("NORACE".equals(stringArray[n4])) {
                n3 -= this.calculateSaveBonusRace(n);
            }
            if ("NOFEATS".equals(stringArray[n4])) {
                n3 -= (int)this.getFeatBonusTo("CHECKS", string, true);
            }
            if ("NOSTAT".equals(stringArray[n4]) || "NOSTATMOD".equals(stringArray[n4])) {
                n3 -= (int)this.getCheckBonusTo("CHECKS", string);
            }
            ++n4;
        }
        return n3;
    }

    public boolean delSpellBook(String string) {
        if (string.length() > 0 && !string.equals(Globals.getDefaultSpellBook()) && this.spellBooks.contains(string)) {
            return this.delSpellBook(this.spellBookMap.get(string));
        }
        return false;
    }

    public boolean delSpellBook(SpellBook spellBook) {
        String string;
        if (spellBook != null && !(string = spellBook.getName()).equals(Globals.getDefaultSpellBook()) && this.spellBooks.contains(string)) {
            this.spellBooks.remove(string);
            this.spellBookMap.remove(string);
            this.setDirty(true);
            for (PCClass pCClass : this.classList) {
                List<CharacterSpell> list = pCClass.getSpellSupport().getCharacterSpell(null, string, -1);
                for (int i = list.size() - 1; i >= 0; --i) {
                    CharacterSpell characterSpell = list.get(i);
                    characterSpell.removeSpellInfo(characterSpell.getSpellInfoFor(string, -1, -1));
                }
            }
            return true;
        }
        return false;
    }

    public void determinePrimaryOffWeapon() {
        this.primaryWeapons.clear();
        this.secondaryWeapons.clear();
        if (this.equipmentList.isEmpty()) {
            return;
        }
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        ArrayList<Equipment> arrayList2 = new ArrayList<Equipment>();
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isWeapon() || equipment.getSlots(this) < 1) continue;
            boolean bl = equipment.isEquipped();
            if (equipment.getLocation() == 1 || equipment.getLocation() == 3 && this.primaryWeapons.isEmpty() || equipment.getLocation() == 4) {
                if (bl) {
                    this.primaryWeapons.add(equipment);
                } else {
                    arrayList.add(equipment);
                }
            } else if (equipment.getLocation() == 3 && !this.primaryWeapons.isEmpty()) {
                if (bl) {
                    this.secondaryWeapons.add(equipment);
                } else {
                    arrayList2.add(equipment);
                }
            }
            if (equipment.getLocation() == 2) {
                if (bl) {
                    this.secondaryWeapons.add(equipment);
                } else {
                    arrayList2.add(equipment);
                }
            }
            if (equipment.getLocation() != 4) continue;
            for (int i = 0; i < equipment.getNumberEquipped() - 1; ++i) {
                if (bl) {
                    this.secondaryWeapons.add(equipment);
                    continue;
                }
                arrayList2.add(equipment);
            }
        }
        if (Globals.checkRule("EQUIPATTACK")) {
            if (arrayList.size() != 0) {
                this.primaryWeapons.addAll(arrayList);
            }
            if (arrayList2.size() != 0) {
                this.secondaryWeapons.addAll(arrayList2);
            }
        }
    }

    public int dodgeAC() {
        return this.calcACOfType("Dodge");
    }

    public int equipmentAC() {
        return this.calcACOfType("Equipment") + this.calcACOfType("Armor");
    }

    public int flatfootedAC() {
        return this.calcACOfType("Flatfooted");
    }

    public boolean hasDomainSource(String string, String string2, int n) {
        String string3 = string + "|" + string2 + "|" + n;
        return this.domainSourceMap.containsKey(string3);
    }

    public boolean hasFeatAutomatic(String string) {
        return AbilityUtilities.getAbilityFromList(this.featAutoList(), "FEAT", string, Ability.Nature.ANY) != null;
    }

    public boolean hasFeatVirtual(String string) {
        return AbilityUtilities.getAbilityFromList(this.getVirtualFeatList(), "FEAT", string, Ability.Nature.ANY) != null;
    }

    public boolean hasAutomaticAbility(AbilityCategory abilityCategory, Ability ability) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.hasFeatAutomatic(ability.getKeyName());
        }
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.AUTOMATIC);
        if (list == null) {
            return false;
        }
        return list.contains(ability);
    }

    public boolean hasVirtualAbility(AbilityCategory abilityCategory, Ability ability) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.hasFeatVirtual(ability.getKeyName());
        }
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.VIRTUAL);
        if (list == null) {
            return false;
        }
        return list.contains(ability);
    }

    public boolean hasMadeKitSelectionForAgeSet(int n) {
        return n >= 0 && n < 10 && this.ageSetKitSelections[n];
    }

    public boolean hasSpecialAbility(String string) {
        for (SpecialAbility specialAbility : this.getSpecialAbilityList()) {
            if (!specialAbility.getKeyName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public int hitPoints() {
        int n = 0;
        String string = Globals.getGameModeHPFormula();
        if (string.length() != 0) {
            int n2;
            int n3;
            while ((n3 = string.indexOf("$$")) >= 0 && (n2 = string.indexOf("$$", n3 + 2)) >= 0) {
                Object object2 = string.substring(n3 + 2, n2);
                object2 = ExportHandler.getTokenString(this, (String)object2);
                string = string.substring(0, n3) + (String)object2 + string.substring(n2 + 2);
            }
            n = this.getVariableValue(string, "").intValue();
        } else {
            double d = this.getStatBonusTo("HP", "BONUS");
            if (this.race.hitDice(this) != 0) {
                n = this.race.calcHitPoints((int)d);
            }
            for (PCClass object3 : this.classList) {
                n += object3.hitPoints((int)d);
            }
        }
        n += (int)this.getTotalBonusTo("HP", "CURRENTMAX");
        PlayerCharacter playerCharacter = this.getMasterPC();
        if (playerCharacter == null) {
            return n;
        }
        if (this.getCopyMasterHP().length() == 0) {
            return n;
        }
        PlayerCharacter playerCharacter2 = this;
        Globals.setCurrentPC(playerCharacter);
        int n4 = playerCharacter.hitPoints();
        Globals.setCurrentPC(playerCharacter2);
        String string2 = this.replaceMasterString(this.getCopyMasterHP(), n4);
        n4 = this.getVariableValue(string2, "").intValue();
        return n4;
    }

    public boolean ignoreEncumberedArmorMove(Load load) {
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null || !load.checkLtEq(pObject.getEncumberedArmorMove())) continue;
            return true;
        }
        return false;
    }

    public boolean ignoreEncumberedLoadMove(Load load) {
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null || !load.checkLtEq(pObject.getEncumberedLoadMove())) continue;
            return true;
        }
        return false;
    }

    public void incrementClassLevel(int n, PCClass pCClass) {
        this.incrementClassLevel(n, pCClass, false);
        this.setDirty(true);
    }

    public int indexOfFirstEmptyCharacterDomain() {
        for (int i = 0; i < this.characterDomainList.size(); ++i) {
            CharacterDomain characterDomain = this.characterDomainList.get(i);
            if (characterDomain.getDomain() != null) continue;
            return i;
        }
        return -1;
    }

    public int initiativeMod() {
        int n = (int)this.getTotalBonusTo("COMBAT", "Initiative") + this.getVariableValue("INITCOMP", "").intValue();
        return n;
    }

    public int languageNum(boolean bl) {
        int n = (int)this.getStatBonusTo("LANG", "BONUS");
        Race race = this.getRace();
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        if (n < 0) {
            n = 0;
        }
        if (bl) {
            for (Skill pObject : arrayList) {
                if (pObject.getChoiceString().indexOf("Language") < 0) continue;
                n += pObject.getTotalRank(this).intValue();
            }
        }
        if (race != null) {
            n += race.getLangNum() + (int)this.getTotalBonusTo("LANGUAGES", "NUMBER");
        }
        for (PCClass pCClass : this.classList) {
            int n2 = pCClass.getLevel();
            List<LevelAbility> list = pCClass.getLevelAbilityList();
            if (list == null) continue;
            for (int i = list.size() - 1; i >= 0; --i) {
                LevelAbility levelAbility = list.get(i);
                if (!levelAbility.isLanguage() || n2 < levelAbility.level()) continue;
                ++n;
            }
        }
        return n += this.freeLangs;
    }

    public String listBonusesFor(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : this.getActiveBonusMap().keySet()) {
            int n;
            if (!string3.startsWith(string)) continue;
            if (string3.endsWith(".REPLACE")) {
                arrayList.add(string3);
                continue;
            }
            string2 = "";
            if (string3.length() > string.length()) {
                string2 = string3.substring(string.length() + 1);
            }
            if ((n = (int)this.getActiveBonusForMapKey(string3, 0.0)) == 0) continue;
            if (!"NULL".equals(string2) && string2.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string2).append(' ');
            }
            stringBuffer.append(Delta.toString(n));
        }
        for (String string3 : arrayList) {
            String string4;
            if (string3.length() <= 7) continue;
            string2 = string3.substring(0, string3.length() - 8);
            double d = this.getActiveBonusForMapKey(string3, 0.0);
            double d2 = this.getActiveBonusForMapKey(string2, 0.0);
            int n = (int)Math.max(d2 += this.getActiveBonusForMapKey(string2 + ".STACK", 0.0), d);
            if (n == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (!"NULL".equals(string4 = string2.substring(string.length() + 1))) {
                stringBuffer.append(string4).append(' ');
            }
            stringBuffer.append(Delta.toString(n));
        }
        return stringBuffer.toString();
    }

    public boolean loadDescriptionFilesInDirectory(String string) {
        new File(string).list(new FilenameFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                if (PCGFile.isPCGenListFile(file2)) {
                    BufferedReader bufferedReader = null;
                    try {
                        if (!file2.exists()) return false;
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
                        int n = (int)file2.length();
                        char[] cArray = new char[n];
                        bufferedReader.read(cArray, 0, n);
                        PlayerCharacter.this.setDescriptionLst(PlayerCharacter.this.getDescriptionLst() + new String(cArray));
                        return false;
                    }
                    catch (IOException iOException) {
                        Logging.errorPrint("IOException in PlayerCharacter.loadDescriptionFilesInDirectory", iOException);
                        return false;
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {
                                Logging.errorPrint("Couldn't close descriptionReader in PlayerCharacter.loadDescriptionFilesInDirectory", iOException);
                            }
                        }
                    }
                }
                if (!file.isDirectory()) return false;
                PlayerCharacter.this.loadDescriptionFilesInDirectory(file.getPath() + File.separator + string);
                return false;
            }
        });
        return false;
    }

    public void makeIntoExClass(PCClass pCClass) {
        String string = pCClass.getExClass();
        if (string.length() == 0) {
            return;
        }
        try {
            int n;
            PCClass pCClass2 = this.getClassKeyed(string);
            if (pCClass2 == null) {
                pCClass2 = Globals.getClassKeyed(string);
                if (pCClass2 == null) {
                    return;
                }
                pCClass2 = pCClass2.clone();
                this.rebuildLists(pCClass2, pCClass, pCClass.getLevel(), this);
                pCClass2.setLevel(pCClass.getLevel(), this);
                pCClass2.setHitPointMap(pCClass.getHitPointMap());
                n = this.classList.indexOf(pCClass);
                this.classList.set(n, pCClass2);
            } else {
                this.rebuildLists(pCClass2, pCClass, pCClass.getLevel(), this);
                pCClass2.setLevel(pCClass2.getLevel() + pCClass.getLevel(), this);
                for (n = 0; n < pCClass.getLevel(); ++n) {
                    pCClass2.setHitPoint(pCClass2.getLevel() + n + 1, pCClass.getHitPoint(n + 1));
                }
                this.classList.remove(pCClass);
            }
            for (n = this.pcLevelInfo.size() - 1; n >= 0; --n) {
                PCLevelInfo cloneable = this.pcLevelInfo.get(n);
                if (!cloneable.getClassKeyName().equals(pCClass.getKeyName())) continue;
                cloneable.setClassKeyName(pCClass2.getKeyName());
            }
            for (Skill skill : this.getSkillList()) {
                skill.replaceClassRank(pCClass.getKeyName(), string);
            }
            pCClass2.setSkillPool(pCClass.getSkillPool(this));
        }
        catch (NumberFormatException numberFormatException) {
            ShowMessageDelegate.showMessageDialog(numberFormatException.getMessage(), "PCGen", MessageType.INFORMATION);
        }
    }

    public int minXPForECL() {
        return PlayerCharacterUtilities.minXPForLevel(this.getECL(), this);
    }

    public int minXPForNextECL() {
        return PlayerCharacterUtilities.minXPForLevel(this.getECL() + 1, this);
    }

    public int miscAC() {
        return this.calcACOfType("Misc");
    }

    public int modFromArmorOnWeaponRolls() {
        int n = 0;
        for (Equipment equipment : this.getEquipmentOfType("Armor", 1)) {
            if (equipment == null || this.isProficientWith(equipment)) continue;
            n += equipment.acCheck(this).intValue();
        }
        for (Equipment equipment : this.getEquipmentOfType("Shield", 1)) {
            if (equipment == null || this.isProficientWith(equipment)) continue;
            n += equipment.acCheck(this).intValue();
        }
        return n;
    }

    private Load getLoadType() {
        if (Globals.checkRule("SYS_LDPACSK")) {
            int n = this.getVariableValue("LOADSCORE", "").intValue();
            return Globals.loadTypeForLoadScore(n, this.totalWeight(), this);
        }
        return Load.LIGHT;
    }

    private int modToACFromEquipment() {
        int n = 0;
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            n += equipment.getACMod(this).intValue();
        }
        return n;
    }

    private int modToACCHECKFromEquipment() {
        Load load = this.getLoadType();
        int n = 0;
        int n2 = Load.MEDIUM == load ? -3 : (Load.HEAVY == load ? -6 : 0);
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            n += equipment.acCheck(this).intValue();
        }
        n = Math.min(n, n2);
        return n += (int)this.getTotalBonusTo("MISC", "ACCHECK");
    }

    private int modToSpellFailureFromEquipment() {
        int n = 0;
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            n += equipment.spellFailure(this).intValue();
        }
        return n += (int)this.getTotalBonusTo("MISC", "SPELLFAILURE");
    }

    private int modToMaxDexFromEquipment() {
        int n = (int)this.getStatBonusTo("MISC", "MAXDEX");
        Load load = this.getLoadType();
        int n2 = load == Load.MEDIUM ? 3 : (load == Load.HEAVY ? 1 : (load == Load.OVERLOAD ? 0 : n));
        boolean bl = load == Load.LIGHT;
        for (Equipment equipment : this.equipmentList) {
            int n3;
            if (!equipment.isEquipped() || (n3 = equipment.getMaxDex(this).intValue()) == 100) continue;
            if (bl || n2 > n3) {
                n2 = n3;
            }
            bl = false;
        }
        if (bl) {
            n2 = 100;
        }
        if ((n2 += (int)this.getTotalBonusTo("MISC", "MAXDEX") - n) < 0) {
            n2 = 0;
        } else if (n2 > 100) {
            n2 = 100;
        }
        return n2;
    }

    public int modToFromEquipment(String string) {
        if (string.equals("AC")) {
            return this.modToACFromEquipment();
        }
        if (string.equals("ACCHECK")) {
            return this.modToACCHECKFromEquipment();
        }
        if (string.equals("MAXDEX")) {
            return this.modToMaxDexFromEquipment();
        }
        if (string.equals("SPELLFAILURE")) {
            return this.modToSpellFailureFromEquipment();
        }
        return 0;
    }

    public double movement(int n) {
        double d = this.getMovement(n);
        d += this.getTotalBonusTo("MOVEADD", "TYPE." + this.getMovementType(n).toUpperCase());
        double d2 = d += this.getTotalBonusTo("MOVEADD", "TYPE.ALL");
        if (this.getMovementMult(n) > 0.0) {
            d2 = this.calcMoveMult(d, n);
        }
        double d3 = this.getTotalBonusTo("MOVEMULT", "TYPE." + this.getMovementType(n).toUpperCase());
        if ((d3 += this.getTotalBonusTo("MOVEMULT", "TYPE.ALL")) > 0.0) {
            d2 = (int)(d2 * d3);
        }
        double d4 = d2;
        d4 += this.getTotalBonusTo("POSTMOVEADD", "TYPE." + this.getMovementType(n).toUpperCase());
        d = Math.max(d2, d4 += this.getTotalBonusTo("POSTMOVEADD", "TYPE.ALL"));
        Load load = Load.LIGHT;
        for (Equipment equipment : this.getEquipmentOfType("Armor", 1)) {
            if (equipment.isShield()) continue;
            if (equipment.isHeavy() && !this.ignoreEncumberedArmorMove(Load.HEAVY)) {
                load = load.max(Load.HEAVY);
                continue;
            }
            if (!equipment.isMedium() || this.ignoreEncumberedArmorMove(Load.MEDIUM)) continue;
            load = load.max(Load.MEDIUM);
        }
        double d5 = Globals.calcEncumberedMove(load, d, true, null);
        Load load2 = Globals.loadTypeForLoadScore(this.getVariableValue("LOADSCORE", "").intValue(), this.totalWeight(), this);
        double d6 = Globals.calcEncumberedMove(load2, d, true, this);
        d = Math.min(d5, d6);
        return d;
    }

    public double multiclassXPMultiplier() {
        TreeSet<String> treeSet = new TreeSet<String>();
        SortedSet<String> sortedSet = this.getFavoredClasses();
        boolean bl = false;
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 1.0;
        if (sortedSet.contains("Any")) {
            bl = true;
        }
        for (PCClass object : this.classList) {
            if (sortedSet.contains(object.getDisplayClassName()) || sortedSet.contains(object.toString()) || !object.hasXPPenalty()) continue;
            treeSet.add(object.getDisplayClassName());
            if (object.getLevel() > n) {
                if (bl) {
                    n2 = n;
                    string2 = string;
                }
                n = object.getLevel();
                string = object.getDisplayClassName();
                continue;
            }
            if (object.getLevel() <= n2 || !bl) continue;
            n2 = object.getLevel();
            string2 = object.getDisplayClassName();
        }
        if (bl && n2 > 0) {
            n = n2;
            treeSet.remove(string);
            string = string2;
        }
        if (n > 0) {
            treeSet.remove(string);
            for (String string3 : treeSet) {
                PCClass pCClass = this.getClassDisplayNamed(string3);
                if (pCClass == null || n - pCClass.getLevel() <= 1) continue;
                ++n3;
            }
            d = 1.0 - (double)n3 * 0.2;
            if (d < 0.0) {
                d = 0.0;
            }
        }
        return d;
    }

    public int naturalAC() {
        return this.calcACOfType("NaturalArmor");
    }

    public String parseSpellString(Spell spell, String string, PObject pObject) {
        String string2 = null;
        if (pObject instanceof Domain) {
            CharacterDomain characterDomain = this.getCharacterDomainForDomain(pObject.getKeyName());
            if (characterDomain != null && characterDomain.isFromPCClass()) {
                string2 = "CLASS:" + this.getClassKeyed(characterDomain.getObjectName());
            }
        } else if (pObject instanceof PCClass) {
            string2 = "CLASS:" + pObject.getKeyName();
        } else if (pObject instanceof Race) {
            string2 = "RACE:" + pObject.getKeyName();
        }
        if (string2 == null) {
            return string;
        }
        while (string.lastIndexOf(40) >= 0) {
            boolean bl = false;
            int n = string.indexOf(40);
            int n2 = 0;
            int n3 = 0;
            for (int i = n; i < string.length(); ++i) {
                if (string.charAt(i) == '(') {
                    ++n3;
                    continue;
                }
                if (string.charAt(i) != ')' || --n3 != 0) continue;
                n2 = i;
                break;
            }
            String string3 = string.substring(n + 1, n2);
            String string4 = "0";
            Float f = this.getVariableValue(spell, string3, string2);
            if (!CoreUtility.doublesEqual(f.floatValue(), 0.0)) {
                bl = true;
                string4 = f.intValue() + "";
            } else if (string3.indexOf("MIN") >= 0 || string3.indexOf("MAX") >= 0) {
                bl = true;
                string4 = f.intValue() + "";
            } else if (string3.toUpperCase().indexOf("MIN(") >= 0 || string3.toUpperCase().indexOf("MAX(") >= 0) {
                bl = true;
                string4 = f.intValue() + "";
            }
            if (bl) {
                string = string.substring(0, n) + string4 + string.substring(n2 + 1);
                continue;
            }
            string = string.substring(0, n) + "[" + string3 + "]" + string.substring(n2 + 1);
        }
        return string;
    }

    public void populateSkills(int n) {
        boolean bl;
        int n2;
        Globals.sortPObjectListByName(this.getSkillList());
        this.removeExcessSkills(n);
        this.addNewSkills(n);
        switch (this.getSkillsOutputOrder()) {
            case 0: {
                n2 = 0;
                bl = true;
                break;
            }
            case 1: {
                n2 = 0;
                bl = false;
                break;
            }
            case 2: {
                n2 = 1;
                bl = true;
                break;
            }
            case 3: {
                n2 = 1;
                bl = false;
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<Skill> arrayList = this.getSkillList();
        SkillComparator skillComparator = new SkillComparator(n2, bl);
        int n3 = 1;
        Collections.sort(arrayList, skillComparator);
        for (Skill skill : arrayList) {
            if (skill.getOutputIndex() < 0) continue;
            skill.setOutputIndex(n3++);
        }
    }

    public void removeCharacterDomain(CharacterDomain characterDomain) {
        if (!this.characterDomainList.isEmpty()) {
            this.characterDomainList.remove(characterDomain);
            this.setDirty(true);
        }
    }

    public void removeCharacterDomain(String string) {
        CharacterDomain characterDomain = this.getCharacterDomainForDomain(string);
        this.characterDomainList.remove(characterDomain);
    }

    public void removeNaturalWeapons(PObject pObject) {
        for (Equipment equipment : pObject.getNaturalWeapons()) {
            this.removeEquipment(equipment);
            this.delEquipSetItem(equipment);
            this.setDirty(true);
        }
    }

    public void removeTempBonus(BonusObj bonusObj) {
        this.getTempBonusList().remove(bonusObj);
        this.setDirty(true);
    }

    public void removeTempBonusItemList(Equipment equipment) {
        this.getTempBonusItemList().remove(equipment);
        this.setDirty(true);
    }

    public void removeTemplate(PCTemplate pCTemplate) {
        int n;
        if (pCTemplate == null) {
            return;
        }
        this.cachedWeaponProfs = null;
        this.languages.removeAll(pCTemplate.getSafeListFor(ListKey.AUTO_LANGUAGES));
        this.templateAutoLanguages.removeAll(pCTemplate.getSafeListFor(ListKey.AUTO_LANGUAGES));
        this.templateLanguages.removeAll(pCTemplate.getLanguageBonus());
        this.removeNaturalWeapons(pCTemplate);
        PCTemplate pCTemplate2 = this.getTemplateKeyed(pCTemplate.getKeyName());
        for (n = pCTemplate.getLevelMods().size() - 1; n >= 0; --n) {
            String object = pCTemplate.getLevelMods().get(n);
            StringTokenizer stringTokenizer = new StringTokenizer(object, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (!string.startsWith("ADD")) continue;
                String string2 = stringTokenizer.nextToken();
                int n2 = this.getVariableValue(stringTokenizer.nextToken(), "").intValue();
                PCClass pCClass = this.getClassKeyed(string2);
                boolean bl = SettingsHandler.getShowHPDialogAtLevelUp();
                SettingsHandler.setShowHPDialogAtLevelUp(false);
                boolean bl2 = SettingsHandler.getShowFeatDialogAtLevelUp();
                SettingsHandler.setShowFeatDialogAtLevelUp(false);
                int n3 = SettingsHandler.getSingleChoicePreference();
                SettingsHandler.setSingleChoicePreference(2);
                this.incrementClassLevel(-n2, pCClass, true, true);
                SettingsHandler.setSingleChoicePreference(n3);
                SettingsHandler.setShowFeatDialogAtLevelUp(bl2);
                SettingsHandler.setShowHPDialogAtLevelUp(bl);
            }
        }
        for (n = 0; n < pCTemplate.templatesAdded().size(); ++n) {
            this.removeTemplate(this.getTemplateKeyed(pCTemplate.templatesAdded().get(n)));
        }
        for (PCTemplate pCTemplate3 : this.templateList) {
            if (!pCTemplate3.getKeyName().equals(pCTemplate.getKeyName())) continue;
            this.templateList.remove(pCTemplate3);
            break;
        }
        if (!PlayerCharacterUtilities.canReassignTemplateFeats()) {
            this.setAutomaticFeatsStable(false);
        }
        this.adjustMoveRates();
        this.getSpellList();
        this.calcActiveBonuses();
        this.setDirty(true);
    }

    public String replaceMasterString(String string, int n) {
        int n2;
        while ((n2 = string.indexOf("MASTER")) != -1) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 6);
            string = string2 + Integer.toString(n) + string3;
        }
        return string;
    }

    public PCLevelInfo saveLevelInfo(String string) {
        PCLevelInfo pCLevelInfo = new PCLevelInfo(this, string);
        this.pcLevelInfo.add(pCLevelInfo);
        return pCLevelInfo;
    }

    public void saveStatIncrease(String string, int n, boolean bl) {
        int n2 = this.getLevelInfoSize() - 1;
        if (n2 >= 0) {
            this.pcLevelInfo.get(n2).addModifiedStat(string, n, bl);
        }
        this.setDirty(true);
    }

    public int getStatIncrease(String string, boolean bl) {
        int n = this.getLevelInfoSize() - 1;
        if (n >= 0) {
            return this.pcLevelInfo.get(n).getTotalStatMod(string, bl);
        }
        return 0;
    }

    public int sizeAC() {
        return this.calcACOfType("Size");
    }

    public int sizeInt() {
        int n = this.racialSizeInt();
        if (this.race != null) {
            n += (int)this.getTotalBonusTo("SIZEMOD", "NUMBER");
            for (int i = 0; i < this.race.sizesAdvanced(this.totalHitDice()); ++i) {
                ++n;
            }
            if (n < 0) {
                n = 0;
            }
            if (n >= SettingsHandler.getGame().getSizeAdjustmentListSize()) {
                n = SettingsHandler.getGame().getSizeAdjustmentListSize() - 1;
            }
        }
        return n;
    }

    public int totalHitDice() {
        return this.race.hitDice(this) + this.totalMonsterLevels();
    }

    public int totalNonMonsterLevels() {
        int n = 0;
        for (PCClass pCClass : this.classList) {
            if (pCClass.isMonster()) continue;
            n += pCClass.getLevel();
        }
        return n;
    }

    public BigDecimal totalValue() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (Equipment equipment : this.getEquipmentMasterList()) {
            bigDecimal = bigDecimal.add(equipment.getCost(this).multiply(new BigDecimal(equipment.qty())));
        }
        return bigDecimal;
    }

    public Float totalWeight() {
        float f = 0.0f;
        Float f2 = Float.valueOf(0.0f);
        boolean bl = true;
        if (this.equipmentList.isEmpty()) {
            return f2;
        }
        for (Equipment equipment : this.equipmentList) {
            if (equipment.getCarried().compareTo(f2) <= 0 || equipment.getParent() != null) continue;
            if (equipment.getChildCount() > 0) {
                f = (float)((double)f + (equipment.getWeightAsDouble(this) + (double)equipment.getContainedWeight(this).floatValue()));
                continue;
            }
            if (bl && equipment.isEquipped() && equipment.isType("CLOTHING")) {
                bl = false;
                f = (float)((double)f + equipment.getWeightAsDouble(this) * (double)Math.max(equipment.getCarried().floatValue() - 1.0f, 0.0f));
                continue;
            }
            f = (float)((double)f + equipment.getWeightAsDouble(this) * (double)equipment.getCarried().floatValue());
        }
        return Float.valueOf(f);
    }

    public int touchAC() {
        return this.calcACOfType("Touch");
    }

    public void updateEquipSetItem(Equipment equipment, Equipment equipment2) {
        if (this.equipSetList.isEmpty()) {
            return;
        }
        ArrayList<EquipSet> arrayList = new ArrayList<EquipSet>();
        for (EquipSet equipSet : this.equipSetList) {
            Equipment equipment3 = equipSet.getItem();
            if (equipment3 == null || !equipment.equals(equipment3)) continue;
            arrayList.add(equipSet);
        }
        for (EquipSet equipSet : arrayList) {
            equipSet.setValue(equipment2.getName());
            equipSet.setItem(equipment2);
        }
        this.setDirty(true);
    }

    public boolean wasEverSaved() {
        return !"".equals(this.getFileName());
    }

    void setActiveBonusStack(double d, String string, Map<String, String> map) {
        String string2;
        if (string != null) {
            if (!((string = string.toUpperCase()).startsWith("ITEMWEIGHT") || string.startsWith("ITEMCOST") || string.startsWith("ACVALUE") || string.startsWith("ITEMCAPACITY") || string.startsWith("LOADMULT") || string.startsWith("FEAT") || string.indexOf("DAMAGEMULT") >= 0)) {
                d = (int)d;
            }
        } else {
            return;
        }
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() == 2) {
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                n = SettingsHandler.getGame().getUnmodifiableBonusStackList().indexOf(string2);
            }
        } else {
            n = 1;
        }
        if (string.endsWith(".STACK") || string.endsWith(".REPLACE")) {
            n = 1;
        }
        if (d < 0.0) {
            n = 1;
        }
        if (n == -1) {
            string2 = map.get(string);
            if (string2 == null) {
                this.putActiveBonusMap(string, String.valueOf(d), map);
            } else {
                this.putActiveBonusMap(string, String.valueOf(Math.max(d, (double)Float.parseFloat(string2))), map);
            }
        } else {
            if (string == null) {
                string = "";
            }
            if ((string2 = map.get(string)) == null) {
                this.putActiveBonusMap(string, String.valueOf(d), map);
            } else {
                this.putActiveBonusMap(string, String.valueOf(d + (double)Float.parseFloat(string2)), map);
            }
        }
    }

    public List<Ability> getAvailableAbilities(String string, String string2, boolean bl) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator(string);
        while (iterator.hasNext()) {
            Ability ability = (Ability)iterator.next();
            if (!ability.matchesType(string2) || !this.canSelectAbility(ability, bl)) continue;
            arrayList.add(ability);
        }
        return arrayList;
    }

    public List<String> getAvailableFeatNames(String string) {
        return this.getAvailableFeatNames(string, false);
    }

    public List<String> getAvailableFeatNames(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
        while (iterator.hasNext()) {
            Ability ability = (Ability)iterator.next();
            if (!ability.matchesType(string) || !this.canSelectAbility(ability, bl)) continue;
            arrayList.add(ability.getKeyName());
        }
        return arrayList;
    }

    public boolean isNotImporting() {
        return !this.importing;
    }

    public boolean isImporting() {
        return this.importing;
    }

    Double getMovementMult(int n) {
        if (this.getMovements() != null && n < this.movementMult.length) {
            return this.movementMult[n];
        }
        return 0.0;
    }

    void addVariable(String string) {
        this.variableList.add(string);
        this.setDirty(true);
    }

    void giveClassesAway(PCClass pCClass, PCClass pCClass2, int n) {
        int n2;
        if (pCClass == null || pCClass2 == null) {
            return;
        }
        if (pCClass.hasMaxLevel() && pCClass.getLevel() + n > pCClass.getMaxLevel()) {
            n = pCClass.getMaxLevel() - pCClass.getLevel();
        }
        if (pCClass2.getLevel() <= n || n < 1) {
            return;
        }
        int n3 = pCClass2.getLevel() - n;
        int n4 = pCClass.getLevel();
        pCClass.setLevel(n4 + n, this);
        for (int i = 0; i < n; ++i) {
            pCClass.setHitPoint(n4 + i, pCClass2.getHitPoint(n3 + i));
            pCClass2.setHitPoint(n3 + i, 0);
        }
        this.rebuildLists(pCClass, pCClass2, n, this);
        pCClass2.setLevel(n3, this);
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName())) continue;
            n2 = pCLevelInfo.getLevel() + pCClass.getLevel() - n4;
            pCLevelInfo.setLevel(n2);
        }
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            if (!pCLevelInfo.getClassKeyName().equals(pCClass2.getKeyName()) || pCLevelInfo.getLevel() <= n3) continue;
            n2 = pCLevelInfo.getLevel() - n3;
            pCLevelInfo.setClassKeyName(pCClass.getKeyName());
            pCLevelInfo.setLevel(n2);
        }
    }

    public boolean containsCharacterDomain(String string) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (!domain.getKeyName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCharacterDomain(String string, String string2) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain;
            if (!characterDomain.isFromPCClass(string) || !(domain = characterDomain.getDomain()).getKeyName().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int getCharacterDomainIndex(String string) {
        for (int i = 0; i < this.characterDomainList.size(); ++i) {
            CharacterDomain characterDomain = this.characterDomainList.get(i);
            Domain domain = characterDomain.getDomain();
            if (domain == null || !domain.getKeyName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    boolean addFavoredClass(String string) {
        if (string.length() != 0 && !this.favoredClasses.contains(string)) {
            this.favoredClasses.add(string);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    void addFreeLanguage(Language language) {
        this.languages.add(language);
        ++this.freeLangs;
        this.setDirty(true);
    }

    void addFreeLanguageKeyed(String string) {
        Language language = Globals.getLanguageKeyed(string);
        if (language != null) {
            this.addFreeLanguage(language);
        }
    }

    boolean hasSpecialAbility(SpecialAbility specialAbility) {
        String string = specialAbility.getKeyName();
        String string2 = specialAbility.getSADesc();
        for (SpecialAbility specialAbility2 : this.getSpecialAbilityList()) {
            if (!specialAbility2.getKeyName().equalsIgnoreCase(string) || !specialAbility2.getSADesc().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    boolean removeFavoredClass(String string) {
        if (this.favoredClasses.contains(string)) {
            this.favoredClasses.remove(string);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    void removeVariable(String string) {
        Iterator<String> iterator = this.variableList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            iterator.remove();
            this.setDirty(true);
        }
    }

    void validateCharacterDomains() {
        if (!this.isImporting()) {
            this.getSpellList();
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            if (characterDomain.isDomainValidFor(this)) continue;
            this.removeCharacterDomain(characterDomain);
        }
    }

    private double getActiveBonusForMapKey(String string, double d) {
        string = string.toUpperCase();
        String string2 = this.getActiveBonusMap().get(string);
        if (string2 != null) {
            return Double.parseDouble(string2);
        }
        return d;
    }

    public List<BonusObj> getActiveBonusList() {
        return this.activeBonusList;
    }

    private List<String> getAutoArmorProfList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null) continue;
            pObject.addAutoTagsToList("ARMORPROF", arrayList, this, true);
        }
        return arrayList;
    }

    private double getCheckBonusTo(String string, String string2) {
        double d = 0.0;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        List<PObject> list = SettingsHandler.getGame().getUnmodifiableCheckList();
        for (PObject pObject : list) {
            List<BonusObj> list2 = pObject.getBonusListOfType(string, string2);
            if (list2.isEmpty()) continue;
            d += this.calcBonusFromList(list2);
        }
        return d;
    }

    private synchronized void setClassLevelsBrazenlyTo(Map<String, String> map) {
        for (PCClass pCClass : this.classList) {
            String string = map.get(pCClass.getKeyName());
            if (string == null) {
                string = "0";
            }
            pCClass.setLevelWithoutConsequence(Integer.parseInt(string));
        }
        this.calcActiveBonuses();
    }

    private String getDisplayClassName() {
        return this.classList.isEmpty() ? "Nobody" : this.classList.get(this.classList.size() - 1).getDisplayClassName();
    }

    private String getDisplayRaceName() {
        String string = this.getRace().toString();
        return string.equals("<none selected>") ? "Nothing" : string;
    }

    public double getEquipmentBonusTo(String string, String string2) {
        double d = 0.0;
        if (this.equipmentList.isEmpty()) {
            return d;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            List<BonusObj> list = equipment.getBonusListOfType(string, string2, true);
            if (equipment.isWeapon() && equipment.isDouble()) {
                list.addAll(equipment.getBonusListOfType(string, string2, false));
            }
            d += this.calcBonusFromList(list);
        }
        return d;
    }

    private Ability getFeatKeyed(String string, List<Ability> list) {
        if (list.isEmpty()) {
            return null;
        }
        for (Ability ability : list) {
            if (!ability.getKeyName().equalsIgnoreCase(string)) continue;
            return ability;
        }
        return null;
    }

    private String getFullDisplayClassName() {
        if (this.classList.isEmpty()) {
            return "Nobody";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (PCClass pCClass : this.classList) {
            if (!bl) {
                stringBuffer.append('/');
                bl = false;
            }
            stringBuffer.append(pCClass.getFullDisplayClassName());
        }
        return stringBuffer.toString();
    }

    private Map<String, String> getCharacterLevelHashMap(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        for (int i = 0; i < this.getLevelInfoSize(); ++i) {
            String string = this.getLevelInfoClassKeyName(i);
            PCClass pCClass = Globals.getClassKeyed(string);
            if (pCClass.isMonster() || n2 < n) {
                String string2 = (String)hashMap.get(string);
                if (string2 == null) {
                    string2 = "0";
                }
                string2 = String.valueOf(Integer.parseInt(string2) + 1);
                hashMap.put(string, string2);
            }
            if (pCClass.isMonster()) continue;
            ++n2;
        }
        return hashMap;
    }

    private void setMoveFromList(List<? extends PObject> list) {
        for (PObject pObject : list) {
            List<Movement> list2 = pObject.getMovements();
            if (list2 == null || list2.isEmpty()) continue;
            for (Movement movement : list2) {
                if (movement == null || movement.getNumberOfMovements() < 1) continue;
                for (int i = 0; i < movement.getNumberOfMovements(); ++i) {
                    this.setMyMoveRates(movement.getMovementType(i), movement.getMovement(i), movement.getMovementMult(i), movement.getMovementMultOp(i), movement.getMoveRatesFlag());
                }
            }
        }
    }

    public Double[] getMovements() {
        return this.movements;
    }

    private void setMyMoveRates(String string, double d, Double d2, String string2, int n) {
        if ("ALL".equals(string)) {
            if (n == 0) {
                for (int i = 0; i < this.movements.length; ++i) {
                    Double d3;
                    this.movements[i] = d3 = new Double(d);
                }
            } else {
                for (int i = 0; i < this.movements.length; ++i) {
                    Double d4;
                    this.movements[i] = d4 = new Double(d + this.movements[i]);
                }
            }
        } else if (n == 0) {
            Double d5 = new Double(d);
            for (int i = 0; i < this.movements.length; ++i) {
                if (!string.equals(this.movementTypes[i])) continue;
                this.movements[i] = d5;
                this.movementMult[i] = d2;
                this.movementMultOp[i] = string2;
                return;
            }
            this.increaseMoveArray(d5, string, d2, string2);
        } else if (n == 1) {
            for (int i = 0; i < this.movements.length; ++i) {
                Double d6 = new Double(d + this.movements[i]);
                if (string.equals(this.movementTypes[i])) {
                    this.movements[i] = d6;
                    this.movementMult[i] = d2;
                    this.movementMultOp[i] = string2;
                    return;
                }
                this.increaseMoveArray(d6, string, d2, string2);
            }
        } else {
            Double d7 = new Double(d + this.movements[0]);
            for (int i = 0; i < this.movements.length; ++i) {
                if (!string.equals(this.movementTypes[i])) continue;
                this.movements[i] = d7;
                this.movementMult[i] = d2;
                this.movementMultOp[i] = string2;
                return;
            }
            this.increaseMoveArray(d7, string, d2, string2);
        }
        this.setDirty(true);
    }

    int getNumAttacks() {
        return Math.min(Math.max(this.baseAttackBonus() / 5, 4), 1);
    }

    private String getOrdinal(int n) {
        switch (n) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    private double getPObjectWithCostBonusTo(List<? extends PObject> list, String string, String string2, boolean bl) {
        double d = 0.0;
        if (list.isEmpty()) {
            return d;
        }
        for (PObject pObject : list) {
            List<BonusObj> list2 = pObject.getBonusListOfType(string, string2);
            d += this.calcBonusWithCostFromList(list2, bl);
        }
        return d;
    }

    private boolean isProficientWith(Equipment equipment, List<String> list) {
        String string;
        for (int i = 0; i < list.size() && ((string = list.get(i)).startsWith("TYPE=") || string.startsWith("TYPE.")); ++i) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(5), ".");
            int n2 = stringTokenizer.countTokens();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!equipment.isType(string2)) continue;
                ++n;
            }
            if (n != n2) continue;
            return true;
        }
        return list.contains(equipment.profKey(this));
    }

    private boolean isProficientWithWeapon(Equipment equipment) {
        if (equipment.isNatural()) {
            return true;
        }
        WeaponProf weaponProf = equipment.getExpandedWeaponProf(this);
        if (weaponProf == null) {
            return false;
        }
        return this.hasWeaponProfKeyed(weaponProf.getKeyName());
    }

    private SortedSet<String> getRacialFavoredClasses() {
        String string = this.getRace().getFavoredClass();
        if (string.startsWith("CHOOSE:")) {
            Cloneable cloneable;
            ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(7), "|");
            while (stringTokenizer.hasMoreTokens()) {
                cloneable = Globals.getClassKeyed(stringTokenizer.nextToken());
                if (cloneable == null) continue;
                arrayList.add(cloneable);
            }
            cloneable = new ArrayList(1);
            Globals.getChoiceFromList("Select favored class", arrayList, cloneable, 1, true);
            string = ((PCClass)cloneable.get(0)).getKeyName();
        }
        if (this.addFavoredClass(string)) {
            this.setStringFor(StringKey.RACIAL_FAVORED_CLASS, string);
        } else {
            this.removeStringFor(StringKey.RACIAL_FAVORED_CLASS);
        }
        return this.favoredClasses;
    }

    private List<String> getSelectedArmorProfList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PObject pObject : this.getPObjectList()) {
            List<String> list;
            if (pObject == null || (list = pObject.getListFor(ListKey.SELECTED_ARMOR_PROF)) == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private String getSubRegion(boolean bl) {
        String string = this.getStringFor(StringKey.SUB_REGION);
        if (string != null || !bl) {
            return string;
        }
        String string2 = "None";
        for (PCTemplate pCTemplate : this.templateList) {
            String string3 = pCTemplate.getSubRegion();
            if (string3.equals("None")) continue;
            string2 = string3;
        }
        return string2;
    }

    private int getTotalClassLevels() {
        int n = 0;
        for (PCClass pCClass : this.classList) {
            n += pCClass.getLevel();
        }
        return n;
    }

    private int getTotalCharacterLevel() {
        int n = 0;
        for (PCClass pCClass : this.classList) {
            if (pCClass.isMonster()) continue;
            n += pCClass.getLevel();
        }
        return n;
    }

    private HashMap<String, String> getTotalLevelHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (PCClass pCClass : this.classList) {
            hashMap.put(pCClass.getKeyName(), String.valueOf(pCClass.getLevel()));
        }
        return hashMap;
    }

    private boolean isVirtualFeatsStable() {
        return this.virtualFeatsStable;
    }

    private void addListToActiveBonuses(List<BonusObj> list) {
        if (list == null) {
            return;
        }
        this.activeBonusList.addAll(list);
    }

    private void addSpells(PObject pObject) {
        if (this.race == null || pObject == null || pObject.getSpellList() == null || pObject.getSpellList().isEmpty()) {
            return;
        }
        List<PCSpell> list = pObject.getSpellList();
        for (PCSpell pCSpell : list) {
            String string = pCSpell.getKeyName();
            Spell spell = Globals.getSpellKeyed(string);
            if (spell == null) {
                return;
            }
            String string2 = pCSpell.getTimesPerDay();
            int n = -1;
            int n2 = 1;
            int n3 = 0;
            PObject pObject2 = this.race;
            if (string2 == null || string2.equals("")) {
                n2 = 1;
            } else if (string2.startsWith("LEVEL=") || string2.startsWith("LEVEL.")) {
                n3 = n = Integer.parseInt(string2.substring(6));
                if (pObject instanceof PCClass) {
                    pObject2 = pObject;
                }
            } else {
                n2 = this.getVariableValue(string2, "").intValue();
            }
            String string3 = pCSpell.getSpellbook();
            String string4 = pCSpell.getDcFormula();
            if (string4 != null && !string4.equals("")) {
                this.getVariableValue(string4, "").intValue();
            }
            if (!PrereqHandler.passesAll(pCSpell.getPreReqList(), this, pCSpell)) continue;
            Spell spell2 = spell.clone();
            spell.setFixedCasterLevel(pCSpell.getCasterLevelFormula());
            spell.setFixedDC(pCSpell.getDcFormula());
            List<CharacterSpell> list2 = pObject2.getSpellSupport().getCharacterSpell(spell2, string3, n);
            if (!list2.isEmpty()) continue;
            CharacterSpell characterSpell = new CharacterSpell(pObject2, spell);
            characterSpell.addInfo(n3, n2, string3);
            this.addSpellBook(string3);
            pObject2.getSpellSupport().addCharacterSpell(characterSpell);
        }
        this.setDirty(true);
    }

    private Map<String, String> addStringToDRMap(Map<String, String> map, String string) {
        if (string == null || string.length() == 0) {
            return map;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(47);
            if (n2 <= 0 || n2 >= string2.length()) continue;
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if (string4.length() > 0 && string4.charAt(0) == '+') {
                string4 = string4.substring(1);
            }
            int n3 = -1;
            String string5 = map.get(string4);
            if (string5 != null) {
                n3 = Integer.parseInt(string5);
            }
            if ((n = this.getVariableValue(string3, "").intValue()) <= n3) continue;
            map.put(string4, String.valueOf(n));
        }
        return map;
    }

    private List<Vision> addStringToVisionList(List<Vision> list, List<Vision> list2) {
        if (list2 == null || list2.size() == 0) {
            return list;
        }
        for (Vision vision : list2) {
            VisionType visionType = vision.getType();
            if (!vision.qualifies(this)) continue;
            Vision vision2 = null;
            for (Vision vision3 : list) {
                if (vision3.getType() != visionType) continue;
                vision2 = vision3;
                break;
            }
            int n = this.getVariableValue(vision.getDistance(), "").intValue();
            n += (int)this.getTotalBonusTo("VISION", visionType.toString());
            if (vision2 == null) {
                list.add(new Vision(visionType, String.valueOf(n)));
                continue;
            }
            if (n <= Integer.parseInt(vision2.getDistance())) continue;
            list.remove(vision2);
            list.add(new Vision(visionType, String.valueOf(n)));
        }
        return list;
    }

    private void setStableAggregateFeatList(List<Ability> list) {
        this.stableAggregateFeatList = list;
        this.setAggregateFeatsStable(list != null);
    }

    private void addWeaponProfToList(List<Ability> list, String string, boolean bl) {
        if (string.startsWith("WEAPONTYPE=") || string.startsWith("WEAPONTYPE.")) {
            for (Equipment equipment : EquipmentList.getEquipmentOfType("WEAPON." + string.substring(11), "")) {
                WeaponProf weaponProf = Globals.getWeaponProfKeyed(equipment.profKey(this));
                if (weaponProf == null) continue;
                this.addWeaponProfToList(list, weaponProf.getKeyName(), bl);
            }
            return;
        }
        if (Globals.weaponTypesContains(string)) {
            for (WeaponProf weaponProf : Globals.getAllWeaponProfsOfType(string)) {
                this.addWeaponProfToList(list, weaponProf.getKeyName(), bl);
            }
            return;
        }
        WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
        if (weaponProf != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(weaponProf.getType(), ".");
            String string2 = stringTokenizer.nextToken() + " Weapon Proficiency";
            while (stringTokenizer.hasMoreTokens() || string2.length() > 0) {
                Ability ability;
                if ("".equals(string2)) {
                    if (!stringTokenizer.hasMoreTokens()) break;
                    string2 = stringTokenizer.nextToken() + " Weapon Proficiency";
                }
                if ((ability = AbilityUtilities.getAbilityFromList(list, "FEAT", string2, Ability.Nature.ANY)) != null) {
                    if (ability.isMultiples() && !ability.containsAssociated(string)) {
                        ability.addAssociated(string);
                        ability.sortAssociated();
                    }
                } else {
                    ability = Globals.getAbilityKeyed("FEAT", string2);
                    if (ability != null) {
                        if (bl && !ability.isMultiples() && !"PCGENi_WEAPON_PROFICIENCY".equalsIgnoreCase(string2)) {
                            if (this.hasRealFeat(ability)) {
                                string2 = "PCGENi_WEAPON_PROFICIENCY";
                                continue;
                            }
                            string2 = "";
                            continue;
                        }
                        ability = ability.clone();
                        ability.addAssociated(string);
                        if (bl) {
                            ability.setFeatType(Ability.Nature.AUTOMATIC);
                        }
                        list.add(ability);
                    }
                }
                if (ability != null) {
                    ability.addSelectedWeaponProfBonus(string);
                }
                string2 = "";
            }
        }
        if (weaponProf != null && this.cachedWeaponProfs != null) {
            this.cachedWeaponProfs.put(weaponProf.getKeyName(), weaponProf);
        }
    }

    private SortedSet<String> addWeaponProfsLists(List<String> list, SortedSet<String> sortedSet, List<Ability> list2, boolean bl) {
        if (list == null || list.isEmpty()) {
            return sortedSet;
        }
        PreParserFactory preParserFactory = null;
        try {
            preParserFactory = PreParserFactory.getInstance();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            // empty catch block
        }
        for (String string : list) {
            Collection<PObject> collection;
            Object object;
            int n;
            boolean bl2;
            Cloneable cloneable;
            int n2 = string.indexOf(91);
            if (n2 >= 0 && preParserFactory != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2 + 1), "[]");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                string = string.substring(0, n2);
                if (arrayList.size() != 0) {
                    cloneable = new ArrayList<Prerequisite>(arrayList.size());
                    for (String string2 : arrayList) {
                        try {
                            cloneable.add(preParserFactory.parse(string2));
                        }
                        catch (PersistenceLayerException persistenceLayerException) {}
                    }
                    if (!PrereqHandler.passesAll(cloneable, this, null)) continue;
                }
            }
            boolean bl3 = bl2 = (n = string.lastIndexOf(44)) < 0;
            if (!bl2 && this.race != null) {
                cloneable = string.substring(n + 1);
                int n3 = this.sizeInt();
                for (int i = 0; i < ((String)((Object)cloneable)).length(); ++i) {
                    if ("FDTSMLHGC".lastIndexOf(((String)((Object)cloneable)).charAt(i)) != n3) continue;
                    bl2 = true;
                    break;
                }
                string = string.substring(0, n);
            }
            if (!bl2) continue;
            cloneable = EquipmentList.getEquipmentKeyed(string);
            if (cloneable != null) {
                if (!bl) continue;
                sortedSet.add(string);
                this.addWeaponProfToList(list2, string, true);
                continue;
            }
            ArrayList arrayList = new ArrayList();
            boolean bl4 = string.indexOf(".") >= 0;
            boolean bl5 = false;
            if (!bl4) {
                object = Globals.getWeaponProfKeyed(string);
                if (object != null) {
                    arrayList.add(object);
                    bl5 = true;
                } else {
                    collection = Globals.getAllWeaponProfsOfType(string);
                    if (collection != null && !collection.isEmpty()) {
                        for (WeaponProf weaponProf : collection) {
                            arrayList.add(weaponProf);
                        }
                        bl5 = true;
                    }
                }
            }
            if (!(!bl4 && bl5 || (collection = EquipmentList.getEquipmentOfType((String)(object = "Weapon." + string), "")) == null || collection.isEmpty())) {
                for (Equipment equipment : collection) {
                    WeaponProf weaponProf = equipment.getExpandedWeaponProf(this);
                    arrayList.add(weaponProf);
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                collection = (WeaponProf)object.next();
                if (!bl) continue;
                Iterator<Equipment> iterator = ((PObject)((Object)collection)).getKeyName();
                sortedSet.add((String)((Object)iterator));
                this.addWeaponProfToList(list2, (String)((Object)iterator), true);
            }
        }
        return sortedSet;
    }

    private List<String> getAutoShieldProfList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null) continue;
            pObject.addAutoTagsToList("SHIELDPROF", arrayList, this, true);
        }
        return arrayList;
    }

    public String getClassLevelString(String string, boolean bl) {
        PCClass pCClass;
        int n = 0;
        int n2 = string.indexOf(";BEFORELEVEL=");
        if (n2 < 0) {
            n2 = string.indexOf(";BEFORELEVEL.");
        }
        if (n2 > 0) {
            n = Integer.parseInt(string.substring(n2 + 13));
            string = string.substring(0, n2);
        }
        if (bl) {
            string = string.replace('{', '(').replace('}', ')');
        }
        if ((pCClass = this.getClassKeyed(string)) != null) {
            if (n > 0) {
                return this.getLevelBefore(pCClass.getKeyName(), n);
            }
            return Integer.toString(pCClass.getLevel());
        }
        return "0";
    }

    private String getLevelBefore(String string, int n) {
        String string2;
        int n2 = 0;
        for (int i = 0; i < n && (string2 = this.getLevelInfoClassKeyName(i)).length() != 0; ++i) {
            if (!string2.equals(string)) continue;
            ++n2;
        }
        return Integer.toString(n2);
    }

    private List<? extends PObject> getPObjectList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Campaign> list = Globals.getCampaignList();
        for (Campaign object2 : list) {
            if (object2 == null || !object2.isLoaded()) continue;
            arrayList.add(object2);
            arrayList.addAll(object2.getSubCampaigns());
        }
        PCAlignment pCAlignment = SettingsHandler.getGame().getAlignmentAtIndex(this.getAlignment());
        if (pCAlignment != null) {
            arrayList.add(pCAlignment);
        }
        arrayList.add(Globals.getBioSet());
        arrayList.addAll(SettingsHandler.getGame().getUnmodifiableCheckList());
        arrayList.addAll(this.classList);
        arrayList.addAll(this.companionModList);
        if (this.deity != null) {
            arrayList.add(this.deity);
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (domain == null) continue;
            arrayList.add(domain);
        }
        for (Equipment equipment : this.getEquipmentList()) {
            if (!equipment.isEquipped() && !equipment.isNatural()) continue;
            arrayList.add(equipment);
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                arrayList.add(equipmentModifier);
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                arrayList.add(equipmentModifier);
            }
        }
        Set<Ability> set = this.getFullAbilitySet();
        arrayList.addAll(set);
        if (this.getRace() != null) {
            arrayList.add(this.getRace());
        }
        if (this.getSizeAdjustment() != null) {
            arrayList.add(this.getSizeAdjustment());
        }
        arrayList.addAll(this.getSkillList());
        arrayList.addAll(this.statList.getStatList());
        arrayList.addAll(this.getTemplateList());
        return arrayList;
    }

    private void getPreReqFromACType(String string, PObject pObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = "|";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (PreParserFactory.isPreReqString(string3)) {
                try {
                    Logging.debugPrint("Why is this prerequisite '" + string3 + "' parsed in '" + this.getClass().getName() + ".getPreReqFromACType()' rather than the persistence layer?");
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    Prerequisite prerequisite = preParserFactory.parse(string3);
                    pObject.addPreReq(prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                }
                continue;
            }
            string2 = string2 + string3 + "|";
        }
        string = string2.substring(1);
    }

    private List<String> getSelectedShieldProfList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null || !pObject.containsListFor((ListKey)ListKey.SELECTED_SHIELD_PROFS)) continue;
            arrayList.addAll(pObject.getListFor(ListKey.SELECTED_SHIELD_PROFS));
        }
        return arrayList;
    }

    private void addNewSkills(int n) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        ArrayList<Skill> arrayList2 = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill : Globals.getSkillList()) {
            if (!this.includeSkill(skill, n)) continue;
            boolean bl = false;
            for (Skill skill2 : arrayList2) {
                if (!skill2.getKeyName().equals(skill.getKeyName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(skill.clone());
        }
        this.getSkillList().addAll(arrayList);
    }

    public boolean availableSpells(int n, PCClass pCClass, String string, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl3 = false;
        boolean bl4 = "Divine".equalsIgnoreCase(pCClass.getSpellType());
        boolean bl5 = bl ? this.getUseHigherKnownSlots() : this.getUseHigherPreppedSlots();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        for (n10 = 0; n10 < n; ++n10) {
            if (bl) {
                n9 = pCClass.getKnownForLevel(n10, string, this);
                n8 = pCClass.getSpecialtyKnownForLevel(n10, this);
                n7 = n9 + n8;
            } else {
                n7 = pCClass.getCastForLevel(n10, string, true, true, this);
                n9 = pCClass.getCastForLevel(n10, string, false, true, this);
                n8 = n7 - n9;
            }
            n6 = pCClass.memorizedSpellForLevelBook(n10, string);
            n5 = pCClass.memorizedSpecialtiesForLevelBook(n10, string);
            n4 = n6 - n5;
            n3 = n8 - n5;
            for (n2 = n9 - n4; n2 > 0 && n12 < 0; --n2, ++n12) {
            }
            while (n3 > 0 && n11 < 0) {
                --n3;
                ++n11;
            }
            if (!bl4 || bl) {
                while (n2 > 0 && n11 < 0) {
                    --n2;
                    ++n11;
                }
                while (n2 > 0 && n3 < 0) {
                    --n2;
                    ++n3;
                }
            }
            if (n3 < 0) {
                n11 += n3;
            }
            if (n2 >= 0) continue;
            n12 += n2;
        }
        n10 = n;
        while (true) {
            if (bl) {
                n9 = pCClass.getKnownForLevel(n10, string, this);
                n8 = pCClass.getSpecialtyKnownForLevel(n10, this);
                n7 = n9 + n8;
            } else {
                n7 = pCClass.getCastForLevel(n10, string, true, true, this);
                n9 = pCClass.getCastForLevel(n10, string, false, true, this);
                n8 = n7 - n9;
            }
            if (n7 == 0 || !bl5 && n10 > n) break;
            n6 = pCClass.memorizedSpellForLevelBook(n10, string);
            n5 = pCClass.memorizedSpecialtiesForLevelBook(n10, string);
            n4 = n6 - n5;
            n3 = n8 - n5;
            for (n2 = n9 - n4; n2 > 0 && n12 < 0; --n2, ++n12) {
            }
            while (n2 > 0 && n14 < 0) {
                --n2;
                ++n14;
            }
            while (n3 > 0 && n11 < 0) {
                --n3;
                ++n11;
            }
            while (n3 > 0 && n13 < 0) {
                --n3;
                ++n13;
            }
            if (!bl4) {
                while (n2 > 0 && n11 < 0) {
                    --n2;
                    ++n11;
                }
                while (n2 > 0 && n13 < 0) {
                    --n2;
                    ++n13;
                }
                while (n2 > 0 && n3 < 0) {
                    --n2;
                    ++n3;
                }
            }
            if (bl4) {
                if (bl2 && n3 > 0) {
                    bl3 = true;
                }
                if (!bl2 && n2 > 0) {
                    bl3 = true;
                }
            } else {
                if (!bl2 && n2 > 0) {
                    bl3 = true;
                }
                if (bl2 && (n2 > 0 || n3 > 0)) {
                    bl3 = true;
                }
            }
            if (bl3) break;
            if (n3 < 0) {
                n13 += n3;
            }
            if (n2 < 0) {
                n14 += n2;
            }
            ++n10;
        }
        return bl3;
    }

    private void buildActiveBonusMap() {
        PObject pObject;
        this.clearActiveBonusMap();
        this.processedBonusList.clear();
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        arrayList.addAll(this.getActiveBonusList());
        for (BonusObj bonusObj : arrayList) {
            if (!bonusObj.isValueStatic() || (pObject = (PObject)bonusObj.getCreatorObject()) == null) continue;
            this.processedBonusList.add(bonusObj);
            for (String string : bonusObj.getStringListFromBonus(pObject)) {
                double d = bonusObj.getValueAsdouble();
                this.setActiveBonusStack(d, string, this.getActiveBonusMap());
                Logging.debugPrint("BONUS: " + pObject.getDisplayName() + " : " + d + " : " + string);
            }
        }
        arrayList = new ArrayList();
        arrayList.addAll(this.getActiveBonusList());
        for (BonusObj bonusObj : this.getActiveBonusList()) {
            if (this.processedBonusList.contains(bonusObj) || (pObject = (PObject)bonusObj.getCreatorObject()) == null) continue;
            this.processBonus(bonusObj, new ArrayList<BonusObj>());
        }
    }

    private double calcBonusWithCostFromList(List<BonusObj> list, boolean bl) {
        double d = 0.0;
        for (BonusObj bonusObj : list) {
            PObject pObject = (PObject)bonusObj.getCreatorObject();
            if (pObject == null) continue;
            double d2 = 0.0;
            if (bonusObj.qualifies(this)) {
                d2 = pObject.calcBonusFrom(bonusObj, this, this);
            }
            int n = Math.max(1, (int)((double)pObject.getAssociatedCount() * ((HasCost)((Object)pObject)).getCost()));
            if (bl && pObject.getAssociatedCount() > 0) {
                n = 0;
                for (int i = 0; i < pObject.getAssociatedCount(); ++i) {
                    String string = pObject.getAssociated(i);
                    if (!string.equalsIgnoreCase(bonusObj.getBonusInfo())) continue;
                    ++n;
                }
            }
            if (n == 0 && !CoreUtility.doublesEqual(d2, 0.0)) {
                d += d2;
                continue;
            }
            d += d2 * (double)n;
        }
        return d;
    }

    private List<BonusObj> getPurchaseModeBonuses() {
        GameMode gameMode = SettingsHandler.getGame();
        String string = gameMode.getPurchaseModeMethodName();
        if (gameMode.isPurchaseStatMode()) {
            PointBuyMethod pointBuyMethod = gameMode.getPurchaseMethodByName(string);
            pointBuyMethod.activateBonuses(this);
            return pointBuyMethod.getActiveBonuses();
        }
        return Collections.emptyList();
    }

    private List<BonusObj> getTempBonuses() {
        List<BonusObj> list = this.getFilteredTempBonusList();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<BonusObj> iterator = list.iterator();
        while (iterator.hasNext()) {
            BonusObj bonusObj = iterator.next();
            bonusObj.setApplied(false);
            if (bonusObj.qualifies(this)) {
                bonusObj.setApplied(true);
            }
            if (bonusObj.isApplied()) continue;
            iterator.remove();
        }
        return list;
    }

    private int calculateSaveBonusRace(int n) {
        if (n - 1 < 0 || n - 1 >= SettingsHandler.getGame().getUnmodifiableCheckList().size()) {
            return 0;
        }
        String string = SettingsHandler.getGame().getUnmodifiableCheckList().get(n - 1).toString();
        int n2 = (int)this.race.bonusTo("CHECKS", "BASE." + string, this, this);
        return n2 += (int)this.race.bonusTo("CHECKS", string, this, this);
    }

    private void clearActiveBonusMap() {
        this.activeBonusMap.clear();
    }

    int countSpellLevelsInBook(String string) {
        PObject pObject;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = Globals.getDefaultSpellBook();
        if (n3 > 0) {
            string2 = this.getSpellBooks().get(n3);
        }
        if ((pObject = this.getSpellClassAtIndex(n2)) != null) {
            List<CharacterSpell> list;
            for (n = 0; n >= 0 && (list = pObject.getSpellSupport().getCharacterSpell(null, string2, n)).size() >= 1; ++n) {
            }
        }
        return n;
    }

    int countSpellListBook(String string) {
        int n = string.lastIndexOf(46);
        int n2 = 0;
        if (n < 0) {
            for (PCClass pCClass : this.classList) {
                n2 += pCClass.getSpellSupport().getCharacterSpellCount();
            }
        } else {
            int n3 = Integer.parseInt(string.substring(17, n));
            int n4 = Integer.parseInt(string.substring(n + 1, string.length() - 1));
            PObject pObject = this.getSpellClassAtIndex(n3);
            if (pObject != null) {
                List<CharacterSpell> list = pObject.getSpellSupport().getCharacterSpell(null, Globals.getDefaultSpellBook(), n4);
                n2 = list.size();
            }
        }
        return n2;
    }

    int countSpellTimes(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(10), ".");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        PObject pObject = this.getSpellClassAtIndex(n);
        String string2 = Globals.getDefaultSpellBook();
        if (n2 > 0) {
            string2 = this.getSpellBooks().get(n2);
        }
        if (pObject != null || n == -1) {
            if (n == -1) {
                string2 = Globals.getDefaultSpellBook();
            }
            if (!"".equals(string2)) {
                List<CharacterSpell> list;
                SpellInfo spellInfo = null;
                if (n == -1) {
                    ArrayList<CharacterSpell> arrayList = new ArrayList<CharacterSpell>();
                    for (PCClass pCClass : this.getClassList()) {
                        List<CharacterSpell> list2 = pCClass.getSpellSupport().getCharacterSpell(null, string2, -1);
                        for (CharacterSpell characterSpell : list2) {
                            if (arrayList.contains(characterSpell)) continue;
                            arrayList.add(characterSpell);
                        }
                    }
                    Collections.sort(arrayList);
                    if (n4 < arrayList.size()) {
                        CharacterSpell characterSpell = (CharacterSpell)arrayList.get(n4);
                        spellInfo = characterSpell.getSpellInfoFor(string2, -1, -1);
                        bl = true;
                    }
                } else if (pObject != null && n4 < (list = pObject.getSpellSupport().getCharacterSpell(null, string2, n3)).size()) {
                    CharacterSpell characterSpell = list.get(n4);
                    spellInfo = characterSpell.getSpellInfoFor(string2, n3, -1);
                    bl = true;
                }
                if (bl && spellInfo != null) {
                    return spellInfo.getTimes();
                }
            }
        }
        return 0;
    }

    int countSpellsInBook(String string) {
        PObject pObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        if (n2 >= this.getSpellBooks().size()) {
            return 0;
        }
        int n3 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : -1;
        String string2 = Globals.getDefaultSpellBook();
        if (n2 > 0) {
            string2 = this.getSpellBooks().get(n2);
        }
        if ((pObject = this.getSpellClassAtIndex(n)) != null) {
            List<CharacterSpell> list = pObject.getSpellSupport().getCharacterSpell(null, string2, n3);
            return list.size();
        }
        return 0;
    }

    private String findTemplateGender() {
        String string = "None";
        for (PCTemplate pCTemplate : this.templateList) {
            String string2 = pCTemplate.getGenderLock();
            if (string2.equals("None")) continue;
            string = string2;
        }
        return string;
    }

    private PCClass getClassDisplayNamed(String string) {
        for (PCClass pCClass : this.classList) {
            if (!pCClass.getDisplayClassName().equalsIgnoreCase(string)) continue;
            return pCClass;
        }
        return null;
    }

    private void setEarnedXP(int n) {
        this.earnedXP = n;
        this.setDirty(true);
    }

    private int getLAXP() {
        return PlayerCharacterUtilities.minXPForLevel(this.getLevelAdjustment(this) + 1, this);
    }

    private SizeAdjustment getSizeAdjustment() {
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.sizeInt());
        return sizeAdjustment;
    }

    int getSpellClassCount() {
        return this.getSpellClassList().size();
    }

    public List<? extends PObject> getSpellClassList() {
        ArrayList<PObject> arrayList = new ArrayList<PObject>();
        if (!this.race.getSpellSupport().getCharacterSpell(null, "", -1).isEmpty()) {
            arrayList.add(this.race);
        }
        for (PCClass pCClass : this.classList) {
            if (pCClass.getSpellType().equalsIgnoreCase("None")) continue;
            arrayList.add(pCClass);
        }
        return arrayList;
    }

    private String checkForVariableInList(PObject pObject, String string, boolean bl, String string2, String string3, boolean bl2, double d, int n) {
        boolean bl3 = false;
        int n2 = pObject.getVariableCount();
        for (int i = 0; i < n2; ++i) {
            String string4;
            String string5 = pObject.getVariableDefinition(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string5, "|");
            String string6 = stringTokenizer.nextToken();
            if (string2.length() > 0 && !string6.equals(string2)) continue;
            if (string3.length() > 0 || string2.length() > 0) {
                string4 = stringTokenizer.nextToken();
                if (string3.length() > 0 && !string4.equals(string3)) continue;
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            string4 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens() || !string4.equalsIgnoreCase(string)) continue;
            String string7 = stringTokenizer.nextToken();
            Float f = this.getVariableValue(string7, string6);
            d = !bl2 ? (double)f.floatValue() : (bl ? Math.max(d, f.doubleValue()) : Math.min(d, f.doubleValue()));
            bl2 = true;
            bl3 = true;
        }
        if (bl3) {
            return d + "";
        }
        return "";
    }

    boolean hasDeity(String string) {
        Prerequisite prerequisite = new Prerequisite();
        prerequisite.setKind("DEITY");
        prerequisite.setOperand(string);
        prerequisite.setOperator(PrerequisiteOperator.EQ);
        return PrereqHandler.passes(prerequisite, this, null);
    }

    private boolean includeSkill(Skill skill, int n) {
        boolean bl = false;
        if (skill.isUntrained() && skill.isExclusive() && skill.isClassSkill(this.classList, this)) {
            bl = true;
        }
        return n == 2 || skill.isRequired() || skill.getTotalRank(this).floatValue() > 0.0f || n == 1 && skill.isUntrained() && !skill.isExclusive() || n == 1 && bl;
    }

    private void increaseMoveArray(Double d, String string, Double d2, String string2) {
        Double[] doubleArray = this.movements;
        String[] stringArray = this.movementTypes;
        Double[] doubleArray2 = this.movementMult;
        String[] stringArray2 = this.movementMultOp;
        this.movements = new Double[doubleArray.length + 1];
        this.movementTypes = new String[doubleArray.length + 1];
        this.movementMult = new Double[doubleArray.length + 1];
        this.movementMultOp = new String[doubleArray.length + 1];
        System.arraycopy(doubleArray, 0, this.movements, 0, doubleArray.length);
        System.arraycopy(stringArray, 0, this.movementTypes, 0, doubleArray.length);
        System.arraycopy(doubleArray2, 0, this.movementMult, 0, doubleArray.length);
        System.arraycopy(stringArray2, 0, this.movementMultOp, 0, doubleArray.length);
        this.movements[doubleArray.length] = d;
        this.movementTypes[doubleArray.length] = string;
        this.movementMult[doubleArray.length] = d2;
        this.movementMultOp[doubleArray.length] = string2;
    }

    public void incrementClassLevel(int n, PCClass pCClass, boolean bl) {
        this.incrementClassLevel(n, pCClass, bl, false);
    }

    public void incrementClassLevel(int n, PCClass pCClass, boolean bl, boolean bl2) {
        int n2;
        PCClass pCClass2;
        if (!this.isImporting()) {
            this.getSpellList();
        }
        if (n > 0) {
            if (!bl2 && !pCClass.isQualified(this)) {
                return;
            }
            if (pCClass.isMonster() && !SettingsHandler.isIgnoreMonsterHDCap() && !this.race.isAdvancementUnlimited() && this.totalHitDice() + n > this.race.maxHitDiceAdvancement() && !bl) {
                ShowMessageDelegate.showMessageDialog("Cannot increase Monster Hit Dice for this character beyond " + this.race.maxHitDiceAdvancement() + ". This character's current number of Monster Hit Dice is " + this.totalHitDice(), "PCGen", MessageType.INFORMATION);
                return;
            }
        }
        if ((pCClass2 = this.getClassKeyed(pCClass.getKeyName())) == null) {
            if (n >= 0) {
                pCClass2 = pCClass.clone();
                if (pCClass2 == null) {
                    Logging.errorPrint("PlayerCharacter::incrementClassLevel => Clone of class " + pCClass.getKeyName() + " failed!");
                    return;
                }
                if (!this.isImporting() && this.classList.isEmpty()) {
                    this.adjustFeats(pCClass2.getInitialFeats());
                }
                this.classList.add(pCClass2);
                if (n > 0) {
                    this.languages.addAll(pCClass2.getSafeListFor(ListKey.AUTO_LANGUAGES));
                }
            } else {
                return;
            }
        }
        if (n > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                PCLevelInfo cloneable = this.saveLevelInfo(pCClass2.getKeyName());
                if (pCClass2.addLevel(cloneable, false, bl, this, false)) continue;
                this.removeLevelInfo(pCClass2.getKeyName());
                return;
            }
        } else if (n < 0) {
            for (n2 = 0; n2 < -n; ++n2) {
                pCClass2.subLevel(bl, this);
                this.removeLevelInfo(pCClass2.getKeyName());
            }
        }
        if (!PlayerCharacterUtilities.canReassignTemplateFeats()) {
            for (PCTemplate pCTemplate : this.templateList) {
                List<String> list = pCTemplate.feats(this.getTotalLevels(), this.totalHitDice(), this, true);
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    AbilityUtilities.modFeatsFromList(this, null, list.get(i), true, false);
                }
            }
        }
        this.setAggregateAbilitiesStable(null, false);
        this.calcActiveBonuses();
    }

    private void processBonus(BonusObj bonusObj, ArrayList<BonusObj> arrayList) {
        if (arrayList.contains(bonusObj)) {
            Logging.debugPrint("Ignoring bonus loop for " + bonusObj + " as it was already processed. Bonuses already processed: " + arrayList);
            return;
        }
        arrayList.add(bonusObj);
        ArrayList<BonusObj> arrayList2 = new ArrayList<BonusObj>();
        for (BonusObj object : this.getActiveBonusList()) {
            if (this.processedBonusList.contains(object) || !bonusObj.getDependsOn(object.getUnparsedBonusInfoList())) continue;
            arrayList2.add(object);
        }
        for (BonusObj bonusObj2 : arrayList2) {
            this.processBonus(bonusObj2, arrayList);
        }
        if (this.processedBonusList.contains(bonusObj)) {
            return;
        }
        this.processedBonusList.add(bonusObj);
        PObject pObject = (PObject)bonusObj.getCreatorObject();
        if (pObject == null) {
            arrayList.remove(bonusObj);
            return;
        }
        for (String string : bonusObj.getStringListFromBonus(pObject)) {
            double d = pObject.calcBonusFrom(bonusObj, this, string, this);
            this.setActiveBonusStack(d, string, this.getActiveBonusMap());
            Logging.debugPrint("BONUS: " + pObject.getDisplayName() + " : " + d + " : " + string);
        }
        arrayList.remove(bonusObj);
    }

    private boolean qualifiesForFeat(Ability ability) {
        return ability.canBeSelectedBy(this);
    }

    private boolean hasSkill(String string) {
        return this.getSkillKeyed(string) != null;
    }

    private void rebuildLists(PCClass pCClass, PCClass pCClass2, int n, PlayerCharacter playerCharacter) {
        int n2 = pCClass2.getLevel();
        int n3 = pCClass.getLevel();
        for (int i = 0; i < n; ++i) {
            pCClass2.doMinusLevelMods(this, n2 - i);
            PCLevelInfo pCLevelInfo = playerCharacter.getLevelInfoFor(pCClass.getKeyName(), n3 + i + 1);
            pCClass.doPlusLevelMods(n3 + i + 1, playerCharacter, pCLevelInfo);
        }
    }

    private void removeExcessSkills(int n) {
        ArrayList<Skill> arrayList = this.getSkillList();
        ArrayList<Skill> arrayList2 = new ArrayList<Skill>();
        arrayList2.addAll(arrayList);
        Iterator iterator = arrayList2.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            if (this.includeSkill(skill, n)) continue;
            arrayList.remove(skill);
            bl = true;
        }
        if (bl) {
            this.setDirty(true);
        }
    }

    private boolean removeLevelInfo(String string) {
        for (int i = this.pcLevelInfo.size() - 1; i >= 0; --i) {
            PCLevelInfo pCLevelInfo = this.pcLevelInfo.get(i);
            if (!pCLevelInfo.getClassKeyName().equals(string)) continue;
            this.removeObjectsForLevelInfo(pCLevelInfo);
            this.removeLevelInfo(i);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    private void removeObjectsForLevelInfo(PCLevelInfo pCLevelInfo) {
        for (PObject pObject : pCLevelInfo.getObjects()) {
            Ability ability;
            Iterator<Ability> iterator = this.getRealAbilitiesList(AbilityCategory.FEAT).iterator();
            while (iterator.hasNext()) {
                ability = iterator.next();
                if (pObject != ability) continue;
                iterator.remove();
            }
            iterator = this.stableVirtualFeatList.iterator();
            while (iterator.hasNext()) {
                ability = iterator.next();
                if (pObject != ability) continue;
                iterator.remove();
            }
        }
    }

    private void removeLevelInfo(int n) {
        this.pcLevelInfo.remove(n);
        this.setDirty(true);
    }

    public void rollStats(int n) {
        int n2 = n;
        if (SettingsHandler.getGame().isPurchaseStatMode()) {
            n2 = 2;
        }
        this.rollStats(n2, this.statList.getStatList(), SettingsHandler.getGame().getCurrentRollingMethod(), false);
    }

    public void rollStats(int n, List<PCStat> list, GameModeRollMethod gameModeRollMethod, boolean bl) {
        int n2;
        int[] nArray = new int[list.size()];
        block5: for (n2 = 0; n2 < nArray.length; ++n2) {
            switch (n) {
                case 2: {
                    nArray[n2] = SettingsHandler.getGame().getPurchaseModeBaseStatScore(this);
                    continue block5;
                }
                case 1: {
                    nArray[n2] = SettingsHandler.getGame().getAllStatsValue();
                    continue block5;
                }
                case 3: {
                    String string = gameModeRollMethod.getMethodRoll();
                    nArray[n2] = RollingMethods.roll(string);
                    continue block5;
                }
                default: {
                    nArray[n2] = 0;
                }
            }
        }
        if (bl) {
            Arrays.sort(nArray);
        }
        n2 = list.size() - 1;
        int n3 = 0;
        while (n2 >= 0) {
            PCStat pCStat = list.get(n2);
            pCStat.setBaseScore(0);
            if (pCStat.isRolled()) {
                int n4 = nArray[n3] + pCStat.getBaseScore();
                if (n4 < pCStat.getMinValue()) {
                    n4 = pCStat.getMinValue();
                }
                if (n4 > pCStat.getMaxValue()) {
                    n4 = pCStat.getMaxValue();
                }
                pCStat.setBaseScore(n4);
            }
            --n2;
            ++n3;
        }
        this.setPoolAmount(0);
        this.costPool = 0;
        this.languages.clear();
        this.getAutoLanguages();
        this.setPoolAmount(0);
    }

    private List<Equipment> sortEquipmentList(List<Equipment> list) {
        return this.sortEquipmentList(list, 0);
    }

    private List<Equipment> sortEquipmentList(List<Equipment> list, int n) {
        if (list.isEmpty()) {
            return list;
        }
        List<Equipment> list2 = EquipmentUtilities.mergeEquipmentList(list, n);
        Iterator<Equipment> iterator = list2.iterator();
        while (iterator.hasNext()) {
            Equipment equipment = iterator.next();
            if (equipment.getOutputIndex() != -1) continue;
            iterator.remove();
        }
        return list2;
    }

    private int subCalcACOfType(StringTokenizer stringTokenizer) {
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            n += Integer.parseInt(BonusToken.getBonusToken("BONUS.COMBAT.AC." + string, this));
        }
        return n;
    }

    private double sumActiveBonusMap(String string) {
        double d = 0.0;
        string = string.toUpperCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this.getActiveBonusMap().keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            if (arrayList.contains(string2)) continue;
            String string3 = string2;
            if (string3.endsWith(".STACK")) {
                string3 = string3.substring(0, string3.length() - 6);
            } else if (string3.endsWith(".REPLACE")) {
                string3 = string3.substring(0, string3.length() - 8);
            }
            if (string3.length() > string.length() && !string3.startsWith(string + ":") || !string3.startsWith(string)) continue;
            arrayList.add(string3);
            arrayList.add(string3 + ".STACK");
            arrayList.add(string3 + ".REPLACE");
            double d2 = this.getActiveBonusForMapKey(string3, Double.NaN);
            double d3 = this.getActiveBonusForMapKey(string3 + ".REPLACE", Double.NaN);
            double d4 = this.getActiveBonusForMapKey(string3 + ".STACK", 0.0);
            if (Double.isNaN(d2)) {
                if (!Double.isNaN(d3)) {
                    d += d3;
                }
            } else {
                d = Double.isNaN(d3) ? (d += d2) : (d += Math.max(d2, d3));
            }
            d += d4;
        }
        return d;
    }

    private int totalMonsterLevels() {
        int n = 0;
        for (PCClass pCClass : this.classList) {
            if (!pCClass.isMonster()) continue;
            n += pCClass.getLevel();
        }
        return n;
    }

    private void setDescriptionLst(String string) {
        this.descriptionLst = string;
    }

    public int getCharacterLevel(PCLevelInfo pCLevelInfo) {
        int n = 1;
        for (PCLevelInfo pCLevelInfo2 : this.pcLevelInfo) {
            if (pCLevelInfo == pCLevelInfo2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Set<Language> getLanguageBonusSelectionList() {
        HashSet<Language> hashSet = new HashSet<Language>();
        hashSet.addAll(this.race.getLanguageBonus());
        for (PCTemplate object2 : this.templateList) {
            hashSet.addAll(object2.getLanguageBonus());
        }
        for (PCClass pCClass : this.classList) {
            hashSet.addAll(pCClass.getLanguageBonus());
        }
        boolean bl = false;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Language language = (Language)iterator.next();
            if (!language.isAllLang()) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            hashSet.addAll(Globals.getLanguageList());
        }
        return hashSet;
    }

    @Deprecated
    public int getPartialStatBonusFor(String string, boolean bl, boolean bl2) {
        List<BonusObj> list = this.getActiveBonusList();
        String string2 = "STAT." + string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (BonusObj object : list) {
            Object object22;
            if (!object.isApplied() || !object.getBonusName().equals("STAT")) continue;
            boolean bl3 = false;
            for (Object object22 : object.getBonusInfoList()) {
                if (!(object22 instanceof PCStat) || !((PCStat)object22).getAbb().equals(string)) continue;
                bl3 = true;
                break;
            }
            if (!bl3) continue;
            boolean bl4 = false;
            bl4 = object.getCreatorObject() instanceof Equipment || object.getCreatorObject() instanceof EquipmentModifier ? bl2 : (this.tempBonusList.contains(object) ? bl : true);
            if (!bl4) continue;
            object22 = object.getStringListFromBonus((PObject)object.getCreatorObject());
            for (String string3 : object22) {
                if (!string3.startsWith(string2)) continue;
                this.setActiveBonusStack(object.getCalculatedValue(this), string3, hashMap);
            }
        }
        int n = 0;
        for (String string4 : hashMap.keySet()) {
            n = (int)((float)n + Float.parseFloat((String)hashMap.get(string4)));
        }
        return n;
    }

    public int getPartialStatAtLevel(String string, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.getStatList().getPartialStatFor(string, bl2, bl3);
        for (int i = this.getLevelInfoSize() - 1; i >= n; --i) {
            int n3 = this.pcLevelInfo.get(i).getTotalStatMod(string, bl);
            n2 -= n3;
        }
        return n2;
    }

    public Object clone() {
        PlayerCharacter playerCharacter = null;
        playerCharacter = new PlayerCharacter();
        playerCharacter.addArmorProfs(this.getArmorProfList());
        for (Ability iterator2 : this.getRealAbilitiesList(AbilityCategory.FEAT)) {
            playerCharacter.addRealAbility(AbilityCategory.FEAT, iterator2.clone());
        }
        for (AbilityCategory abilityCategory : this.theAbilities.getKeySet()) {
            for (Ability ability : this.getRealAbilityList(abilityCategory)) {
                playerCharacter.addRealAbility(abilityCategory, ability.clone());
            }
        }
        playerCharacter.miscList.addAll(this.getMiscList());
        for (NoteItem noteItem : this.getNotesList()) {
            playerCharacter.addNotesItem(noteItem);
        }
        playerCharacter.primaryWeapons.addAll(this.getPrimaryWeapons());
        playerCharacter.secondaryWeapons.addAll(this.getSecondaryWeapons());
        playerCharacter.shieldProfList.addAll(this.getShieldProfList());
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            playerCharacter.skillList.add(skill.clone());
        }
        playerCharacter.specialAbilityList.addAll(this.getSpecialAbilityList());
        playerCharacter.templateList.addAll(this.getTemplateList());
        for (String string : this.variableList) {
            playerCharacter.variableList.add(new String(string));
        }
        playerCharacter.gold = new BigDecimal(this.gold.toString());
        playerCharacter.deity = this.deity;
        playerCharacter.domainSourceMap = new HashMap<String, String>(this.domainSourceMap);
        playerCharacter.characterDomainList.addAll(this.characterDomainList);
        for (PCClass pCClass : this.classList) {
            playerCharacter.classList.add(pCClass.clone());
        }
        playerCharacter.companionModList.addAll(this.companionModList);
        playerCharacter.qualifyArrayMap.addAllLists(this.qualifyArrayMap);
        playerCharacter.followerMaster = this.followerMaster != null ? this.followerMaster.clone() : null;
        for (EquipSet equipSet : this.equipSetList) {
            playerCharacter.addEquipSet((EquipSet)equipSet.clone());
        }
        playerCharacter.equipmentList.addAll(this.equipmentList);
        playerCharacter.equipmentMasterList.addAll(this.equipmentMasterList);
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            playerCharacter.pcLevelInfo.add((PCLevelInfo)pCLevelInfo.clone());
        }
        for (String string : this.spellBooks) {
            playerCharacter.addSpellBook(new String(string));
        }
        playerCharacter.tempBonusItemList.addAll(this.tempBonusItemList);
        playerCharacter.tempBonusList.addAll(this.tempBonusList);
        playerCharacter.tempBonusFilters.addAll(this.tempBonusFilters);
        playerCharacter.race = this.race;
        playerCharacter.favoredClasses.addAll(this.favoredClasses);
        playerCharacter.statList.clear();
        for (PCStat pCStat : this.statList) {
            playerCharacter.statList.addStat(pCStat.clone());
        }
        if (this.kitList != null) {
            playerCharacter.kitList = new ArrayList<Kit>();
            playerCharacter.kitList.addAll(this.kitList);
        }
        playerCharacter.spellTracker = this.spellTracker;
        playerCharacter.templateAutoLanguages.addAll(this.templateAutoLanguages);
        playerCharacter.templateLanguages.addAll(this.templateLanguages);
        playerCharacter.setBio(new String(this.getBio()));
        playerCharacter.setBirthday(new String(this.getBirthday()));
        playerCharacter.setBirthplace(new String(this.getBirthplace()));
        playerCharacter.setCatchPhrase(new String(this.getCatchPhrase()));
        playerCharacter.setCurrentEquipSetName(new String(this.getCurrentEquipSetName()));
        playerCharacter.setDescription(new String(this.getDescription()));
        playerCharacter.setDescriptionLst(new String(this.getDescriptionLst()));
        playerCharacter.setEyeColor(new String(this.getEyeColor()));
        playerCharacter.setFileName(new String(this.getFileName()));
        playerCharacter.setGender(new String(this.getGender()));
        playerCharacter.setHairColor(new String(this.getHairColor()));
        playerCharacter.setHairStyle(new String(this.getHairStyle()));
        playerCharacter.setHanded(new String(this.getHanded()));
        playerCharacter.setInterests(new String(this.getInterests()));
        playerCharacter.setLocation(new String(this.getLocation()));
        playerCharacter.setName(new String(this.getName()));
        playerCharacter.setPhobias(new String(this.getPhobias()));
        playerCharacter.setPlayersName(new String(this.getPlayersName()));
        playerCharacter.setPortraitPath(new String(this.getPortraitPath()));
        if (this.getRegion() != null) {
            playerCharacter.setRegion(new String(this.getRegion()));
        }
        playerCharacter.setResidence(new String(this.getResidence()));
        playerCharacter.setSkinColor(new String(this.getSkinColor()));
        playerCharacter.setSpeechTendency(new String(this.getSpeechTendency()));
        if (this.getSubRegion() != null) {
            playerCharacter.setSubRegion(new String(this.getSubRegion()));
        }
        playerCharacter.tabName = new String(this.tabName);
        playerCharacter.setTrait1(new String(this.getTrait1()));
        playerCharacter.setTrait2(new String(this.getTrait2()));
        playerCharacter.languages.addAll(this.languages);
        if (this.theWeaponProfs != null) {
            playerCharacter.theWeaponProfs = new TreeSet<WeaponProf>();
            playerCharacter.theWeaponProfs.addAll(this.theWeaponProfs);
        }
        playerCharacter.autoKnownSpells = this.autoKnownSpells;
        playerCharacter.autoLoadCompanion = this.autoLoadCompanion;
        playerCharacter.autoSortGear = this.autoSortGear;
        playerCharacter.outputSheetHTML = new String(this.outputSheetHTML);
        playerCharacter.outputSheetPDF = new String(this.outputSheetPDF);
        playerCharacter.ageSetKitSelections = new boolean[10];
        System.arraycopy(this.ageSetKitSelections, 0, playerCharacter.ageSetKitSelections, 0, this.ageSetKitSelections.length);
        playerCharacter.serial = this.serial;
        playerCharacter.displayUpdate = this.displayUpdate;
        playerCharacter.setImporting(false);
        playerCharacter.useTempMods = this.useTempMods;
        playerCharacter.setFeats(this.feats);
        playerCharacter.age = this.age;
        playerCharacter.alignment = this.alignment;
        playerCharacter.costPool = this.costPool;
        playerCharacter.currentEquipSetNumber = this.currentEquipSetNumber;
        playerCharacter.earnedXP = this.earnedXP;
        playerCharacter.equipOutputOrder = this.equipOutputOrder;
        playerCharacter.freeLangs = this.freeLangs;
        playerCharacter.heightInInches = this.heightInInches;
        playerCharacter.poolAmount = this.poolAmount;
        playerCharacter.skillsOutputOrder = this.skillsOutputOrder;
        playerCharacter.spellLevelTemp = this.spellLevelTemp;
        playerCharacter.weightInPounds = this.weightInPounds;
        playerCharacter.variableProcessor = new VariableProcessorPC(playerCharacter);
        playerCharacter.pointBuyPoints = this.pointBuyPoints;
        playerCharacter.setDirty(true);
        playerCharacter.setAutomaticFeatsStable(false);
        playerCharacter.setVirtualFeatsStable(false);
        playerCharacter.adjustMoveRates();
        playerCharacter.calcActiveBonuses();
        return playerCharacter;
    }

    public void setStringFor(StringKey stringKey, String string) {
        this.stringChar.put(stringKey, string);
        this.setDirty(true);
    }

    public String removeStringFor(StringKey stringKey) {
        return this.stringChar.remove(stringKey);
    }

    private Float getEquippedQty(EquipSet equipSet, Equipment equipment) {
        String string = equipSet.getIdPath();
        for (EquipSet equipSet2 : this.getEquipSet()) {
            String string2;
            String string3 = equipSet2.getIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".") || !equipment.getName().equals(equipSet2.getValue())) continue;
            return equipSet2.getQty();
        }
        return Float.valueOf(0.0f);
    }

    private static List<String> getWeaponLocationChoices(int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(n + 2);
        if (n > 0) {
            arrayList.add("Primary Hand");
            for (int i = 1; i < n; ++i) {
                if (i > 1) {
                    arrayList.add("Secondary Hand " + i);
                    continue;
                }
                arrayList.add("Secondary Hand");
            }
            if (string.length() > 0) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private String getSingleLocation(Equipment equipment) {
        if (equipment.isNatural() && equipment.getSlots(this) == 0) {
            if (equipment.modifiedName().endsWith("Primary")) {
                return "Natural-Primary";
            }
            return "Natural-Secondary";
        }
        if (equipment.isWeapon() && !equipment.isArmor()) {
            return "";
        }
        List<EquipSlot> list = SystemCollections.getUnmodifiableEquipSlotList();
        if (list == null || list.isEmpty()) {
            return "";
        }
        for (EquipSlot equipSlot : list) {
            if (!equipSlot.canContainType(equipment.getType())) continue;
            return equipSlot.getSlotName();
        }
        return "";
    }

    public List<String> getEquippableLocations(EquipSet equipSet, Equipment equipment, List<String> list) {
        String string;
        int n = this.getHands();
        List<String> list2 = new ArrayList<String>();
        if (equipment.isWeapon()) {
            if (equipment.isUnarmed()) {
                list2.add("Unarmed");
            } else if (equipment.isShield()) {
                list2.add("Shield");
            } else if (!equipment.isWeaponOutsizedForPC(this)) {
                if (equipment.isWeaponOneHanded(this)) {
                    list2 = PlayerCharacter.getWeaponLocationChoices(n, "Both Hands");
                } else {
                    list2.add("Both Hands");
                }
                if (equipment.isMelee() && equipment.isDouble()) {
                    list2.add("Double Weapon");
                }
            }
        } else {
            string = this.getSingleLocation(equipment);
            if (string.length() != 0) {
                list2.add(string);
            } else {
                list2.add("Equipped");
            }
        }
        if (!equipment.isUnarmed()) {
            list2.add("Carried");
            list2.add("Not Carried");
        }
        if (list != null && equipSet != null) {
            string = equipSet.getIdPath();
            for (EquipSet equipSet2 : this.getEquipSet()) {
                Equipment equipment2;
                String string2;
                String string3 = equipSet2.getParentIdPath() + ".";
                if (!string3.startsWith(string2 = string + ".") || (equipment2 = equipSet2.getItem()) == null || !equipment2.isContainer()) continue;
                list.add(equipment2.getName());
            }
        }
        return list2;
    }

    public boolean canEquipItem(EquipSet equipSet, String string, Equipment equipment, Equipment equipment2) {
        Object object;
        String string2;
        String string3;
        String string4 = equipSet.getIdPath();
        if (equipment2 != null && equipment2.isContainer()) {
            return true;
        }
        if (string.startsWith("Carried") || string.startsWith("Equipped") || string.startsWith("Not Carried")) {
            return true;
        }
        if (equipment.isUnarmed()) {
            return true;
        }
        if (string.equals("Natural-Secondary")) {
            return true;
        }
        if (equipment.isWeapon() && equipment.isWeaponOutsizedForPC(this) && !equipment.isNatural()) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (EquipSet equipSet2 : this.getEquipSet()) {
            string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string4 + ".") || !equipSet2.getName().equals(string)) continue;
            object = equipSet2.getItem();
            String string5 = (String)hashMap.get(string);
            int n = 0;
            if (string5 != null) {
                n = Integer.parseInt(string5);
            }
            if (object != null) {
                n += ((Equipment)object).getSlots(this);
            }
            hashMap.put(string, String.valueOf(n));
        }
        for (EquipSet equipSet2 : this.getEquipSet()) {
            string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string4 + ".")) continue;
            if (equipment.isWeapon()) {
                if (equipSet2.getName().equals(string)) {
                    return false;
                }
                if ((string.equals("Both Hands") || string.equals("Double Weapon")) && (equipSet2.getName().equals("Primary Hand") || equipSet2.getName().equals("Secondary Hand") || equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon"))) {
                    return false;
                }
                if ((string.equals("Primary Hand") || string.equals("Secondary Hand")) && (equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon"))) {
                    return false;
                }
            }
            if (!equipSet2.getName().equals(string)) continue;
            object = (String)hashMap.get(string);
            int n = 0;
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
            n += equipment.getSlots(this);
            EquipSlot equipSlot = Globals.getEquipSlotByName(string);
            if (equipSlot == null) {
                return true;
            }
            return n <= equipSlot.getSlotCount() + (int)this.getTotalBonusTo("SLOTS", equipSlot.getContainType());
        }
        return true;
    }

    private EquipSet getEquipSetForItem(EquipSet equipSet, Equipment equipment) {
        String string = equipSet.getIdPath();
        for (EquipSet equipSet2 : this.getEquipSet()) {
            String string2;
            String string3 = equipSet2.getIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".") || !equipment.getName().equals(equipSet2.getValue())) continue;
            return equipSet2;
        }
        return null;
    }

    private String getNewIdPath(EquipSet equipSet) {
        String string = "0";
        int n = 0;
        if (equipSet != null) {
            string = equipSet.getIdPath();
        }
        for (EquipSet equipSet2 : this.getEquipSet()) {
            if (!equipSet2.getParentIdPath().equals(string) || equipSet2.getId() <= n) continue;
            n = equipSet2.getId();
        }
        return string + "." + ++n;
    }

    public EquipSet addEquipToTarget(EquipSet equipSet, Equipment equipment, String string, Equipment equipment2, Float f) {
        float f2 = 1.0f;
        if (f != null) {
            f2 = f.floatValue();
        } else {
            f = Float.valueOf(f2);
        }
        boolean bl = false;
        boolean bl2 = false;
        Equipment equipment3 = this.getEquipmentNamed(equipment2.getName());
        if (equipment3 == null) {
            return null;
        }
        float f3 = equipment3.getQty().floatValue() - this.getEquippedQty(equipSet, equipment2).floatValue();
        if (f.floatValue() < 0.0f) {
            f2 = f3;
            f = new Float(f2 + this.getEquippedQty(equipSet, equipment2).floatValue());
            bl = true;
        }
        if (f2 > f3) {
            return null;
        }
        if (equipment != null && equipment.isContainer()) {
            equipment2.setQty(f);
            equipment2.setNumberCarried(f);
            if (equipment.canContain(this, equipment2) == 1) {
                string = equipment.getName();
                bl = true;
                bl2 = true;
            } else {
                return null;
            }
        }
        if ((string == null || string != null && ("".equals(string) || string.length() == 0)) && (string = this.getSingleLocation(equipment2)).length() == 0) {
            return null;
        }
        if (!this.canEquipItem(equipSet, string, equipment2, equipment)) {
            return null;
        }
        if (equipment2.isContainer()) {
            bl2 = false;
        }
        EquipSet equipSet2 = this.getEquipSetForItem(equipSet, equipment2);
        if (bl && bl2 && equipSet2 != null) {
            f = new Float(f2 + this.getEquippedQty(equipSet, equipment2).floatValue());
            equipSet2.setQty(f);
            equipment2.setQty(f);
            equipment2.setNumberCarried(f);
            this.setDirty(true);
            if (equipment != null && equipment.isContainer()) {
                equipment.updateContainerContentsString(this);
            }
            return equipSet2;
        }
        if (equipment != null && equipment.isContainer()) {
            equipment.insertChild(this, equipment2);
            equipment2.setParent(equipment);
        }
        String string2 = this.getNewIdPath(equipSet);
        EquipSet equipSet3 = new EquipSet(string2, string, equipment2.getName(), equipment2);
        equipment2.setQty(f);
        equipSet3.setQty(f);
        this.addEquipSet(equipSet3);
        this.setDirty(true);
        return equipSet3;
    }

    public String getStringFor(StringKey stringKey) {
        return this.stringChar.get(stringKey);
    }

    public String getSafeStringFor(StringKey stringKey) {
        String string = this.stringChar.get(stringKey);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setDoLevelAbilities(boolean bl) {
        this.processLevelAbilities = bl;
    }

    public boolean doLevelAbilities() {
        return this.processLevelAbilities;
    }

    public void setAllowFeatPoolAdjustment(boolean bl) {
        this.allowFeatPoolAdjustment = bl;
    }

    private void setAggregateFeatsStable(boolean bl) {
        this.setAggregateAbilitiesStable(AbilityCategory.FEAT, bl);
    }

    public void setAggregateAbilitiesStable(AbilityCategory abilityCategory, boolean bl) {
        if (!bl) {
            this.cachedWeaponProfs = null;
        }
        if (abilityCategory == AbilityCategory.FEAT) {
            this.aggregateFeatsStable = bl;
            this.setVirtualFeatsStable(bl);
            this.setAutomaticFeatsStable(bl);
            if (!bl) {
                this.cachedWeaponProfs = null;
            }
        }
        if (abilityCategory == null) {
            if (!bl) {
                for (AbilityCategory abilityCategory2 : this.theAbilities.getKeySet()) {
                    if (abilityCategory2 == null) {
                        Logging.errorPrint("Null category entry in character's abilities key set " + String.valueOf(this.theAbilities.getKeySet()));
                        continue;
                    }
                    this.setAggregateAbilitiesStable(abilityCategory2, bl);
                }
            }
            this.setAggregateFeatsStable(bl);
            return;
        }
        if (!bl) {
            this.theAbilities.put(abilityCategory, Ability.Nature.AUTOMATIC, null);
            this.theAbilities.put(abilityCategory, Ability.Nature.VIRTUAL, null);
            this.theAbilities.put(abilityCategory, Ability.Nature.NORMAL, null);
        }
    }

    private boolean isAggregateFeatsStable() {
        return this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.AUTOMATIC) != null && this.virtualFeatsStable && this.aggregateFeatsStable;
    }

    public boolean isAggregateAbilitiesStable(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.isAggregateFeatsStable();
        }
        return this.theAbilities.get(abilityCategory, Ability.Nature.NORMAL) != null && this.theAbilities.get(abilityCategory, Ability.Nature.AUTOMATIC) != null && this.theAbilities.get(abilityCategory, Ability.Nature.VIRTUAL) != null;
    }

    private void setAutomaticFeatsStable(boolean bl) {
        this.setAutomaticAbilitiesStable(AbilityCategory.FEAT, bl);
    }

    public void setAutomaticAbilitiesStable(AbilityCategory abilityCategory, boolean bl) {
        if (abilityCategory == null) {
            if (!bl) {
                for (AbilityCategory abilityCategory2 : this.theAbilities.getKeySet()) {
                    this.theAbilities.put(abilityCategory2, Ability.Nature.AUTOMATIC, null);
                }
            }
            this.setAutomaticFeatsStable(bl);
            return;
        }
        if (!bl) {
            this.theAbilities.put(abilityCategory, Ability.Nature.AUTOMATIC, null);
        }
    }

    public boolean addRealAbility(AbilityCategory abilityCategory, Ability ability) {
        if (ability == null) {
            return false;
        }
        ability.setFeatType(Ability.Nature.NORMAL);
        List<Ability> list = this.realAbilities.get(abilityCategory);
        if (list == null) {
            list = new ArrayList<Ability>();
            this.realAbilities.put(abilityCategory, list);
        }
        list.add(ability);
        return true;
    }

    public void clearRealAbilities(AbilityCategory abilityCategory) {
        if (abilityCategory == null) {
            for (AbilityCategory abilityCategory2 : this.theAbilities.getKeySet()) {
                this.theAbilities.put(abilityCategory2, Ability.Nature.NORMAL, null);
            }
            return;
        }
        this.theAbilities.put(abilityCategory, Ability.Nature.NORMAL, null);
    }

    public int getNumberOfRealAbilities(AbilityCategory abilityCategory) {
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.NORMAL);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public HashMap<Ability.Nature, Set<Ability>> getAbilitiesSet() {
        Set<AbilityCategory> set = this.theAbilities.getKeySet();
        HashMap<Ability.Nature, Set<Ability>> hashMap = new HashMap<Ability.Nature, Set<Ability>>();
        hashMap.put(Ability.Nature.AUTOMATIC, new HashSet());
        hashMap.put(Ability.Nature.NORMAL, new HashSet());
        hashMap.put(Ability.Nature.VIRTUAL, new HashSet());
        hashMap.put(Ability.Nature.ANY, new HashSet());
        if (set == null) {
            return hashMap;
        }
        hashMap.get((Object)Ability.Nature.VIRTUAL).addAll(this.getAbilitySetByNature(Ability.Nature.VIRTUAL));
        hashMap.get((Object)Ability.Nature.AUTOMATIC).addAll(this.getAbilitySetByNature(Ability.Nature.AUTOMATIC));
        hashMap.get((Object)Ability.Nature.NORMAL).addAll(this.getAbilitySetByNature(Ability.Nature.NORMAL));
        hashMap.get((Object)Ability.Nature.ANY).addAll((Collection<Ability>)hashMap.get((Object)Ability.Nature.NORMAL));
        hashMap.get((Object)Ability.Nature.ANY).addAll((Collection<Ability>)hashMap.get((Object)Ability.Nature.AUTOMATIC));
        hashMap.get((Object)Ability.Nature.ANY).addAll((Collection<Ability>)hashMap.get((Object)Ability.Nature.VIRTUAL));
        return hashMap;
    }

    public List<Ability> getRealAbilitiesList(AbilityCategory abilityCategory) {
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.NORMAL);
        if (list != null) {
            return new ArrayList<Ability>(list);
        }
        list = new ArrayList<Ability>();
        if (this.realAbilities.get(abilityCategory) != null) {
            list.addAll((Collection<Ability>)this.realAbilities.get(abilityCategory));
        }
        this.theAbilities.put(abilityCategory, Ability.Nature.NORMAL, list);
        for (PObject pObject : this.getPObjectList()) {
            List<String> list2 = pObject.getAbilityKeys(this, abilityCategory, Ability.Nature.NORMAL);
            for (String string : list2) {
                Ability ability = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, abilityCategory, string);
                if (ability == null) continue;
                ability.setFeatType(Ability.Nature.NORMAL);
            }
        }
        return new ArrayList<Ability>(list);
    }

    public List<Ability> getRealAbilitiesListAnyCat(AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (AbilityCategory abilityCategory2 : SettingsHandler.getGame().getAllAbilityCategories()) {
            for (Ability ability : this.getRealAbilitiesList(abilityCategory2)) {
                if (!abilityCategory.getKeyName().equals(ability.getCategory())) continue;
                arrayList.add(ability);
            }
        }
        return arrayList;
    }

    public List<Ability> getRealFeatList() {
        return this.getRealAbilitiesList(AbilityCategory.FEAT);
    }

    public List<Ability> getRealAbilityList(AbilityCategory abilityCategory) {
        return this.getRealAbilitiesList(abilityCategory);
    }

    public Ability getRealFeatKeyed(String string) {
        return this.getRealAbilityKeyed(AbilityCategory.FEAT, string);
    }

    public Ability getRealAbilityKeyed(AbilityCategory abilityCategory, String string) {
        List<Ability> list = this.getRealAbilitiesList(abilityCategory);
        if (list != null) {
            for (Ability ability : list) {
                if (!ability.getKeyName().equals(string)) continue;
                return ability;
            }
        }
        return null;
    }

    public Ability getRealFeatNamed(String string) {
        return AbilityUtilities.getAbilityFromList(this.realAbilities.get(AbilityCategory.FEAT), "FEAT", string, Ability.Nature.ANY);
    }

    public boolean hasRealFeat(Ability ability) {
        return this.hasRealAbility(AbilityCategory.FEAT, ability);
    }

    public boolean hasRealAbility(AbilityCategory abilityCategory, Ability ability) {
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.NORMAL);
        if (list == null) {
            return false;
        }
        return list.contains(ability);
    }

    public boolean hasAbility(AbilityCategory abilityCategory, Ability.Nature nature, Ability ability) {
        int n;
        int n2;
        ArrayList<AbilityCategory> arrayList;
        if (abilityCategory == null) {
            arrayList = new ArrayList<AbilityCategory>();
            Collection<AbilityCategory> collection = SettingsHandler.getGame().getAllAbilityCategories();
            for (AbilityCategory abilityCategory2 : collection) {
                if (!abilityCategory2.getAbilityCategory().equals(ability.getCategory())) continue;
                arrayList.add(abilityCategory2);
            }
        } else {
            arrayList = new ArrayList();
            arrayList.add(abilityCategory);
        }
        if (nature == Ability.Nature.ANY) {
            n2 = 0;
            n = Ability.Nature.values().length - 2;
        } else {
            n2 = n = nature.ordinal();
        }
        for (int i = n2; i <= n; ++i) {
            Ability.Nature nature2 = Ability.Nature.values()[i];
            boolean bl = false;
            for (AbilityCategory abilityCategory3 : arrayList) {
                switch (nature2) {
                    case NORMAL: {
                        bl = this.hasRealAbility(abilityCategory3, ability);
                        break;
                    }
                    case AUTOMATIC: {
                        bl = this.hasAutomaticAbility(abilityCategory3, ability);
                        break;
                    }
                    case VIRTUAL: {
                        bl = this.hasVirtualAbility(abilityCategory3, ability);
                    }
                }
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRealFeatNamed(String string) {
        List<Ability> list = this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.NORMAL);
        if (list == null) {
            return false;
        }
        return AbilityUtilities.getAbilityFromList(list, "FEAT", string, Ability.Nature.ANY) != null;
    }

    public boolean removeRealFeat(Ability ability) {
        return this.removeRealAbility(AbilityCategory.FEAT, ability);
    }

    public boolean removeRealAbility(AbilityCategory abilityCategory, Ability ability) {
        List<Ability> list = this.realAbilities.get(abilityCategory);
        if (list == null) {
            return false;
        }
        return list.remove(ability);
    }

    public void adjustFeats(double d) {
        if (this.allowFeatPoolAdjustment) {
            this.feats += d;
        }
        this.setDirty(true);
    }

    public void adjustAbilities(AbilityCategory abilityCategory, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.equals(BigDecimal.ZERO)) {
            return;
        }
        if (abilityCategory == AbilityCategory.FEAT) {
            this.adjustFeats(bigDecimal.doubleValue());
            return;
        }
        if (this.theUserPoolBonuses == null) {
            this.theUserPoolBonuses = new HashMap<AbilityCategory, BigDecimal>();
        }
        bigDecimal2 = (bigDecimal2 = this.theUserPoolBonuses.get(abilityCategory)) != null ? bigDecimal2.add(bigDecimal) : bigDecimal;
        this.theUserPoolBonuses.put(abilityCategory, bigDecimal2);
        this.setDirty(true);
    }

    public void setFeats(double d) {
        if (this.allowFeatPoolAdjustment) {
            this.feats = d;
        }
        this.setDirty(true);
    }

    public void setAbilities(AbilityCategory abilityCategory, double d) {
        if (abilityCategory == AbilityCategory.FEAT) {
            this.setFeats(d);
            return;
        }
    }

    public void setUserPoolBonus(AbilityCategory abilityCategory, BigDecimal bigDecimal) {
        if (this.theUserPoolBonuses == null) {
            this.theUserPoolBonuses = new HashMap<AbilityCategory, BigDecimal>();
        }
        this.theUserPoolBonuses.put(abilityCategory, bigDecimal);
    }

    public double getUserPoolBonus(AbilityCategory abilityCategory) {
        BigDecimal bigDecimal = null;
        if (this.theUserPoolBonuses != null) {
            bigDecimal = this.theUserPoolBonuses.get(abilityCategory);
        }
        if (bigDecimal == null) {
            return 0.0;
        }
        return bigDecimal.doubleValue();
    }

    public BigDecimal getTotalAbilityPool(AbilityCategory abilityCategory) {
        Float f = this.getVariableValue(abilityCategory.getPoolFormula(), this.getClass().toString());
        if (!abilityCategory.allowFractionalPool()) {
            f = new Float(f.intValue());
        }
        double d = this.getTotalBonusTo("ABILITYPOOL", abilityCategory.getKeyName());
        if (!abilityCategory.allowFractionalPool()) {
            d = Math.floor(d);
        }
        double d2 = this.getUserPoolBonus(abilityCategory);
        return BigDecimal.valueOf((double)f.floatValue() + d + d2);
    }

    public List<Ability> getSelectedAbilities(AbilityCategory abilityCategory) {
        return this.getRealAbilitiesList(abilityCategory);
    }

    public double getFeats() {
        if (Globals.getGameModeHasPointPool()) {
            return this.getSkillPoints();
        }
        return this.getRawFeats(true);
    }

    public BigDecimal getAvailableAbilityPool(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return BigDecimal.valueOf(this.getFeats());
        }
        return this.getTotalAbilityPool(abilityCategory).subtract(this.getAbilityPoolSpent(abilityCategory));
    }

    public double getRawFeats(boolean bl) {
        double d = this.feats;
        if (bl) {
            d += this.getBonusFeatPool();
        }
        return d;
    }

    public boolean canSelectAbility(Ability ability) {
        return this.canSelectAbility(ability, false);
    }

    public boolean canSelectAbility(Ability ability, boolean bl) {
        boolean bl2 = this.qualifiesForFeat(ability);
        boolean bl3 = ability.isMultiples();
        boolean bl4 = this.hasRealFeat(ability);
        boolean bl5 = this.hasFeatAutomatic(ability.getKeyName());
        boolean bl6 = !bl4 && !bl5;
        return !(!bl && !bl2 || !bl3 && !bl6);
    }

    public double getUsedFeatCount() {
        double d = 0.0;
        List<Ability> list = this.realAbilities.get(AbilityCategory.FEAT);
        if (list == null) {
            return 0.0;
        }
        for (Ability ability : list) {
            int n = ability.getAssociatedCount();
            if (n > 1) {
                d += (double)n;
                continue;
            }
            d += ability.getCost(this);
        }
        return d;
    }

    public BigDecimal getAbilityPoolSpent(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return BigDecimal.valueOf(this.getUsedFeatCount());
        }
        double d = 0.0;
        List<Ability> list = this.getSelectedAbilities(abilityCategory);
        if (list != null) {
            for (Ability ability : list) {
                int n = ability.getAssociatedCount();
                if (ability.getChoiceString() != null && ability.getChoiceString().length() > 0) {
                    d += (double)n;
                    continue;
                }
                if (!abilityCategory.allowFractionalPool()) {
                    d += (double)((int)Math.ceil(ability.getCost(this)));
                    continue;
                }
                d += ability.getCost(this);
            }
        }
        if (!abilityCategory.allowFractionalPool()) {
            return BigDecimal.valueOf((int)Math.ceil(d));
        }
        return BigDecimal.valueOf(d);
    }

    public double getUsedAbilityCount(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.getUsedFeatCount();
        }
        return this.getAbilityPoolSpent(abilityCategory).doubleValue();
    }

    private void setVirtualFeatsStable(boolean bl) {
        this.virtualFeatsStable = bl;
    }

    public void setVirtualAbilitiesStable(AbilityCategory abilityCategory, boolean bl) {
        if (abilityCategory == AbilityCategory.FEAT) {
            this.setVirtualFeatsStable(bl);
            return;
        }
        if (!bl) {
            this.theAbilities.put(abilityCategory, Ability.Nature.VIRTUAL, null);
        }
    }

    public void addFeat(Ability ability, PCLevelInfo pCLevelInfo) {
        if (this.hasRealFeat(ability)) {
            Logging.errorPrint("Adding duplicate feat: " + ability.getDisplayName());
        }
        if (!this.addRealAbility(AbilityCategory.FEAT, ability)) {
            Logging.errorPrint("Problem adding feat: " + ability.getDisplayName());
        }
        if (pCLevelInfo != null) {
            pCLevelInfo.addObject(ability);
        }
        this.addNaturalWeapons(ability.getNaturalWeapons());
        this.setAggregateFeatsStable(false);
        this.calcActiveBonuses();
    }

    public void addAbility(AbilityCategory abilityCategory, Ability ability, PCLevelInfo pCLevelInfo) {
        if (this.hasRealAbility(abilityCategory, ability)) {
            Logging.errorPrint("Adding duplicate ability: " + ability.getDisplayName());
        }
        if (!this.addRealAbility(abilityCategory, ability)) {
            Logging.errorPrint("Problem adding ability: " + ability.getDisplayName());
        }
        if (pCLevelInfo != null) {
            pCLevelInfo.addObject(ability);
        }
        this.addNaturalWeapons(ability.getNaturalWeapons());
        this.setAggregateAbilitiesStable(abilityCategory, false);
        this.calcActiveBonuses();
    }

    public Ability getFeatAutomaticKeyed(String string) {
        return this.getAutomaticAbilityKeyed(AbilityCategory.FEAT, string);
    }

    public Ability getAutomaticAbilityKeyed(AbilityCategory abilityCategory, String string) {
        List<Ability> list = this.getAutomaticAbilityList(abilityCategory);
        for (Ability ability : list) {
            if (!ability.getKeyName().equals(string)) continue;
            return ability;
        }
        return null;
    }

    public Ability getVirtualFeatKeyed(String string) {
        return AbilityUtilities.getAbilityFromList(this.getVirtualFeatList(), "FEAT", string, Ability.Nature.ANY);
    }

    public Ability getVirtualAbilityKeyed(AbilityCategory abilityCategory, String string) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.getVirtualFeatKeyed(string);
        }
        List<Ability> list = this.getVirtualAbilityList(abilityCategory);
        for (Ability ability : list) {
            if (!ability.getKeyName().equals(string)) continue;
            return ability;
        }
        return null;
    }

    public int addAbility(PCLevelInfo pCLevelInfo, AbilityCategory abilityCategory, String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = !bl2;
        if (!this.isImporting()) {
            this.getSpellList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        String string3 = EquipmentUtilities.getUndecoratedName(string, arrayList);
        String string4 = arrayList.size() > 0 ? arrayList.get(0) : "";
        Ability ability = this.getRealAbilityKeyed(abilityCategory, string2);
        if (ability == null) {
            ability = this.getRealAbilityKeyed(abilityCategory, string3);
            if (!bl3 && ability != null && string4.length() != 0) {
                bl3 = true;
            }
        }
        if (ability == null && bl) {
            ability = Globals.getAbilityKeyed(abilityCategory, string3);
            if (ability == null && (ability = Globals.getAbilityKeyed(abilityCategory, string2)) != null) {
                string4 = "";
            }
            if (ability == null) {
                Logging.errorPrint("Ability not found: " + string2);
                return bl ? 1 : 0;
            }
            ability = ability.clone();
            this.addAbility(abilityCategory, ability, pCLevelInfo);
            ability.getTemplates(this.isImporting(), this);
        }
        if (ability == null) {
            return bl ? 1 : 0;
        }
        return AbilityUtilities.finaliseAbility(ability, string4, this, bl, bl3, abilityCategory);
    }

    public Ability getFeatKeyed(String string) {
        return this.getFeatKeyed(string, this.aggregateFeatList());
    }

    public Ability getAbilityKeyed(AbilityCategory abilityCategory, String string) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.getFeatKeyed(string);
        }
        List<Ability> list = this.getAggregateAbilityList(abilityCategory);
        for (Ability ability : list) {
            if (!ability.getKeyName().equals(string)) continue;
            return ability;
        }
        return null;
    }

    public List<Ability> aggregateFeatList() {
        List<Ability> list = this.getStableAggregateFeatList();
        if (list != null) {
            return list;
        }
        return this.rebuildFeatAggreagateList();
    }

    public List<Ability> getAggregateAbilityList(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.aggregateFeatList();
        }
        ArrayList<Ability> arrayList = new ArrayList<Ability>(this.getRealAbilitiesList(abilityCategory));
        arrayList.addAll(this.getVirtualAbilityList(abilityCategory));
        arrayList.addAll(this.getAutomaticAbilityList(abilityCategory));
        return arrayList;
    }

    private List<Ability> rebuildFeatAggreagateList() {
        String string;
        int n;
        Ability ability;
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        HashMap<String, Ability> hashMap = new HashMap<String, Ability>();
        for (Ability ability2 : this.getRealAbilitiesList(AbilityCategory.FEAT)) {
            if (ability2 == null) continue;
            hashMap.put(ability2.getKeyName(), ability2);
        }
        for (Ability ability2 : this.getVirtualFeatList()) {
            if (!hashMap.containsKey(ability2.getKeyName())) {
                hashMap.put(ability2.getKeyName(), ability2);
                continue;
            }
            if (!ability2.isMultiples()) continue;
            ability = (Ability)hashMap.get(ability2.getKeyName());
            ability = ability.clone();
            for (n = 0; n < ability2.getAssociatedCount(); ++n) {
                string = ability2.getAssociated(n);
                if (!ability.isStacks() && ability.containsAssociated(string)) continue;
                ability.addAssociated(string);
            }
            hashMap.put(ability2.getKeyName(), ability);
        }
        arrayList.addAll(hashMap.values());
        this.setStableAggregateFeatList(arrayList);
        for (Ability ability2 : this.featAutoList()) {
            if (!hashMap.containsKey(ability2.getKeyName())) {
                hashMap.put(ability2.getKeyName(), ability2);
                continue;
            }
            if (!ability2.isMultiples()) continue;
            ability = (Ability)hashMap.get(ability2.getKeyName());
            ability = ability.clone();
            for (n = 0; n < ability2.getAssociatedCount(); ++n) {
                string = ability2.getAssociated(n);
                if (!ability.isStacks() && ability.containsAssociated(string)) continue;
                ability.addAssociated(string);
            }
            hashMap.put(ability2.getKeyName(), ability);
        }
        arrayList = new ArrayList();
        arrayList.addAll(hashMap.values());
        this.setStableAggregateFeatList(arrayList);
        return arrayList;
    }

    public List<Ability> aggregateVisibleFeatList() {
        return this.getAggregateVisibleAbilityList(AbilityCategory.FEAT);
    }

    public List<Ability> getAggregateVisibleAbilityList(AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        arrayList.addAll(this.getRealAbilitiesListAnyCat(AbilityCategory.FEAT));
        arrayList.addAll(this.getAutomaticAbilityList(AbilityCategory.FEAT));
        arrayList.addAll(this.getVirtualAbilityList(AbilityCategory.FEAT));
        ArrayList<Ability> arrayList2 = new ArrayList<Ability>(arrayList.size());
        for (Ability ability : arrayList) {
            if (ability.getVisibility() != Visibility.DEFAULT && ability.getVisibility() != Visibility.OUTPUT_ONLY) continue;
            arrayList2.add(ability);
        }
        return arrayList2;
    }

    boolean isAutomaticAbilitiesStable(AbilityCategory abilityCategory) {
        return this.theAbilities.get(abilityCategory, Ability.Nature.AUTOMATIC) != null;
    }

    public List<Ability> getVirtualFeatList() {
        ArrayList<Skill> arrayList;
        Ability ability;
        Object object4;
        Object object22;
        Object object32;
        List<Ability> list = this.getStableVirtualFeatList();
        if (list != null) {
            return list;
        }
        this.setVirtualFeatsStable(true);
        list = new ArrayList<Ability>();
        if (this.stableVirtualFeatList != null) {
            for (Ability object5 : this.stableVirtualFeatList) {
                if (!object5.needsSaving() || !PrereqHandler.passesAll(object5.getPreReqList(), this, object5)) continue;
                list.add(object5);
            }
        }
        for (PCClass pCClass : this.classList) {
            List<Ability> list2 = pCClass.getVirtualFeatList(pCClass.getLevel());
            object32 = pCClass.getAbilityKeys(this, AbilityCategory.FEAT, Ability.Nature.VIRTUAL);
            object22 = object32.iterator();
            while (object22.hasNext()) {
                object4 = object22.next();
                ability = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list2, AbilityCategory.FEAT, (String)object4);
                if (ability == null) continue;
                ability.setFeatType(Ability.Nature.VIRTUAL);
            }
            for (Object object4 : list2) {
                if (!PrereqHandler.passesAll(((PrereqObject)object4).getPreReqList(), this, (PObject)object4)) continue;
                list.add((Ability)object4);
            }
        }
        for (Ability ability2 : this.getRealAbilitiesList(AbilityCategory.FEAT)) {
            List<Ability> list3 = ability2.getVirtualFeatList();
            for (Object object22 : list3) {
                if (!PrereqHandler.passesAll(((PrereqObject)object22).getPreReqList(), this, (PObject)object22)) continue;
                list.add((Ability)object22);
            }
        }
        for (PCTemplate pCTemplate : this.templateList) {
            List<Ability> list4 = pCTemplate.getVirtualFeatList();
            for (Object object22 : list4) {
                if (!PrereqHandler.passesAll(((PrereqObject)object22).getPreReqList(), this, (PObject)object22)) continue;
                list.add((Ability)object22);
            }
        }
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            List<Ability> list5 = equipment.getVirtualFeatList();
            for (Object object22 : list5) {
                if (!PrereqHandler.passesAll(((PrereqObject)object22).getPreReqList(), this, (PObject)object22)) continue;
                list.add((Ability)object22);
            }
        }
        if (this.getRace() != null) {
            arrayList = this.getRace().getVirtualFeatList();
            for (Ability ability3 : arrayList) {
                if (!PrereqHandler.passesAll(ability3.getPreReqList(), this, ability3)) continue;
                list.add(ability3);
            }
        }
        arrayList = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill : arrayList) {
            object32 = skill.getVirtualFeatList();
            object22 = object32.iterator();
            while (object22.hasNext()) {
                object4 = (Ability)object22.next();
                if (!PrereqHandler.passesAll(((PrereqObject)object4).getPreReqList(), this, (PObject)object4)) continue;
                list.add((Ability)object4);
            }
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            if (characterDomain.getDomain() == null) continue;
            object32 = characterDomain.getDomain().getVirtualFeatList();
            object22 = object32.iterator();
            while (object22.hasNext()) {
                object4 = (Ability)object22.next();
                if (!PrereqHandler.passesAll(((PrereqObject)object4).getPreReqList(), this, (PObject)object4)) continue;
                list.add((Ability)object4);
            }
        }
        if (this.deity != null) {
            List<Ability> list6 = this.deity.getVirtualFeatList();
            for (Object object32 : list6) {
                if (!PrereqHandler.passesAll(((PrereqObject)object32).getPreReqList(), this, object32)) continue;
                list.add((Ability)object32);
            }
        }
        for (CompanionMod companionMod : this.companionModList) {
            object32 = companionMod.getVirtualFeatList();
            object22 = object32.iterator();
            while (object22.hasNext()) {
                object4 = (Ability)object22.next();
                if (!PrereqHandler.passesAll(((PrereqObject)object4).getPreReqList(), this, (PObject)object4)) continue;
                list.add((Ability)object4);
            }
        }
        this.setStableVirtualFeatList(list);
        for (PObject pObject : this.getPObjectList()) {
            object32 = pObject.getAbilityKeys(this, AbilityCategory.FEAT, Ability.Nature.VIRTUAL);
            object22 = object32.iterator();
            while (object22.hasNext()) {
                object4 = (String)object22.next();
                ability = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, AbilityCategory.FEAT, (String)object4);
                if (ability == null) continue;
                ability.setFeatType(Ability.Nature.VIRTUAL);
            }
        }
        return list;
    }

    public Set<Ability> getAbilitySetByNature(Ability.Nature nature) {
        GameMode gameMode = SettingsHandler.getGame();
        HashSet<AbilityCategory> hashSet = new HashSet<AbilityCategory>();
        hashSet.addAll(gameMode.getAllAbilityCategories());
        HashSet<Ability> hashSet2 = new HashSet<Ability>();
        switch (nature) {
            case AUTOMATIC: {
                for (AbilityCategory abilityCategory : hashSet) {
                    hashSet2.addAll(this.getAutomaticAbilityList(abilityCategory));
                }
                break;
            }
            case NORMAL: {
                for (AbilityCategory abilityCategory : hashSet) {
                    hashSet2.addAll(this.getRealAbilitiesList(abilityCategory));
                }
                break;
            }
            case VIRTUAL: {
                for (AbilityCategory abilityCategory : hashSet) {
                    hashSet2.addAll(this.getVirtualAbilityList(abilityCategory));
                }
                break;
            }
            default: {
                Logging.errorPrint("Attempt to get abilities of Nature: " + (Object)((Object)nature));
            }
        }
        return hashSet2;
    }

    private Set<Ability> getFullAbilitySet() {
        GameMode gameMode = SettingsHandler.getGame();
        HashSet<AbilityCategory> hashSet = new HashSet<AbilityCategory>();
        hashSet.addAll(gameMode.getAllAbilityCategories());
        HashSet<Ability> hashSet2 = new HashSet<Ability>();
        for (AbilityCategory abilityCategory : hashSet) {
            hashSet2.addAll(this.getAggregateAbilityList(abilityCategory));
        }
        return hashSet2;
    }

    public List<Ability> getVirtualAbilityList(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.getVirtualFeatList();
        }
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.VIRTUAL);
        if (list == null) {
            list = new ArrayList<Ability>();
            this.theAbilities.put(abilityCategory, Ability.Nature.VIRTUAL, list);
            for (PObject pObject : this.getPObjectList()) {
                List<String> list2 = pObject.getAbilityKeys(this, abilityCategory, Ability.Nature.VIRTUAL);
                for (String string : list2) {
                    Ability ability = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, abilityCategory, string);
                    if (ability == null) continue;
                    ability.setFeatType(Ability.Nature.VIRTUAL);
                }
            }
        }
        return Collections.unmodifiableList(list);
    }

    public List<Ability> featAutoList() {
        return this.getAutomaticAbilityList(AbilityCategory.FEAT);
    }

    public List<Ability> getAutomaticAbilityList(AbilityCategory abilityCategory) {
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.AUTOMATIC);
        if (list == null) {
            list = new ArrayList<Ability>();
            this.theAbilities.put(abilityCategory, Ability.Nature.AUTOMATIC, list);
            for (PObject pObject : this.getPObjectList()) {
                List<String> list2 = pObject.getAbilityKeys(this, abilityCategory, Ability.Nature.AUTOMATIC);
                for (String string : list2) {
                    Ability ability = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, abilityCategory, string);
                    if (ability == null) continue;
                    ability.setFeatType(Ability.Nature.AUTOMATIC);
                }
            }
            if (abilityCategory == AbilityCategory.FEAT) {
                this.addNonAbilityAutoFeats(list);
            }
            this.cachedWeaponProfs = null;
        }
        return list;
    }

    private List<Ability> getStableAggregateFeatList() {
        if (this.isAggregateFeatsStable()) {
            return this.stableAggregateFeatList;
        }
        return null;
    }

    private void setStableVirtualFeatList(List<Ability> list) {
        this.stableVirtualFeatList = list;
        this.setVirtualFeatsStable(list != null);
        if (list == null) {
            this.cachedWeaponProfs = null;
        }
    }

    private List<Ability> getStableVirtualFeatList() {
        if (this.isVirtualFeatsStable()) {
            return this.stableVirtualFeatList;
        }
        return null;
    }

    private void addNonAbilityAutoFeats(List<Ability> list) {
        Object object;
        Object object2;
        Iterator<Object> iterator;
        Object object3;
        if (this.getRace() != null && !PlayerCharacterUtilities.canReassignRacialFeats()) {
            Iterator<Object> iterator2 = new StringTokenizer(this.getRace().getFeatList(this), "|");
            while (((StringTokenizer)((Object)iterator2)).hasMoreTokens()) {
                Ability object4 = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, "FEAT", ((StringTokenizer)((Object)iterator2)).nextToken());
                if (object4 == null) continue;
                object4.setFeatType(Ability.Nature.AUTOMATIC);
            }
            this.addAutoProfsToList(this.getRace().getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
        }
        for (PCClass pCClass : this.getClassList()) {
            object3 = new ArrayList();
            for (int i = 0; i <= pCClass.getLevel(); ++i) {
                for (String string : pCClass.getFeatAutos(i)) {
                    object3.add(string);
                }
            }
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                int n = ((String)object2).indexOf(91);
                if (n >= 0) {
                    object = new StringTokenizer(((String)object2).substring(n + 1), "[]");
                    ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string = ((StringTokenizer)object).nextToken();
                        Logging.debugPrint("Why is the prerequisite '" + string + "' parsed in PlayerCharacter.featAutoList() rather than the persistence layer");
                        try {
                            PreParserFactory preParserFactory = PreParserFactory.getInstance();
                            Prerequisite prerequisite = preParserFactory.parse(string);
                            arrayList.add(prerequisite);
                        }
                        catch (PersistenceLayerException persistenceLayerException) {
                            Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                        }
                    }
                    object2 = ((String)object2).substring(0, n);
                    if (arrayList.size() != 0 && !PrereqHandler.passesAll(arrayList, this, null)) continue;
                }
                if ((object = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, "FEAT", (String)object2)) == null) continue;
                ((Ability)object).setFeatType(Ability.Nature.AUTOMATIC);
            }
            this.addAutoProfsToList(pCClass.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
        }
        if (!PlayerCharacterUtilities.canReassignTemplateFeats() && !this.getTemplateList().isEmpty()) {
            for (PCTemplate pCTemplate : this.getTemplateList()) {
                object3 = pCTemplate.feats(this.getTotalLevels(), this.totalHitDice(), this, false);
                if (!object3.isEmpty()) {
                    iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            object = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, "FEAT", stringTokenizer.nextToken());
                            if (object == null) continue;
                            ((Ability)object).setFeatType(Ability.Nature.AUTOMATIC);
                        }
                    }
                }
                this.addAutoProfsToList(pCTemplate.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
            }
        }
        if (!this.getCharacterDomainList().isEmpty()) {
            for (CharacterDomain characterDomain : this.getCharacterDomainList()) {
                object3 = characterDomain.getDomain();
                if (object3 == null) continue;
                for (int i = 0; i < ((PObject)object3).getAssociatedCount(); ++i) {
                    object2 = ((PObject)object3).getAssociated(i);
                    if (!((String)object2).startsWith("FEAT")) continue;
                    int n = ((String)object2).indexOf(63);
                    if (n > -1) {
                        object = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, "FEAT", ((String)object2).substring(n + 1));
                        if (object == null) continue;
                        ((Ability)object).setFeatType(Ability.Nature.AUTOMATIC);
                        continue;
                    }
                    Logging.errorPrint("no '?' in Domain assocatedList entry: " + (String)object2);
                }
                iterator = ((Domain)object3).getFeatIterator();
                while (iterator.hasNext()) {
                    object2 = (Ability)iterator.next();
                    Ability ability = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(list, "FEAT", ((PObject)object2).getKeyName());
                    if (ability == null) continue;
                    ability.setFeatType(Ability.Nature.AUTOMATIC);
                }
                this.addAutoProfsToList(((PObject)object3).getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
            }
        }
    }

    private void addAutoProfsToList(List<String> list, List<Ability> list2) {
        for (String string : list) {
            this.addWeaponProfToList(list2, string, true);
        }
    }

    public Point2D.Double getFace() {
        Race race = this.getRace();
        Point2D.Double double_ = new Point2D.Double(5.0, 0.0);
        if (race != null) {
            double_ = race.getFace();
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            if (pCTemplate.getFace() == null) continue;
            double_ = pCTemplate.getFace();
        }
        return double_;
    }

    public int getHands() {
        Race race = this.getRace();
        int n = 0;
        if (race != null) {
            n = race.getHands();
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            if (pCTemplate.getHands() == null) continue;
            n = pCTemplate.getHands();
        }
        return n;
    }

    public int getLegs() {
        Race race = this.getRace();
        int n = 0;
        if (race != null) {
            n = race.getLegs();
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            if (pCTemplate.getLegs() == null) continue;
            n = pCTemplate.getLegs();
        }
        return n;
    }

    public int getReach() {
        Race race = this.getRace();
        int n = 0;
        if (race != null) {
            n = race.getReach();
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            if (pCTemplate.getReach() == null) continue;
            n = pCTemplate.getReach();
        }
        return n += (int)this.getTotalBonusTo("COMBAT", "REACH");
    }

    private class CasterLevelSpellBonus {
        private int bonus;
        private String type;

        public CasterLevelSpellBonus(int n, String string) {
            this.bonus = n;
            this.type = string;
        }

        public int getBonus() {
            return this.bonus;
        }

        public String getType() {
            return this.type;
        }

        public void setBonus(int n) {
            this.bonus = n;
        }

        public String toString() {
            return "bonus: " + this.bonus + "    type: " + this.type;
        }
    }
}

