/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

public final class PCStat
extends PObject {
    private String abbreviation = "";
    private String penaltyVar = "";
    private String statMod = "0";
    private int maxValue = 1000;
    private int minValue = 0;
    private int score = 0;
    private boolean rolled = true;

    public void setAbb(String string) {
        this.abbreviation = string.toUpperCase();
        if (this.abbreviation.length() != 3) {
            Logging.errorPrint("Stat with ABB:" + this.abbreviation + " should be 3 characters long!");
        }
    }

    public String getAbb() {
        return this.abbreviation;
    }

    public void setBaseScore(int n) {
        this.score = n;
    }

    public int getBaseScore() {
        return this.score;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setPenaltyVar(String string) {
        this.penaltyVar = string;
    }

    public String getPenaltyVar() {
        return this.penaltyVar;
    }

    public void setStatMod(String string) {
        this.statMod = string;
    }

    public void setStatRange(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        if (stringTokenizer.countTokens() == 2) {
            try {
                this.minValue = Integer.parseInt(stringTokenizer.nextToken());
                this.maxValue = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            Logging.errorPrint("Error in specified Stat range: " + string);
        }
    }

    public void setRolled(boolean bl) {
        this.rolled = bl;
    }

    public boolean isRolled() {
        return this.rolled;
    }

    public PCStat clone() {
        try {
            return (PCStat)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("stat:").append(this.abbreviation).append(' ');
        stringBuffer.append("formula:").append(this.statMod).append(' ');
        stringBuffer.append("score:").append(this.score);
        if (!this.rolled) {
            stringBuffer.append(' ').append("rolled:").append(this.rolled);
        }
        return stringBuffer.toString();
    }

    String getStatMod() {
        return this.statMod;
    }
}

