/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.NameRule;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.gui.NameElement;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Names {
    private static final Names theInstance = new Names();
    private static final String TAB_CHARACTER = "\t";
    private final List<String> ruleDefinitions = new ArrayList<String>();
    private final Map<String, List<String>> allTheSyllablesForEachRule = new HashMap<String, List<String>>();
    private File sourceFile;
    private PlayerCharacter pc = null;

    private Names() {
    }

    public static Names getInstance() {
        return theInstance;
    }

    public static List<NameElement> findAllNamesFiles() {
        return Names.findAllNamesFiles(SettingsHandler.getPcgenSystemDir());
    }

    public static List<NameElement> findAllNamesFiles(File file) {
        File[] fileArray = file.listFiles(new NamFilter());
        ArrayList<NameElement> arrayList = new ArrayList<NameElement>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName().substring(0, fileArray[i].getName().length() - 4);
            arrayList.add(new NameElement(fileArray[i], string));
        }
        File[] fileArray2 = file.listFiles(new DirectoryFilter());
        for (int i = 0; i < fileArray2.length; ++i) {
            arrayList.addAll(Names.findAllNamesFiles(fileArray2[i]));
        }
        return arrayList;
    }

    public String getRandomName() {
        NameRule nameRule = Names.chooseARandomRule(this.buildTheRuleSyllableMapping());
        if (nameRule == null) {
            Logging.errorPrint("Couldn't find a name rule to use.");
            throw new RuntimeException("No random name available. Try again.");
        }
        return this.constructTheName(nameRule);
    }

    public void init(NameElement nameElement, PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.clearAllRules();
        this.parseFile(nameElement.getSource());
    }

    String[] getRuleDefinitions() {
        return this.ruleDefinitions.toArray(new String[this.ruleDefinitions.size()]);
    }

    String[] getSyllablesByName(String string) {
        List<String> list = this.allTheSyllablesForEachRule.get(string);
        return list.toArray(new String[list.size()]);
    }

    private List<NameRule> buildTheRuleSyllableMapping() {
        ArrayList<NameRule> arrayList = new ArrayList<NameRule>();
        String[] stringArray = this.getRuleDefinitions();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                StringTokenizer stringTokenizer = new StringTokenizer(string, TAB_CHARACTER, false);
                NameRule nameRule = new NameRule(Integer.parseInt(stringTokenizer.nextToken()));
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    nameRule.addSyllable(string2);
                }
                arrayList.add(nameRule);
            }
        }
        return arrayList;
    }

    private static NameRule chooseARandomRule(List<NameRule> list) {
        NameRule nameRule = null;
        int n = RollingMethods.roll(1, 100);
        for (NameRule nameRule2 : list) {
            if (n > nameRule2.getChance()) continue;
            nameRule = nameRule2;
            break;
        }
        return nameRule;
    }

    private String getRandomSyllableByName(String string) {
        String[] stringArray = this.getSyllablesByName(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = RollingMethods.roll(1, stringArray.length);
            return stringArray[n - 1];
        }
        return "";
    }

    private void clearAllRules() {
        this.ruleDefinitions.clear();
        this.allTheSyllablesForEachRule.clear();
        this.sourceFile = null;
    }

    private String constructTheName(NameRule nameRule) {
        StringBuffer stringBuffer = new StringBuffer(30);
        String[] stringArray = nameRule.getRuleSyllables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("[{") && stringArray[i].endsWith("}]")) {
                String string = stringArray[i].substring(2, stringArray[i].length() - 2);
                File file = new File(this.sourceFile.getPath() + File.separator + string + ".nam");
                Names names = new Names();
                names.init(new NameElement(file, string), this.pc);
                String string2 = names.getRandomName();
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(this.getRandomSyllableByName(stringArray[i]));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file) {
        String string = "";
        BufferedReader bufferedReader = null;
        int n = 0;
        try {
            String string2 = null;
            boolean bl = true;
            boolean bl2 = false;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                if (string.length() > 0 && string.charAt(0) == '#' || string.startsWith("//") || "".equals(string.trim())) continue;
                if (string.startsWith("[/PRE]")) {
                    bl = true;
                }
                if (string.startsWith("[PRE") && string.indexOf(58) >= 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, string.length() - 1), TAB_CHARACTER, false);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    List<Prerequisite> list = new ArrayList<Prerequisite>();
                    try {
                        PreParserFactory preParserFactory = PreParserFactory.getInstance();
                        list = preParserFactory.parse(arrayList);
                    }
                    catch (PersistenceLayerException persistenceLayerException) {
                        // empty catch block
                    }
                    bl = PrereqHandler.passesAll(list, this.pc, null);
                    continue;
                }
                if (!bl) {
                    if (string.length() <= 0 || string.charAt(0) != '[') continue;
                    System.err.println("Line #" + Integer.toString(n) + " prereqs not met: " + string);
                    continue;
                }
                if (string.startsWith("[RULES]")) {
                    bl2 = true;
                    continue;
                }
                if (string.length() > 0 && string.charAt(0) == '[') {
                    bl2 = false;
                }
                if (bl2) {
                    this.ruleDefinitions.add(string);
                    continue;
                }
                if (string.length() > 0 && string.charAt(0) == '[' && string.endsWith("]")) {
                    string2 = string;
                    this.allTheSyllablesForEachRule.put(string, new ArrayList());
                    continue;
                }
                this.allTheSyllablesForEachRule.get(string2).add(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!"pcgen.ini".equals(file.getName())) {
                Logging.errorPrint("ERROR:" + file.getName() + " error " + string + " Exception type:" + fileNotFoundException.getClass().getName() + " Message:" + fileNotFoundException.getMessage(), fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            if (!"pcgen.ini".equals(file.getName())) {
                Logging.errorPrint("ERROR:" + file.getName() + " error " + string + " Exception type:" + iOException.getClass().getName() + " Message:" + iOException.getMessage(), iOException);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Logging.errorPrint("Couldn't close the reader for " + file.getName(), iOException);
                }
            }
        }
    }

    private static class NamFilter
    implements FilenameFilter {
        private NamFilter() {
        }

        public boolean accept(File file, String string) {
            return string.regionMatches(true, string.length() - 4, ".nam", 0, 4);
        }
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

