/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitStat;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Kit
extends PObject
implements Comparable<Object> {
    private static final int VISIBLE_NO = 0;
    private static final int VISIBLE_YES = 1;
    private static final int VISIBLE_QUALIFIED = 2;
    public static final int APPLY_PERMANENT = 0;
    public static final int APPLY_INSTANT = 1;
    private int kitVisible = 1;
    private final List<BaseKit> theObjects = new ArrayList<BaseKit>();
    private final HashMap<String, LookupTable> lookupTables = new HashMap();
    private List<KitStat> statList = new ArrayList<KitStat>();
    private QualifiedObject<String> buyRate = null;
    private String region = "None";
    private int applyMode = 0;
    private int selectValue = -1;
    private boolean doLevelAbilitiesFlag = true;

    public void addObject(BaseKit baseKit) {
        this.theObjects.add(baseKit);
    }

    public void setBuyRate(String string) {
        this.buyRate = QualifiedObject.createQualifiedObject(string, '[');
    }

    public List<KitStat> getStats() {
        return this.statList;
    }

    public int getApplyMode() {
        return this.applyMode;
    }

    public void setApplyMode(String string) {
        if ("PERMANENT".equals(string)) {
            this.applyMode = 0;
        } else if ("INSTANT".equals(string)) {
            this.applyMode = 1;
        }
    }

    public String getRegion() {
        return this.region;
    }

    public void setSellRate(String string) {
    }

    public void setSelectValue(int n) {
        this.selectValue = n;
    }

    public boolean doLevelAbilities() {
        return this.doLevelAbilitiesFlag;
    }

    public void setDoLevelAbilities(boolean bl) {
        this.doLevelAbilitiesFlag = bl;
    }

    public void addStat(KitStat kitStat) {
        if (kitStat != null) {
            if (this.statList == null) {
                this.statList = new ArrayList<KitStat>();
            }
            this.statList.add(kitStat);
        }
    }

    @Override
    public int compareTo(Object object) {
        Kit kit = (Kit)object;
        return this.getKeyName().compareToIgnoreCase(kit.getKeyName());
    }

    public void processKit(PlayerCharacter playerCharacter, List<BaseKit> list) {
        this.processKit(playerCharacter, list, -1);
    }

    public void processKit(PlayerCharacter playerCharacter, List<BaseKit> list, int n) {
        for (KitStat baseKit : this.statList) {
            baseKit.apply(playerCharacter);
        }
        for (BaseKit baseKit : list) {
            baseKit.apply(playerCharacter);
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        if (characterInfo != null) {
            characterInfo.setPaneForUpdate(characterInfo.infoInventory());
            characterInfo.refresh();
        }
        if (this.applyMode == 0) {
            playerCharacter.addKit(this);
        }
    }

    public int getBuyRate(PlayerCharacter playerCharacter) {
        int n = SettingsHandler.getGearTab_BuyRate();
        QualifiedObject<String> qualifiedObject = this.buyRate;
        if (qualifiedObject != null && qualifiedObject.qualifies(playerCharacter)) {
            n = playerCharacter.getVariableValue(qualifiedObject.getObject(playerCharacter), "").intValue();
        }
        return n;
    }

    public final boolean isVisible(PlayerCharacter playerCharacter) {
        if (this.kitVisible == 2) {
            List<Prerequisite> list = this.getPreReqList();
            return PrereqHandler.passesAll(list, playerCharacter, this);
        }
        return this.kitVisible == 1;
    }

    public final void setVisible(String string) {
        this.kitVisible = string.length() > 0 && string.charAt(0) == 'Y' ? 1 : (string.length() > 0 && string.charAt(0) == 'Q' ? 2 : 0);
    }

    public void testApplyKit(PlayerCharacter playerCharacter, List<BaseKit> list, List<String> list2) {
        PlayerCharacter playerCharacter2 = (PlayerCharacter)playerCharacter.clone();
        for (KitStat baseKit : this.statList) {
            baseKit.testApply(this, playerCharacter2, list2);
        }
        for (BaseKit baseKit : this.theObjects) {
            if (!PrereqHandler.passesAll(baseKit.getPrereqs(), playerCharacter2, this)) continue;
            BaseKit baseKit2 = baseKit.clone();
            if (this.selectValue != -1 && !baseKit2.isOption(playerCharacter2, this.selectValue) || !baseKit2.testApply(this, playerCharacter2, list2)) continue;
            list.add(baseKit2);
        }
    }

    public String getInfo(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append("<html>");
        stringBuffer.append("<b>").append(this.getDisplayName()).append("</b> - ");
        String string = this.getPreReqHTMLStrings(playerCharacter);
        if (string.length() != 0) {
            stringBuffer.append("  <b>Requirements</b>: ").append(string);
        }
        ArrayList<BaseKit> arrayList = new ArrayList<BaseKit>();
        arrayList.addAll(this.theObjects);
        Collections.sort(arrayList, new ObjectTypeComparator());
        String string2 = "";
        for (BaseKit baseKit : arrayList) {
            String string3 = baseKit.getObjectName();
            if (!string3.equals(string2)) {
                if (!"".equals(string2)) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append("  <b>" + string3 + "</b>: ");
                string2 = string3;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(baseKit.toString());
        }
        stringBuffer.append("  <b>Source</b>: ").append(this.getDefaultSourceString());
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private String getPreReqHTMLStrings(PlayerCharacter playerCharacter) {
        return PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, this, this.getPreReqList(), false);
    }

    public void addLookupTable(String string) {
        this.lookupTables.put(string, new LookupTable());
    }

    public void addLookupValue(String string, String string2, String string3, String string4) {
        LookupTable lookupTable = this.lookupTables.get(string);
        lookupTable.addEntry(string2, string3, string4);
    }

    public String getTableValue(PlayerCharacter playerCharacter, String string, String string2) {
        LookupTable lookupTable = this.lookupTables.get(string);
        if (lookupTable == null) {
            return "";
        }
        int n = playerCharacter.getVariableValue(string2, Math.random() + "").intValue();
        return lookupTable.getEntry(playerCharacter, n);
    }

    public String lookup(PlayerCharacter playerCharacter, String string) {
        int n = string.indexOf(",");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        String string4 = this.getTableValue(playerCharacter, string2, string3);
        return string4;
    }

    public static void applyKit(Kit kit, PlayerCharacter playerCharacter) {
        if (kit == null) {
            return;
        }
        if (kit.getApplyMode() == 0 && playerCharacter.getKitInfo().contains(kit)) {
            return;
        }
        ArrayList<BaseKit> arrayList = new ArrayList<BaseKit>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        kit.testApplyKit(playerCharacter, arrayList, arrayList2);
        kit.processKit(playerCharacter, arrayList, 0);
    }

    class LookupTable {
        ArrayList<TableEntry> values = new ArrayList();

        public void addEntry(String string, String string2, String string3) {
            this.values.add(new TableEntry(string, string2, string3));
        }

        public String getEntry(PlayerCharacter playerCharacter, int n) {
            for (TableEntry tableEntry : this.values) {
                if (!tableEntry.isIn(playerCharacter, n)) continue;
                return tableEntry.getValue();
            }
            return "";
        }

        class TableEntry {
            private String value = "";
            private String lowValue = "-2147483648";
            private String highValue = "2147483647";

            public TableEntry(String string, String string2, String string3) {
                this.value = string;
                this.lowValue = string2;
                this.highValue = string3;
            }

            public boolean isIn(PlayerCharacter playerCharacter, int n) {
                int n2 = playerCharacter.getVariableValue(this.lowValue, "").intValue();
                int n3 = playerCharacter.getVariableValue(this.highValue, "").intValue();
                return n >= n2 && n <= n3;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectTypeComparator
    implements Comparator<BaseKit> {
        private ObjectTypeComparator() {
        }

        @Override
        public int compare(BaseKit baseKit, BaseKit baseKit2) {
            String string = baseKit.getObjectName();
            String string2 = baseKit2.getObjectName();
            return string.compareTo(string2);
        }
    }
}

