/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Delta;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentList {
    private static boolean autoGeneration = false;
    private static TreeMap<String, EquipmentModifier> modifierList = new TreeMap();
    private static TreeMap<String, Equipment> equipmentNameMap = new TreeMap();
    private static TreeMap<String, Equipment> equipmentKeyMap = new TreeMap();

    private EquipmentList() {
    }

    public static void clearEquipmentMap() {
        equipmentNameMap.clear();
        equipmentKeyMap.clear();
    }

    protected static void clearModifierList() {
        modifierList.clear();
    }

    private static boolean isAutoGeneration() {
        return autoGeneration;
    }

    public static void addEquipmentModifier(EquipmentModifier equipmentModifier) {
        modifierList.put(equipmentModifier.getKeyName(), equipmentModifier);
    }

    public static void removeEquipmentModifier(EquipmentModifier equipmentModifier) {
        modifierList.remove(equipmentModifier.getKeyName());
    }

    public static Collection<EquipmentModifier> getModifierCollection() {
        return modifierList.values();
    }

    public static void setAutoGeneration(boolean bl) {
        autoGeneration = bl;
    }

    public static void setEquipmentMap(TreeMap<String, Equipment> treeMap) {
        equipmentNameMap = treeMap;
    }

    public static Equipment getEquipmentFromName(String string, PlayerCharacter playerCharacter) {
        Equipment equipment;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string2 = string;
        int n = string2.indexOf(40);
        if (n >= 0) {
            object = new StringTokenizer(string2.substring(n + 1), "/)", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                int n2;
                String string3 = ((StringTokenizer)object).nextToken();
                for (n2 = 0; n2 <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1 && !string3.equalsIgnoreCase(SettingsHandler.getGame().getSizeAdjustmentAtIndex(n2).getAbbreviation()); ++n2) {
                }
                if (n2 <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) {
                    arrayList3.add(string3);
                    continue;
                }
                if ("Mighty Composite".equalsIgnoreCase(string3)) {
                    arrayList.add("Mighty");
                    arrayList.add("Composite");
                    continue;
                }
                arrayList.add(string3);
            }
            string2 = string2.substring(0, n).trim();
        }
        if (n >= 0) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                object = (String)arrayList.get(n);
                if (EquipmentList.getModifierNamed((String)object) != null) continue;
                arrayList2.add(0, (String)object);
                arrayList.remove(n);
            }
        }
        object = null;
        int n3 = 0;
        n = string2.indexOf(43);
        if (n >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n), "/", false);
            n3 = stringTokenizer.countTokens();
            object = new int[n3];
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                object[n4++] = Delta.decode(string4);
            }
            string2 = string2.substring(0, n).trim();
            if (n3 > 0) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string5 = (String)arrayList2.get(i);
                    if (!"Mighty".equalsIgnoreCase(string5)) continue;
                    string5 = Delta.toString((int)object[n3 - 1]) + " " + string5;
                    arrayList2.set(i, string5);
                    --n3;
                }
            }
        }
        String string6 = "";
        String string7 = "";
        while (true) {
            String string8;
            if ((equipment = EquipmentList.findEquipment(string8 = string2 + string7, null, arrayList2, arrayList3, string6)) != null) {
                if (arrayList3.size() <= 1) break;
                arrayList3.remove(0);
                break;
            }
            equipment = EquipmentList.findEquipment(string8, arrayList2, null, arrayList3, string6);
            if (equipment != null) {
                if (arrayList3.size() <= 1) break;
                arrayList3.remove(0);
                break;
            }
            equipment = EquipmentList.findEquipment(string8, arrayList2, null, null, string6);
            if (equipment != null) break;
            if (arrayList3.size() == 1) {
                equipment = EquipmentList.findEquipment(string8, arrayList3, arrayList2, null, string6);
                if (equipment == null) {
                    equipment = EquipmentList.findEquipment(string8, arrayList2, arrayList3, null, string6);
                }
                if (equipment != null) {
                    arrayList3.clear();
                    break;
                }
            }
            if (string.indexOf("Thrown") >= 0 && string6.length() == 0) {
                string6 = "Thrown";
                continue;
            }
            if (n3 <= 0 || object == null || string7.length() != 0) break;
            string6 = "";
            string7 = " " + Delta.toString((int)object[0]);
        }
        if (equipment != null) {
            boolean bl = false;
            boolean bl2 = false;
            equipment = equipment.clone();
            for (String string9 : arrayList) {
                EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed(string9, equipment);
                if (equipmentModifier != null) {
                    equipment.addEqModifier(equipmentModifier, true, playerCharacter);
                    if (!equipmentModifier.getAssignToAll() || !equipment.isDouble()) continue;
                    equipment.addEqModifier(equipmentModifier, false, playerCharacter);
                    bl = true;
                    continue;
                }
                Logging.errorPrint("Could not find a qualified modifier named: " + string9 + " for " + equipment.getName() + ":" + equipment.typeList());
                bl2 = true;
            }
            if (bl2) {
                return null;
            }
            if (arrayList3.size() != 0) {
                equipment.resizeItem(playerCharacter, (String)arrayList3.get(0));
                bl = true;
                if (arrayList3.size() > 1) {
                    Logging.errorPrint("Too many sizes in item name, used only 1st of: " + arrayList3);
                }
            }
            if (bl) {
                equipment.nameItemFromModifiers(playerCharacter);
                if (!EquipmentList.addEquipment(equipment)) {
                    equipment = EquipmentList.getEquipmentNamed(equipment.getName());
                }
            }
        }
        return equipment;
    }

    public static Equipment getEquipmentKeyed(String string) {
        return equipmentKeyMap.get(string);
    }

    public static Equipment getEquipmentKeyedNoCustom(String string) {
        Equipment equipment = EquipmentList.getEquipmentKeyed(string);
        if (equipment == null) {
            return null;
        }
        if (equipment.isType("CUSTOM")) {
            return null;
        }
        return equipment;
    }

    public static Collection<Equipment> getEquipmentList() {
        return equipmentNameMap.values();
    }

    public static Iterator<Map.Entry<String, Equipment>> getEquipmentListIterator() {
        return equipmentKeyMap.entrySet().iterator();
    }

    public static Equipment getEquipmentNamed(String string) {
        return equipmentNameMap.get(string);
    }

    public static Equipment getEquipmentNamed(String string, List<Equipment> list) {
        for (Equipment equipment : list) {
            if (!equipment.getName().equalsIgnoreCase(string)) continue;
            return equipment;
        }
        return null;
    }

    public static List<Equipment> getEquipmentOfType(Iterator<Map.Entry<String, Equipment>> iterator, String string, String string2) {
        List<String> list = CoreUtility.split(string, '.');
        List<String> list2 = CoreUtility.split(string2, '.');
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(100);
        if (list.size() != 0) {
            while (iterator.hasNext()) {
                Equipment equipment = iterator.next().getValue();
                boolean bl = true;
                for (String string3 : list) {
                    if (equipment.isType(string3)) continue;
                    bl = false;
                    break;
                }
                if (bl && list2.size() != 0) {
                    for (String string3 : list2) {
                        if (!equipment.isType(string3)) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                arrayList.add(equipment);
            }
        }
        return arrayList;
    }

    public static List<Equipment> getEquipmentOfType(String string, String string2) {
        return EquipmentList.getEquipmentOfType(equipmentNameMap.entrySet().iterator(), string, string2);
    }

    public static EquipmentModifier getModifierKeyed(String string) {
        return modifierList.get(string);
    }

    public static boolean addEquipment(Equipment equipment) {
        if (EquipmentList.getEquipmentKeyed(equipment.getKeyName()) != null) {
            return false;
        }
        Equipment.getEquipmentTypes().addAll(equipment.typeList());
        equipmentNameMap.put(equipment.getName(), equipment);
        equipmentKeyMap.put(equipment.getKeyName(), equipment);
        return true;
    }

    public static void autoGenerateEquipment() {
        EquipmentList.setAutoGeneration(true);
        EquipmentList.autogenerateRacialEquipment();
        EquipmentList.autogenerateMasterWorkEquipment();
        EquipmentList.autogenerateMagicEquipment();
        EquipmentList.autogenerateExoticMaterialsEquipment();
        EquipmentList.setAutoGeneration(false);
    }

    private static void autogenerateExoticMaterialsEquipment() {
        if (SettingsHandler.isAutogenExoticMaterial()) {
            HashSet<Map.Entry<String, Equipment>> hashSet = new HashSet<Map.Entry<String, Equipment>>(equipmentNameMap.entrySet());
            for (Map.Entry entry : hashSet) {
                Equipment equipment = (Equipment)entry.getValue();
                if (equipment.isMagic() || equipment.isUnarmed() || equipment.isMasterwork() || !equipment.isAmmunition() && !equipment.isArmor() && !equipment.isShield() && !equipment.isWeapon()) continue;
                EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed("Darkwood", equipment);
                EquipmentModifier equipmentModifier2 = EquipmentList.getQualifiedModifierNamed("Adamantine", equipment);
                EquipmentModifier equipmentModifier3 = EquipmentList.getQualifiedModifierNamed("Mithral", equipment);
                EquipmentList.createItem(equipment, equipmentModifier, null, null, null);
                EquipmentList.createItem(equipment, equipmentModifier2, null, null, null);
                EquipmentList.createItem(equipment, equipmentModifier3, null, null, null);
            }
        }
    }

    private static void autogenerateMagicEquipment() {
        if (SettingsHandler.isAutogenMagic()) {
            for (int i = 1; i <= 5; ++i) {
                String string = Delta.toString(i);
                HashSet<Map.Entry<String, Equipment>> hashSet = new HashSet<Map.Entry<String, Equipment>>(equipmentNameMap.entrySet());
                for (Map.Entry entry : hashSet) {
                    Equipment equipment = (Equipment)entry.getValue();
                    if (equipment.isMagic() || equipment.isMasterwork() || !equipment.isAmmunition() && !equipment.isArmor() && !equipment.isShield() && !equipment.isWeapon()) continue;
                    EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed("Masterwork", equipment);
                    if (equipmentModifier == null) {
                        Logging.debugPrint("Could not generate a Masterwork " + equipment.toString() + " as the equipment modifier could not be found.");
                        continue;
                    }
                    EquipmentChoice equipmentChoice = equipmentModifier.buildEquipmentChoice(0, equipment, false, false, 0);
                    EquipmentChoice.EquipChoiceIterator equipChoiceIterator = equipmentChoice.getChoiceIterator(true);
                    while (equipChoiceIterator.hasNext()) {
                        String string2 = (String)equipChoiceIterator.next();
                        equipment = equipment.clone();
                        equipment.addEqModifier(equipmentModifier, true, null, string2, equipmentChoice);
                        if (equipment.isWeapon() && equipment.isDouble()) {
                            equipment.addEqModifier(equipmentModifier, false, null, string2, equipmentChoice);
                        }
                        if ((equipmentModifier = EquipmentList.getQualifiedModifierNamed(string, equipment)) == null) {
                            Logging.debugPrint("Could not generate a " + string + " " + equipment.toString() + " as the equipment modifier could not be found.");
                            continue;
                        }
                        EquipmentList.createItem(equipment, equipmentModifier, null, null, null);
                    }
                }
            }
        }
    }

    private static void autogenerateMasterWorkEquipment() {
        if (SettingsHandler.isAutogenMasterwork()) {
            HashSet<Map.Entry<String, Equipment>> hashSet = new HashSet<Map.Entry<String, Equipment>>(equipmentNameMap.entrySet());
            for (Map.Entry entry : hashSet) {
                Equipment equipment = (Equipment)entry.getValue();
                if (equipment.isMagic() || equipment.isUnarmed() || equipment.isMasterwork() || !equipment.isAmmunition() && !equipment.isArmor() && !equipment.isShield() && !equipment.isWeapon()) continue;
                EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed("Masterwork", equipment);
                EquipmentChoice equipmentChoice = equipmentModifier.buildEquipmentChoice(0, equipment, false, false, 0);
                EquipmentChoice.EquipChoiceIterator equipChoiceIterator = equipmentChoice.getChoiceIterator(true);
                while (equipChoiceIterator.hasNext()) {
                    String string = (String)equipChoiceIterator.next();
                    EquipmentList.createItem(equipment, equipmentModifier, null, string, equipmentChoice);
                }
            }
        }
    }

    private static void autogenerateRacialEquipment() {
        if (SettingsHandler.isAutogenRacial()) {
            int[] nArray = new int[10];
            for (Race cloneable2 : Globals.getAllRaces()) {
                int iterator;
                int n = iterator = Globals.sizeInt(cloneable2.getSize());
                nArray[n] = nArray[n] | 1;
            }
            int n = -1;
            HashSet<Map.Entry<String, Equipment>> hashSet = new HashSet<Map.Entry<String, Equipment>>(equipmentNameMap.entrySet());
            for (Map.Entry entry : hashSet) {
                Equipment equipment = (Equipment)entry.getValue();
                if (equipment.isMagic() || equipment.isUnarmed() || equipment.isMasterwork() || !equipment.isArmor() && !equipment.isShield() && !equipment.isType("RESIZABLE")) continue;
                for (int i = 0; i <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1; ++i) {
                    SizeAdjustment sizeAdjustment;
                    if (n == -1 && (sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(i)).isDefaultSize()) {
                        n = i;
                    }
                    if (i == n || (nArray[i] & 1) == 0) continue;
                    EquipmentList.createItem(equipment, i, null);
                }
            }
        }
    }

    static EquipmentModifier getQualifiedModifierNamed(String string, List<String> list) {
        for (EquipmentModifier equipmentModifier : EquipmentList.getModifierCollection()) {
            if (!equipmentModifier.getDisplayName().equals(string)) continue;
            if (equipmentModifier.isType("All")) {
                return equipmentModifier;
            }
            for (String string2 : list) {
                if (!equipmentModifier.isType(string2)) continue;
                return equipmentModifier;
            }
        }
        return null;
    }

    private static EquipmentModifier getModifierNamed(String string) {
        for (EquipmentModifier equipmentModifier : EquipmentList.getModifierCollection()) {
            if (!equipmentModifier.getDisplayName().equals(string)) continue;
            return equipmentModifier;
        }
        return null;
    }

    private static EquipmentModifier getQualifiedModifierNamed(String string, Equipment equipment) {
        for (EquipmentModifier equipmentModifier : EquipmentList.getModifierCollection()) {
            if (!equipmentModifier.getDisplayName().startsWith(string)) continue;
            for (String string2 : equipment.typeList()) {
                if (!equipmentModifier.isType(string2) || !equipmentModifier.passesPreReqToGain(equipment, null)) continue;
                return equipmentModifier;
            }
        }
        return null;
    }

    private static void appendNameParts(List<String> list, String string, StringBuffer stringBuffer) {
        for (String string2 : list) {
            if (string.length() != 0 && string2.equals(string)) continue;
            if (stringBuffer.length() > 2) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string2);
        }
    }

    private static void createItem(Equipment equipment, int n, PlayerCharacter playerCharacter) {
        EquipmentList.createItem(equipment, null, n, playerCharacter, "", null);
    }

    private static void createItem(Equipment equipment, EquipmentModifier equipmentModifier, PlayerCharacter playerCharacter, String string, EquipmentChoice equipmentChoice) {
        EquipmentList.createItem(equipment, equipmentModifier, -1, playerCharacter, string, equipmentChoice);
    }

    private static void createItem(Equipment equipment, EquipmentModifier equipmentModifier, int n, PlayerCharacter playerCharacter, String string, EquipmentChoice equipmentChoice) {
        if (equipment == null) {
            return;
        }
        try {
            String string2;
            Equipment equipment2;
            if (!equipment.getModifiersAllowed() || equipment.isArmor() && equipment.getACMod(playerCharacter) == 0 && equipmentModifier != null && !equipmentModifier.getDisplayName().equalsIgnoreCase("MASTERWORK")) {
                return;
            }
            if ((equipment = equipment.clone()) == null) {
                Logging.errorPrint("could not clone item");
                return;
            }
            if (equipmentModifier != null) {
                equipment.addEqModifier(equipmentModifier, true, playerCharacter, string, equipmentChoice);
                if (equipment.isWeapon() && equipment.isDouble()) {
                    equipment.addEqModifier(equipmentModifier, false, playerCharacter, string, equipmentChoice);
                }
            }
            if (n >= 0 && n <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) {
                equipment.resizeItem(playerCharacter, SettingsHandler.getGame().getSizeAdjustmentAtIndex(n).getDisplayName());
            }
            if ((equipment2 = EquipmentList.getEquipmentKeyed(string2 = equipment.nameItemFromModifiers(playerCharacter))) != null) {
                return;
            }
            String string3 = EquipmentList.isAutoGeneration() ? "AUTO_GEN" : "CUSTOM";
            if (!equipment.isType(string3)) {
                equipment.addMyType(string3);
            }
            Equipment.getEquipmentTypes().addAll(equipment.typeList());
            EquipmentList.addEquipment(equipment);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("createItem: exception: " + equipment.getName());
        }
    }

    private static Equipment findEquipment(String string, List<String> list, List<String> list2, List<String> list3, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(" (");
        if (list != null) {
            object = list;
            EquipmentList.appendNameParts(object, string2, stringBuffer);
        }
        if (list3 != null && list3.size() > 1) {
            stringBuffer.append(list3.get(0));
        }
        if (list2 != null) {
            EquipmentList.appendNameParts(list2, string2, stringBuffer);
        }
        if (stringBuffer.length() == 2) {
            stringBuffer.setLength(0);
        } else {
            stringBuffer.append(')');
        }
        object = EquipmentList.getEquipmentKeyed(string + stringBuffer);
        return object;
    }

    public static int size() {
        return equipmentKeyMap.size();
    }

    public static void remove(Equipment equipment) {
        if (equipment == null) {
            return;
        }
        equipmentKeyMap.remove(equipment.getKeyName());
        equipmentNameMap.remove(equipment.getName());
    }
}

