/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.core.AbilityInfo;
import pcgen.core.AbilityStore;
import pcgen.core.Categorisable;
import pcgen.core.CharacterDomain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Domain
extends PObject {
    private AbilityStore abilityStore = new AbilityStore();
    private boolean isLocked;

    public void addFeat(String string) {
        this.abilityStore.addAbilityInfo(string, "FEAT", "|,", true, false);
    }

    public void setIsLocked(boolean bl, PlayerCharacter playerCharacter) {
        if (this.isLocked == bl) {
            return;
        }
        this.isLocked = bl;
        if (bl) {
            List<Spell> list;
            PlayerCharacter playerCharacter2 = playerCharacter;
            CharacterDomain characterDomain = playerCharacter2.getCharacterDomainForDomain(this.keyName);
            PCClass pCClass = null;
            if (characterDomain != null && characterDomain.isFromPCClass() && (pCClass = playerCharacter2.getClassKeyed(characterDomain.getObjectName())) != null) {
                int n;
                for (n = 0; n < 10 && pCClass.getCastForLevel(n, playerCharacter2) != 0; ++n) {
                }
                if (n > 0) {
                    this.addSpellsToClassForLevels(pCClass, 0, n - 1);
                }
                if (n > 1 && pCClass.getKnownSpellsFromSpecialty() == 0) {
                    list = Globals.getSpellsIn(-1, "", this.keyName);
                    for (Spell spell : list) {
                        if (spell.levelForKey("DOMAIN", this.keyName, playerCharacter2) >= n || pCClass.getKnownSpellsFromSpecialty() != 0) continue;
                        pCClass.setKnownSpellsFromSpecialty(1);
                        break;
                    }
                }
            }
            List<PCSpell> list2 = this.getSpellList();
            if (pCClass != null && list2 != null && !list2.isEmpty()) {
                list = list2.iterator();
                while (list.hasNext()) {
                    List<CharacterSpell> list3;
                    Spell spell;
                    PCSpell pCSpell = (PCSpell)list.next();
                    spell = Globals.getSpellKeyed(pCSpell.getKeyName());
                    if (spell == null) {
                        return;
                    }
                    int n = Integer.parseInt(pCSpell.getTimesPerDay());
                    String string = pCSpell.getSpellbook();
                    if (!PrereqHandler.passesAll(pCSpell.getPreReqList(), playerCharacter2, this) || !(list3 = pCClass.getSpellSupport().getCharacterSpell(spell, string, -1)).isEmpty()) continue;
                    CharacterSpell characterSpell = new CharacterSpell(this, spell);
                    characterSpell.addInfo(1, n, string);
                    pCClass.getSpellSupport().addCharacterSpell(characterSpell);
                }
            }
            if (((String)((Object)(list = this.getChoiceString()))).length() > 0 && !playerCharacter2.isImporting() && !((String)((Object)list)).startsWith("FEAT|")) {
                ChooserUtilities.modChoices(this, new ArrayList(), new ArrayList(), true, playerCharacter2, true, null);
            }
            if (!playerCharacter2.isImporting()) {
                this.globalChecks(playerCharacter2);
                this.activateBonuses(playerCharacter2);
            }
        }
    }

    @Override
    public String getSpellKey() {
        return "DOMAIN|" + this.keyName;
    }

    @Override
    public Domain clone() {
        Domain domain = null;
        try {
            domain = (Domain)super.clone();
            domain.abilityStore = new AbilityStore();
            Iterator<Categorisable> iterator = this.abilityStore.getKeyIterator("ALL");
            while (iterator.hasNext()) {
                Categorisable categorisable = iterator.next();
                domain.addFeat("CATEGORY=" + categorisable.getCategory() + "|" + categorisable.getKeyName());
            }
            domain.isLocked = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return domain;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            return ((Domain)object).getKeyName().equals(this.getKeyName());
        }
        return false;
    }

    public int hashCode() {
        int n = this.getKeyName() != null ? this.getKeyName().hashCode() : 0;
        return n;
    }

    public boolean qualifiesForDomain(PlayerCharacter playerCharacter) {
        return PrereqHandler.passesAll(this.getPreReqList(), playerCharacter, this);
    }

    public Iterator<Categorisable> getFeatIterator() {
        return this.abilityStore.getNameIterator("FEAT");
    }

    public int getNumberOfFeats() {
        return this.abilityStore.getUnmodifiableList("FEAT").size();
    }

    void addSpellsToClassForLevels(PCClass pCClass, int n, int n2) {
        if (pCClass == null) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            List<Spell> list = Globals.getSpellsIn(i, "", this.keyName);
            for (Spell spell : list) {
                CharacterSpell characterSpell;
                List<CharacterSpell> list2 = pCClass.getSpellSupport().getCharacterSpell(spell, Globals.getDefaultSpellBook(), i);
                boolean bl = true;
                Object object = list2.iterator();
                while (object.hasNext() && (bl = !(characterSpell = object.next()).getOwner().equals(this))) {
                }
                if (!bl) continue;
                object = new CharacterSpell(this, spell);
                ((CharacterSpell)object).addInfo(i, 1, Globals.getDefaultSpellBook());
                pCClass.getSpellSupport().addCharacterSpell((CharacterSpell)object);
            }
        }
    }

    @Override
    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(super.getPCCText(true));
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator<Categorisable> iterator = this.getFeatIterator();
        while (iterator.hasNext()) {
            AbilityInfo abilityInfo = (AbilityInfo)iterator.next();
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append("|");
            }
            stringBuffer2.append(abilityInfo.getKeyName());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append('\t').append("FEAT:").append(stringBuffer2);
        }
        return stringBuffer.toString();
    }
}

