/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.StatList;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportHandler;
import pcgen.util.enumeration.AttackType;

public class PlayerCharacterOutput {
    private PlayerCharacter pc;

    public PlayerCharacterOutput(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        Globals.setCurrentPC(playerCharacter);
    }

    public String getAC() {
        return Integer.toString(this.pc.getACTotal());
    }

    public String getACFlatFooted() {
        return Integer.toString(this.pc.flatfootedAC());
    }

    public String getACTouch() {
        return Integer.toString(this.pc.touchAC());
    }

    public String getAlignmentLong() {
        return SettingsHandler.getGame().getLongAlignmentAtIndex(this.pc.getAlignment());
    }

    public String getAlignmentShort() {
        return SettingsHandler.getGame().getShortAlignmentAtIndex(this.pc.getAlignment());
    }

    public String getBAB() {
        return Integer.toString(this.pc.baseAttackBonus());
    }

    public String getCR() {
        return Integer.toString(this.pc.calcCR());
    }

    public String getClasses() {
        StringBuffer stringBuffer = new StringBuffer();
        for (PCClass pCClass : this.pc.getClassList()) {
            stringBuffer.append(pCClass.getDisplayName() + pCClass.getLevel() + " ");
        }
        return stringBuffer.toString();
    }

    public String getRaceType() {
        return this.pc.getRaceType();
    }

    public String getDeity() {
        Deity deity = this.pc.getDeity();
        if (deity != null) {
            return deity.getOutputName();
        }
        return null;
    }

    public String getDomainName(Domain domain) {
        return domain.getDisplayName();
    }

    public String getDomainPower(PlayerCharacter playerCharacter, Domain domain) {
        return domain.piDescString(playerCharacter);
    }

    public String getEquipmentList() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Equipment equipment : this.pc.getEquipmentListInOutputOrder()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(1);
            decimalFormat.setMinimumFractionDigits(0);
            stringBuffer.append(decimalFormat.format(equipment.getQty()) + " " + equipment.getName());
        }
        return stringBuffer.toString();
    }

    public String getExportToken(String string) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            ExportHandler exportHandler = new ExportHandler(new File(""));
            exportHandler.replaceTokenSkipMath(this.pc, string, bufferedWriter);
            stringWriter.flush();
            try {
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringWriter.toString();
        }
        catch (Exception exception) {
            System.out.println("Failure fetching token: " + string);
            return "";
        }
    }

    public String getFeatList() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Ability ability : this.pc.getRealFeatList()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(ability.qualifiedName());
        }
        return stringBuffer.toString();
    }

    public String getGender() {
        return this.pc.getGender();
    }

    public String getHitDice() {
        return this.getExportToken("HITDICE");
    }

    public String getHitPoints() {
        return Integer.toString(this.pc.hitPoints());
    }

    public String getInitMiscMod() {
        StatList statList = this.pc.getStatList();
        int n = statList.getStatModFor("DEX");
        int n2 = this.pc.initiativeMod() - n;
        return "+" + n2;
    }

    public String getInitStatMod() {
        StatList statList = this.pc.getStatList();
        int n = statList.getStatModFor("DEX");
        return "+" + n;
    }

    public String getInitTotal() {
        return "+" + this.pc.initiativeMod();
    }

    public String getMeleeTotal() {
        int n = (int)this.pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)this.pc.getTotalBonusTo("TOHIT", "TYPE.MELEE") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT.MELEE");
        return this.pc.getAttackString(AttackType.MELEE, n);
    }

    public String getName() {
        return this.pc.getName();
    }

    public String getRaceName() {
        return this.pc.getRace().getDisplayName();
    }

    public String getRangedTotal() {
        int n = (int)this.pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)this.pc.getTotalBonusTo("TOHIT", "TYPE.RANGED") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT.RANGED");
        return this.pc.getAttackString(AttackType.MELEE, n);
    }

    public String getRegion() {
        return this.pc.getRegion();
    }

    public String getSaveFort() {
        return "+" + this.pc.getTotalCheck(0);
    }

    public String getSaveRef() {
        return "+" + this.pc.getTotalCheck(1);
    }

    public String getSaveWill() {
        return "+" + this.pc.getTotalCheck(2);
    }

    public String getSize() {
        return this.pc.getSize();
    }

    public String getSpecialAbilities() {
        return CoreUtility.join(this.pc.getSpecialAbilityTimesList(), ", ");
    }

    public String getSpeed() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.pc.getNumberOfMovements(); ++i) {
            stringBuffer.append(this.pc.getMovementType(i) + " " + Globals.getGameModeUnitSet().convertDistanceToUnitSet(this.pc.movement(i)) + Globals.getGameModeUnitSet().getDistanceUnit());
        }
        return stringBuffer.toString();
    }

    public String getStat(String string) {
        StatList statList = this.pc.getStatList();
        return Integer.toString(statList.getTotalStatFor(string));
    }

    public StatList getStatList() {
        return this.pc.getStatList();
    }

    public String getStatMod(String string) {
        StatList statList = this.pc.getStatList();
        int n = statList.getStatModFor(string);
        return n < 0 ? Integer.toString(n) : "+" + n;
    }

    public String getVision() {
        return this.pc.getVision();
    }

    public String getWeaponToken(int n, String string) {
        return this.getExportToken("WEAPON." + n + "." + string);
    }

    public String getWeaponCritMult(int n) {
        return this.getWeaponToken(n, "MULT");
    }

    public String getWeaponCritRange(int n) {
        return this.getWeaponToken(n, "CRIT");
    }

    public String getWeaponDamage(int n) {
        return this.getWeaponToken(n, "DAMAGE");
    }

    public String getWeaponHand(Equipment equipment) {
        int n;
        String string = Equipment.getLocationName(equipment.getLocation());
        int n2 = string.indexOf(40) + 1;
        if (n2 > 0 && (n = string.indexOf(41, n2)) > 0) {
            string = string.substring(n2, n);
        }
        return string;
    }

    public String getWeaponName(Equipment equipment) {
        return equipment.getOutputName() + equipment.getAppliedName();
    }

    public String getWeaponRange(Equipment equipment) {
        return equipment.getRange(this.pc).toString() + Globals.getGameModeUnitSet().getDistanceUnit();
    }

    public String getWeaponSize(Equipment equipment) {
        return equipment.getSize();
    }

    public String getWeaponSpecialProperties(Equipment equipment) {
        return equipment.getSpecialProperties(this.pc);
    }

    public String getWeaponToHit(int n) {
        return this.getWeaponToken(n, "TOTALHIT");
    }

    public String getWeaponType(Equipment equipment) {
        String string = this.getWeaponType(equipment, true);
        if (equipment.isDouble()) {
            string = string + '/' + this.getWeaponType(equipment, false);
        }
        return string;
    }

    public String getWeaponType(Equipment equipment, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(SettingsHandler.getGame().getWeaponTypes(), "|", false);
        while (stringTokenizer.countTokens() >= 2) {
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            if (!equipment.isType(string, true)) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getUnarmedAttack() {
        return this.getExportToken("WEAPONH.TOTALHIT");
    }

    public String getUnarmedDamage() {
        return this.getExportToken("WEAPONH.DAMAGE");
    }

    public String getUnarmedCritRange() {
        return this.getExportToken("WEAPONH.CRIT");
    }

    public String getUnarmedCritMult() {
        return this.getExportToken("WEAPONH.MULT");
    }
}

