/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.Dice;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderComperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import pcgen.core.SettingsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitHolderList
extends ArrayList<InitHolder> {
    public int getMaxInit() {
        int n = 20;
        for (InitHolder initHolder : this) {
            int n2 = initHolder.getInitiative().getCurrentInitiative();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public Vector<String> getRowVector(int n, List<String> list) {
        return ((InitHolder)this.get(n)).getRowVector(list);
    }

    public String getUniqueName(String string) {
        int n = 1;
        String string2 = string;
        while (!this.isUniqueName(string2)) {
            string2 = string2.replaceAll(" \\(\\d.*\\)", "") + " (" + n + ")";
            ++n;
        }
        return string2;
    }

    public boolean isUniqueName(String string) {
        for (InitHolder initHolder : this) {
            if (!initHolder.getName().equals(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(InitHolder initHolder) {
        boolean bl = super.add(initHolder);
        if (bl) {
            this.sort();
        }
        return bl;
    }

    public void calculateNumberField() {
        int n = 1;
        for (InitHolder initHolder : this) {
            if (!(initHolder instanceof Combatant)) continue;
            Combatant combatant = (Combatant)initHolder;
            combatant.setNumber(n);
            ++n;
        }
    }

    public void check() {
        Dice dice = new Dice(1, 20);
        boolean bl = SettingsHandler.getGMGenOption("Initiative.rollPCInitiatives", true);
        for (InitHolder initHolder : this) {
            Combatant combatant;
            int n = dice.roll();
            boolean bl2 = true;
            if (!bl && initHolder instanceof Combatant && (combatant = (Combatant)initHolder).getCombatantType().equals("PC")) {
                bl2 = false;
            }
            if (bl2) {
                initHolder.getInitiative().checkExtRoll(n);
                continue;
            }
            initHolder.getInitiative().resetCurrentInitiative();
        }
        this.sort();
        this.calculateNumberField();
    }

    public boolean initValid(int n) {
        for (InitHolder initHolder : this) {
            int n2;
            if (initHolder.getStatus().equals("Dead") || (n2 = initHolder.getInitiative().getCurrentInitiative()) != n) continue;
            return true;
        }
        return false;
    }

    public void sort() {
        Collections.sort(this, new InitHolderComperator());
    }
}

