/*
 * Decompiled with CFR 0.152.
 */
package gmgen.io;

import gmgen.io.VectorTable;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import pcgen.util.Logging;

public class ReadXML {
    private Document d;
    private String tableName = "";
    private VectorTable vt = new VectorTable();
    private int cols = 0;
    private int rows = 0;

    public ReadXML(File file) {
        this();
        this.readxmlFile(file);
    }

    private ReadXML() {
    }

    public VectorTable getTable() {
        return this.vt;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void displayTable() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
            }
        }
    }

    public String findPercentageEntry(int n) {
        String string = Integer.toString(n);
        for (int i = n; i <= 100 && this.vt.crossReference(string = Integer.toString(i), "d%") == null; ++i) {
        }
        return string;
    }

    private void readxmlFile(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.d = documentBuilder.parse(file);
            this.tableName = this.d.getElementsByTagName("lookuptable").item(0).getAttributes().getNamedItem("name").getNodeValue();
            this.rows = this.d.getElementsByTagName("row").getLength();
            int n = this.d.getElementsByTagName("item").getLength();
            this.cols = n / this.rows;
            this.vt.setName(file.getPath());
            int n2 = 0;
            for (int i = 0; i < this.rows; ++i) {
                Vector<String> vector = new Vector<String>();
                for (int j = 0; j < this.cols; ++j) {
                    vector.add(this.d.getElementsByTagName("item").item(n2).getChildNodes().item(0).getNodeValue());
                    ++n2;
                }
                this.vt.add(vector);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logging.errorPrint("ParserConfigurationException!");
            Logging.errorPrint("Could not parse xml file " + file.getPath());
            Logging.errorPrint("IO", parserConfigurationException);
        }
        catch (IOException iOException) {
            Logging.errorPrint("IOException!");
            Logging.errorPrint("Could not parse xml file " + file.getPath());
            Logging.errorPrint("IO", iOException);
        }
        catch (SAXException sAXException) {
            Logging.errorPrint("SAXException!");
            Logging.errorPrint("Could not parse xml file " + file.getPath());
            Logging.errorPrint("IO", sAXException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.errorPrint("IllegalArgumentException!");
            Logging.errorPrint("Could not parse xml file " + file.getPath());
            Logging.errorPrint("IO", illegalArgumentException);
        }
    }
}

