/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public class SaLst
implements GlobalLstToken {
    public String getTokenName() {
        return "SA";
    }

    public boolean parse(PObject pObject, String string, int n) {
        if (pObject instanceof Skill) {
            Logging.errorPrint((String)"SA not supported in Skills");
            return false;
        }
        SaLst.parseSpecialAbility(pObject, string, n);
        return true;
    }

    public static void parseSpecialAbility(PObject pObject, String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringTokenizer.nextToken());
        SpecialAbility specialAbility = new SpecialAbility();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (PreParserFactory.isPreReqString((String)string2)) {
                try {
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    Prerequisite prerequisite = preParserFactory.parse(string2);
                    if (pObject instanceof PCClass && "var".equals(prerequisite.getKind())) {
                        prerequisite.setSubKey("CLASS:" + pObject.getKeyName());
                    }
                    specialAbility.addPreReq(prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint((String)persistenceLayerException.getMessage(), (Throwable)persistenceLayerException);
                }
            } else {
                stringBuffer.append(string2);
            }
            if (!".CLEAR".equals(string2)) continue;
            pObject.clearSpecialAbilityList();
            stringBuffer.setLength(0);
        }
        specialAbility.setName(stringBuffer.toString());
        if (n >= 0) {
            try {
                specialAbility.addPreReq(PreParserFactory.createLevelPrereq((PObject)pObject, (int)n));
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint((String)"Failed to assign level prerequisite.", (Throwable)persistenceLayerException);
            }
        }
        if (pObject instanceof PCClass) {
            specialAbility.setSASource("PCCLASS=" + pObject.getKeyName() + "|" + n);
        }
        if (!string.equals(".CLEAR")) {
            Globals.addToSASet((SpecialAbility)specialAbility);
            pObject.addSpecialAbilityToList(specialAbility);
        }
    }
}

