/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassToken
extends Token {
    public static final String TOKENNAME = "CLASS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        int n = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("LEVEL".equals(string2)) {
                int n2 = ClassToken.getLevelToken(playerCharacter, n);
                if (n2 > 0) {
                    return Integer.toString(n2);
                }
                return "";
            }
            if ("SALIST".equals(string2)) {
                return ClassToken.getSAListToken(playerCharacter, n);
            }
            if ("TYPE".equals(string2)) {
                return ClassToken.getClassType(playerCharacter, n);
            }
        }
        return ClassToken.getClassToken(playerCharacter, n);
    }

    public static String getClassToken(PlayerCharacter playerCharacter, int n) {
        String string = "";
        if (playerCharacter.getClassList().size() > n) {
            PCClass pCClass = (PCClass)playerCharacter.getClassList().get(n);
            string = "None".equals(pCClass.getSubClassKey()) || "".equals(pCClass.getSubClassKey()) ? pCClass.getOutputName() : pCClass.getSubClassKeyed(pCClass.getSubClassKey()).getDisplayName();
        }
        return string;
    }

    public static int getLevelToken(PlayerCharacter playerCharacter, int n) {
        if (playerCharacter.getClassList().size() > n) {
            PCClass pCClass = (PCClass)playerCharacter.getClassList().get(n);
            return pCClass.getLevel();
        }
        return 0;
    }

    public static String getSAListToken(PlayerCharacter playerCharacter, int n) {
        if (playerCharacter.getClassList().size() > n) {
            PCClass pCClass = (PCClass)playerCharacter.getClassList().get(n);
            List<String> list = ClassToken.getClassSpecialAbilityList(pCClass, playerCharacter);
            return CoreUtility.join(list, (String)", ");
        }
        return "";
    }

    public static List<String> getClassSpecialAbilityList(PCClass pCClass, PlayerCharacter playerCharacter) {
        SpecialAbility object3;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List list = pCClass.getListFor(ListKey.SPECIAL_ABILITY);
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !arrayList.contains(object = (object3 = (SpecialAbility)iterator.next()).toString())) {
            if (!object3.pcQualifiesFor(playerCharacter)) continue;
            arrayList.add((String)object);
        }
        for (String string : arrayList) {
            object = new StringTokenizer(string, "|");
            String string2 = ((StringTokenizer)object).nextToken();
            int[] nArray = null;
            int n = ((StringTokenizer)object).countTokens();
            if (n != 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    nArray[i] = playerCharacter.getVariable(string3, true, true, "", "", 0).intValue();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            object = new StringTokenizer(string2, "%", true);
            n = 0;
            boolean bl = false;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                if ("%".equals(string4)) {
                    if (n == 0) {
                        bl = true;
                    }
                    if (nArray != null && n < nArray.length) {
                        int n2;
                        bl &= (n2 = nArray[n++]) == 0;
                        stringBuffer.append(n2);
                        continue;
                    }
                    stringBuffer.append('%');
                    continue;
                }
                stringBuffer.append(string4);
            }
            if (bl) continue;
            arrayList2.add(stringBuffer.toString());
        }
        return arrayList2;
    }

    public static String getClassType(PlayerCharacter playerCharacter, int n) {
        if (playerCharacter.getClassList().size() > n) {
            return ((PCClass)playerCharacter.getClassList().get(n)).getType();
        }
        return "";
    }
}

