/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNodeDiff {
    private List<Integer> stringAScript = new LinkedList<Integer>();
    private List<Integer> stringBScript = new LinkedList<Integer>();

    public PathNodeDiff(String stringA, String stringB, boolean matchCase) {
        if (!matchCase) {
            stringA = stringA.toLowerCase();
            stringB = stringB.toLowerCase();
        }
        int lengthA = stringA.length();
        int lengthB = stringB.length();
        int maxDistance = lengthA + lengthB;
        PathNode[] distanceNodes = new PathNode[maxDistance * 2 + 1];
        for (int distance = 0; distance <= maxDistance; ++distance) {
            for (int k = -distance; k <= distance; k += 2) {
                int x;
                int ik = k + maxDistance;
                PathNode previousNode = null;
                if (k == -distance) {
                    previousNode = distanceNodes[ik + 1];
                    x = previousNode == null ? 0 : previousNode.getX();
                } else if (k == distance) {
                    previousNode = distanceNodes[ik - 1];
                    x = previousNode == null ? 0 : previousNode.getX() + 1;
                } else {
                    int rightX;
                    PathNode leftNode = distanceNodes[ik - 1];
                    PathNode rightNode = distanceNodes[ik + 1];
                    int leftX = leftNode.getX();
                    if (leftX < (rightX = rightNode.getX())) {
                        x = rightX;
                        previousNode = rightNode;
                    } else {
                        x = leftX + 1;
                        previousNode = leftNode;
                    }
                }
                int y = x - k;
                PathNode currentNode = null;
                currentNode = previousNode == null ? new PathNode() : new PathNode(previousNode, new Point(x, y));
                while (x < lengthA && y < lengthB && stringA.charAt(x) == stringB.charAt(y)) {
                    currentNode = new PathNode(currentNode, new Point(++x, ++y));
                }
                distanceNodes[ik] = currentNode;
                if (x < lengthA || y < lengthB) continue;
                List<Point> points = currentNode.getPointList();
                for (int i = 0; i < points.size() - 1; ++i) {
                    int stringIndex;
                    Point point = points.get(i);
                    Point nextPoint = points.get(i + 1);
                    if (point.getX() == nextPoint.getX()) {
                        stringIndex = point.getY();
                        this.stringBScript.add(stringIndex);
                    }
                    if (point.getY() != nextPoint.getY()) continue;
                    stringIndex = point.getX();
                    this.stringAScript.add(stringIndex);
                }
                return;
            }
        }
    }

    public List<Integer> getStringAScript() {
        return this.stringAScript;
    }

    public List<Integer> getStringBScript() {
        return this.stringBScript;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathNode {
        private PathNode previousNode;
        private Point point;

        public PathNode() {
            this.previousNode = null;
            this.point = new Point(0, 0);
        }

        public PathNode(PathNode previousNode, Point point) {
            this.previousNode = previousNode;
            this.point = point;
        }

        public int getX() {
            return this.point.getX();
        }

        public List<Point> getPointList() {
            return this.getPointList(null);
        }

        private List<Point> getPointList(List<Point> pointList) {
            pointList = this.previousNode == null ? new LinkedList<Point>() : this.previousNode.getPointList(pointList);
            pointList.add(this.point);
            return pointList;
        }
    }

    private static class Point {
        private int x;
        private int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }
}

