/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvParser {
    public static List<List<String>> parseCsvFile(Reader reader) throws Exception {
        ArrayList<List<String>> csvFile = new ArrayList<List<String>>();
        PushbackReader pushbackReader = new PushbackReader(reader, 2);
        int lineCounter = 1;
        int currentChar = pushbackReader.read();
        while (currentChar != -1) {
            pushbackReader.unread(currentChar);
            List<String> csvLine = CsvParser.parseCsvLine(pushbackReader, lineCounter);
            csvFile.add(csvLine);
            ++lineCounter;
            currentChar = pushbackReader.read();
        }
        return csvFile;
    }

    private static List<String> parseCsvLine(PushbackReader pushbackReader, int lineCounter) throws Exception {
        ArrayList<String> csvLine = new ArrayList<String>();
        int column = 1;
        while (true) {
            String csvString = CsvParser.parseCsvString(pushbackReader, lineCounter);
            csvLine.add(csvString);
            if (CsvParser.endOfLineFollows(pushbackReader)) {
                CsvParser.consumeEndOfLine(pushbackReader);
                break;
            }
            int currentChar = pushbackReader.read();
            if (currentChar == -1) break;
            if (currentChar != 44) {
                throw new Exception("missing comma after column " + column + " of line " + lineCounter + " (found character \"" + (char)currentChar + "\" == " + currentChar + ")");
            }
            ++column;
        }
        return csvLine;
    }

    private static String parseCsvString(PushbackReader pushbackReader, int lineCounter) throws Exception {
        CsvParser.consumeOptionalWhiteSpaces(pushbackReader);
        if (CsvParser.endOfLineFollows(pushbackReader)) {
            return null;
        }
        int currentChar = pushbackReader.read();
        if (currentChar == 44) {
            pushbackReader.unread(currentChar);
            return null;
        }
        String csvString = null;
        csvString = currentChar == 34 ? CsvParser.parseQuotedCsvString(pushbackReader, lineCounter) : CsvParser.parseSimpleCsvString(currentChar, pushbackReader);
        CsvParser.consumeOptionalWhiteSpaces(pushbackReader);
        return csvString;
    }

    private static String parseSimpleCsvString(int currentChar, PushbackReader pushbackReader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append((char)currentChar);
            if (CsvParser.endOfLineFollows(pushbackReader)) break;
            currentChar = pushbackReader.read();
            if (currentChar != 44) continue;
            pushbackReader.unread(currentChar);
            break;
        } while (currentChar != -1);
        return stringBuilder.toString().trim();
    }

    private static String parseQuotedCsvString(PushbackReader pushbackReader, int lineCounter) throws Exception {
        int currentChar;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (CsvParser.endOfLineFollows(pushbackReader)) {
                CsvParser.consumeEndOfLine(pushbackReader);
                stringBuilder.append("\n");
            }
            if ((currentChar = pushbackReader.read()) == -1) break;
            if (currentChar == 34) {
                currentChar = pushbackReader.read();
                if (currentChar == 34) {
                    stringBuilder.append((char)currentChar);
                    continue;
                }
                if (currentChar != -1) {
                    pushbackReader.unread(currentChar);
                }
                pushbackReader.unread(34);
                break;
            }
            stringBuilder.append((char)currentChar);
        }
        if ((currentChar = pushbackReader.read()) != 34) {
            throw new Exception("missing terminating double quote in CSV line " + lineCounter);
        }
        return stringBuilder.toString();
    }

    private static void consumeOptionalWhiteSpaces(PushbackReader pushbackReader) throws IOException {
        int currentChar = pushbackReader.read();
        while (CsvParser.isSpace(currentChar)) {
            currentChar = pushbackReader.read();
        }
        if (currentChar != -1) {
            pushbackReader.unread(currentChar);
        }
    }

    private static boolean endOfLineFollows(PushbackReader pushbackReader) throws IOException {
        int currentChar = pushbackReader.read();
        if (currentChar != -1) {
            pushbackReader.unread(currentChar);
        }
        boolean endOfLineFollows = currentChar == 10 || currentChar == 13;
        return endOfLineFollows;
    }

    private static void consumeEndOfLine(PushbackReader pushbackReader) throws Exception {
        int currentChar = pushbackReader.read();
        if (currentChar != 10) {
            if (currentChar == 13) {
                currentChar = pushbackReader.read();
                if (currentChar != 10) {
                    pushbackReader.unread(currentChar);
                }
            } else {
                throw new Exception("there was no newline here");
            }
        }
    }

    private static boolean isSpace(int currentChar) {
        return currentChar == 32 || currentChar == 9;
    }
}

