/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import pauker.program.Batch;
import pauker.program.Card;
import pauker.program.CardSide;
import pauker.program.SearchEngine;
import pauker.program.gui.swing.BatchListCellRenderer;
import pauker.program.gui.swing.BatchListModel;
import pauker.program.gui.swing.EditCardDialog;
import pauker.program.gui.swing.EditCardPanel;
import pauker.program.gui.swing.PaukerFrame;
import pauker.program.gui.swing.UpdateLayoutList;

public class NewCardDialog
extends JDialog {
    private PaukerFrame paukerFrame;
    private BatchListModel similarCardsListModel;
    private BatchListCellRenderer batchListCellRenderer;
    private JTextComponent frontSideTextComponent;
    private JTextComponent reverseSideTextComponent;
    private SearchEngine searchEngine;
    private boolean showSimilarCards;
    private JScrollPane batchListScrollPane;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private EditCardPanel editCardPanel;
    private JCheckBox keepOpenCheckBox;
    private JButton okButton;
    private UpdateLayoutList similarCardsList;
    private JPanel similarCardsPanel;
    private JLabel similarLabel;
    private JSeparator similarSeparator1;
    private JSeparator similarSeparator2;
    private JSplitPane splitPane;

    public NewCardDialog(PaukerFrame paukerFrame, SearchEngine searchEngine, boolean keepOpen) {
        super((Frame)paukerFrame, true);
        this.paukerFrame = paukerFrame;
        this.searchEngine = searchEngine;
        this.setTitle(PaukerFrame.strings.getString("Add_Card"));
        this.initComponents();
        this.editCardPanel.setPaukerFrame(paukerFrame);
        this.editCardPanel.setSplitOrientation(paukerFrame.getSplitOrientation());
        this.editCardPanel.applyWrapSettings();
        this.editCardPanel.setNextFocusComponent(this.okButton);
        this.frontSideTextComponent = this.editCardPanel.getFrontSideTextComponent();
        this.reverseSideTextComponent = this.editCardPanel.getReverseSideTextComponent();
        this.showSimilarCards = true;
        this.frontSideTextComponent.getDocument().addDocumentListener(new MyDocumentListener(Card.Element.FRONT_SIDE));
        this.reverseSideTextComponent.getDocument().addDocumentListener(new MyDocumentListener(Card.Element.REVERSE_SIDE));
        this.similarCardsListModel = new BatchListModel();
        this.similarCardsList.setModel(this.similarCardsListModel);
        this.batchListCellRenderer = new BatchListCellRenderer(paukerFrame, this.similarCardsList.getSelectionBackground());
        this.batchListCellRenderer.disableInfoPanel();
        this.batchListCellRenderer.setLineWrap(paukerFrame.isLineWrapping());
        this.similarCardsList.setCellRenderer(this.batchListCellRenderer);
        this.similarCardsList.setLineWrapping(paukerFrame.isLineWrapping());
        this.keepOpenCheckBox.setSelected(keepOpen);
        this.pack();
        this.similarSeparator1.setMinimumSize(this.similarSeparator1.getPreferredSize());
        this.similarLabel.setMinimumSize(this.similarLabel.getPreferredSize());
        this.similarSeparator2.setMinimumSize(this.similarSeparator2.getPreferredSize());
        this.similarCardsPanel.setMinimumSize(this.similarCardsPanel.getPreferredSize());
        this.setLocationRelativeTo(paukerFrame);
    }

    public void reset() {
        this.editCardPanel.reset();
        this.editCardPanel.setNextFocusComponent(this.okButton);
        this.similarCardsListModel.clear();
        this.similarCardsList.setLineWrapping(this.paukerFrame.isLineWrapping());
        this.batchListCellRenderer.setLineWrap(this.paukerFrame.isLineWrapping());
        this.setLocationRelativeTo(this.paukerFrame);
    }

    public void setOrientation(int orientation) {
        this.editCardPanel.setSplitOrientation(orientation);
    }

    public EditCardPanel getEditCardPanel() {
        return this.editCardPanel;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.editCardPanel = new EditCardPanel();
        this.similarCardsPanel = new JPanel();
        this.similarSeparator1 = new JSeparator();
        this.similarLabel = new JLabel();
        this.similarSeparator2 = new JSeparator();
        this.batchListScrollPane = new JScrollPane();
        this.similarCardsList = new UpdateLayoutList();
        this.buttonPanel = new JPanel();
        this.keepOpenCheckBox = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewCardDialog.this.closeDialog(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                NewCardDialog.this.formComponentShown(evt);
            }
        });
        this.splitPane.setOrientation(0);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NewCardDialog.this.splitPanePropertyChange(evt);
            }
        });
        this.editCardPanel.setRepeatByTyping(false);
        this.splitPane.setTopComponent(this.editCardPanel);
        this.similarCardsPanel.setLayout(new GridBagLayout());
        this.similarSeparator1.setPreferredSize(new Dimension(20, 2));
        this.similarCardsPanel.add((Component)this.similarSeparator1, new GridBagConstraints());
        this.similarLabel.setFont(new Font("Dialog", 0, 10));
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.similarLabel.setText(bundle.getString("Similar_Cards"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.similarCardsPanel.add((Component)this.similarLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.similarCardsPanel.add((Component)this.similarSeparator2, gridBagConstraints);
        this.similarCardsList.setName("similarCardsList");
        this.similarCardsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NewCardDialog.this.similarCardsListMouseClicked(evt);
            }
        });
        this.batchListScrollPane.setViewportView(this.similarCardsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.similarCardsPanel.add((Component)this.batchListScrollPane, gridBagConstraints);
        this.splitPane.setBottomComponent(this.similarCardsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.keepOpenCheckBox.setFont(new Font("Dialog", 0, 10));
        this.keepOpenCheckBox.setText(bundle.getString("Keep_Dialog_Open"));
        this.keepOpenCheckBox.setName("keepOpenCheckBox");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.buttonPanel.add((Component)this.keepOpenCheckBox, gridBagConstraints);
        this.okButton.setFont(new Font("Dialog", 0, 10));
        this.okButton.setText(bundle.getString("OK"));
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCardDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setFont(new Font("Dialog", 0, 10));
        this.cancelButton.setText(bundle.getString("Cancel"));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCardDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void similarCardsListMouseClicked(MouseEvent evt) {
        Card selectedCard;
        EditCardDialog editCardDialog;
        int selectedIndex;
        if (evt.getClickCount() == 2 && (selectedIndex = this.similarCardsList.getSelectedIndex()) != -1 && (editCardDialog = new EditCardDialog((Dialog)this, this.paukerFrame, selectedCard = (Card)this.similarCardsListModel.get(selectedIndex), this.searchEngine)).okPressed()) {
            this.similarCardsListModel.cardsChanged(selectedIndex, selectedIndex);
            this.paukerFrame.somethingHasChanged();
        }
    }

    private void splitPanePropertyChange(PropertyChangeEvent evt) {
        int dividerSize;
        Dimension splitPaneSize = this.splitPane.getSize();
        int dividerLocation = this.splitPane.getDividerLocation();
        if (splitPaneSize.height - dividerLocation - (dividerSize = this.splitPane.getDividerSize()) < 3) {
            this.showSimilarCards = false;
        } else if (!this.showSimilarCards) {
            this.showSimilarCards = true;
            NewCardDialog newCardDialog = this;
            if (newCardDialog.editCardPanel.getLastFocusSide() == Card.Element.FRONT_SIDE) {
                this.searchSimilarCards(this.editCardPanel.getFrontSide(), "frontSide");
            } else {
                this.searchSimilarCards(this.editCardPanel.getReverseSide(), "reverseSide");
            }
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.editCardPanel.setFocus(Card.Element.FRONT_SIDE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewCardDialog.this.getRootPane().setDefaultButton(NewCardDialog.this.okButton);
            }
        });
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.exitDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String frontSideText = this.editCardPanel.getFrontSide();
        String reverseSideText = this.editCardPanel.getReverseSide();
        if (frontSideText.length() == 0) {
            JOptionPane.showMessageDialog(this, PaukerFrame.strings.getString("FrontSide_Is_Empty"), PaukerFrame.strings.getString("Error"), 0);
            this.editCardPanel.setFocus(Card.Element.FRONT_SIDE);
            return;
        }
        if (reverseSideText.length() == 0) {
            JOptionPane.showMessageDialog(this, PaukerFrame.strings.getString("ReverseSide_Is_Empty"), PaukerFrame.strings.getString("Error"), 0);
            this.editCardPanel.setFocus(Card.Element.REVERSE_SIDE);
            return;
        }
        CardSide frontSide = new CardSide(frontSideText);
        frontSide.setFont(this.editCardPanel.getFrontSideFont());
        frontSide.setForegroundColor(this.editCardPanel.getFrontForegroundColor());
        frontSide.setBackgroundColor(this.editCardPanel.getFrontBackgroundColor());
        frontSide.setOrientation(this.editCardPanel.getFrontSideComponentOrientation());
        frontSide.setRepeatByTyping(this.editCardPanel.getRepeatByTyping());
        CardSide reverseSide = new CardSide(reverseSideText);
        reverseSide.setFont(this.editCardPanel.getReverseSideFont());
        reverseSide.setForegroundColor(this.editCardPanel.getReverseSideForegroundColor());
        reverseSide.setBackgroundColor(this.editCardPanel.getReverseSideBackgroundColor());
        reverseSide.setOrientation(this.editCardPanel.getReverseSideComponentOrientation());
        Card newCard = new Card(frontSide, reverseSide);
        this.paukerFrame.addCard(newCard);
        if (this.keepOpenCheckBox.isSelected()) {
            this.editCardPanel.clear();
            this.editCardPanel.setFocus(Card.Element.FRONT_SIDE);
            this.similarCardsListModel.clear();
            this.similarCardsList.repaint();
        } else {
            this.exitDialog();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.exitDialog();
    }

    private void searchSimilarCards(String searchString, String sideString) {
        try {
            if (searchString.length() > 2) {
                List<Card> similarCards = this.searchEngine.search(searchString, sideString);
                Batch similarCardsBatch = new Batch(similarCards);
                this.similarCardsListModel.setBatch(similarCardsBatch);
            } else {
                this.similarCardsListModel.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exitDialog() {
        this.setVisible(false);
        this.dispose();
    }

    boolean getKeepOpen() {
        return this.keepOpenCheckBox.isSelected();
    }

    private class MyDocumentListener
    implements DocumentListener {
        private Card.Element cardSide;

        public MyDocumentListener(Card.Element cardSide) {
            this.cardSide = cardSide;
        }

        public void changedUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        private void documentChanged() {
            if (NewCardDialog.this.showSimilarCards) {
                if (this.cardSide == Card.Element.FRONT_SIDE) {
                    NewCardDialog.this.searchSimilarCards(NewCardDialog.this.editCardPanel.getFrontSide(), "frontSide");
                } else {
                    NewCardDialog.this.searchSimilarCards(NewCardDialog.this.editCardPanel.getReverseSide(), "reverseSide");
                }
            }
        }
    }
}

