/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import javax.swing.text.Element;
import pauker.program.Card;
import pauker.program.CardSide;
import pauker.program.gui.swing.LineLabeler;
import pauker.program.gui.swing.PaukerFrame;

public class ImportDialog
extends JDialog {
    private PaukerFrame paukerFrame;
    private JButton importButton;
    private JLabel infoLabel;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public ImportDialog(PaukerFrame paukerFrame) {
        super((Frame)paukerFrame, true);
        this.paukerFrame = paukerFrame;
        this.initComponents();
        LineLabeler lineLabeler = new LineLabeler(this.textArea, PaukerFrame.strings.getString("Frontside"), PaukerFrame.strings.getString("Reverse_Side"));
        this.scrollPane.setRowHeaderView(lineLabeler);
        this.pack();
        this.setLocationRelativeTo(paukerFrame);
        Dimension size = this.infoLabel.getSize();
        this.infoLabel.setMinimumSize(size);
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.importButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(ResourceBundle.getBundle("pauker/Strings").getString("Text_Import"));
        this.infoLabel.setFont(new Font("Dialog", 0, 10));
        this.infoLabel.setText(ResourceBundle.getBundle("pauker/Strings").getString("Text_Import_Info"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.infoLabel, gridBagConstraints);
        this.scrollPane.setPreferredSize(new Dimension(500, 300));
        this.textArea.setFont(new Font("Dialog", 0, 10));
        this.scrollPane.setViewportView(this.textArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.scrollPane, gridBagConstraints);
        this.importButton.setFont(new Font("Dialog", 0, 10));
        this.importButton.setText(ResourceBundle.getBundle("pauker/Strings").getString("Import"));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportDialog.this.importButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.importButton, gridBagConstraints);
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        Document document = this.textArea.getDocument();
        Element rootElement = document.getDefaultRootElement();
        int numberOfLines = rootElement.getElementCount();
        if (numberOfLines % 2 != 0) {
            JOptionPane.showMessageDialog(this, PaukerFrame.strings.getString("Error_Import_Incomplete_Card"), PaukerFrame.strings.getString("Error"), 0);
            this.textArea.requestFocusInWindow();
            Element lastLine = rootElement.getElement(numberOfLines - 1);
            this.textArea.setCaretPosition(lastLine.getEndOffset() - 1);
            return;
        }
        for (int i = 0; i < numberOfLines; ++i) {
            Element line = rootElement.getElement(i);
            if (line.getStartOffset() + 1 != line.getEndOffset()) continue;
            JOptionPane.showMessageDialog(this, PaukerFrame.strings.getString("Error_Import_Empty_Card_Side"), PaukerFrame.strings.getString("Error"), 0);
            this.textArea.requestFocusInWindow();
            this.textArea.setCaretPosition(line.getStartOffset());
            return;
        }
        String frontSideText = null;
        String reverseSideText = null;
        try {
            for (int i = 0; i < numberOfLines; ++i) {
                Element line = rootElement.getElement(i);
                int offset = line.getStartOffset();
                int length = line.getEndOffset() - offset - 1;
                if (i % 2 == 0) {
                    frontSideText = document.getText(offset, length);
                    continue;
                }
                reverseSideText = document.getText(offset, length);
                CardSide frontSide = new CardSide(frontSideText);
                CardSide reverseSide = new CardSide(reverseSideText);
                Card newCard = new Card(frontSide, reverseSide);
                this.paukerFrame.addCard(newCard);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dispose();
        this.setVisible(false);
    }
}

