/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import pauker.program.Card;
import pauker.program.gui.swing.PaukerFrame;

public class FontDialog
extends JDialog {
    private boolean okButtonPressed;
    private JLabel backLabel;
    private JRadioButton backRadioButton;
    private JButton backgroundButton;
    private JToggleButton boldToggleButton;
    private JLabel bothLabel;
    private JRadioButton bothRadioButton;
    private ButtonGroup buttonGroup;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel fontButtonPanel;
    private JComboBox fontFamilyComboBox;
    private JPanel fontPanel;
    private JComboBox fontSizeComboBox;
    private JButton foregroundButton;
    private JLabel frontLabel;
    private JRadioButton frontRadioButton;
    private JToggleButton italicToggleButton;
    private JButton okButton;
    private JPanel radioButtonPanel;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public FontDialog(Frame parent, Font initialFont, Color initialForeground, Color initialBackground) {
        super(parent, true);
        String[] fontFamilyNames;
        this.initComponents();
        DefaultComboBoxModel<String> fontFamilyComboModel = new DefaultComboBoxModel<String>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontFamilyName : fontFamilyNames = graphicsEnvironment.getAvailableFontFamilyNames()) {
            fontFamilyComboModel.addElement(fontFamilyName);
        }
        this.fontFamilyComboBox.setModel(fontFamilyComboModel);
        Object[] fontSizes = new Object[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"};
        DefaultComboBoxModel<Object> fontSizeComboModel = new DefaultComboBoxModel<Object>(fontSizes);
        this.fontSizeComboBox.setModel(fontSizeComboModel);
        this.textArea.setFont(initialFont);
        this.textArea.setForeground(initialForeground);
        this.textArea.setBackground(initialBackground);
        this.fontFamilyComboBox.setSelectedItem(initialFont.getFamily());
        this.fontSizeComboBox.setSelectedItem(Integer.toString(initialFont.getSize()));
        this.boldToggleButton.setSelected(initialFont.isBold());
        this.italicToggleButton.setSelected(initialFont.isItalic());
        Dimension size = this.scrollPane.getPreferredSize();
        size.height += 30;
        size.width += 50;
        this.scrollPane.setPreferredSize(size);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean okButtonPressed() {
        return this.okButtonPressed;
    }

    public Font getFont() {
        return this.textArea.getFont();
    }

    public Color getForegroundColor() {
        return this.textArea.getForeground();
    }

    public Color getBackgroundColor() {
        return this.textArea.getBackground();
    }

    public Card.Element getSide() {
        if (this.frontRadioButton.isSelected()) {
            return Card.Element.FRONT_SIDE;
        }
        if (this.backRadioButton.isSelected()) {
            return Card.Element.REVERSE_SIDE;
        }
        return Card.Element.BOTH_SIDES;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.fontPanel = new JPanel();
        this.fontButtonPanel = new JPanel();
        this.fontFamilyComboBox = new JComboBox();
        this.fontSizeComboBox = new JComboBox();
        this.boldToggleButton = new JToggleButton();
        this.italicToggleButton = new JToggleButton();
        this.foregroundButton = new JButton();
        this.backgroundButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.radioButtonPanel = new JPanel();
        this.frontLabel = new JLabel();
        this.frontRadioButton = new JRadioButton();
        this.backLabel = new JLabel();
        this.backRadioButton = new JRadioButton();
        this.bothLabel = new JLabel();
        this.bothRadioButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.setTitle(bundle.getString("Set_Font"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FontDialog.this.closeDialog(evt);
            }
        });
        this.fontPanel.setLayout(new GridBagLayout());
        this.fontPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("Font"), 0, 0, new Font("Dialog", 0, 10)));
        this.fontButtonPanel.setLayout(new GridBagLayout());
        this.fontButtonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.fontFamilyComboBox.setFont(new Font("Dialog", 0, 10));
        this.fontFamilyComboBox.setName("fontFamilyComboBox");
        this.fontFamilyComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.fontFamilyComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontButtonPanel.add((Component)this.fontFamilyComboBox, gridBagConstraints);
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.setFont(new Font("Dialog", 0, 10));
        this.fontSizeComboBox.setName("fontSizeComboBox");
        this.fontSizeComboBox.setPreferredSize(new Dimension(60, 24));
        this.fontSizeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.fontSizeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontButtonPanel.add((Component)this.fontSizeComboBox, gridBagConstraints);
        this.boldToggleButton.setText(bundle.getString("Bold_Mnemonic"));
        this.boldToggleButton.setToolTipText(bundle.getString("Bold"));
        this.boldToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.boldToggleButton.setName("boldToggleButton");
        this.boldToggleButton.setPreferredSize(new Dimension(26, 26));
        this.boldToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.boldToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.fontButtonPanel.add((Component)this.boldToggleButton, gridBagConstraints);
        this.italicToggleButton.setFont(new Font("Dialog", 3, 12));
        this.italicToggleButton.setText(bundle.getString("Italic_Mnemonic"));
        this.italicToggleButton.setToolTipText(bundle.getString("Italic"));
        this.italicToggleButton.setMargin(new Insets(2, 0, 2, 0));
        this.italicToggleButton.setName("italicToggleButton");
        this.italicToggleButton.setPreferredSize(new Dimension(26, 26));
        this.italicToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.italicToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontButtonPanel.add((Component)this.italicToggleButton, gridBagConstraints);
        this.foregroundButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/foreground.png")));
        this.foregroundButton.setToolTipText(bundle.getString("Font_Color"));
        this.foregroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.foregroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.foregroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fontButtonPanel.add((Component)this.foregroundButton, gridBagConstraints);
        this.backgroundButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/background.png")));
        this.backgroundButton.setToolTipText(bundle.getString("Background_Color"));
        this.backgroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.backgroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.fontButtonPanel.add((Component)this.backgroundButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.fontPanel.add((Component)this.fontButtonPanel, gridBagConstraints);
        this.textArea.setText(bundle.getString("All_Letters_Sentence"));
        this.textArea.setName("textArea");
        this.scrollPane.setViewportView(this.textArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.fontPanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.fontPanel, gridBagConstraints);
        this.radioButtonPanel.setLayout(new GridBagLayout());
        this.radioButtonPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("Card_Side"), 0, 0, new Font("Dialog", 0, 10)));
        this.frontLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/frontSide.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.radioButtonPanel.add((Component)this.frontLabel, gridBagConstraints);
        this.buttonGroup.add(this.frontRadioButton);
        this.frontRadioButton.setFont(new Font("Dialog", 0, 10));
        this.frontRadioButton.setSelected(true);
        this.frontRadioButton.setText(bundle.getString("Frontside"));
        this.frontRadioButton.setMargin(new Insets(2, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.radioButtonPanel.add((Component)this.frontRadioButton, gridBagConstraints);
        this.backLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/reverseSide.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.radioButtonPanel.add((Component)this.backLabel, gridBagConstraints);
        this.buttonGroup.add(this.backRadioButton);
        this.backRadioButton.setFont(new Font("Dialog", 0, 10));
        this.backRadioButton.setText(bundle.getString("Reverse_Side"));
        this.backRadioButton.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.radioButtonPanel.add((Component)this.backRadioButton, gridBagConstraints);
        this.bothLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/bothSides.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.radioButtonPanel.add((Component)this.bothLabel, gridBagConstraints);
        this.buttonGroup.add(this.bothRadioButton);
        this.bothRadioButton.setFont(new Font("Dialog", 0, 10));
        this.bothRadioButton.setText(bundle.getString("Both_Sides"));
        this.bothRadioButton.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.radioButtonPanel.add((Component)this.bothRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.radioButtonPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okButton.setFont(new Font("Dialog", 0, 10));
        this.okButton.setText(bundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setFont(new Font("Dialog", 0, 10));
        this.cancelButton.setText(bundle.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void backgroundButtonActionPerformed(ActionEvent evt) {
        Color background = JColorChooser.showDialog(this, PaukerFrame.strings.getString("Choose_Background_Color"), Color.white);
        if (background != null) {
            this.textArea.setBackground(background);
        }
    }

    private void foregroundButtonActionPerformed(ActionEvent evt) {
        Color foreground = JColorChooser.showDialog(this, PaukerFrame.strings.getString("Choose_Font_Color"), Color.black);
        if (foreground != null) {
            this.textArea.setForeground(foreground);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okButtonPressed = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void italicToggleButtonActionPerformed(ActionEvent evt) {
        this.setFontStyle(2, this.italicToggleButton.isSelected());
    }

    private void boldToggleButtonActionPerformed(ActionEvent evt) {
        this.setFontStyle(1, this.boldToggleButton.isSelected());
    }

    private void setFontStyle(int style, boolean setStyle) {
        Font oldFont = this.textArea.getFont();
        int newStyle = oldFont.getStyle();
        newStyle = setStyle ? (newStyle += style) : (newStyle -= style);
        Font newFont = oldFont.deriveFont(newStyle);
        this.textArea.setFont(newFont);
    }

    private void fontSizeComboBoxActionPerformed(ActionEvent evt) {
        String sizeString = (String)this.fontSizeComboBox.getSelectedItem();
        try {
            int fontSize = Integer.parseInt(sizeString);
            Font oldFont = this.textArea.getFont();
            Font newFont = oldFont.deriveFont((float)fontSize);
            this.textArea.setFont(newFont);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fontFamilyComboBoxActionPerformed(ActionEvent evt) {
        Font oldFont = this.textArea.getFont();
        int fontSize = oldFont.getSize();
        int fontStyle = oldFont.getStyle();
        String fontFamilyName = (String)this.fontFamilyComboBox.getSelectedItem();
        Font font = new Font(fontFamilyName, fontStyle, fontSize);
        this.textArea.setFont(font);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

