/*****************************************************************************
*
* File: VDP.h
*
* Project: Osmose emulator.
*
* Description: This class will handle VDP (Video Display Processor)operation.
*
* Author: Vedder Bruno
* Date: 11/10/2004, 08h30
*
* URL: http://bcz.emu-france.com/
*****************************************************************************/
#ifndef VDP_H
#define VDP_H
#include <SDL/SDL.h>
#include <iomanip>
#include <iostream>
#include "Bits.h"
#include "Options.h"

using namespace std;

extern EmulatorOptions emu_opt;

#define VDP_REGISTER_NBR        16

/* Destination component when data port is written */
#define D_VRAM                        0
#define D_CRAM                        1

#define REG0 regs [0]
#define REG1 regs [1]
#define REG2 regs [2]
#define REG3 regs [3]
#define REG4 regs [4]
#define REG5 regs [5]
#define REG6 regs [6]
#define REG7 regs [7]
#define REG8 regs [8]
#define REG9 regs [9]
#define REG10 regs [10]

/*Uncomment this to have VDP access trace */
//#define VDP_VERBOSE

class VDP {

public:
    unsigned char  rd_data_port_buffer;		   // Buffer used in read data port.
    unsigned short line_buffer [256];              // Line buffer for tile/sprite priority.
    unsigned char  tile_mask   [256];              // Pixels above sprites are marked here.
    unsigned char  spr_col     [256];              // Use for sprite collision.
    unsigned short *colors;                        // For on fly color conversion.
    unsigned char  *VRAM;                          // Video memory.
    unsigned short map_addr;                       // Where in vram is tilemap.
    unsigned short sit_addr;                       // for sprite info. table.
    unsigned char  regs[VDP_REGISTER_NBR];         // VDP Registers.
    unsigned char  vdp_status;                     // used with portBF read.
    unsigned char  v_counter;                      // Vertical scanline ctr.  
    unsigned char *v_cnt;		           // point ntsc/pal vcount values.
    int line;                                      // Line actualy drawn.
    bool sms_irq;                                  // Set when VDP gen. an irq.

protected:

    unsigned short *gfx_buffer;                    // Internal gfx buffer.
    signed int     i_counter;                      // Interrupt Line counter.
    unsigned char  *CRAM;                          // Color RAM.   
    unsigned char  latch;                          // Latch for address.
    unsigned short addr;                           // VDP address pointer.
    unsigned char r_col[4];			   // Precalc Red possible values.
    unsigned char g_col[4];			   // Precalc Green possible values.
    unsigned char b_col[4];			   // Precalc Blue possible values.
    unsigned char  cmd_type;			   // VRAM Wr/Rd, VDP Wr Reg or CRAM Wr.
    bool           cmd_flag;                       // Flag for 2 bytes cmd.      

public:

    VDP(bool ntsc);
    void writeDataPort(unsigned char data);        // Port 0xBE written.
    unsigned char readDataPort();                  // Port 0xBE read.
    void writeCtrlPort(unsigned char data);        // Port 0xBF/0xBD written.
    unsigned char readStatusFlag();                // Port 0xBF/0xBD read.
    void reset();                                  // reset VDP.
    void dumpVRAM(unsigned int, int nb_lines);     // Dump VDP VRAM.
    void dumpCRAM();                               // Dump VDP CRAM.
    void update(SDL_Surface *s, bool drawline);    // Update VDP.
    unsigned short getVRAMAddr();		   // Get VDP pointer.
protected:

    void writeRegs(unsigned char r,unsigned char v);        // Called on write regs.
    void traceBackGroundLine(SDL_Surface *s);		    // Draw one line.
    void displaySpritesLine();                              // Used in traceBackGroundLine.
};
#endif
