/*****************************************************************************
*
* File: IOMapper.h
*
* Project: Osmose emulator.
*
* Description: This class will handle emulator input/output operation. 
*
* Author: Vedder Bruno
* Date: 08/10/2004, 18h00
*
* URL: http://bcz.emu-france.com/
*****************************************************************************/
#ifndef IO_MAPPER_H
#define IO_MAPPER_H
#include <iostream>
#include <iomanip>
#include "VDP.h"
#include "SN76489.h"
#include "Options.h"

extern Options opt;

/* Uncomment this line for verbose information on PSG/VDP access */
//#define PSG_VERBOSE
//#define VDP_ACCESS
//#define AUTO_NAT_VERBOSE
//#define PAD_VERBOSE
//#define MEM_CTRL_VERBOSE

using namespace std;

class IOMapper {

protected:

    VDP     &vdp;			// Reference on VDP object.	
    SN76489 &psg;			// Reference on PSG object.	

public:

    IOMapper(VDP &, SN76489 &);		// Constructor.
    unsigned char paddleValue;		// Paddle knob value.
    bool flipFlop;
    unsigned char port3E;		// Memory control. 	
    unsigned char port3F;		// Auto nationalisation port. 	
    unsigned char portPAD1;		// Joypad port 1.
    unsigned char portPAD2;		// Joypad port 2.	
    unsigned char smsVersion;		// Sms type.	
    void reset();	 
    void out8(unsigned address, unsigned char value);
    unsigned char in8(unsigned  address);

};
#endif
