/*****************************************************************************
*
* File: BilinearVideoFilter.cpp
*
* Project: Osmose emulator.
*
* Description: This class provide a code for the Bilinear Video Filter.
*
* Author: Vedder Bruno
* Date: 03/04/2005, 16h00
*
* URL: http://bcz.emu-france.com/
*****************************************************************************/
#include "BilinearVideoFilter.h"

int BilinearVideoFilter::getFinalOutputWidth()
{
    return 512;
}

int BilinearVideoFilter::getFinalOutputHeight()
{
    return 384;
}

void BilinearVideoFilter::Filter(SDL_Surface *s, SDL_Surface *d)
{
    unsigned short *src, *dst, *s_src, *s_dst;
    unsigned short col,r,g,b;

    src = (unsigned short *) s->pixels;
    dst = (unsigned short *) d->pixels;    
    s_src = src;
    s_dst = dst;

    //
    //    Mangle source picture:
    //	
    //	
    //	ABC     AxBxC
    //	DEF =>  xxxxx
    //                DxExF
    //        Where x is the point to be interpolated.
    //	
    //
    for (int o = 0; o < 192; o++)
    {
	for (int i = 0; i < 256; i++)
	{
	    *dst =  *src;
	    dst++;
	    dst++;
    	    src++;
	}
	dst +=512;
    }

    // Linear interpolation.
    dst = s_dst;
    dst++;
    for (int o=0; o < 192; o++)
    {
	for (int i = 1; i < 256; i++)
	{
            col = *(dst-1);
	    r = col >> 11;
	    g = (col >>  5) & 0x3f;
	    b = col & 0x1f;

	    col = *(dst+1);
	    r += col >> 11;
	    g += (col >>  5) & 0x3f;
	    b += col & 0x1f;

            r = r >> 1;
            g = g >> 1;
	    b = b >> 1;
            col = (unsigned short)((r <<11) + (g << 5) + b);	    
            *dst = col;
	    dst++;
	    dst++;
	}
	dst += 512+2;
    }

    // Linear interpolation.
    dst = s_dst;
    dst += 512;
    for (int o=0; o < 191; o++)
    {
	for (int i = 0; i < 512; i++)
	{
            col = *(dst-512);
	    r = col >> 11;
	    g = (col >>  5) & 0x3f;
	    b = col & 0x1f;

	    col = *(dst+512);
	    r += col >> 11;
	    g += (col >>  5) & 0x3f;
	    b += col & 0x1f;

            r = r >> 1;
            g = g >> 1;
	    b = b >> 1;
            col = (unsigned short)((r <<11) + (g << 5) + b);
            *dst = col;
	    dst++;
	}
	dst += 512;
    }

}

string BilinearVideoFilter::getFilterName()
{
    return string("Bilinear Video Filter.");
}


