/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnsync;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNConsoleAuthenticationProvider;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svnsync.SVNSyncCommand;
import org.tmatesoft.svn.cli.svnsync.SVNSyncOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSyncCommandEnvironment
extends AbstractSVNCommandEnvironment {
    private boolean myIsNonInteractive;
    private boolean myIsNoAuthCache;
    private String myUserName;
    private String myPassword;
    private String mySourceUsername;
    private String mySourcePassword;
    private String mySyncUsername;
    private String mySyncPassword;
    private String myConfigDir;
    private boolean myIsVersion;
    private boolean myIsQuiet;
    private boolean myIsHelp;
    private boolean myIsTrustServerCertificate;

    public boolean isNonInteractive() {
        return this.myIsNonInteractive;
    }

    public boolean isNoAuthCache() {
        return this.myIsNoAuthCache;
    }

    public String getUsername() {
        return this.myUserName;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public String getSourceUsername() {
        return this.mySourceUsername;
    }

    public String getSourcePassword() {
        return this.mySourcePassword;
    }

    public String getSyncUsername() {
        return this.mySyncUsername;
    }

    public String getSyncPassword() {
        return this.mySyncPassword;
    }

    public String getConfigDir() {
        return this.myConfigDir;
    }

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public boolean isQuiet() {
        return this.myIsQuiet;
    }

    public boolean isHelp() {
        return this.myIsHelp;
    }

    public SVNSyncCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
    }

    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir) : SVNWCUtil.getDefaultConfigurationDirectory();
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((File)configDir, (String)this.myUserName, (String)this.myPassword, (!this.myIsNoAuthCache ? 1 : 0) != 0);
        if (!this.myIsNonInteractive) {
            authManager.setAuthenticationProvider((ISVNAuthenticationProvider)new SVNConsoleAuthenticationProvider(this.myIsTrustServerCertificate));
        }
        return authManager;
    }

    protected DefaultSVNOptions createClientOptions() {
        return null;
    }

    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        AbstractSVNOption option = optionValue.getOption();
        if (option == SVNSyncOption.NON_INTERACTIVE) {
            this.myIsNonInteractive = true;
        } else if (option == SVNSyncOption.NO_AUTH_CACHE) {
            this.myIsNoAuthCache = true;
        } else if (option == SVNSyncOption.USERNAME) {
            this.myUserName = optionValue.getValue();
        } else if (option == SVNSyncOption.PASSWORD) {
            this.myPassword = optionValue.getValue();
        } else if (option == SVNSyncOption.SOURCE_USERNAME) {
            this.mySourceUsername = optionValue.getValue();
        } else if (option == SVNSyncOption.SOURCE_PASSWORD) {
            this.mySourcePassword = optionValue.getValue();
        } else if (option == SVNSyncOption.SYNC_USERNAME) {
            this.mySyncUsername = optionValue.getValue();
        } else if (option == SVNSyncOption.SYNC_PASSWORD) {
            this.mySyncPassword = optionValue.getValue();
        } else if (option == SVNSyncOption.CONFIG_DIR) {
            this.myConfigDir = optionValue.getValue();
        } else if (option == SVNSyncOption.VERSION) {
            this.myIsVersion = true;
        } else if (option == SVNSyncOption.QUIET) {
            this.myIsQuiet = true;
        } else if (option == SVNSyncOption.TRUST_SERVER_CERT) {
            this.myIsTrustServerCertificate = true;
        } else if (option == SVNSyncOption.HELP || option == SVNSyncOption.QUESTION) {
            this.myIsHelp = true;
        }
    }

    protected void validateOptions(SVNCommandLine commandLine) throws SVNException {
        super.validateOptions(commandLine);
        if (!(this.myUserName == null && this.myPassword == null || this.mySourceUsername == null && this.mySourcePassword == null || this.mySyncUsername == null && this.mySyncPassword == null)) {
            SVNErrorMessage error = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Cannot use --username or --password with any of --source-username, --source-password, --sync-username, or --sync-password.");
            SVNErrorManager.error((SVNErrorMessage)error, (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.myUserName != null) {
            this.mySourceUsername = this.myUserName;
            this.mySyncUsername = this.myUserName;
        }
        if (this.myPassword != null) {
            this.mySourcePassword = this.myPassword;
            this.mySyncPassword = this.myPassword;
        }
        if (this.myIsTrustServerCertificate && !this.myIsNonInteractive) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--trust-server-cert requires --non-interactive");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }

    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNSyncOption.HELP || option == SVNSyncOption.QUESTION) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNSyncOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (commandName == null) {
            if (this.isVersion()) {
                SVNSyncCommand versionCommand = new SVNSyncCommand("--version", null, 0){

                    protected Collection createSupportedOptions() {
                        LinkedList<SVNSyncOption> options = new LinkedList<SVNSyncOption>();
                        options.add(SVNSyncOption.VERSION);
                        return options;
                    }

                    public void run() throws SVNException {
                        AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                        helpCommand.init(SVNSyncCommandEnvironment.this);
                        helpCommand.run();
                    }
                };
                AbstractSVNCommand.registerCommand(versionCommand);
                return "--version";
            }
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Subcommand argument required");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return commandName;
    }

    protected String getCommandLineClientName() {
        return "svnsync";
    }
}

