/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.text.MessageFormat;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.DefaultSVNCommandLineDiffGenerator;
import org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import org.tmatesoft.svn.cli.svn.SVNConflictAcceptPolicy;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;

public class SVNCommandLineConflictHandler
implements ISVNConflictHandler {
    private SVNConflictAcceptPolicy myAccept;
    private SVNCommandEnvironment mySVNEnvironment;
    private boolean myIsExternalFailed;

    public SVNCommandLineConflictHandler(SVNConflictAcceptPolicy accept, SVNCommandEnvironment environment) {
        this.myAccept = accept;
        this.mySVNEnvironment = environment;
    }

    public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
        SVNConflictChoice choice;
        block63: {
            if (conflictDescription.isTreeConflict()) {
                return null;
            }
            SVNMergeFileSet files = conflictDescription.getMergeFiles();
            if (this.myAccept == SVNConflictAcceptPolicy.POSTPONE) {
                return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.BASE) {
                return new SVNConflictResult(SVNConflictChoice.BASE, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.MINE) {
                return new SVNConflictResult(SVNConflictChoice.MINE_CONFLICT, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.THEIRS) {
                return new SVNConflictResult(SVNConflictChoice.THEIRS_CONFLICT, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.MINE_FULL) {
                return new SVNConflictResult(SVNConflictChoice.MINE_FULL, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.THEIRS_FULL) {
                return new SVNConflictResult(SVNConflictChoice.THEIRS_FULL, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.EDIT) {
                if (files.getResultFile() != null) {
                    if (this.myIsExternalFailed) {
                        return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                    }
                    try {
                        SVNCommandUtil.editFileExternally(this.mySVNEnvironment, this.mySVNEnvironment.getEditorCommand(), files.getResultFile().getAbsolutePath());
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_EDITOR) {
                            this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No editor found, leaving all conflicts.");
                            this.myIsExternalFailed = true;
                        }
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                            this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "Error running editor, leaving all conflicts.");
                            this.myIsExternalFailed = true;
                        }
                        throw svne;
                    }
                    return new SVNConflictResult(SVNConflictChoice.MERGED, null);
                }
            } else if (this.myAccept == SVNConflictAcceptPolicy.LAUNCH && files.getBaseFile() != null && files.getLocalFile() != null && files.getRepositoryFile() != null && files.getResultFile() != null) {
                if (this.myIsExternalFailed) {
                    return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                }
                try {
                    SVNCommandUtil.mergeFileExternally(this.mySVNEnvironment, files.getBaseFile().getAbsolutePath(), files.getRepositoryFile().getAbsolutePath(), files.getLocalFile().getAbsolutePath(), files.getResultFile().getAbsolutePath());
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_MERGE_TOOL) {
                        this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No merge tool found.");
                        this.myIsExternalFailed = true;
                    }
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                        this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "Error running merge tool.");
                        this.myIsExternalFailed = true;
                    }
                    throw svne;
                }
                return new SVNConflictResult(SVNConflictChoice.MERGED, null);
            }
            choice = SVNConflictChoice.POSTPONE;
            if (conflictDescription.getNodeKind() == SVNNodeKind.FILE && conflictDescription.getConflictAction() == SVNConflictAction.EDIT && conflictDescription.getConflictReason() == SVNConflictReason.EDITED || conflictDescription.isPropertyConflict()) {
                String message;
                boolean performedEdit = false;
                boolean diffAllowed = false;
                String path = this.mySVNEnvironment.getRelativePath(files.getWCFile());
                path = SVNCommandUtil.getLocalPath(path);
                if (conflictDescription.isPropertyConflict()) {
                    message = "Property conflict for ''{0}'' discovered on ''{1}''.";
                    message = MessageFormat.format(message, conflictDescription.getPropertyName(), path);
                    this.mySVNEnvironment.getErr().println(message);
                    if (files.getLocalFile() == null && files.getRepositoryFile() != null || files.getLocalFile() != null && files.getRepositoryFile() == null) {
                        if (files.getLocalFile() != null) {
                            String myVal = SVNFileUtil.readFile((File)files.getLocalFile());
                            message = MessageFormat.format("They want to delete the property, you want to change the value to ''{0}''.", myVal);
                            this.mySVNEnvironment.getErr().println(message);
                        }
                    } else {
                        String reposVal = SVNFileUtil.readFile((File)files.getRepositoryFile());
                        message = MessageFormat.format("They want to change the property value to ''{0}'', you want to delete the property.", reposVal);
                        this.mySVNEnvironment.getErr().println(message);
                    }
                } else {
                    message = "Conflict discovered in ''{0}''.";
                    message = MessageFormat.format(message, path);
                    this.mySVNEnvironment.getErr().println(message);
                }
                if (files.getResultFile() != null && files.getBaseFile() != null || files.getBaseFile() != null && files.getLocalFile() != null && files.getRepositoryFile() != null) {
                    diffAllowed = true;
                }
                while (true) {
                    message = "Select: (p)ostpone";
                    message = diffAllowed ? message + ", (D)iff in full, (e)dit" : message + ", (M)ine in full, (T)heirs in full";
                    if (performedEdit) {
                        message = message + ", (r)esolved";
                    }
                    message = !diffAllowed && performedEdit ? message + ",\n        " : message + ", ";
                    message = message + "(h)elp for more options : ";
                    String answer = SVNCommandUtil.prompt(message, this.mySVNEnvironment);
                    int answerChar = 0;
                    if (answer != null) {
                        if (answer.length() != 1) continue;
                        answerChar = answer.charAt(0);
                    }
                    if (answerChar == 104 || answerChar == 63) {
                        this.mySVNEnvironment.getErr().println("  (p)ostpone    - mark the conflict to be resolved later");
                        this.mySVNEnvironment.getErr().println("  (D)iff-full   - show all changes made to merged file");
                        this.mySVNEnvironment.getErr().println("  (e)dit        - change merged file in an editor");
                        this.mySVNEnvironment.getErr().println("  (r)esolved    - accept merged version of file");
                        this.mySVNEnvironment.getErr().println("  (M)ine-full   - accept my version of entire file (ignore their changes)");
                        this.mySVNEnvironment.getErr().println("  (T)heirs-full - accept their version of entire file (lose my changes)");
                        this.mySVNEnvironment.getErr().println("  (l)aunch      - use third-party tool to resolve conflict");
                        this.mySVNEnvironment.getErr().println("  (h)elp        - show this list");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (answerChar == 112) {
                        choice = SVNConflictChoice.POSTPONE;
                        break block63;
                    }
                    if (answerChar == 109) {
                        this.mySVNEnvironment.getErr().println("Sorry, '(m)ine' is not yet implemented; see");
                        this.mySVNEnvironment.getErr().println("http://subversion.tigris.org/issues/show_bug.cgi?id=3049");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (answerChar == 116) {
                        this.mySVNEnvironment.getErr().println("Sorry, '(t)heirs' is not yet implemented; see");
                        this.mySVNEnvironment.getErr().println("http://subversion.tigris.org/issues/show_bug.cgi?id=3049");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (answerChar == 77) {
                        choice = SVNConflictChoice.MINE_FULL;
                        break block63;
                    }
                    if (answerChar == 84) {
                        choice = SVNConflictChoice.THEIRS_FULL;
                        break block63;
                    }
                    if (answerChar == 100) {
                        this.mySVNEnvironment.getErr().println("Sorry, '(d)iff' is not yet implemented; see");
                        this.mySVNEnvironment.getErr().println("http://subversion.tigris.org/issues/show_bug.cgi?id=3048");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (answerChar == 68) {
                        if (!diffAllowed) {
                            this.mySVNEnvironment.getErr().println("Invalid option; there's no merged version to diff.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        File path1 = null;
                        File path2 = null;
                        if (files.getResultFile() != null && files.getBaseFile() != null) {
                            path1 = files.getBaseFile();
                            path2 = files.getResultFile();
                        } else {
                            path1 = files.getRepositoryFile();
                            path2 = files.getLocalFile();
                        }
                        DefaultSVNCommandLineDiffGenerator diffGenerator = new DefaultSVNCommandLineDiffGenerator(path1, path2);
                        diffGenerator.setDiffOptions(new SVNDiffOptions(false, false, true));
                        diffGenerator.displayFileDiff("", path1, path2, null, null, null, null, System.out);
                        performedEdit = true;
                        continue;
                    }
                    if (answerChar == 101) {
                        if (files.getResultFile() != null) {
                            try {
                                String resultPath = files.getResultFile().getAbsolutePath();
                                SVNCommandUtil.editFileExternally(this.mySVNEnvironment, this.mySVNEnvironment.getEditorCommand(), resultPath);
                                performedEdit = true;
                            }
                            catch (SVNException svne) {
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_EDITOR) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No editor found.");
                                }
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "Error running editor.");
                                }
                                throw svne;
                            }
                        }
                        this.mySVNEnvironment.getErr().println("Invalid option; there's no merged version to edit.");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (answerChar == 108) {
                        if (files.getBaseFile() != null && files.getLocalFile() != null && files.getRepositoryFile() != null && files.getResultFile() != null) {
                            try {
                                SVNCommandUtil.mergeFileExternally(this.mySVNEnvironment, files.getBasePath(), files.getRepositoryPath(), files.getLocalPath(), files.getResultPath());
                                performedEdit = true;
                            }
                            catch (SVNException svne) {
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_MERGE_TOOL) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No merge tool found.");
                                    this.myIsExternalFailed = true;
                                }
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "Error running merge tool.");
                                    this.myIsExternalFailed = true;
                                }
                                throw svne;
                            }
                        }
                        this.mySVNEnvironment.getErr().println("Invalid option.");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (answerChar != 114) continue;
                    if (performedEdit) {
                        choice = SVNConflictChoice.MERGED;
                        break block63;
                    }
                    this.mySVNEnvironment.getErr().println("Invalid option.");
                    this.mySVNEnvironment.getErr().println();
                }
            }
            if (conflictDescription.getConflictAction() == SVNConflictAction.ADD && conflictDescription.getConflictReason() == SVNConflictReason.OBSTRUCTED) {
                String message = "Conflict discovered when trying to add ''{0}''.";
                message = MessageFormat.format(message, files.getWCFile());
                this.mySVNEnvironment.getErr().println(message);
                this.mySVNEnvironment.getErr().println("An object of the same name already exists.");
                String prompt = "Select: (p)ostpone, (M)ine-full, (T)heirs-full, (h)elp :";
                while (true) {
                    String answer = SVNCommandUtil.prompt(prompt, this.mySVNEnvironment);
                    int answerChar = 0;
                    if (answer != null) {
                        if (answer.length() != 1) continue;
                        answer = answer.toLowerCase();
                        answerChar = answer.charAt(0);
                    }
                    if (answerChar == 104 || answerChar == 63) {
                        this.mySVNEnvironment.getErr().println("  (p)ostpone    - resolve the conflict later");
                        this.mySVNEnvironment.getErr().println("  (M)ine-full   - accept pre-existing item");
                        this.mySVNEnvironment.getErr().println("  (T)heirs-full - accept incoming item");
                        this.mySVNEnvironment.getErr().println("  (h)elp        - show this list");
                        this.mySVNEnvironment.getErr().println();
                    }
                    if (answerChar == 112) {
                        choice = SVNConflictChoice.POSTPONE;
                        break block63;
                    }
                    if (answerChar == 77) {
                        choice = SVNConflictChoice.MINE_FULL;
                        break block63;
                    }
                    if (answerChar == 84) {
                        choice = SVNConflictChoice.THEIRS_FULL;
                        break block63;
                    }
                    if (answerChar == 109) {
                        this.mySVNEnvironment.getErr().println("Sorry, '(m)ine' is not yet implemented; see");
                        this.mySVNEnvironment.getErr().println("http://subversion.tigris.org/issues/show_bug.cgi?id=3049");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (answerChar != 116) continue;
                    this.mySVNEnvironment.getErr().println("Sorry, '(t)heirs' is not yet implemented; see");
                    this.mySVNEnvironment.getErr().println("http://subversion.tigris.org/issues/show_bug.cgi?id=3049");
                    this.mySVNEnvironment.getErr().println();
                }
            }
            choice = SVNConflictChoice.POSTPONE;
        }
        return new SVNConflictResult(choice, null);
    }
}

